"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const react_styles_1 = require("@patternfly/react-styles");
const table_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Table/table"));
const Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip/Tooltip");
exports.HeaderCell = (_a) => {
    var { className = '', component = 'th', scope = '', textCenter = false, tooltip: tooltipProp = '', onMouseEnter: onMouseEnterProp = () => { }, children, 
    /* eslint-disable @typescript-eslint/no-unused-vars */
    isVisible, dataLabel = '' } = _a, 
    /* eslint-enable @typescript-eslint/no-unused-vars */
    props = tslib_1.__rest(_a, ["className", "component", "scope", "textCenter", "tooltip", "onMouseEnter", "children", "isVisible", "dataLabel"]);
    const mappedProps = Object.assign(Object.assign({}, (scope ? { scope } : {})), props);
    const [tooltip, setTooltip] = React.useState('');
    const onMouseEnter = (event) => {
        if (event.target.offsetWidth < event.target.scrollWidth) {
            if (tooltipProp) {
                setTooltip(tooltipProp);
            }
            else if (typeof children === 'string') {
                setTooltip(children);
            }
        }
        else {
            setTooltip('');
        }
        onMouseEnterProp(event);
    };
    const Component = component;
    const cell = (React.createElement(Component, Object.assign({}, mappedProps, { onMouseEnter: onMouseEnter, className: react_styles_1.css(className, textCenter && table_1.default.modifiers.center) }), children));
    return tooltip !== '' ? React.createElement(Tooltip_1.Tooltip, { content: tooltip }, cell) : cell;
};
exports.HeaderCell.displayName = 'HeaderCell';
//# sourceMappingURL=HeaderCell.js.map