import { __rest } from "tslib";
import * as React from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/DescriptionList/description-list';
import { formatBreakpointMods } from '../../helpers';
export const DescriptionList = (_a) => {
    var { className = '', children = null, isHorizontal = false, isAutoColumnWidths, isInlineGrid, columnModifier } = _a, props = __rest(_a, ["className", "children", "isHorizontal", "isAutoColumnWidths", "isInlineGrid", "columnModifier"]);
    return (React.createElement("dl", Object.assign({ className: css(styles.descriptionList, isHorizontal && styles.modifiers.horizontal, isAutoColumnWidths && styles.modifiers.autoColumnWidths, formatBreakpointMods(columnModifier, styles), isInlineGrid && styles.modifiers.inlineGrid, className) }, props), children));
};
DescriptionList.displayName = 'DescriptionList';
//# sourceMappingURL=DescriptionList.js.map