(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "tslib", "react", "@apollo/react-common", "@apollo/react-hooks"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("tslib"), require("react"), require("@apollo/react-common"), require("@apollo/react-hooks"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.tslib, global.react, global.reactCommon, global.reactHooks);
    global.unknown = mod.exports;
  }
})(this, function (_exports, _tslib, _react, _reactCommon, _reactHooks) {

  _exports.__esModule = true;
  _exports.getDataFromTree = getDataFromTree;
  _exports.getMarkupFromTree = getMarkupFromTree;
  _exports.renderToStringWithData = renderToStringWithData;
  _react = _interopRequireDefault(_react);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

  function getDataFromTree(tree, context) {
    if (context === void 0) {
      context = {};
    }

    return getMarkupFromTree({
      tree: tree,
      context: context,
      renderFunction: require('react-dom/server').renderToStaticMarkup
    });
  }

  function getMarkupFromTree(_a) {
    var tree = _a.tree,
        _b = _a.context,
        context = _b === void 0 ? {} : _b,
        _c = _a.renderFunction,
        renderFunction = _c === void 0 ? require('react-dom/server').renderToStaticMarkup : _c;
    var renderPromises = new _reactHooks.RenderPromises();

    function process() {
      var ApolloContext = (0, _reactCommon.getApolloContext)();
      var html = renderFunction(_react.default.createElement(ApolloContext.Provider, {
        value: (0, _tslib.__assign)((0, _tslib.__assign)({}, context), {
          renderPromises: renderPromises
        })
      }, tree));
      return renderPromises.hasPromises() ? renderPromises.consumeAndAwaitPromises().then(process) : html;
    }

    return Promise.resolve().then(process);
  }

  function renderToStringWithData(component) {
    return getMarkupFromTree({
      tree: component,
      renderFunction: require('react-dom/server').renderToString
    });
  } 

});
