# Contributing guidelines

## How to become a contributor and submit your own code

### Signing Contributor License Agreements(CLA)

We'd love to accept your patches! Before we can take them, we have to jump a couple of legal hurdles.
 
 Please fill out either the individual or corporate Contributor License Agreement
 (CLA).
 
   * If you are an individual writing original source code and you're sure you
     own the intellectual property, then you'll need to sign an
     [individual CLA](https://identity.linuxfoundation.org/node/285/node/285/individual-signup).
   * If you work for a company that wants to allow you to contribute your work,
     then you'll need to sign a
     [corporate CLA](https://identity.linuxfoundation.org/?destination=node/285/organization-signup).

### Contributing A Patch
 * Sign a Contributor License Agreement, if you haven't already done so(see details above).
 * Fork the desired repo, develop and test your code changes.
 * Submit a pull request.

All changes must be code reviewed. Coding conventions and standards are explained in the official 
[developer docs](https://github.com/kubernetes/community/tree/master/contributors/devel). Expect 
reviewers to request that you avoid common [go style mistakes](https://github.com/golang/go/wiki/CodeReviewComments)
in your PRs.

### Merge Approval

Autoscaler collaborators may add "LGTM" (Looks Good To Me) or an equivalent comment to indicate 
that a PR is acceptable. Any change requires at least one LGTM. No pull requests can be merged 
until at least one Autoscaler collaborator signs off with an LGTM.

### Support Channels

Whether you are a user or contributor, official support channels include:

 * GitHub issues: https://github.com/kubernetes/autoscaler/issues
 * Slack: Sig-autoscaling room in the [Kubernetes Slack](https://kubernetes.slack.com/?redir=%2Fmessages%2Fsig-autoscaling)
 * Email: kubernetes-users [mailing list](https://groups.google.com/forum/#!forum/kubernetes-sig-autoscaling)

For further information, please refer to [Kubernetes Contributor Guide](https://github.com/kubernetes/community/blob/master/contributors/guide/README.md)
