// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package augmentedairuntime

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opDeleteHumanLoop = "DeleteHumanLoop"

// DeleteHumanLoopRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHumanLoop operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHumanLoop for more information on using the DeleteHumanLoop
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteHumanLoopRequest method.
//    req, resp := client.DeleteHumanLoopRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DeleteHumanLoop
func (c *AugmentedAIRuntime) DeleteHumanLoopRequest(input *DeleteHumanLoopInput) (req *request.Request, output *DeleteHumanLoopOutput) {
	op := &request.Operation{
		Name:       opDeleteHumanLoop,
		HTTPMethod: "DELETE",
		HTTPPath:   "/human-loops/{HumanLoopName}",
	}

	if input == nil {
		input = &DeleteHumanLoopInput{}
	}

	output = &DeleteHumanLoopOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteHumanLoop API operation for Amazon Augmented AI Runtime.
//
// Deletes the specified human loop for a flow definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Augmented AI Runtime's
// API operation DeleteHumanLoop for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   Your request was not valid. Check the syntax and try again.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   We were unable to find the requested resource.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Your request has exceeded the allowed amount of requests.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   Your request could not be processed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DeleteHumanLoop
func (c *AugmentedAIRuntime) DeleteHumanLoop(input *DeleteHumanLoopInput) (*DeleteHumanLoopOutput, error) {
	req, out := c.DeleteHumanLoopRequest(input)
	return out, req.Send()
}

// DeleteHumanLoopWithContext is the same as DeleteHumanLoop with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHumanLoop for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AugmentedAIRuntime) DeleteHumanLoopWithContext(ctx aws.Context, input *DeleteHumanLoopInput, opts ...request.Option) (*DeleteHumanLoopOutput, error) {
	req, out := c.DeleteHumanLoopRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHumanLoop = "DescribeHumanLoop"

// DescribeHumanLoopRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHumanLoop operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHumanLoop for more information on using the DescribeHumanLoop
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHumanLoopRequest method.
//    req, resp := client.DescribeHumanLoopRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DescribeHumanLoop
func (c *AugmentedAIRuntime) DescribeHumanLoopRequest(input *DescribeHumanLoopInput) (req *request.Request, output *DescribeHumanLoopOutput) {
	op := &request.Operation{
		Name:       opDescribeHumanLoop,
		HTTPMethod: "GET",
		HTTPPath:   "/human-loops/{HumanLoopName}",
	}

	if input == nil {
		input = &DescribeHumanLoopInput{}
	}

	output = &DescribeHumanLoopOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHumanLoop API operation for Amazon Augmented AI Runtime.
//
// Returns information about the specified human loop.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Augmented AI Runtime's
// API operation DescribeHumanLoop for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   Your request was not valid. Check the syntax and try again.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   We were unable to find the requested resource.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Your request has exceeded the allowed amount of requests.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   Your request could not be processed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/DescribeHumanLoop
func (c *AugmentedAIRuntime) DescribeHumanLoop(input *DescribeHumanLoopInput) (*DescribeHumanLoopOutput, error) {
	req, out := c.DescribeHumanLoopRequest(input)
	return out, req.Send()
}

// DescribeHumanLoopWithContext is the same as DescribeHumanLoop with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHumanLoop for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AugmentedAIRuntime) DescribeHumanLoopWithContext(ctx aws.Context, input *DescribeHumanLoopInput, opts ...request.Option) (*DescribeHumanLoopOutput, error) {
	req, out := c.DescribeHumanLoopRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListHumanLoops = "ListHumanLoops"

// ListHumanLoopsRequest generates a "aws/request.Request" representing the
// client's request for the ListHumanLoops operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHumanLoops for more information on using the ListHumanLoops
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHumanLoopsRequest method.
//    req, resp := client.ListHumanLoopsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops
func (c *AugmentedAIRuntime) ListHumanLoopsRequest(input *ListHumanLoopsInput) (req *request.Request, output *ListHumanLoopsOutput) {
	op := &request.Operation{
		Name:       opListHumanLoops,
		HTTPMethod: "GET",
		HTTPPath:   "/human-loops",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHumanLoopsInput{}
	}

	output = &ListHumanLoopsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHumanLoops API operation for Amazon Augmented AI Runtime.
//
// Returns information about human loops, given the specified parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Augmented AI Runtime's
// API operation ListHumanLoops for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   Your request was not valid. Check the syntax and try again.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Your request has exceeded the allowed amount of requests.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   Your request could not be processed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/ListHumanLoops
func (c *AugmentedAIRuntime) ListHumanLoops(input *ListHumanLoopsInput) (*ListHumanLoopsOutput, error) {
	req, out := c.ListHumanLoopsRequest(input)
	return out, req.Send()
}

// ListHumanLoopsWithContext is the same as ListHumanLoops with the addition of
// the ability to pass a context and additional request options.
//
// See ListHumanLoops for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AugmentedAIRuntime) ListHumanLoopsWithContext(ctx aws.Context, input *ListHumanLoopsInput, opts ...request.Option) (*ListHumanLoopsOutput, error) {
	req, out := c.ListHumanLoopsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHumanLoopsPages iterates over the pages of a ListHumanLoops operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHumanLoops method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHumanLoops operation.
//    pageNum := 0
//    err := client.ListHumanLoopsPages(params,
//        func(page *augmentedairuntime.ListHumanLoopsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AugmentedAIRuntime) ListHumanLoopsPages(input *ListHumanLoopsInput, fn func(*ListHumanLoopsOutput, bool) bool) error {
	return c.ListHumanLoopsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHumanLoopsPagesWithContext same as ListHumanLoopsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AugmentedAIRuntime) ListHumanLoopsPagesWithContext(ctx aws.Context, input *ListHumanLoopsInput, fn func(*ListHumanLoopsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHumanLoopsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHumanLoopsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHumanLoopsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartHumanLoop = "StartHumanLoop"

// StartHumanLoopRequest generates a "aws/request.Request" representing the
// client's request for the StartHumanLoop operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartHumanLoop for more information on using the StartHumanLoop
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartHumanLoopRequest method.
//    req, resp := client.StartHumanLoopRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StartHumanLoop
func (c *AugmentedAIRuntime) StartHumanLoopRequest(input *StartHumanLoopInput) (req *request.Request, output *StartHumanLoopOutput) {
	op := &request.Operation{
		Name:       opStartHumanLoop,
		HTTPMethod: "POST",
		HTTPPath:   "/human-loops",
	}

	if input == nil {
		input = &StartHumanLoopInput{}
	}

	output = &StartHumanLoopOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartHumanLoop API operation for Amazon Augmented AI Runtime.
//
// Starts a human loop, provided that at least one activation condition is met.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Augmented AI Runtime's
// API operation StartHumanLoop for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   Your request was not valid. Check the syntax and try again.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Your request has exceeded the allowed amount of requests.
//
//   * ErrCodeServiceQuotaExceededException "ServiceQuotaExceededException"
//   You have exceeded your service quota. To perform the requested action, remove
//   some of the relevant resources, or request a service quota increase.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   Your request could not be processed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StartHumanLoop
func (c *AugmentedAIRuntime) StartHumanLoop(input *StartHumanLoopInput) (*StartHumanLoopOutput, error) {
	req, out := c.StartHumanLoopRequest(input)
	return out, req.Send()
}

// StartHumanLoopWithContext is the same as StartHumanLoop with the addition of
// the ability to pass a context and additional request options.
//
// See StartHumanLoop for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AugmentedAIRuntime) StartHumanLoopWithContext(ctx aws.Context, input *StartHumanLoopInput, opts ...request.Option) (*StartHumanLoopOutput, error) {
	req, out := c.StartHumanLoopRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopHumanLoop = "StopHumanLoop"

// StopHumanLoopRequest generates a "aws/request.Request" representing the
// client's request for the StopHumanLoop operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopHumanLoop for more information on using the StopHumanLoop
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopHumanLoopRequest method.
//    req, resp := client.StopHumanLoopRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StopHumanLoop
func (c *AugmentedAIRuntime) StopHumanLoopRequest(input *StopHumanLoopInput) (req *request.Request, output *StopHumanLoopOutput) {
	op := &request.Operation{
		Name:       opStopHumanLoop,
		HTTPMethod: "POST",
		HTTPPath:   "/human-loops/stop",
	}

	if input == nil {
		input = &StopHumanLoopInput{}
	}

	output = &StopHumanLoopOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopHumanLoop API operation for Amazon Augmented AI Runtime.
//
// Stops the specified human loop.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Augmented AI Runtime's
// API operation StopHumanLoop for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   Your request was not valid. Check the syntax and try again.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   We were unable to find the requested resource.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Your request has exceeded the allowed amount of requests.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   Your request could not be processed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StopHumanLoop
func (c *AugmentedAIRuntime) StopHumanLoop(input *StopHumanLoopInput) (*StopHumanLoopOutput, error) {
	req, out := c.StopHumanLoopRequest(input)
	return out, req.Send()
}

// StopHumanLoopWithContext is the same as StopHumanLoop with the addition of
// the ability to pass a context and additional request options.
//
// See StopHumanLoop for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AugmentedAIRuntime) StopHumanLoopWithContext(ctx aws.Context, input *StopHumanLoopInput, opts ...request.Option) (*StopHumanLoopOutput, error) {
	req, out := c.StopHumanLoopRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DeleteHumanLoopInput struct {
	_ struct{} `type:"structure"`

	// The name of the human loop you want to delete.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `location:"uri" locationName:"HumanLoopName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHumanLoopInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHumanLoopInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHumanLoopInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHumanLoopInput"}
	if s.HumanLoopName == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopName"))
	}
	if s.HumanLoopName != nil && len(*s.HumanLoopName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HumanLoopName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *DeleteHumanLoopInput) SetHumanLoopName(v string) *DeleteHumanLoopInput {
	s.HumanLoopName = &v
	return s
}

type DeleteHumanLoopOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHumanLoopOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHumanLoopOutput) GoString() string {
	return s.String()
}

type DescribeHumanLoopInput struct {
	_ struct{} `type:"structure"`

	// The name of the human loop.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `location:"uri" locationName:"HumanLoopName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeHumanLoopInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHumanLoopInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHumanLoopInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeHumanLoopInput"}
	if s.HumanLoopName == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopName"))
	}
	if s.HumanLoopName != nil && len(*s.HumanLoopName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HumanLoopName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *DescribeHumanLoopInput) SetHumanLoopName(v string) *DescribeHumanLoopInput {
	s.HumanLoopName = &v
	return s
}

type DescribeHumanLoopOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp when Amazon Augmented AI created the human loop.
	//
	// CreationTimestamp is a required field
	CreationTimestamp *time.Time `type:"timestamp" required:"true"`

	// A failure code denoting a specific type of failure.
	FailureCode *string `type:"string"`

	// The reason why a human loop has failed. The failure reason is returned when
	// the human loop status is Failed.
	FailureReason *string `type:"string"`

	// The Amazon Resource Name (ARN) of the flow definition.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the human loop.
	//
	// HumanLoopArn is a required field
	HumanLoopArn *string `type:"string" required:"true"`

	// An object containing information about the human loop input.
	//
	// HumanLoopInput is a required field
	HumanLoopInput *HumanLoopInputContent `type:"structure" required:"true"`

	// The name of the human loop.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `min:"1" type:"string" required:"true"`

	// An object containing information about the output of the human loop.
	HumanLoopOutput *HumanLoopOutputContent `type:"structure"`

	// The status of the human loop. Valid values:
	//
	// HumanLoopStatus is a required field
	HumanLoopStatus *string `type:"string" required:"true" enum:"HumanLoopStatus"`
}

// String returns the string representation
func (s DescribeHumanLoopOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHumanLoopOutput) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *DescribeHumanLoopOutput) SetCreationTimestamp(v time.Time) *DescribeHumanLoopOutput {
	s.CreationTimestamp = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *DescribeHumanLoopOutput) SetFailureCode(v string) *DescribeHumanLoopOutput {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeHumanLoopOutput) SetFailureReason(v string) *DescribeHumanLoopOutput {
	s.FailureReason = &v
	return s
}

// SetFlowDefinitionArn sets the FlowDefinitionArn field's value.
func (s *DescribeHumanLoopOutput) SetFlowDefinitionArn(v string) *DescribeHumanLoopOutput {
	s.FlowDefinitionArn = &v
	return s
}

// SetHumanLoopArn sets the HumanLoopArn field's value.
func (s *DescribeHumanLoopOutput) SetHumanLoopArn(v string) *DescribeHumanLoopOutput {
	s.HumanLoopArn = &v
	return s
}

// SetHumanLoopInput sets the HumanLoopInput field's value.
func (s *DescribeHumanLoopOutput) SetHumanLoopInput(v *HumanLoopInputContent) *DescribeHumanLoopOutput {
	s.HumanLoopInput = v
	return s
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *DescribeHumanLoopOutput) SetHumanLoopName(v string) *DescribeHumanLoopOutput {
	s.HumanLoopName = &v
	return s
}

// SetHumanLoopOutput sets the HumanLoopOutput field's value.
func (s *DescribeHumanLoopOutput) SetHumanLoopOutput(v *HumanLoopOutputContent) *DescribeHumanLoopOutput {
	s.HumanLoopOutput = v
	return s
}

// SetHumanLoopStatus sets the HumanLoopStatus field's value.
func (s *DescribeHumanLoopOutput) SetHumanLoopStatus(v string) *DescribeHumanLoopOutput {
	s.HumanLoopStatus = &v
	return s
}

// Contains information about why a human loop was triggered. If at least one
// activation reason is evaluated to be true, the human loop is activated.
type HumanLoopActivationReason struct {
	_ struct{} `type:"structure"`

	// True if the specified conditions were matched to trigger the human loop.
	ConditionsMatched *bool `type:"boolean"`
}

// String returns the string representation
func (s HumanLoopActivationReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HumanLoopActivationReason) GoString() string {
	return s.String()
}

// SetConditionsMatched sets the ConditionsMatched field's value.
func (s *HumanLoopActivationReason) SetConditionsMatched(v bool) *HumanLoopActivationReason {
	s.ConditionsMatched = &v
	return s
}

// Information about the corresponding flow definition's human loop activation
// condition evaluation. Null if StartHumanLoop was invoked directly.
type HumanLoopActivationResults struct {
	_ struct{} `type:"structure"`

	// A copy of the human loop activation conditions of the flow definition, augmented
	// with the results of evaluating those conditions on the input provided to
	// the StartHumanLoop operation.
	HumanLoopActivationConditionsEvaluationResults *string `type:"string"`

	// An object containing information about why a human loop was triggered.
	HumanLoopActivationReason *HumanLoopActivationReason `type:"structure"`
}

// String returns the string representation
func (s HumanLoopActivationResults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HumanLoopActivationResults) GoString() string {
	return s.String()
}

// SetHumanLoopActivationConditionsEvaluationResults sets the HumanLoopActivationConditionsEvaluationResults field's value.
func (s *HumanLoopActivationResults) SetHumanLoopActivationConditionsEvaluationResults(v string) *HumanLoopActivationResults {
	s.HumanLoopActivationConditionsEvaluationResults = &v
	return s
}

// SetHumanLoopActivationReason sets the HumanLoopActivationReason field's value.
func (s *HumanLoopActivationResults) SetHumanLoopActivationReason(v *HumanLoopActivationReason) *HumanLoopActivationResults {
	s.HumanLoopActivationReason = v
	return s
}

// An object containing the input.
type HumanLoopInputContent struct {
	_ struct{} `type:"structure"`

	// Serialized input from the human loop.
	//
	// InputContent is a required field
	InputContent *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HumanLoopInputContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HumanLoopInputContent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanLoopInputContent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HumanLoopInputContent"}
	if s.InputContent == nil {
		invalidParams.Add(request.NewErrParamRequired("InputContent"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputContent sets the InputContent field's value.
func (s *HumanLoopInputContent) SetInputContent(v string) *HumanLoopInputContent {
	s.InputContent = &v
	return s
}

// Information about where the human output will be stored.
type HumanLoopOutputContent struct {
	_ struct{} `type:"structure"`

	// The location of the Amazon S3 object where Amazon Augmented AI stores your
	// human loop output. The output is stored at the following location: s3://S3OutputPath/HumanLoopName/CreationTime/output.json.
	//
	// OutputS3Uri is a required field
	OutputS3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HumanLoopOutputContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HumanLoopOutputContent) GoString() string {
	return s.String()
}

// SetOutputS3Uri sets the OutputS3Uri field's value.
func (s *HumanLoopOutputContent) SetOutputS3Uri(v string) *HumanLoopOutputContent {
	s.OutputS3Uri = &v
	return s
}

// Summary information about the human loop.
type HumanLoopSummary struct {
	_ struct{} `type:"structure"`

	// When Amazon Augmented AI created the human loop.
	CreationTime *time.Time `type:"timestamp"`

	// The reason why the human loop failed. A failure reason is returned only when
	// the status of the human loop is Failed.
	FailureReason *string `type:"string"`

	// The Amazon Resource Name (ARN) of the flow definition.
	FlowDefinitionArn *string `type:"string"`

	// The name of the human loop.
	HumanLoopName *string `min:"1" type:"string"`

	// The status of the human loop. Valid values:
	HumanLoopStatus *string `type:"string" enum:"HumanLoopStatus"`
}

// String returns the string representation
func (s HumanLoopSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HumanLoopSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *HumanLoopSummary) SetCreationTime(v time.Time) *HumanLoopSummary {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *HumanLoopSummary) SetFailureReason(v string) *HumanLoopSummary {
	s.FailureReason = &v
	return s
}

// SetFlowDefinitionArn sets the FlowDefinitionArn field's value.
func (s *HumanLoopSummary) SetFlowDefinitionArn(v string) *HumanLoopSummary {
	s.FlowDefinitionArn = &v
	return s
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *HumanLoopSummary) SetHumanLoopName(v string) *HumanLoopSummary {
	s.HumanLoopName = &v
	return s
}

// SetHumanLoopStatus sets the HumanLoopStatus field's value.
func (s *HumanLoopSummary) SetHumanLoopStatus(v string) *HumanLoopSummary {
	s.HumanLoopStatus = &v
	return s
}

// Attributes of the data specified by the customer. Use these to describe the
// data to be labeled.
type HumanReviewDataAttributes struct {
	_ struct{} `type:"structure"`

	// Declares that your content is free of personally identifiable information
	// or adult content. Amazon SageMaker may restrict the Amazon Mechanical Turk
	// workers that can view your task based on this information.
	//
	// ContentClassifiers is a required field
	ContentClassifiers []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s HumanReviewDataAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HumanReviewDataAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanReviewDataAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HumanReviewDataAttributes"}
	if s.ContentClassifiers == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentClassifiers"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentClassifiers sets the ContentClassifiers field's value.
func (s *HumanReviewDataAttributes) SetContentClassifiers(v []*string) *HumanReviewDataAttributes {
	s.ContentClassifiers = v
	return s
}

type ListHumanLoopsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The timestamp of the date when you want the human loops to begin.
	// For example, 1551000000.
	CreationTimeAfter *time.Time `location:"querystring" locationName:"CreationTimeAfter" type:"timestamp"`

	// (Optional) The timestamp of the date before which you want the human loops
	// to begin. For example, 1550000000.
	CreationTimeBefore *time.Time `location:"querystring" locationName:"CreationTimeBefore" type:"timestamp"`

	// The total number of items to return. If the total number of available items
	// is more than the value specified in MaxResults, then a NextToken will be
	// provided in the output that you can use to resume pagination.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// A token to resume pagination.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// An optional value that specifies whether you want the results sorted in Ascending
	// or Descending order.
	SortOrder *string `location:"querystring" locationName:"SortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s ListHumanLoopsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHumanLoopsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHumanLoopsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHumanLoopsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *ListHumanLoopsInput) SetCreationTimeAfter(v time.Time) *ListHumanLoopsInput {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *ListHumanLoopsInput) SetCreationTimeBefore(v time.Time) *ListHumanLoopsInput {
	s.CreationTimeBefore = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHumanLoopsInput) SetMaxResults(v int64) *ListHumanLoopsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHumanLoopsInput) SetNextToken(v string) *ListHumanLoopsInput {
	s.NextToken = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListHumanLoopsInput) SetSortOrder(v string) *ListHumanLoopsInput {
	s.SortOrder = &v
	return s
}

type ListHumanLoopsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects containing information about the human loops.
	//
	// HumanLoopSummaries is a required field
	HumanLoopSummaries []*HumanLoopSummary `type:"list" required:"true"`

	// A token to resume pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHumanLoopsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHumanLoopsOutput) GoString() string {
	return s.String()
}

// SetHumanLoopSummaries sets the HumanLoopSummaries field's value.
func (s *ListHumanLoopsOutput) SetHumanLoopSummaries(v []*HumanLoopSummary) *ListHumanLoopsOutput {
	s.HumanLoopSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHumanLoopsOutput) SetNextToken(v string) *ListHumanLoopsOutput {
	s.NextToken = &v
	return s
}

type StartHumanLoopInput struct {
	_ struct{} `type:"structure"`

	// Attributes of the data specified by the customer.
	DataAttributes *HumanReviewDataAttributes `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow definition.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `type:"string" required:"true"`

	// An object containing information about the human loop.
	//
	// HumanLoopInput is a required field
	HumanLoopInput *HumanLoopInputContent `type:"structure" required:"true"`

	// The name of the human loop.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartHumanLoopInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartHumanLoopInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartHumanLoopInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartHumanLoopInput"}
	if s.FlowDefinitionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowDefinitionArn"))
	}
	if s.HumanLoopInput == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopInput"))
	}
	if s.HumanLoopName == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopName"))
	}
	if s.HumanLoopName != nil && len(*s.HumanLoopName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HumanLoopName", 1))
	}
	if s.DataAttributes != nil {
		if err := s.DataAttributes.Validate(); err != nil {
			invalidParams.AddNested("DataAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.HumanLoopInput != nil {
		if err := s.HumanLoopInput.Validate(); err != nil {
			invalidParams.AddNested("HumanLoopInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAttributes sets the DataAttributes field's value.
func (s *StartHumanLoopInput) SetDataAttributes(v *HumanReviewDataAttributes) *StartHumanLoopInput {
	s.DataAttributes = v
	return s
}

// SetFlowDefinitionArn sets the FlowDefinitionArn field's value.
func (s *StartHumanLoopInput) SetFlowDefinitionArn(v string) *StartHumanLoopInput {
	s.FlowDefinitionArn = &v
	return s
}

// SetHumanLoopInput sets the HumanLoopInput field's value.
func (s *StartHumanLoopInput) SetHumanLoopInput(v *HumanLoopInputContent) *StartHumanLoopInput {
	s.HumanLoopInput = v
	return s
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *StartHumanLoopInput) SetHumanLoopName(v string) *StartHumanLoopInput {
	s.HumanLoopName = &v
	return s
}

type StartHumanLoopOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the human loop activation.
	HumanLoopActivationResults *HumanLoopActivationResults `type:"structure"`

	// The Amazon Resource Name (ARN) of the human loop.
	HumanLoopArn *string `type:"string"`
}

// String returns the string representation
func (s StartHumanLoopOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartHumanLoopOutput) GoString() string {
	return s.String()
}

// SetHumanLoopActivationResults sets the HumanLoopActivationResults field's value.
func (s *StartHumanLoopOutput) SetHumanLoopActivationResults(v *HumanLoopActivationResults) *StartHumanLoopOutput {
	s.HumanLoopActivationResults = v
	return s
}

// SetHumanLoopArn sets the HumanLoopArn field's value.
func (s *StartHumanLoopOutput) SetHumanLoopArn(v string) *StartHumanLoopOutput {
	s.HumanLoopArn = &v
	return s
}

type StopHumanLoopInput struct {
	_ struct{} `type:"structure"`

	// The name of the human loop you want to stop.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopHumanLoopInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopHumanLoopInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopHumanLoopInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopHumanLoopInput"}
	if s.HumanLoopName == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopName"))
	}
	if s.HumanLoopName != nil && len(*s.HumanLoopName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HumanLoopName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *StopHumanLoopInput) SetHumanLoopName(v string) *StopHumanLoopInput {
	s.HumanLoopName = &v
	return s
}

type StopHumanLoopOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopHumanLoopOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopHumanLoopOutput) GoString() string {
	return s.String()
}

const (
	// ContentClassifierFreeOfPersonallyIdentifiableInformation is a ContentClassifier enum value
	ContentClassifierFreeOfPersonallyIdentifiableInformation = "FreeOfPersonallyIdentifiableInformation"

	// ContentClassifierFreeOfAdultContent is a ContentClassifier enum value
	ContentClassifierFreeOfAdultContent = "FreeOfAdultContent"
)

const (
	// HumanLoopStatusInProgress is a HumanLoopStatus enum value
	HumanLoopStatusInProgress = "InProgress"

	// HumanLoopStatusFailed is a HumanLoopStatus enum value
	HumanLoopStatusFailed = "Failed"

	// HumanLoopStatusCompleted is a HumanLoopStatus enum value
	HumanLoopStatusCompleted = "Completed"

	// HumanLoopStatusStopped is a HumanLoopStatus enum value
	HumanLoopStatusStopped = "Stopped"

	// HumanLoopStatusStopping is a HumanLoopStatus enum value
	HumanLoopStatusStopping = "Stopping"
)

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "Ascending"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "Descending"
)
