package batch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// JobScheduleClient is the a client for issuing REST requests to the Azure Batch service.
type JobScheduleClient struct {
	BaseClient
}

// NewJobScheduleClient creates an instance of the JobScheduleClient client.
func NewJobScheduleClient(batchURL string) JobScheduleClient {
	return JobScheduleClient{New(batchURL)}
}

// Add sends the add request.
// Parameters:
// cloudJobSchedule - the Job Schedule to be added.
// timeout - the maximum time that the server can spend processing the request, in seconds. The default is 30
// seconds.
// clientRequestID - the caller-generated request identity, in the form of a GUID with no decoration such as
// curly braces, e.g. 9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
// returnClientRequestID - whether the server should return the client-request-id in the response.
// ocpDate - the time the request was issued. Client libraries typically set this to the current system clock
// time; set it explicitly if you are calling the REST API directly.
func (client JobScheduleClient) Add(ctx context.Context, cloudJobSchedule JobScheduleAddParameter, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleClient.Add")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: cloudJobSchedule,
			Constraints: []validation.Constraint{{Target: "cloudJobSchedule.ID", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "cloudJobSchedule.Schedule", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "cloudJobSchedule.JobSpecification", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.NetworkConfiguration", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.NetworkConfiguration.SubnetID", Name: validation.Null, Rule: true, Chain: nil}}},
						{Target: "cloudJobSchedule.JobSpecification.JobManagerTask", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.JobManagerTask.ID", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "cloudJobSchedule.JobSpecification.JobManagerTask.CommandLine", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "cloudJobSchedule.JobSpecification.JobManagerTask.ContainerSettings", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.JobManagerTask.ContainerSettings.ImageName", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "cloudJobSchedule.JobSpecification.JobManagerTask.ContainerSettings.Registry", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.JobManagerTask.ContainerSettings.Registry.UserName", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "cloudJobSchedule.JobSpecification.JobManagerTask.ContainerSettings.Registry.Password", Name: validation.Null, Rule: true, Chain: nil},
											}},
									}},
							}},
						{Target: "cloudJobSchedule.JobSpecification.JobPreparationTask", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.JobPreparationTask.CommandLine", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "cloudJobSchedule.JobSpecification.JobPreparationTask.ContainerSettings", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.JobPreparationTask.ContainerSettings.ImageName", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "cloudJobSchedule.JobSpecification.JobPreparationTask.ContainerSettings.Registry", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.JobPreparationTask.ContainerSettings.Registry.UserName", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "cloudJobSchedule.JobSpecification.JobPreparationTask.ContainerSettings.Registry.Password", Name: validation.Null, Rule: true, Chain: nil},
											}},
									}},
							}},
						{Target: "cloudJobSchedule.JobSpecification.JobReleaseTask", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.JobReleaseTask.CommandLine", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "cloudJobSchedule.JobSpecification.JobReleaseTask.ContainerSettings", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.JobReleaseTask.ContainerSettings.ImageName", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "cloudJobSchedule.JobSpecification.JobReleaseTask.ContainerSettings.Registry", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.JobReleaseTask.ContainerSettings.Registry.UserName", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "cloudJobSchedule.JobSpecification.JobReleaseTask.ContainerSettings.Registry.Password", Name: validation.Null, Rule: true, Chain: nil},
											}},
									}},
							}},
						{Target: "cloudJobSchedule.JobSpecification.PoolInfo", Name: validation.Null, Rule: true,
							Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.VMSize", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.CloudServiceConfiguration", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.CloudServiceConfiguration.OsFamily", Name: validation.Null, Rule: true, Chain: nil}}},
										{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.VirtualMachineConfiguration", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.VirtualMachineConfiguration.ImageReference", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.VirtualMachineConfiguration.NodeAgentSKUID", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.VirtualMachineConfiguration.ContainerConfiguration", Name: validation.Null, Rule: false,
													Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.VirtualMachineConfiguration.ContainerConfiguration.Type", Name: validation.Null, Rule: true, Chain: nil}}},
											}},
										{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.NetworkConfiguration", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.NetworkConfiguration.EndpointConfiguration", Name: validation.Null, Rule: false,
												Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.NetworkConfiguration.EndpointConfiguration.InboundNATPools", Name: validation.Null, Rule: true, Chain: nil}}},
											}},
										{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask.CommandLine", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask.ContainerSettings", Name: validation.Null, Rule: false,
													Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask.ContainerSettings.ImageName", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask.ContainerSettings.Registry", Name: validation.Null, Rule: false,
															Chain: []validation.Constraint{{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask.ContainerSettings.Registry.UserName", Name: validation.Null, Rule: true, Chain: nil},
																{Target: "cloudJobSchedule.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask.ContainerSettings.Registry.Password", Name: validation.Null, Rule: true, Chain: nil},
															}},
													}},
											}},
									}},
								}},
							}},
					}}}}}); err != nil {
		return result, validation.NewError("batch.JobScheduleClient", "Add", err.Error())
	}

	req, err := client.AddPreparer(ctx, cloudJobSchedule, timeout, clientRequestID, returnClientRequestID, ocpDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Add", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Add", resp, "Failure sending request")
		return
	}

	result, err = client.AddResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Add", resp, "Failure responding to request")
	}

	return
}

// AddPreparer prepares the Add request.
func (client JobScheduleClient) AddPreparer(ctx context.Context, cloudJobSchedule JobScheduleAddParameter, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"batchUrl": client.BatchURL,
	}

	const APIVersion = "2019-08-01.10.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	} else {
		queryParameters["timeout"] = autorest.Encode("query", 30)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; odata=minimalmetadata; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{batchUrl}", urlParameters),
		autorest.WithPath("/jobschedules"),
		autorest.WithJSON(cloudJobSchedule),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	if returnClientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(returnClientRequestID)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(false)))
	}
	if ocpDate != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("ocp-date", autorest.String(ocpDate)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSender sends the Add request. The method will close the
// http.Response Body if it receives an error.
func (client JobScheduleClient) AddSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddResponder handles the response to the Add request. The method always
// closes the http.Response Body.
func (client JobScheduleClient) AddResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Delete when you delete a Job Schedule, this also deletes all Jobs and Tasks under that schedule. When Tasks are
// deleted, all the files in their working directories on the Compute Nodes are also deleted (the retention period is
// ignored). The Job Schedule statistics are no longer accessible once the Job Schedule is deleted, though they are
// still counted towards Account lifetime statistics.
// Parameters:
// jobScheduleID - the ID of the Job Schedule to delete.
// timeout - the maximum time that the server can spend processing the request, in seconds. The default is 30
// seconds.
// clientRequestID - the caller-generated request identity, in the form of a GUID with no decoration such as
// curly braces, e.g. 9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
// returnClientRequestID - whether the server should return the client-request-id in the response.
// ocpDate - the time the request was issued. Client libraries typically set this to the current system clock
// time; set it explicitly if you are calling the REST API directly.
// ifMatch - an ETag value associated with the version of the resource known to the client. The operation will
// be performed only if the resource's current ETag on the service exactly matches the value specified by the
// client.
// ifNoneMatch - an ETag value associated with the version of the resource known to the client. The operation
// will be performed only if the resource's current ETag on the service does not match the value specified by
// the client.
// ifModifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has been modified since the specified time.
// ifUnmodifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has not been modified since the specified
// time.
func (client JobScheduleClient) Delete(ctx context.Context, jobScheduleID string, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, jobScheduleID, timeout, clientRequestID, returnClientRequestID, ocpDate, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client JobScheduleClient) DeletePreparer(ctx context.Context, jobScheduleID string, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"batchUrl": client.BatchURL,
	}

	pathParameters := map[string]interface{}{
		"jobScheduleId": autorest.Encode("path", jobScheduleID),
	}

	const APIVersion = "2019-08-01.10.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	} else {
		queryParameters["timeout"] = autorest.Encode("query", 30)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{batchUrl}", urlParameters),
		autorest.WithPathParameters("/jobschedules/{jobScheduleId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	if returnClientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(returnClientRequestID)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(false)))
	}
	if ocpDate != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("ocp-date", autorest.String(ocpDate)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if ifModifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if ifUnmodifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client JobScheduleClient) DeleteSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client JobScheduleClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Disable no new Jobs will be created until the Job Schedule is enabled again.
// Parameters:
// jobScheduleID - the ID of the Job Schedule to disable.
// timeout - the maximum time that the server can spend processing the request, in seconds. The default is 30
// seconds.
// clientRequestID - the caller-generated request identity, in the form of a GUID with no decoration such as
// curly braces, e.g. 9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
// returnClientRequestID - whether the server should return the client-request-id in the response.
// ocpDate - the time the request was issued. Client libraries typically set this to the current system clock
// time; set it explicitly if you are calling the REST API directly.
// ifMatch - an ETag value associated with the version of the resource known to the client. The operation will
// be performed only if the resource's current ETag on the service exactly matches the value specified by the
// client.
// ifNoneMatch - an ETag value associated with the version of the resource known to the client. The operation
// will be performed only if the resource's current ETag on the service does not match the value specified by
// the client.
// ifModifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has been modified since the specified time.
// ifUnmodifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has not been modified since the specified
// time.
func (client JobScheduleClient) Disable(ctx context.Context, jobScheduleID string, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleClient.Disable")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DisablePreparer(ctx, jobScheduleID, timeout, clientRequestID, returnClientRequestID, ocpDate, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Disable", nil, "Failure preparing request")
		return
	}

	resp, err := client.DisableSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Disable", resp, "Failure sending request")
		return
	}

	result, err = client.DisableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Disable", resp, "Failure responding to request")
	}

	return
}

// DisablePreparer prepares the Disable request.
func (client JobScheduleClient) DisablePreparer(ctx context.Context, jobScheduleID string, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"batchUrl": client.BatchURL,
	}

	pathParameters := map[string]interface{}{
		"jobScheduleId": autorest.Encode("path", jobScheduleID),
	}

	const APIVersion = "2019-08-01.10.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	} else {
		queryParameters["timeout"] = autorest.Encode("query", 30)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{batchUrl}", urlParameters),
		autorest.WithPathParameters("/jobschedules/{jobScheduleId}/disable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	if returnClientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(returnClientRequestID)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(false)))
	}
	if ocpDate != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("ocp-date", autorest.String(ocpDate)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if ifModifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if ifUnmodifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DisableSender sends the Disable request. The method will close the
// http.Response Body if it receives an error.
func (client JobScheduleClient) DisableSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DisableResponder handles the response to the Disable request. The method always
// closes the http.Response Body.
func (client JobScheduleClient) DisableResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Enable sends the enable request.
// Parameters:
// jobScheduleID - the ID of the Job Schedule to enable.
// timeout - the maximum time that the server can spend processing the request, in seconds. The default is 30
// seconds.
// clientRequestID - the caller-generated request identity, in the form of a GUID with no decoration such as
// curly braces, e.g. 9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
// returnClientRequestID - whether the server should return the client-request-id in the response.
// ocpDate - the time the request was issued. Client libraries typically set this to the current system clock
// time; set it explicitly if you are calling the REST API directly.
// ifMatch - an ETag value associated with the version of the resource known to the client. The operation will
// be performed only if the resource's current ETag on the service exactly matches the value specified by the
// client.
// ifNoneMatch - an ETag value associated with the version of the resource known to the client. The operation
// will be performed only if the resource's current ETag on the service does not match the value specified by
// the client.
// ifModifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has been modified since the specified time.
// ifUnmodifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has not been modified since the specified
// time.
func (client JobScheduleClient) Enable(ctx context.Context, jobScheduleID string, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleClient.Enable")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.EnablePreparer(ctx, jobScheduleID, timeout, clientRequestID, returnClientRequestID, ocpDate, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Enable", nil, "Failure preparing request")
		return
	}

	resp, err := client.EnableSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Enable", resp, "Failure sending request")
		return
	}

	result, err = client.EnableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Enable", resp, "Failure responding to request")
	}

	return
}

// EnablePreparer prepares the Enable request.
func (client JobScheduleClient) EnablePreparer(ctx context.Context, jobScheduleID string, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"batchUrl": client.BatchURL,
	}

	pathParameters := map[string]interface{}{
		"jobScheduleId": autorest.Encode("path", jobScheduleID),
	}

	const APIVersion = "2019-08-01.10.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	} else {
		queryParameters["timeout"] = autorest.Encode("query", 30)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{batchUrl}", urlParameters),
		autorest.WithPathParameters("/jobschedules/{jobScheduleId}/enable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	if returnClientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(returnClientRequestID)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(false)))
	}
	if ocpDate != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("ocp-date", autorest.String(ocpDate)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if ifModifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if ifUnmodifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// EnableSender sends the Enable request. The method will close the
// http.Response Body if it receives an error.
func (client JobScheduleClient) EnableSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// EnableResponder handles the response to the Enable request. The method always
// closes the http.Response Body.
func (client JobScheduleClient) EnableResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Exists sends the exists request.
// Parameters:
// jobScheduleID - the ID of the Job Schedule which you want to check.
// timeout - the maximum time that the server can spend processing the request, in seconds. The default is 30
// seconds.
// clientRequestID - the caller-generated request identity, in the form of a GUID with no decoration such as
// curly braces, e.g. 9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
// returnClientRequestID - whether the server should return the client-request-id in the response.
// ocpDate - the time the request was issued. Client libraries typically set this to the current system clock
// time; set it explicitly if you are calling the REST API directly.
// ifMatch - an ETag value associated with the version of the resource known to the client. The operation will
// be performed only if the resource's current ETag on the service exactly matches the value specified by the
// client.
// ifNoneMatch - an ETag value associated with the version of the resource known to the client. The operation
// will be performed only if the resource's current ETag on the service does not match the value specified by
// the client.
// ifModifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has been modified since the specified time.
// ifUnmodifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has not been modified since the specified
// time.
func (client JobScheduleClient) Exists(ctx context.Context, jobScheduleID string, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleClient.Exists")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ExistsPreparer(ctx, jobScheduleID, timeout, clientRequestID, returnClientRequestID, ocpDate, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Exists", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExistsSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Exists", resp, "Failure sending request")
		return
	}

	result, err = client.ExistsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Exists", resp, "Failure responding to request")
	}

	return
}

// ExistsPreparer prepares the Exists request.
func (client JobScheduleClient) ExistsPreparer(ctx context.Context, jobScheduleID string, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"batchUrl": client.BatchURL,
	}

	pathParameters := map[string]interface{}{
		"jobScheduleId": autorest.Encode("path", jobScheduleID),
	}

	const APIVersion = "2019-08-01.10.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	} else {
		queryParameters["timeout"] = autorest.Encode("query", 30)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsHead(),
		autorest.WithCustomBaseURL("{batchUrl}", urlParameters),
		autorest.WithPathParameters("/jobschedules/{jobScheduleId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	if returnClientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(returnClientRequestID)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(false)))
	}
	if ocpDate != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("ocp-date", autorest.String(ocpDate)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if ifModifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if ifUnmodifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExistsSender sends the Exists request. The method will close the
// http.Response Body if it receives an error.
func (client JobScheduleClient) ExistsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ExistsResponder handles the response to the Exists request. The method always
// closes the http.Response Body.
func (client JobScheduleClient) ExistsResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets information about the specified Job Schedule.
// Parameters:
// jobScheduleID - the ID of the Job Schedule to get.
// selectParameter - an OData $select clause.
// expand - an OData $expand clause.
// timeout - the maximum time that the server can spend processing the request, in seconds. The default is 30
// seconds.
// clientRequestID - the caller-generated request identity, in the form of a GUID with no decoration such as
// curly braces, e.g. 9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
// returnClientRequestID - whether the server should return the client-request-id in the response.
// ocpDate - the time the request was issued. Client libraries typically set this to the current system clock
// time; set it explicitly if you are calling the REST API directly.
// ifMatch - an ETag value associated with the version of the resource known to the client. The operation will
// be performed only if the resource's current ETag on the service exactly matches the value specified by the
// client.
// ifNoneMatch - an ETag value associated with the version of the resource known to the client. The operation
// will be performed only if the resource's current ETag on the service does not match the value specified by
// the client.
// ifModifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has been modified since the specified time.
// ifUnmodifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has not been modified since the specified
// time.
func (client JobScheduleClient) Get(ctx context.Context, jobScheduleID string, selectParameter string, expand string, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (result CloudJobSchedule, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, jobScheduleID, selectParameter, expand, timeout, clientRequestID, returnClientRequestID, ocpDate, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client JobScheduleClient) GetPreparer(ctx context.Context, jobScheduleID string, selectParameter string, expand string, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"batchUrl": client.BatchURL,
	}

	pathParameters := map[string]interface{}{
		"jobScheduleId": autorest.Encode("path", jobScheduleID),
	}

	const APIVersion = "2019-08-01.10.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	} else {
		queryParameters["timeout"] = autorest.Encode("query", 30)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{batchUrl}", urlParameters),
		autorest.WithPathParameters("/jobschedules/{jobScheduleId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	if returnClientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(returnClientRequestID)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(false)))
	}
	if ocpDate != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("ocp-date", autorest.String(ocpDate)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if ifModifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if ifUnmodifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client JobScheduleClient) GetSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client JobScheduleClient) GetResponder(resp *http.Response) (result CloudJobSchedule, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List sends the list request.
// Parameters:
// filter - an OData $filter clause. For more information on constructing this filter, see
// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-job-schedules.
// selectParameter - an OData $select clause.
// expand - an OData $expand clause.
// maxResults - the maximum number of items to return in the response. A maximum of 1000 Job Schedules can be
// returned.
// timeout - the maximum time that the server can spend processing the request, in seconds. The default is 30
// seconds.
// clientRequestID - the caller-generated request identity, in the form of a GUID with no decoration such as
// curly braces, e.g. 9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
// returnClientRequestID - whether the server should return the client-request-id in the response.
// ocpDate - the time the request was issued. Client libraries typically set this to the current system clock
// time; set it explicitly if you are calling the REST API directly.
func (client JobScheduleClient) List(ctx context.Context, filter string, selectParameter string, expand string, maxResults *int32, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123) (result CloudJobScheduleListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleClient.List")
		defer func() {
			sc := -1
			if result.cjslr.Response.Response != nil {
				sc = result.cjslr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: maxResults,
			Constraints: []validation.Constraint{{Target: "maxResults", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "maxResults", Name: validation.InclusiveMaximum, Rule: int64(1000), Chain: nil},
					{Target: "maxResults", Name: validation.InclusiveMinimum, Rule: 1, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("batch.JobScheduleClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, filter, selectParameter, expand, maxResults, timeout, clientRequestID, returnClientRequestID, ocpDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.cjslr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "List", resp, "Failure sending request")
		return
	}

	result.cjslr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client JobScheduleClient) ListPreparer(ctx context.Context, filter string, selectParameter string, expand string, maxResults *int32, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"batchUrl": client.BatchURL,
	}

	const APIVersion = "2019-08-01.10.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if maxResults != nil {
		queryParameters["maxresults"] = autorest.Encode("query", *maxResults)
	} else {
		queryParameters["maxresults"] = autorest.Encode("query", 1000)
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	} else {
		queryParameters["timeout"] = autorest.Encode("query", 30)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{batchUrl}", urlParameters),
		autorest.WithPath("/jobschedules"),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	if returnClientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(returnClientRequestID)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(false)))
	}
	if ocpDate != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("ocp-date", autorest.String(ocpDate)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client JobScheduleClient) ListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client JobScheduleClient) ListResponder(resp *http.Response) (result CloudJobScheduleListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client JobScheduleClient) listNextResults(ctx context.Context, lastResults CloudJobScheduleListResult) (result CloudJobScheduleListResult, err error) {
	req, err := lastResults.cloudJobScheduleListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "batch.JobScheduleClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "batch.JobScheduleClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client JobScheduleClient) ListComplete(ctx context.Context, filter string, selectParameter string, expand string, maxResults *int32, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123) (result CloudJobScheduleListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, filter, selectParameter, expand, maxResults, timeout, clientRequestID, returnClientRequestID, ocpDate)
	return
}

// Patch this replaces only the Job Schedule properties specified in the request. For example, if the schedule property
// is not specified with this request, then the Batch service will keep the existing schedule. Changes to a Job
// Schedule only impact Jobs created by the schedule after the update has taken place; currently running Jobs are
// unaffected.
// Parameters:
// jobScheduleID - the ID of the Job Schedule to update.
// jobSchedulePatchParameter - the parameters for the request.
// timeout - the maximum time that the server can spend processing the request, in seconds. The default is 30
// seconds.
// clientRequestID - the caller-generated request identity, in the form of a GUID with no decoration such as
// curly braces, e.g. 9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
// returnClientRequestID - whether the server should return the client-request-id in the response.
// ocpDate - the time the request was issued. Client libraries typically set this to the current system clock
// time; set it explicitly if you are calling the REST API directly.
// ifMatch - an ETag value associated with the version of the resource known to the client. The operation will
// be performed only if the resource's current ETag on the service exactly matches the value specified by the
// client.
// ifNoneMatch - an ETag value associated with the version of the resource known to the client. The operation
// will be performed only if the resource's current ETag on the service does not match the value specified by
// the client.
// ifModifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has been modified since the specified time.
// ifUnmodifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has not been modified since the specified
// time.
func (client JobScheduleClient) Patch(ctx context.Context, jobScheduleID string, jobSchedulePatchParameter JobSchedulePatchParameter, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleClient.Patch")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PatchPreparer(ctx, jobScheduleID, jobSchedulePatchParameter, timeout, clientRequestID, returnClientRequestID, ocpDate, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Patch", nil, "Failure preparing request")
		return
	}

	resp, err := client.PatchSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Patch", resp, "Failure sending request")
		return
	}

	result, err = client.PatchResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Patch", resp, "Failure responding to request")
	}

	return
}

// PatchPreparer prepares the Patch request.
func (client JobScheduleClient) PatchPreparer(ctx context.Context, jobScheduleID string, jobSchedulePatchParameter JobSchedulePatchParameter, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"batchUrl": client.BatchURL,
	}

	pathParameters := map[string]interface{}{
		"jobScheduleId": autorest.Encode("path", jobScheduleID),
	}

	const APIVersion = "2019-08-01.10.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	} else {
		queryParameters["timeout"] = autorest.Encode("query", 30)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; odata=minimalmetadata; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{batchUrl}", urlParameters),
		autorest.WithPathParameters("/jobschedules/{jobScheduleId}", pathParameters),
		autorest.WithJSON(jobSchedulePatchParameter),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	if returnClientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(returnClientRequestID)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(false)))
	}
	if ocpDate != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("ocp-date", autorest.String(ocpDate)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if ifModifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if ifUnmodifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PatchSender sends the Patch request. The method will close the
// http.Response Body if it receives an error.
func (client JobScheduleClient) PatchSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// PatchResponder handles the response to the Patch request. The method always
// closes the http.Response Body.
func (client JobScheduleClient) PatchResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Terminate sends the terminate request.
// Parameters:
// jobScheduleID - the ID of the Job Schedule to terminates.
// timeout - the maximum time that the server can spend processing the request, in seconds. The default is 30
// seconds.
// clientRequestID - the caller-generated request identity, in the form of a GUID with no decoration such as
// curly braces, e.g. 9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
// returnClientRequestID - whether the server should return the client-request-id in the response.
// ocpDate - the time the request was issued. Client libraries typically set this to the current system clock
// time; set it explicitly if you are calling the REST API directly.
// ifMatch - an ETag value associated with the version of the resource known to the client. The operation will
// be performed only if the resource's current ETag on the service exactly matches the value specified by the
// client.
// ifNoneMatch - an ETag value associated with the version of the resource known to the client. The operation
// will be performed only if the resource's current ETag on the service does not match the value specified by
// the client.
// ifModifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has been modified since the specified time.
// ifUnmodifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has not been modified since the specified
// time.
func (client JobScheduleClient) Terminate(ctx context.Context, jobScheduleID string, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleClient.Terminate")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.TerminatePreparer(ctx, jobScheduleID, timeout, clientRequestID, returnClientRequestID, ocpDate, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Terminate", nil, "Failure preparing request")
		return
	}

	resp, err := client.TerminateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Terminate", resp, "Failure sending request")
		return
	}

	result, err = client.TerminateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Terminate", resp, "Failure responding to request")
	}

	return
}

// TerminatePreparer prepares the Terminate request.
func (client JobScheduleClient) TerminatePreparer(ctx context.Context, jobScheduleID string, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"batchUrl": client.BatchURL,
	}

	pathParameters := map[string]interface{}{
		"jobScheduleId": autorest.Encode("path", jobScheduleID),
	}

	const APIVersion = "2019-08-01.10.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	} else {
		queryParameters["timeout"] = autorest.Encode("query", 30)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{batchUrl}", urlParameters),
		autorest.WithPathParameters("/jobschedules/{jobScheduleId}/terminate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	if returnClientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(returnClientRequestID)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(false)))
	}
	if ocpDate != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("ocp-date", autorest.String(ocpDate)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if ifModifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if ifUnmodifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TerminateSender sends the Terminate request. The method will close the
// http.Response Body if it receives an error.
func (client JobScheduleClient) TerminateSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// TerminateResponder handles the response to the Terminate request. The method always
// closes the http.Response Body.
func (client JobScheduleClient) TerminateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Update this fully replaces all the updatable properties of the Job Schedule. For example, if the schedule property
// is not specified with this request, then the Batch service will remove the existing schedule. Changes to a Job
// Schedule only impact Jobs created by the schedule after the update has taken place; currently running Jobs are
// unaffected.
// Parameters:
// jobScheduleID - the ID of the Job Schedule to update.
// jobScheduleUpdateParameter - the parameters for the request.
// timeout - the maximum time that the server can spend processing the request, in seconds. The default is 30
// seconds.
// clientRequestID - the caller-generated request identity, in the form of a GUID with no decoration such as
// curly braces, e.g. 9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
// returnClientRequestID - whether the server should return the client-request-id in the response.
// ocpDate - the time the request was issued. Client libraries typically set this to the current system clock
// time; set it explicitly if you are calling the REST API directly.
// ifMatch - an ETag value associated with the version of the resource known to the client. The operation will
// be performed only if the resource's current ETag on the service exactly matches the value specified by the
// client.
// ifNoneMatch - an ETag value associated with the version of the resource known to the client. The operation
// will be performed only if the resource's current ETag on the service does not match the value specified by
// the client.
// ifModifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has been modified since the specified time.
// ifUnmodifiedSince - a timestamp indicating the last modified time of the resource known to the client. The
// operation will be performed only if the resource on the service has not been modified since the specified
// time.
func (client JobScheduleClient) Update(ctx context.Context, jobScheduleID string, jobScheduleUpdateParameter JobScheduleUpdateParameter, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobScheduleClient.Update")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: jobScheduleUpdateParameter,
			Constraints: []validation.Constraint{{Target: "jobScheduleUpdateParameter.Schedule", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "jobScheduleUpdateParameter.JobSpecification", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.NetworkConfiguration", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.NetworkConfiguration.SubnetID", Name: validation.Null, Rule: true, Chain: nil}}},
						{Target: "jobScheduleUpdateParameter.JobSpecification.JobManagerTask", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.JobManagerTask.ID", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "jobScheduleUpdateParameter.JobSpecification.JobManagerTask.CommandLine", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "jobScheduleUpdateParameter.JobSpecification.JobManagerTask.ContainerSettings", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.JobManagerTask.ContainerSettings.ImageName", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "jobScheduleUpdateParameter.JobSpecification.JobManagerTask.ContainerSettings.Registry", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.JobManagerTask.ContainerSettings.Registry.UserName", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "jobScheduleUpdateParameter.JobSpecification.JobManagerTask.ContainerSettings.Registry.Password", Name: validation.Null, Rule: true, Chain: nil},
											}},
									}},
							}},
						{Target: "jobScheduleUpdateParameter.JobSpecification.JobPreparationTask", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.JobPreparationTask.CommandLine", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "jobScheduleUpdateParameter.JobSpecification.JobPreparationTask.ContainerSettings", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.JobPreparationTask.ContainerSettings.ImageName", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "jobScheduleUpdateParameter.JobSpecification.JobPreparationTask.ContainerSettings.Registry", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.JobPreparationTask.ContainerSettings.Registry.UserName", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "jobScheduleUpdateParameter.JobSpecification.JobPreparationTask.ContainerSettings.Registry.Password", Name: validation.Null, Rule: true, Chain: nil},
											}},
									}},
							}},
						{Target: "jobScheduleUpdateParameter.JobSpecification.JobReleaseTask", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.JobReleaseTask.CommandLine", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "jobScheduleUpdateParameter.JobSpecification.JobReleaseTask.ContainerSettings", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.JobReleaseTask.ContainerSettings.ImageName", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "jobScheduleUpdateParameter.JobSpecification.JobReleaseTask.ContainerSettings.Registry", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.JobReleaseTask.ContainerSettings.Registry.UserName", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "jobScheduleUpdateParameter.JobSpecification.JobReleaseTask.ContainerSettings.Registry.Password", Name: validation.Null, Rule: true, Chain: nil},
											}},
									}},
							}},
						{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo", Name: validation.Null, Rule: true,
							Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.VMSize", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.CloudServiceConfiguration", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.CloudServiceConfiguration.OsFamily", Name: validation.Null, Rule: true, Chain: nil}}},
										{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.VirtualMachineConfiguration", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.VirtualMachineConfiguration.ImageReference", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.VirtualMachineConfiguration.NodeAgentSKUID", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.VirtualMachineConfiguration.ContainerConfiguration", Name: validation.Null, Rule: false,
													Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.VirtualMachineConfiguration.ContainerConfiguration.Type", Name: validation.Null, Rule: true, Chain: nil}}},
											}},
										{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.NetworkConfiguration", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.NetworkConfiguration.EndpointConfiguration", Name: validation.Null, Rule: false,
												Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.NetworkConfiguration.EndpointConfiguration.InboundNATPools", Name: validation.Null, Rule: true, Chain: nil}}},
											}},
										{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask.CommandLine", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask.ContainerSettings", Name: validation.Null, Rule: false,
													Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask.ContainerSettings.ImageName", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask.ContainerSettings.Registry", Name: validation.Null, Rule: false,
															Chain: []validation.Constraint{{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask.ContainerSettings.Registry.UserName", Name: validation.Null, Rule: true, Chain: nil},
																{Target: "jobScheduleUpdateParameter.JobSpecification.PoolInfo.AutoPoolSpecification.Pool.StartTask.ContainerSettings.Registry.Password", Name: validation.Null, Rule: true, Chain: nil},
															}},
													}},
											}},
									}},
								}},
							}},
					}}}}}); err != nil {
		return result, validation.NewError("batch.JobScheduleClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, jobScheduleID, jobScheduleUpdateParameter, timeout, clientRequestID, returnClientRequestID, ocpDate, ifMatch, ifNoneMatch, ifModifiedSince, ifUnmodifiedSince)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batch.JobScheduleClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client JobScheduleClient) UpdatePreparer(ctx context.Context, jobScheduleID string, jobScheduleUpdateParameter JobScheduleUpdateParameter, timeout *int32, clientRequestID *uuid.UUID, returnClientRequestID *bool, ocpDate *date.TimeRFC1123, ifMatch string, ifNoneMatch string, ifModifiedSince *date.TimeRFC1123, ifUnmodifiedSince *date.TimeRFC1123) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"batchUrl": client.BatchURL,
	}

	pathParameters := map[string]interface{}{
		"jobScheduleId": autorest.Encode("path", jobScheduleID),
	}

	const APIVersion = "2019-08-01.10.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	} else {
		queryParameters["timeout"] = autorest.Encode("query", 30)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; odata=minimalmetadata; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{batchUrl}", urlParameters),
		autorest.WithPathParameters("/jobschedules/{jobScheduleId}", pathParameters),
		autorest.WithJSON(jobScheduleUpdateParameter),
		autorest.WithQueryParameters(queryParameters))
	if clientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("client-request-id", autorest.String(clientRequestID)))
	}
	if returnClientRequestID != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(returnClientRequestID)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("return-client-request-id", autorest.String(false)))
	}
	if ocpDate != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("ocp-date", autorest.String(ocpDate)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	if len(ifNoneMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	if ifModifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Modified-Since", autorest.String(ifModifiedSince)))
	}
	if ifUnmodifiedSince != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Unmodified-Since", autorest.String(ifUnmodifiedSince)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client JobScheduleClient) UpdateSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client JobScheduleClient) UpdateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}
