import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import "../../TabLayout/./tab-layout.css";

var TabLayout = function TabLayout(_ref) {
  var children = _ref.children,
      items = _ref.items,
      classNames = _ref.classNames,
      active = _ref.active,
      onTabClick = _ref.onTabClick,
      props = _objectWithoutProperties(_ref, ["children", "items", "classNames", "active", "onTabClick"]);

  return /*#__PURE__*/React.createElement("section", _extends({}, props, {
    className: classnames(classNames, 'ins-tab-layout'),
    "widget-type": "InsightsTabs"
  }), /*#__PURE__*/React.createElement("div", {
    className: "ins-tabs"
  }, items.map(function (oneItem) {
    return /*#__PURE__*/React.createElement("div", {
      key: oneItem.name,
      className: classnames({
        active: oneItem.name === active
      }),
      onClick: function onClick(event) {
        return onTabClick(event, oneItem);
      },
      "widget-type": "InsightsTabsItem",
      "widget-id": oneItem.name
    }, oneItem.title);
  })), /*#__PURE__*/React.createElement("div", {
    className: "ins-tab-content"
  }, children));
};

TabLayout.propTypes = {
  items: PropTypes.arrayOf(PropTypes.shape({
    name: PropTypes.string,
    title: PropTypes.node
  })),
  children: PropTypes.node,
  classNames: PropTypes.string,
  active: PropTypes.string,
  onTabClick: PropTypes.func
};
TabLayout.defaultProps = {
  items: [],
  onTabClick: function onTabClick() {
    return undefined;
  }
};
export default TabLayout;