import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import { ButtonVariant } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import { Dropdown } from "@patternfly/react-core/dist/esm/components/Dropdown/Dropdown.js";
import { DropdownToggle } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggle.js";
import { DropdownItem } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownItem.js";
import { Input } from '../Input';
import SearchIcon from "@patternfly/react-icons/dist/esm/icons/search-icon";
import "../../SimpleTableFilter/./simple-table-filter.css";

var SimpleFilter = /*#__PURE__*/function (_Component) {
  _inherits(SimpleFilter, _Component);

  var _super = _createSuper(SimpleFilter);

  function SimpleFilter() {
    var _this;

    _classCallCheck(this, SimpleFilter);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      activeFilter: '',
      isOpen: false
    });

    _defineProperty(_assertThisInitialized(_this), "onToggle", function (isOpen) {
      _this.setState({
        isOpen: isOpen
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onInputChange", function (event) {
      _this.setState({
        activeFilter: event.target.value
      });

      _this.props.onFilterChange(event.target.value, _this.state.selected);
    });

    _defineProperty(_assertThisInitialized(_this), "onFilterSubmit", function () {
      _this.props.onButtonClick(_this.state.activeFilter, _this.state.selected);
    });

    _defineProperty(_assertThisInitialized(_this), "onFilterSelect", function (event, oneItem) {
      _this.setState({
        selected: oneItem
      });

      _this.props.onOptionSelect(event, oneItem);
    });

    _defineProperty(_assertThisInitialized(_this), "onSelect", function () {
      _this.setState({
        isOpen: false
      });
    });

    return _this;
  }

  _createClass(SimpleFilter, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          placeholder = _this$props.placeholder,
          buttonTitle = _this$props.buttonTitle,
          className = _this$props.className,
          onButtonClick = _this$props.onButtonClick,
          onOptionSelect = _this$props.onOptionSelect,
          onFilterChange = _this$props.onFilterChange,
          options = _this$props.options,
          searchIcon = _this$props.searchIcon,
          widgetId = _this$props.widgetId,
          props = _objectWithoutProperties(_this$props, ["placeholder", "buttonTitle", "className", "onButtonClick", "onOptionSelect", "onFilterChange", "options", "searchIcon", "widgetId"]);

      var _this$state = this.state,
          isOpen = _this$state.isOpen,
          selected = _this$state.selected;
      var dropdownItems = options && options.items && options.items.map(function (oneItem) {
        return /*#__PURE__*/React.createElement(DropdownItem, {
          component: "button",
          key: oneItem.value,
          onClick: function onClick(event) {
            return _this2.onFilterSelect(event, oneItem);
          },
          "data-key": oneItem.value
        }, oneItem.title);
      });
      return /*#__PURE__*/React.createElement("div", _extends({
        className: "pf-c-input-group ins-c-filter ".concat(!buttonTitle ? 'ins-u-no-title' : '', " ").concat(className)
      }, props), options && /*#__PURE__*/React.createElement(Dropdown, {
        onSelect: this.onSelect,
        isOpen: isOpen,
        toggle: /*#__PURE__*/React.createElement(DropdownToggle, {
          onToggle: this.onToggle
        }, selected && selected.title || options.title || 'Dropdown'),
        dropdownItems: dropdownItems
      }), /*#__PURE__*/React.createElement(Input, {
        placeholder: placeholder,
        onKeyPress: function onKeyPress(event) {
          return event.key === 'Enter' && _this2.onInputChange(event);
        },
        "widget-id": widgetId,
        onChange: this.onInputChange
      }), !buttonTitle && searchIcon && /*#__PURE__*/React.createElement(SearchIcon, {
        size: "sm",
        className: "ins-c-search-icon"
      }), buttonTitle && /*#__PURE__*/React.createElement(Button, {
        variant: ButtonVariant.secondary,
        action: "filter",
        onClick: this.onFilterSubmit
      }, buttonTitle));
    }
  }]);

  return SimpleFilter;
}(Component);

SimpleFilter.propTypes = {
  widgetId: PropTypes.string,
  buttonTitle: PropTypes.string,
  placeholder: PropTypes.string,
  className: PropTypes.string,
  options: PropTypes.shape({
    title: PropTypes.string,
    items: PropTypes.arrayOf(PropTypes.shape({
      value: PropTypes.string,
      title: PropTypes.string
    }))
  }),
  onButtonClick: PropTypes.func,
  onFilterChange: PropTypes.func,
  onOptionSelect: PropTypes.func,
  searchIcon: PropTypes.bool
};
SimpleFilter.defaultProps = {
  className: '',
  placeholder: 'Search items',
  buttonTitle: 'Filter',
  onButtonClick: function onButtonClick() {
    return undefined;
  },
  onFilterChange: function onFilterChange() {
    return undefined;
  },
  onOptionSelect: function onOptionSelect() {
    return undefined;
  },
  searchIcon: true
};
export default SimpleFilter;