import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import propTypes from 'prop-types';
import classNames from 'classnames';
import "../../Section/./section.css";

var Section = function Section(_ref) {
  var type = _ref.type,
      children = _ref.children,
      className = _ref.className,
      props = _objectWithoutProperties(_ref, ["type", "children", "className"]);

  var sectionClasses = classNames(className, _defineProperty({}, "ins-l-".concat(type), type !== undefined));
  return /*#__PURE__*/React.createElement("section", _extends({}, props, {
    className: sectionClasses
  }), " ", children, " ");
};

export default Section;
Section.propTypes = {
  type: propTypes.string,
  className: propTypes.string,
  children: propTypes.any.isRequired
};