import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import PropTypes from 'prop-types';
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import { ButtonVariant } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import { TextInput } from "@patternfly/react-core/dist/esm/components/TextInput/TextInput.js";
import AngleDoubleLeftIcon from "@patternfly/react-icons/dist/esm/icons/angle-double-left-icon";
import AngleLeftIcon from "@patternfly/react-icons/dist/esm/icons/angle-left-icon";
import AngleDoubleRightIcon from "@patternfly/react-icons/dist/esm/icons/angle-double-right-icon";
import AngleRightIcon from "@patternfly/react-icons/dist/esm/icons/angle-right-icon";

var PaginationNav = function PaginationNav(_ref) {
  var lastPage = _ref.lastPage,
      setPage = _ref.setPage,
      pageTitle = _ref.pageTitle,
      amountOfPages = _ref.amountOfPages,
      page = _ref.page,
      onFirstPage = _ref.onFirstPage,
      onLastPage = _ref.onLastPage,
      onPreviousPage = _ref.onPreviousPage,
      onNextPage = _ref.onNextPage,
      props = _objectWithoutProperties(_ref, ["lastPage", "setPage", "pageTitle", "amountOfPages", "page", "onFirstPage", "onLastPage", "onPreviousPage", "onNextPage"]);

  return /*#__PURE__*/React.createElement("nav", _extends({
    className: "pf-c-pagination__nav",
    "aria-label": "Pagination"
  }, props), /*#__PURE__*/React.createElement(Button, {
    variant: ButtonVariant.plain,
    isDisabled: page === 1,
    "aria-label": "Go to first page",
    "data-action": "first-page",
    onClick: function onClick(event) {
      onFirstPage(event);
      setPage(event, 1);
    }
  }, /*#__PURE__*/React.createElement(AngleDoubleLeftIcon, null)), /*#__PURE__*/React.createElement(Button, {
    variant: ButtonVariant.plain,
    isDisabled: page === 1,
    "aria-label": "Go to previous page",
    "data-action": "previous-page",
    onClick: function onClick(event) {
      onPreviousPage(event, page - 1);
      setPage(event, page - 1);
    }
  }, /*#__PURE__*/React.createElement(AngleLeftIcon, null)), /*#__PURE__*/React.createElement("div", {
    className: "pf-c-pagination__nav-page-select",
    "aria-label": "Current page ".concat(page, " of ").concat(lastPage)
  }, /*#__PURE__*/React.createElement(TextInput, {
    className: "pf-c-form-control",
    "aria-label": "Current page",
    type: "number",
    min: "1",
    "data-action": "set-page",
    max: amountOfPages,
    style: {
      width: "".concat(lastPage.toString().length, "rem"),
      minWidth: '3rem'
    },
    isReadOnly: amountOfPages === 1,
    value: page,
    onChange: function onChange(value, event) {
      setPage(event, value === '' ? NaN : Number(value));
    }
  }), /*#__PURE__*/React.createElement("span", {
    "aria-hidden": "true"
  }, "of ", lastPage, " ", pageTitle)), /*#__PURE__*/React.createElement(Button, {
    variant: ButtonVariant.plain,
    isDisabled: page === lastPage,
    "aria-label": "Go to next page",
    "data-action": "next-page",
    onClick: function onClick(event) {
      onNextPage(event, page + 1);
      setPage(event, page + 1);
    }
  }, /*#__PURE__*/React.createElement(AngleRightIcon, null)), /*#__PURE__*/React.createElement(Button, {
    variant: ButtonVariant.plain,
    isDisabled: page === lastPage,
    "aria-label": "Go to last page",
    "data-action": "last-page",
    onClick: function onClick(event) {
      onLastPage(event);
      setPage(event, lastPage);
    }
  }, /*#__PURE__*/React.createElement(AngleDoubleRightIcon, null)));
};

PaginationNav.propTypes = {
  lastPage: PropTypes.number,
  page: PropTypes.number,
  pageTitle: PropTypes.string,
  setPage: PropTypes.func,
  amountOfPages: PropTypes.number,
  onFirstPage: PropTypes.func,
  onLastPage: PropTypes.func,
  onPreviousPage: PropTypes.func,
  onNextPage: PropTypes.func
};
PaginationNav.defaultProps = {
  pageTitle: 'pages',
  onFirstPage: function onFirstPage() {
    return undefined;
  },
  onLastPage: function onLastPage() {
    return undefined;
  },
  onPreviousPage: function onPreviousPage() {
    return undefined;
  },
  onNextPage: function onNextPage() {
    return undefined;
  }
};
export default PaginationNav;