import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component } from 'react';
import propTypes from 'prop-types';
import classNames from 'classnames';
import { connect } from 'react-redux';
import ThemeContext from '../Dark/configContext';
import "../../Main/./main.css";

var toKebab = function toKebab(text) {
  return text.replace(/([a-z0-9])([A-Z])/g, '$1-$2').toLowerCase();
};
/**
 * This is a component that wraps the page
 */


export var Main = /*#__PURE__*/function (_Component) {
  _inherits(Main, _Component);

  var _super = _createSuper(Main);

  function Main() {
    _classCallCheck(this, Main);

    return _super.apply(this, arguments);
  }

  _createClass(Main, [{
    key: "calculateLocation",
    value: function calculateLocation() {
      var _this$props = this.props,
          path = _this$props.path,
          params = _this$props.params;

      if (insights && insights.chrome && insights.chrome.$internal && insights.chrome.$internal.store) {
        var chromeState = insights.chrome.$internal.store.getState();

        if (path && chromeState) {
          return path.split('/').reduce(function (acc, curr) {
            if (curr.indexOf(':') === 0) {
              acc.dynamic = _objectSpread(_objectSpread({}, acc.dynamic), {}, _defineProperty({}, "data-".concat(toKebab(curr.substr(1))), params[curr.substr(1)]));
            } else {
              acc.staticPart = [].concat(_toConsumableArray(acc.staticPart), _toConsumableArray(curr !== '' ? [curr] : []));
            }

            return acc;
          }, {
            staticPart: [chromeState.chrome.appId],
            dynamic: {}
          });
        }
      }

      return {
        staticPart: []
      };
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          className = _this$props2.className,
          children = _this$props2.children,
          params = _this$props2.params,
          path = _this$props2.path,
          props = _objectWithoutProperties(_this$props2, ["className", "children", "params", "path"]);

      var _this$calculateLocati = this.calculateLocation(),
          dynamic = _this$calculateLocati.dynamic,
          staticPart = _this$calculateLocati.staticPart;

      return /*#__PURE__*/React.createElement(ThemeContext.Consumer, null, function () {
        var theme = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'light';
        var themeClasses = classNames(_defineProperty({}, "pf-m-".concat(theme), theme === 'dark'));
        return {
          dark: /*#__PURE__*/React.createElement("section", _extends({}, props, dynamic, {
            "page-type": staticPart.join('-'),
            className: "".concat(classNames(className, 'pf-l-page__main-section pf-c-page__main-section'), " ").concat(themeClasses)
          }), React.Children.map(children, function (child) {
            return /*#__PURE__*/React.cloneElement(child, {
              className: 'pf-m-dark'
            });
          })),
          light: /*#__PURE__*/React.createElement("section", _extends({}, props, dynamic, {
            "page-type": staticPart.join('-'),
            className: "".concat(classNames(className, 'pf-l-page__main-section pf-c-page__main-section'))
          }), children)
        }[theme];
      });
    }
  }]);

  return Main;
}(Component);
Main.propTypes = {
  className: propTypes.string,
  children: propTypes.any.isRequired,
  params: propTypes.any,
  path: propTypes.string
};
export default connect(function (_ref) {
  var routerData = _ref.routerData;
  return {
    params: routerData && routerData.params,
    path: routerData && routerData.path
  };
}, function () {
  return {};
})(Main);