import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import React, { useCallback, useState, useRef, useEffect } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { TextInput } from "@patternfly/react-core/dist/esm/components/TextInput/TextInput.js";
import { MenuList } from "@patternfly/react-core/dist/esm/components/Menu/MenuList.js";
import { MenuItem } from "@patternfly/react-core/dist/esm/components/Menu/MenuItem.js";
import { MenuGroup } from "@patternfly/react-core/dist/esm/components/Menu/MenuGroup.js";
import { Checkbox } from "@patternfly/react-core/dist/esm/components/Checkbox/Checkbox.js";
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import { MenuToggle } from "@patternfly/react-core/dist/esm/components/MenuToggle/MenuToggle.js";
import { Menu } from "@patternfly/react-core/dist/esm/components/Menu/Menu.js";
import { MenuContent } from "@patternfly/react-core/dist/esm/components/Menu/MenuContent.js";
import { Popper } from "@patternfly/react-core/dist/esm/helpers/Popper/Popper.js";
import { Radio } from "@patternfly/react-core/dist/esm/components/Radio/Radio.js";
import { isChecked, calculateSelected, getGroupMenuItems, getMenuItems } from './groupFilterConstants';
import groupType from './groupType';

var Group = function Group(_ref) {
  var placeholder = _ref.placeholder,
      onShowMore = _ref.onShowMore,
      showMoreTitle = _ref.showMoreTitle,
      showMoreOptions = _ref.showMoreOptions,
      items = _ref.items,
      filterBy = _ref.filterBy,
      onFilter = _ref.onFilter,
      className = _ref.className,
      _ref$groups = _ref.groups,
      groups = _ref$groups === void 0 ? [] : _ref$groups,
      onChange = _ref.onChange,
      selected = _ref.selected,
      isFilterable = _ref.isFilterable;

  var _useState = useState({}),
      _useState2 = _slicedToArray(_useState, 2),
      stateSelected = _useState2[0],
      setStateSelected = _useState2[1];

  var _useState3 = useState(''),
      _useState4 = _slicedToArray(_useState3, 2),
      searchString = _useState4[0],
      setSearchString = _useState4[1];

  var _useState5 = useState(false),
      _useState6 = _slicedToArray(_useState5, 2),
      isOpen = _useState6[0],
      setIsOpen = _useState6[1];

  var toggleRef = useRef();
  var containerRef = useRef();
  var menuRef = useRef();
  useEffect(function () {
    setStateSelected(selected);
  }, [selected]);
  var calculateSelection = useCallback(calculateSelected, [stateSelected]);
  useEffect(function () {
    setSearchString(filterBy);
  }, [filterBy]);

  var handleMenuKeys = function handleMenuKeys(event) {
    if (!isOpen) {
      return;
    }

    if (menuRef.current.contains(event.target) || toggleRef.current.contains(event.target)) {
      if (event.key === 'Escape' || event.key === 'Enter') {
        setIsOpen(!isOpen);
        toggleRef.current.focus();
      }
    }
  };

  var handleClickOutside = function handleClickOutside(event) {
    if (isOpen && !menuRef.current.contains(event.target)) {
      setIsOpen(false);
    }
  };

  useEffect(function () {
    window.addEventListener('keydown', handleMenuKeys);
    window.addEventListener('click', handleClickOutside);
    return function () {
      window.removeEventListener('keydown', handleMenuKeys);
      window.removeEventListener('click', handleClickOutside);
    };
  }, [isOpen, menuRef]);

  var onToggleClick = function onToggleClick(ev) {
    ev.stopPropagation(); // Stop handleClickOutside from handling

    ev.persist();
    setIsOpen(!isOpen);
  };

  var groupMenuItems = getGroupMenuItems(groups, onChange, calculateSelection(selected));
  var menuItems = getMenuItems(items, onChange, calculateSelection(selected)); // eslint-disable-next-line react/prop-types

  var renderItems = function renderItems(items, type) {
    var groupKey = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
    return items.map(function (item, key) {
      return /*#__PURE__*/React.createElement(MenuItem, {
        itemId: key,
        key: "".concat(item.value, "-").concat(key, "-item"),
        className: item === null || item === void 0 ? void 0 : item.className,
        onClick: item.onClick && (type || item.type) === groupType.checkbox ? function (e) {
          item.onClick();
          e.preventDefault();
        } : undefined
      }, (type || item.type) === groupType.checkbox ? /*#__PURE__*/React.createElement(Checkbox, _extends({}, item, {
        label: item === null || item === void 0 ? void 0 : item.label,
        isChecked: (item === null || item === void 0 ? void 0 : item.isChecked) || isChecked(groupKey, (item === null || item === void 0 ? void 0 : item.value) || key, item === null || item === void 0 ? void 0 : item.id, item === null || item === void 0 ? void 0 : item.tagValue, stateSelected, selected) || false,
        onChange: function onChange(value, event) {
          var _item$onChange;

          item === null || item === void 0 ? void 0 : (_item$onChange = item.onChange) === null || _item$onChange === void 0 ? void 0 : _item$onChange.call(item, value, event);
        },
        onClick: item.onClick ? function (e) {
          item.onClick();
          e.stopPropagation();
        } : undefined,
        name: (item === null || item === void 0 ? void 0 : item.name) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key),
        id: (item === null || item === void 0 ? void 0 : item.id) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key)
      })) : (type || item.type) === groupType.radio ? /*#__PURE__*/React.createElement(Radio, _extends({}, item, {
        isChecked: (item === null || item === void 0 ? void 0 : item.isChecked) || isChecked((groups === null || groups === void 0 ? void 0 : groups.value) || groupKey, (item === null || item === void 0 ? void 0 : item.value) || key, item === null || item === void 0 ? void 0 : item.id, item === null || item === void 0 ? void 0 : item.tagValue, stateSelected, selected) || false,
        onChange: function onChange(value, event) {
          var _item$onChange2;

          item === null || item === void 0 ? void 0 : (_item$onChange2 = item.onChange) === null || _item$onChange2 === void 0 ? void 0 : _item$onChange2.call(item, value, event);
        },
        value: (item === null || item === void 0 ? void 0 : item.value) || key,
        name: (item === null || item === void 0 ? void 0 : item.name) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key),
        label: (item === null || item === void 0 ? void 0 : item.label) || '',
        id: (item === null || item === void 0 ? void 0 : item.id) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key)
      })) : (type || item.type) === groupType.button ? /*#__PURE__*/React.createElement(Button, _extends({}, item, {
        className: "pf-c-select__option-button ".concat((item === null || item === void 0 ? void 0 : item.className) || ''),
        variant: item === null || item === void 0 ? void 0 : item.variant,
        onClick: item.onClick
      }), item === null || item === void 0 ? void 0 : item.label) : (item === null || item === void 0 ? void 0 : item.label) || '');
    });
  };

  return /*#__PURE__*/React.createElement("div", {
    ref: containerRef
  }, /*#__PURE__*/React.createElement(Popper, {
    appendTo: containerRef.current,
    trigger: /*#__PURE__*/React.createElement(MenuToggle, {
      ref: toggleRef,
      onClick: onToggleClick,
      isExpanded: isOpen,
      className: className
    }, isFilterable || onFilter ? /*#__PURE__*/React.createElement(TextInput, {
      "aria-label": "input with dropdown and clear button",
      placeholder: placeholder,
      value: searchString,
      tabIndex: 0,
      onChange: function onChange(value) {
        setSearchString(value);
        onFilter === null || onFilter === void 0 ? void 0 : onFilter(value);
      },
      type: "search"
    }) : placeholder),
    popper: /*#__PURE__*/React.createElement(Menu, {
      ref: menuRef,
      className: classNames('ins-c-menu__scrollable', className, {
        'pf-m-expanded': isOpen
      })
    }, /*#__PURE__*/React.createElement(MenuContent, null, /*#__PURE__*/React.createElement(MenuList, null, menuItems.length > 0 && /*#__PURE__*/React.createElement(MenuGroup, null, renderItems(items)), groupMenuItems.map(function (group, groupKey) {
      return /*#__PURE__*/React.createElement(MenuGroup, {
        label: group.label,
        key: "".concat(group.label, "-").concat(groupKey, "-group")
      }, renderItems(group.items, group.type, group.value, group));
    }), onShowMore ? /*#__PURE__*/React.createElement(MenuItem, _extends({
      itemId: "loader",
      className: "ins-c-menu__show--more"
    }, showMoreOptions, {
      onClick: function onClick(e) {
        return onShowMore(e);
      }
    }), showMoreTitle) : /*#__PURE__*/React.createElement("span", {
      hidden: true,
      value: ""
    })))),
    isVisible: isOpen
  }));
};

Group.propTypes = {
  placeholder: PropTypes.string,
  onShowMore: PropTypes.func,
  showMoreTitle: PropTypes.node,
  onShowMoreTitle: PropTypes.func,
  showMoreOptions: PropTypes.any,
  items: PropTypes.arrayOf(PropTypes.shape({
    id: PropTypes.string,
    value: PropTypes.string,
    label: PropTypes.node
  })),
  className: PropTypes.string,
  selected: PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.any)))))),
  isFilterable: PropTypes.bool,
  filterBy: PropTypes.string,
  onFilter: PropTypes.func,
  groups: PropTypes.arrayOf(PropTypes.shape({
    type: PropTypes.oneOf(Object.keys(groupType)),
    value: PropTypes.string,
    label: PropTypes.node,
    items: PropTypes.arrayOf(PropTypes.shape({
      id: PropTypes.string,
      tagKey: PropTypes.string
    }))
  })),
  onChange: PropTypes.func.isRequired,
  selectedTags: PropTypes.shape({})
};
export default Group;