"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _Stack = require("@patternfly/react-core/dist/js/layouts/Stack/Stack.js");

var _StackItem = require("@patternfly/react-core/dist/js/layouts/Stack/StackItem.js");

var _sanitizeHtml = _interopRequireDefault(require("sanitize-html"));

require("./truncate.css");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var dangerousHtml = function dangerousHtml(html) {
  return {
    __html: (0, _sanitizeHtml["default"])(html)
  };
};

var Truncate = function Truncate(_ref) {
  var _ref$text = _ref.text,
      text = _ref$text === void 0 ? '' : _ref$text,
      _ref$length = _ref.length,
      length = _ref$length === void 0 ? 150 : _ref$length,
      _ref$expandText = _ref.expandText,
      expandText = _ref$expandText === void 0 ? 'Read more' : _ref$expandText,
      _ref$hideExpandText = _ref.hideExpandText,
      hideExpandText = _ref$hideExpandText === void 0 ? false : _ref$hideExpandText,
      _ref$expandOnMouseOve = _ref.expandOnMouseOver,
      expandOnMouseOver = _ref$expandOnMouseOve === void 0 ? false : _ref$expandOnMouseOve,
      _ref$collapseText = _ref.collapseText,
      collapseText = _ref$collapseText === void 0 ? 'Collapse' : _ref$collapseText,
      className = _ref.className,
      inline = _ref.inline,
      spaceBetween = _ref.spaceBetween;
  var truncateClasses = (0, _classnames["default"])('ins-c-truncate', className, (0, _defineProperty2["default"])({}, "is-inline", inline), (0, _defineProperty2["default"])({}, "is-block", !inline));
  var trimmedText = text.substring(0, length);
  var textOverflow = text.length > length;

  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
      showText = _useState2[0],
      setShowText = _useState2[1];

  var toggleText = function toggleText(event) {
    event && event.preventDefault();
    setShowText(!showText);
  };

  var expandButton = /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    className: "ins-c-expand-button",
    variant: "link",
    onClick: toggleText
  }, expandText);

  var collapseButton = /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    className: "ins-c-collapse-button",
    variant: "link",
    onClick: toggleText
  }, collapseText);

  var textWithOverflow = showText === false ? "".concat(trimmedText).concat(textOverflow ? '...' : '') : text;
  var html = dangerousHtml(textWithOverflow);
  var mouseOverHandler = expandOnMouseOver && {
    onMouseEnter: function onMouseEnter() {
      return setShowText(true);
    },
    onMouseLeave: function onMouseLeave() {
      return setShowText(false);
    }
  };
  return inline ? /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, /*#__PURE__*/_react["default"].createElement("span", (0, _extends2["default"])({
    className: truncateClasses,
    "widget-type": "InsightsTruncateInline",
    dangerouslySetInnerHTML: html
  }, mouseOverHandler)), !hideExpandText && textOverflow && (showText === false ? expandButton : collapseButton)) : /*#__PURE__*/_react["default"].createElement(_Stack.Stack, {
    className: truncateClasses
  }, /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, mouseOverHandler, /*#__PURE__*/_react["default"].createElement("span", {
    "widget-type": "InsightsTruncateBlock",
    dangerouslySetInnerHTML: html
  })), !hideExpandText && textOverflow && /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, {
    className: spaceBetween && 'pf-u-mt-sm'
  }, showText === false ? expandButton : collapseButton));
};

Truncate.propTypes = {
  className: _propTypes["default"].string,
  text: _propTypes["default"].string,
  length: _propTypes["default"].number,
  expandText: _propTypes["default"].string,
  collapseText: _propTypes["default"].string,
  inline: _propTypes["default"].bool,
  spaceBetween: _propTypes["default"].bool,
  hideExpandText: _propTypes["default"].bool,
  expandOnMouseOver: _propTypes["default"].bool
};
var _default = Truncate;
exports["default"] = _default;