"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _TextInput = require("@patternfly/react-core/dist/js/components/TextInput/TextInput.js");

var _angleDoubleLeftIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/angle-double-left-icon"));

var _angleLeftIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/angle-left-icon"));

var _angleDoubleRightIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/angle-double-right-icon"));

var _angleRightIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/angle-right-icon"));

var PaginationNav = function PaginationNav(_ref) {
  var lastPage = _ref.lastPage,
      setPage = _ref.setPage,
      pageTitle = _ref.pageTitle,
      amountOfPages = _ref.amountOfPages,
      page = _ref.page,
      onFirstPage = _ref.onFirstPage,
      onLastPage = _ref.onLastPage,
      onPreviousPage = _ref.onPreviousPage,
      onNextPage = _ref.onNextPage,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["lastPage", "setPage", "pageTitle", "amountOfPages", "page", "onFirstPage", "onLastPage", "onPreviousPage", "onNextPage"]);
  return /*#__PURE__*/_react["default"].createElement("nav", (0, _extends2["default"])({
    className: "pf-c-pagination__nav",
    "aria-label": "Pagination"
  }, props), /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    variant: _Button.ButtonVariant.plain,
    isDisabled: page === 1,
    "aria-label": "Go to first page",
    "data-action": "first-page",
    onClick: function onClick(event) {
      onFirstPage(event);
      setPage(event, 1);
    }
  }, /*#__PURE__*/_react["default"].createElement(_angleDoubleLeftIcon["default"], null)), /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    variant: _Button.ButtonVariant.plain,
    isDisabled: page === 1,
    "aria-label": "Go to previous page",
    "data-action": "previous-page",
    onClick: function onClick(event) {
      onPreviousPage(event, page - 1);
      setPage(event, page - 1);
    }
  }, /*#__PURE__*/_react["default"].createElement(_angleLeftIcon["default"], null)), /*#__PURE__*/_react["default"].createElement("div", {
    className: "pf-c-pagination__nav-page-select",
    "aria-label": "Current page ".concat(page, " of ").concat(lastPage)
  }, /*#__PURE__*/_react["default"].createElement(_TextInput.TextInput, {
    className: "pf-c-form-control",
    "aria-label": "Current page",
    type: "number",
    min: "1",
    "data-action": "set-page",
    max: amountOfPages,
    style: {
      width: "".concat(lastPage.toString().length, "rem"),
      minWidth: '3rem'
    },
    isReadOnly: amountOfPages === 1,
    value: page,
    onChange: function onChange(value, event) {
      setPage(event, value === '' ? NaN : Number(value));
    }
  }), /*#__PURE__*/_react["default"].createElement("span", {
    "aria-hidden": "true"
  }, "of ", lastPage, " ", pageTitle)), /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    variant: _Button.ButtonVariant.plain,
    isDisabled: page === lastPage,
    "aria-label": "Go to next page",
    "data-action": "next-page",
    onClick: function onClick(event) {
      onNextPage(event, page + 1);
      setPage(event, page + 1);
    }
  }, /*#__PURE__*/_react["default"].createElement(_angleRightIcon["default"], null)), /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    variant: _Button.ButtonVariant.plain,
    isDisabled: page === lastPage,
    "aria-label": "Go to last page",
    "data-action": "last-page",
    onClick: function onClick(event) {
      onLastPage(event);
      setPage(event, lastPage);
    }
  }, /*#__PURE__*/_react["default"].createElement(_angleDoubleRightIcon["default"], null)));
};

PaginationNav.propTypes = {
  lastPage: _propTypes["default"].number,
  page: _propTypes["default"].number,
  pageTitle: _propTypes["default"].string,
  setPage: _propTypes["default"].func,
  amountOfPages: _propTypes["default"].number,
  onFirstPage: _propTypes["default"].func,
  onLastPage: _propTypes["default"].func,
  onPreviousPage: _propTypes["default"].func,
  onNextPage: _propTypes["default"].func
};
PaginationNav.defaultProps = {
  pageTitle: 'pages',
  onFirstPage: function onFirstPage() {
    return undefined;
  },
  onLastPage: function onLastPage() {
    return undefined;
  },
  onPreviousPage: function onPreviousPage() {
    return undefined;
  },
  onNextPage: function onNextPage() {
    return undefined;
  }
};
var _default = PaginationNav;
exports["default"] = _default;