"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactCore = require("@scalprum/react-core");

var _reactRouterDom = require("react-router-dom");

var _reactRedux = require("react-redux");

var _Bullseye = require("@patternfly/react-core/dist/js/layouts/Bullseye/Bullseye.js");

var _Spinner = require("@patternfly/react-core/dist/js/components/Spinner/Spinner.js");

var _InventoryLoadError = _interopRequireDefault(require("./InventoryLoadError"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var BaseInventoryDetail = function BaseInventoryDetail(props) {
  var history = (0, _reactRouterDom.useHistory)();
  var store = (0, _reactRedux.useStore)();
  return /*#__PURE__*/_react["default"].createElement(_react.Suspense, {
    fallback: props.fallback
  }, /*#__PURE__*/_react["default"].createElement(_reactCore.ScalprumComponent, (0, _extends2["default"])({
    history: history,
    store: store,
    appName: "inventory",
    module: "./InventoryDetail",
    scope: "inventory",
    ErrorComponent: /*#__PURE__*/_react["default"].createElement(_InventoryLoadError["default"], (0, _extends2["default"])({
      component: "InventoryDetailHead",
      history: history,
      store: store
    }, props)),
    ref: props.innerRef
  }, props)));
};

BaseInventoryDetail.propTypes = {
  fallback: _propTypes["default"].node,
  innerRef: _propTypes["default"].object
};
/**
 * Inventory sub component.
 *
 * This component shows complete inventory detail with system info and app's detail in tab(s).
 */

var InventoryDetail = /*#__PURE__*/_react["default"].forwardRef(function (props, ref) {
  return /*#__PURE__*/_react["default"].createElement(BaseInventoryDetail, (0, _extends2["default"])({
    innerRef: ref
  }, props));
});

InventoryDetail.propTypes = {
  /** React Suspense fallback component. <a href="https://reactjs.org/docs/code-splitting.html#reactlazy" target="_blank">Learn more</a>. */
  fallback: _propTypes["default"].node
};
InventoryDetail.defaultProps = {
  fallback: /*#__PURE__*/_react["default"].createElement(_Bullseye.Bullseye, {
    className: "pf-u-p-lg"
  }, /*#__PURE__*/_react["default"].createElement(_Spinner.Spinner, {
    size: "xl"
  }))
};
var _default = InventoryDetail;
exports["default"] = _default;