"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _TextInput = require("@patternfly/react-core/dist/js/components/TextInput/TextInput.js");

var _searchIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/search-icon"));

require("./conditional-filter.css");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var Text = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(Text, _Component);

  var _super = _createSuper(Text);

  function Text() {
    var _this;

    (0, _classCallCheck2["default"])(this, Text);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "state", {
      stateValue: ''
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onChangeValue", function (e, value) {
      _this.setState({
        stateValue: value
      });
    });
    return _this;
  }

  (0, _createClass2["default"])(Text, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          value = _this$props.value,
          onChange = _this$props.onChange,
          onSubmit = _this$props.onSubmit,
          id = _this$props.id,
          icon = _this$props.icon,
          className = _this$props.className,
          isDisabled = _this$props.isDisabled,
          props = (0, _objectWithoutProperties2["default"])(_this$props, ["value", "onChange", "onSubmit", "id", "icon", "className", "isDisabled"]);
      var Icon = icon || _searchIcon["default"];
      var stateValue = this.state.stateValue;
      var changeCallback = onChange ? onChange : this.onChangeValue;
      return /*#__PURE__*/_react["default"].createElement(_react.Fragment, null, /*#__PURE__*/_react["default"].createElement(_TextInput.TextInput, (0, _extends2["default"])({}, props, {
        className: "ins-c-conditional-filter ".concat(className || ''),
        id: id,
        isDisabled: isDisabled,
        value: onChange ? value : stateValue,
        onChange: function onChange(_inputValue, e) {
          return changeCallback(e, e.target.value);
        },
        "widget-type": "InsightsInput",
        onKeyDown: function onKeyDown(e) {
          return e.key === 'Enter' && onSubmit(e, value || stateValue);
        },
        "data-ouia-component-type": "PF4/TextInput",
        ouiaId: "ConditionalFilter"
      })), /*#__PURE__*/_react["default"].createElement(Icon, {
        size: "sm",
        className: "ins-c-search-icon"
      }));
    }
  }]);
  return Text;
}(_react.Component);

Text.propTypes = {
  value: _propTypes["default"].string,
  placeholder: _propTypes["default"].string,
  onChange: _propTypes["default"].func,
  onSubmit: _propTypes["default"].func,
  isDisabled: _propTypes["default"].bool,
  'aria-label': _propTypes["default"].string,
  id: _propTypes["default"].string,
  icon: _propTypes["default"].elementType,
  className: _propTypes["default"].string
};
Text.defaultProps = {
  value: '',
  onSubmit: function onSubmit() {
    return undefined;
  },
  isDisabled: false,
  'aria-label': 'text input'
};
var _default = Text;
exports["default"] = _default;