"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _CriticalBattery = _interopRequireDefault(require("./CriticalBattery"));

var _HighBattery = _interopRequireDefault(require("./HighBattery"));

var _MediumBattery = _interopRequireDefault(require("./MediumBattery"));

var _LowBattery = _interopRequireDefault(require("./LowBattery"));

var _NullBattery = _interopRequireDefault(require("./NullBattery"));

require("./battery.css");

/* eslint max-len: 0 */

/**
 * This is the battery component that generates a 'battery'
 * which corresponds to a level 1-4
 * 1 - low, green - best case scenario
 * 2 - medium, yellow
 * 3 - high, orange
 * 4 - critical, red - worst case scenario
 * Also accepts a label which can be made invisible
 */
var Battery = function Battery(_ref) {
  var severity = _ref.severity,
      label = _ref.label,
      labelHidden = _ref.labelHidden,
      className = _ref.className,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["severity", "label", "labelHidden", "className"]);
  var batteryClasses = (0, _classnames["default"])(className, 'ins-battery', (0, _defineProperty2["default"])({}, "ins-battery-".concat(severity), severity !== undefined));
  var ariaLabels = {};

  if (labelHidden) {
    ariaLabels = (0, _defineProperty2["default"])({}, 'aria-label', severity + ' ' + label);
  }

  function batteryLevels(severity) {
    switch (severity) {
      case 'critical':
      case 4:
        return /*#__PURE__*/_react["default"].createElement(_CriticalBattery["default"], null);

      case 'high':
      case 'error':
      case 3:
        return /*#__PURE__*/_react["default"].createElement(_HighBattery["default"], null);

      case 'medium':
      case 'warn':
      case 2:
        return /*#__PURE__*/_react["default"].createElement(_MediumBattery["default"], null);

      case 'low':
      case 'info':
      case 1:
        return /*#__PURE__*/_react["default"].createElement(_LowBattery["default"], null);

      default:
        // eslint-disable-next-line
        console.error('Warning: Unsupported value presented to battery component');
        return /*#__PURE__*/_react["default"].createElement(_NullBattery["default"], null);
    }
  }

  return /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, /*#__PURE__*/_react["default"].createElement("i", (0, _extends2["default"])({
    className: batteryClasses
  }, ariaLabels, props, {
    "widget-type": "InsightsBattery",
    "widget-id": label
  }), /*#__PURE__*/_react["default"].createElement("svg", {
    version: "1.1",
    id: "battery_svg",
    x: "0px",
    y: "0px",
    viewBox: "0 0 448 512",
    style: {
      enableBackground: 'new 0 0 448 512'
    },
    shapeRendering: "geometricpresision"
  }, /*#__PURE__*/_react["default"].createElement("path", {
    style: {
      fill: 'none',
      fillOpacity: 1,
      stroke: '#969696',
      strokeWidth: 41.96378708,
      strokeLinejoin: 'round',
      strokeMiterlimit: 4,
      strokeDasharray: 'none',
      strokeDashoffset: 0,
      strokeOpacity: 1
    },
    d: "m 144.16452,21.032222 h 159.67454 q 123.1748,0 123.1748,128.667868 v 212.64759 q 0,128.66788 -123.1748,128.66788 H 144.16452 q -123.174811,0 -123.174811,-128.66788 V 149.70009 q 0,-128.667868 123.174811,-128.667868 z"
  }), batteryLevels(severity))), !labelHidden && /*#__PURE__*/_react["default"].createElement("span", {
    className: "label"
  }, " ", label, " "));
};

var _default = Battery;
exports["default"] = _default;
Battery.propTypes = {
  severity: _propTypes["default"].oneOf([1, 2, 3, 4, 'info', 'low', 'warn', 'medium', 'error', 'high', 'critical']),
  label: _propTypes["default"].string.isRequired,
  labelHidden: _propTypes["default"].bool,
  className: _propTypes["default"].string
};
Battery.defaultProps = {
  severity: 'null'
};