var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
export var GLOBAL_NAMESPACE = '__scalprum__';
export var getScalprum = function () { return window[GLOBAL_NAMESPACE]; };
export var getCachedModule = function (scope, module, skipCache) {
    if (skipCache === void 0) { skipCache = false; }
    var factory = window[GLOBAL_NAMESPACE].factories[scope];
    if (!factory) {
        return undefined;
    }
    var isExpired = skipCache || (new Date().getTime() - factory.expiration.getTime()) / 1000 > window[GLOBAL_NAMESPACE].scalprumOptions.cacheTimeout;
    if (isExpired) {
        delete window[GLOBAL_NAMESPACE].factories[scope];
        return undefined;
    }
    var cachedModule = factory.modules[module];
    if (!module) {
        return undefined;
    }
    return cachedModule;
};
export var setPendingInjection = function (id, callback) {
    window[GLOBAL_NAMESPACE].pendingInjections[id] = callback;
};
export var initialize = function (_a) {
    var appsConfig = _a.appsConfig, api = _a.api, options = _a.options;
    var defaultOptions = __assign({ cacheTimeout: 120 }, options);
    window[GLOBAL_NAMESPACE] = __assign({ appsConfig: appsConfig, pendingInjections: {}, factories: {}, scalprumOptions: defaultOptions }, api);
};
export var getAppData = function (name) { return window[GLOBAL_NAMESPACE].appsConfig[name]; };
export var injectScript = function (appName, scriptLocation, skipPending) {
    if (skipPending === void 0) { skipPending = false; }
    var s = undefined;
    var injectionPromise = new Promise(function (res, rej) {
        s = document.createElement('script');
        s.src = scriptLocation;
        s.id = appName;
        if (skipPending) {
            s.onload = function () {
                res([appName, s]);
            };
        }
        else {
            setPendingInjection(appName, function () { return res([appName, s]); });
        }
        s.onerror = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            console.log(args);
            if (skipPending) {
                rej([args, s]);
            }
            else {
                setPendingInjection(appName, function () { return rej([args, s]); });
            }
        };
    });
    if (typeof s !== 'undefined') {
        document.body.appendChild(s);
    }
    return injectionPromise;
};
export function processManifest(url, appName, scope, processor) {
    return __awaiter(this, void 0, void 0, function () {
        var manifest;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, fetch(url)];
                case 1: return [4, (_a.sent()).json()];
                case 2:
                    manifest = _a.sent();
                    return [2, Promise.all(Object.entries(manifest)
                            .filter(function (_a) {
                            var key = _a[0];
                            return (scope ? key === scope : true);
                        })
                            .flatMap(processor || (function (value) { return value[1].entry || value; }))
                            .map(function (scriptLocation) { return injectScript(appName, scriptLocation, true); }))];
            }
        });
    });
}
export function asyncLoader(scope, module) {
    return __awaiter(this, void 0, void 0, function () {
        var container, factory, factoryCache;
        var _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    if (typeof scope === 'undefined' || scope.length === 0) {
                        throw new Error("Scope can't be undefined or empty");
                    }
                    if (typeof module === 'undefined' || module.length === 0) {
                        throw new Error("Module can't be undefined or empty");
                    }
                    if (!module.startsWith('./')) {
                        console.warn("Your module " + module + " doesn't start with './' this indicates an error");
                    }
                    return [4, __webpack_init_sharing__('default')];
                case 1:
                    _b.sent();
                    container = window[scope];
                    return [4, container.init(__webpack_share_scopes__.default)];
                case 2:
                    _b.sent();
                    return [4, window[scope].get(module)];
                case 3:
                    factory = _b.sent();
                    if (!window[GLOBAL_NAMESPACE].factories[scope]) {
                        window[GLOBAL_NAMESPACE].factories[scope] = {};
                    }
                    factoryCache = {
                        init: container.init,
                        modules: __assign(__assign({}, window[GLOBAL_NAMESPACE].factories[scope].modules), (_a = {}, _a[module] = factory(), _a)),
                        expiration: new Date(),
                    };
                    window[GLOBAL_NAMESPACE].factories[scope] = factoryCache;
                    return [2, factory()];
            }
        });
    });
}
//# sourceMappingURL=index.js.map