"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeArraysByKey = mergeArraysByKey;
exports.downloadFile = downloadFile;
exports.processDate = processDate;
exports.getBaseName = getBaseName;
exports.toUpperCase = exports.generateFilter = exports.JSON_TYPE = exports.CSV_TYPE = void 0;

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _merge = _interopRequireDefault(require("lodash/merge"));

var _mapKeys = _interopRequireDefault(require("lodash/mapKeys"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var CSV_TYPE = 'text/csv;charset=utf-8;';
exports.CSV_TYPE = CSV_TYPE;
var JSON_TYPE = 'data:text/json;charset=utf-8,';
exports.JSON_TYPE = JSON_TYPE;
var monthMap = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'June', 'July', 'Aug', 'Sept', 'Oct', 'Nov', 'Dec'];

function mergeArraysByKey(arrays) {
  var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'id';

  var mergedObject = _merge["default"].apply(void 0, (0, _toConsumableArray2["default"])(arrays.map(function (row) {
    return (0, _mapKeys["default"])(row, function (a) {
      return a && a[key];
    });
  })));

  return Object.values(mergedObject);
}

function downloadFile(data) {
  var filename = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "".concat(new Date().toISOString());
  var format = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : CSV_TYPE;
  var type = format === 'json' ? JSON_TYPE : CSV_TYPE;
  var blob = new Blob([data], {
    type: type
  });
  var link = document.createElement('a');
  link.setAttribute('href', URL.createObjectURL(blob));
  link.setAttribute('download', "".concat(filename, ".").concat(format));
  link.style.visibility = 'hidden';
  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);
}

function processDate(dateString) {
  var date = new Date(dateString);
  var month = monthMap[date.getMonth()];
  var day = date.getDate() < 10 ? "0".concat(date.getDate()) : date.getDate();

  if (!month || isNaN(day)) {
    return 'N/A';
  }

  return "".concat(day, " ").concat(month, " ").concat(date.getFullYear());
}

function getBaseName(pathname) {
  var level = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
  var release = '/';
  var pathName = pathname.replace(/(#|\?).*/, '').split('/');
  pathName.shift();

  if (pathName[0] === 'beta') {
    pathName.shift();
    release = "/beta/";
  }

  return (0, _toConsumableArray2["default"])(new Array(level)).reduce(function (acc, _curr, key) {
    return "".concat(acc).concat(pathName[key] || '').concat(key < level - 1 ? '/' : '');
  }, release);
}

var generateFilter = function generateFilter(data) {
  var path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'filter';
  var options = arguments.length > 2 ? arguments[2] : undefined;
  return Object.entries(data || {}).reduce(function (acc, _ref) {
    var _ref2 = (0, _slicedToArray2["default"])(_ref, 2),
        key = _ref2[0],
        value = _ref2[1];

    var newPath = "".concat(path || '', "[").concat(key, "]").concat(Array.isArray(value) ? "".concat(options !== null && options !== void 0 && options.arrayEnhancer ? "[".concat(options.arrayEnhancer, "]") : '', "[]") : '');

    if (value instanceof Function || value instanceof Date) {
      return acc;
    }

    return _objectSpread(_objectSpread({}, acc), Array.isArray(value) || (0, _typeof2["default"])(value) !== 'object' ? (0, _defineProperty2["default"])({}, newPath, value) : generateFilter(value, newPath, options));
  }, {});
};

exports.generateFilter = generateFilter;

var toUpperCase = function toUpperCase() {
  var text = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  return "".concat(text.charAt(0).toUpperCase()).concat(text.slice(1));
};

exports.toUpperCase = toUpperCase;