import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React from 'react';
import PropTypes from 'prop-types';
import { withRouter, matchPath } from 'react-router-dom';
import { connect } from 'react-redux';
import isEqual from 'lodash/isEqual';
export var routerParams = function routerParams(Component) {
  var RouterParams = /*#__PURE__*/function (_React$Component) {
    _inherits(RouterParams, _React$Component);

    var _super = _createSuper(RouterParams);

    function RouterParams() {
      _classCallCheck(this, RouterParams);

      return _super.apply(this, arguments);
    }

    _createClass(RouterParams, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        var _this$props = this.props,
            _this$props$match = _this$props.match,
            params = _this$props$match.params,
            path = _this$props$match.path,
            url = _this$props$match.url,
            onPathChange = _this$props.onPathChange,
            location = _this$props.location;

        if (matchPath(location.pathname, {
          path: url,
          exact: true
        })) {
          onPathChange && onPathChange({
            params: params,
            path: path
          });
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate() {
        var _this$props2 = this.props,
            _this$props2$match = _this$props2.match,
            params = _this$props2$match.params,
            path = _this$props2$match.path,
            url = _this$props2$match.url,
            onPathChange = _this$props2.onPathChange,
            location = _this$props2.location,
            routerData = _this$props2.routerData;

        if (routerData && (!isEqual(params, routerData.params) || path !== routerData.path)) {
          if (matchPath(location.pathname, {
            path: url,
            exact: true
          })) {
            onPathChange && onPathChange({
              params: params,
              path: path
            });
          }
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props3 = this.props,
            onPathChange = _this$props3.onPathChange,
            routerData = _this$props3.routerData,
            staticContext = _this$props3.staticContext,
            props = _objectWithoutProperties(_this$props3, ["onPathChange", "routerData", "staticContext"]);

        return /*#__PURE__*/React.createElement(Component, props);
      }
    }]);

    return RouterParams;
  }(React.Component);

  ;
  RouterParams.propTypes = {
    match: PropTypes.shape({
      params: PropTypes.object,
      path: PropTypes.string,
      url: PropTypes.string
    }).isRequired,
    onPathChange: PropTypes.func,
    location: PropTypes.shape({
      pathname: PropTypes.string.isRequired
    }).isRequired,
    routerData: PropTypes.shape({
      params: PropTypes.object,
      path: PropTypes.string
    }).isRequired,
    staticContext: PropTypes.any
  };
  return withRouter(connect(function (_ref) {
    var routerData = _ref.routerData;
    return {
      routerData: routerData
    };
  }, function (dispatch) {
    return {
      onPathChange: function onPathChange(data) {
        return dispatch({
          type: '@@INSIGHTS-CORE/NAVIGATION',
          payload: data
        });
      }
    };
  })(RouterParams));
};
export default routerParams;