import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { applyMiddleware, combineReducers, createStore, compose } from 'redux';
export function applyReducerHash(reducerHash) {
  var initialState = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return function () {
    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initialState;
    var action = arguments.length > 1 ? arguments[1] : undefined;

    if (Object.prototype.hasOwnProperty.call(reducerHash, action.type)) {
      return reducerHash[action.type](state, action);
    }

    return state;
  };
}
export function dispatchActionsToStore(actions, store) {
  return Object.keys(actions).reduce(function (acc, curr) {
    return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, curr, function () {
      return store && store.dispatch(actions[curr].apply(actions, arguments));
    }));
  }, {});
}
/**
 * Class used to added reducers to the store during runtime.
 *
 * http://nicolasgallagher.com/redux-modules-and-code-splitting/
 */

export var ReducerRegistry = /*#__PURE__*/function () {
  function ReducerRegistry() {
    var initState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var middlewares = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    var composeEnhancersDefault = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : compose;

    _classCallCheck(this, ReducerRegistry);

    var composeEnhancers = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || composeEnhancersDefault;
    this.store = createStore(function () {
      var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : initState;
      return state;
    }, initState, composeEnhancers(applyMiddleware.apply(void 0, _toConsumableArray(middlewares))));
    this.reducers = {};
  }

  _createClass(ReducerRegistry, [{
    key: "getStore",
    value: function getStore() {
      return this.store;
    }
    /**
     * Adds new reducers to the store
     *
     * @param newReducers the object of new reducers.
     */

  }, {
    key: "register",
    value: function register(newReducers) {
      var _this = this;

      this.reducers = _objectSpread(_objectSpread({}, this.reducers), newReducers);
      this.store.replaceReducer(combineReducers(_objectSpread({}, this.reducers)));
      return function () {
        _this.reducers = Object.entries(_this.reducers).filter(function (reducer) {
          return !Object.keys(newReducers).includes(reducer);
        }).reduce(function (acc, _ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              key = _ref2[0],
              val = _ref2[1];

          return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, key, val));
        }, {});

        _this.store.replaceReducer(combineReducers(_objectSpread({}, _this.reducers)));
      };
    }
  }]);

  return ReducerRegistry;
}();
export var reduxRegistry = new ReducerRegistry();
export default ReducerRegistry;