# contains-path [![NPM version](https://badge.fury.io/js/contains-path.svg)](http://badge.fury.io/js/contains-path)

> Return true if a file path contains the given path.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i contains-path --save
```

## Usage

```js
var contains = require('contains-path');
```

**true**

All of the following return `true`:

```js
containsPath('./a/b/c', 'a');
containsPath('./a/b/c', 'a/b');
containsPath('./b/a/b/c', 'a/b');
containsPath('/a/b/c', '/a/b');
containsPath('/a/b/c', 'a/b');
containsPath('a', 'a');
containsPath('a/b/c', 'a');
//=> true
```

**false**

All of the following return `false`:

```js
containsPath('abc', 'a');
containsPath('abc', 'a.md');
containsPath('./b/a/b/c', './a/b');
containsPath('./b/a/b/c', './a');
containsPath('./b/a/b/c', '/a/b');
containsPath('/b/a/b/c', '/a/b');
//=> false
```

## Related projects

* [ends-with](https://github.com/jonschlinkert/ends-with): Returns `true` if the given `string` or `array` ends with `suffix` using strict equality for… [more](https://github.com/jonschlinkert/ends-with)
* [is-absolute](https://github.com/jonschlinkert/is-absolute): Return true if a file path is absolute.
* [is-relative](https://github.com/jonschlinkert/is-relative): Returns `true` if the path appears to be relative.
* [path-ends-with](https://github.com/jonschlinkert/path-ends-with): Return `true` if a file path ends with the given string/suffix.
* [path-segments](https://github.com/jonschlinkert/path-segments): Get n specific segments of a file path, e.g. first 2, last 3, etc.
* [parse-filepath](https://github.com/jonschlinkert/parse-filepath): Parse a filepath into an object, yielding predictable results for basename and extname.

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/contains-path/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on July 07, 2015._