/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

var request = require('request'),
    cookieUtil = require('./cookie-util'),
    log4js = require('log4js'),
    logger = log4js.getLogger('inspect-icp')

logger.level = process.env.LOG_LEVEL;
exports.inspect = (req, token, cb) => {
	
  var serviceName, Url, reqBody, options;	
  if (process.env.IDPROVIDER_KUBEDNS_NAME) {
    if (process.env.IDPROVIDER_KUBEDNS_NAME.indexOf('http') > -1) {
      serviceName = process.env.IDPROVIDER_KUBEDNS_NAME + ':4300';
    } else {
      serviceName = 'https://'+process.env.IDPROVIDER_KUBEDNS_NAME + ':4300'; 
    }
  }	  
  else if (process.env.PLATFORM_IDENTITY_PROVIDER_URL) {
    serviceName = process.env.PLATFORM_IDENTITY_PROVIDER_URL;
  } else {
    serviceName = 'https://platform-identity-provider:4300'	  
  }
  Url = serviceName + '/v1/auth/userInfo';
  options = {
    method: 'POST',
    url: Url,
    rejectUnauthorized: false,
    json: {'access_token': token}
  }	  
  logger.debug('service '+serviceName + ' Url:'+Url);	
  
  request(options, (err, res, body) => {
    if (err) {
      logger.debug(err)	    
      return cb(err, null, null)
    }
     return cb(null, res, body || {})
  })
}
