import { GraphQLSchema } from 'graphql';
import { Transform, Request, ExecutionResult } from '@graphql-tools/utils';
import { FieldTransformer, FieldNodeTransformer } from '../types';
export default class TransformObjectFields implements Transform {
    private readonly objectFieldTransformer;
    private readonly fieldNodeTransformer;
    private transformer;
    constructor(objectFieldTransformer: FieldTransformer, fieldNodeTransformer?: FieldNodeTransformer);
    transformSchema(originalSchema: GraphQLSchema): GraphQLSchema;
    transformRequest(originalRequest: Request, delegationContext?: Record<string, any>, transformationContext?: Record<string, any>): Request;
    transformResult(originalResult: ExecutionResult, delegationContext?: Record<string, any>, transformationContext?: Record<string, any>): ExecutionResult;
}
