import { GraphQLSchema } from 'graphql';
import { Transform, Request, ExecutionResult } from '@graphql-tools/utils';
import { FieldTransformer, FieldNodeTransformer, DataTransformer, ErrorsTransformer } from '../types';
export default class TransformCompositeFields implements Transform {
    private readonly fieldTransformer;
    private readonly fieldNodeTransformer;
    private readonly dataTransformer;
    private readonly errorsTransformer;
    private transformedSchema;
    private typeInfo;
    private mapping;
    constructor(fieldTransformer: FieldTransformer, fieldNodeTransformer?: FieldNodeTransformer, dataTransformer?: DataTransformer, errorsTransformer?: ErrorsTransformer);
    transformSchema(originalSchema: GraphQLSchema): GraphQLSchema;
    transformRequest(originalRequest: Request, _delegationContext?: Record<string, any>, transformationContext?: Record<string, any>): Request;
    transformResult(result: ExecutionResult, _delegationContext?: Record<string, any>, transformationContext?: Record<string, any>): ExecutionResult<Record<string, any>>;
    private transformDocument;
    private transformSelectionSet;
}
