# unixify [![NPM version](https://img.shields.io/npm/v/unixify.svg?style=flat)](https://www.npmjs.com/package/unixify) [![NPM monthly downloads](https://img.shields.io/npm/dm/unixify.svg?style=flat)](https://npmjs.org/package/unixify) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/unixify.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/unixify)

> Convert Windows file paths to unix paths.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save unixify
```

Install with [yarn](https://yarnpkg.com):

```sh
$ yarn add unixify
```

## Usage

```js
var unixify = require('unixify');
unixify(filepath[, stripTrailingSlash]);
```

**Strips leading drive letters and dot-slash (`./`)**

```js
unixify('.\\one\\two\\three');  //=> 'one/two/three'
unixify('./one/two/three');     //=> 'one/two/three'
unixify('C:\\one\\two\\three'); //=> '/one/two/three'
unixify('\\one\\two\\three');   //=> '/one/two/three'
```

**Normalizes path separators to forward slashes**

```js
unixify('one\\two\\three');      //=> 'one/two/three'
unixify('\\one\\two\\three');    //=> '/one/two/three'
unixify('C:\\one\\two\\three');  //=> '/one/two/three'
```

**Combines multiple consecutive slashes**

```js
unixify('one//two//////three'),     //=> 'one/two/three'
unixify('\\one\\two\\//three');     //=> '/one/two/three'
unixify('C:\\//one\\two\\//three'); //=> '/one/two/three'
```

**Strips trailing slashes by default**

```js
unixify('one//two//////three//'), //=> 'one/two/three'
unixify('C:\\one\\two\\three\\'); //=> '/one/two/three'
```

**Keep trailing slashes**

By passing `false` as the second argument

```js
unixify('one//two//////three//'), //=> 'one/two/three/'
unixify('C:\\one\\two\\three\\'); //=> '/one/two/three/'
```

## About

### Related projects

* [contains-path](https://www.npmjs.com/package/contains-path): Return true if a file path contains the given path. | [homepage](https://github.com/jonschlinkert/contains-path "Return true if a file path contains the given path.")
* [ends-with](https://www.npmjs.com/package/ends-with): Returns `true` if the given `string` or `array` ends with `suffix` using strict equality for… [more](https://github.com/jonschlinkert/ends-with) | [homepage](https://github.com/jonschlinkert/ends-with "Returns `true` if the given `string` or `array` ends with `suffix` using strict equality for comparisons.")
* [is-absolute](https://www.npmjs.com/package/is-absolute): Polyfill for node.js `path.isAbolute`. Returns true if a file path is absolute. | [homepage](https://github.com/jonschlinkert/is-absolute "Polyfill for node.js `path.isAbolute`. Returns true if a file path is absolute.")
* [normalize-path](https://www.npmjs.com/package/normalize-path): Normalize file path slashes to be unix-like forward slashes. Also condenses repeat slashes to a… [more](https://github.com/jonschlinkert/normalize-path) | [homepage](https://github.com/jonschlinkert/normalize-path "Normalize file path slashes to be unix-like forward slashes. Also condenses repeat slashes to a single slash and removes and trailing slashes unless disabled.")
* [path-ends-with](https://www.npmjs.com/package/path-ends-with): Return `true` if a file path ends with the given string/suffix. | [homepage](https://github.com/jonschlinkert/path-ends-with "Return `true` if a file path ends with the given string/suffix.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.5.0, on April 14, 2017._