import { GraphQLList, getNamedType } from 'graphql';
import DataLoader from 'dataloader';
import { delegateToSchema } from '@graphql-tools/delegate';

const cache = new WeakMap();
function createBatchFn(options) {
    var _a;
    const argsFromKeys = (_a = options.argsFromKeys) !== null && _a !== void 0 ? _a : ((keys) => ({ ids: keys }));
    const { valuesFromResults, lazyOptionsFn } = options;
    return async (keys) => {
        const results = await delegateToSchema({
            returnType: new GraphQLList(getNamedType(options.info.returnType)),
            args: argsFromKeys(keys),
            ...(lazyOptionsFn == null ? options : lazyOptionsFn(options)),
        });
        const values = valuesFromResults == null ? results : valuesFromResults(results, keys);
        return Array.isArray(values) ? values : keys.map(() => values);
    };
}
function createLoader(options) {
    const batchFn = createBatchFn(options);
    const newValue = new DataLoader(keys => batchFn(keys), options.dataLoaderOptions);
    cache.set(options.info.fieldNodes, newValue);
    return newValue;
}
function getLoader(options) {
    const cachedValue = cache.get(options.info.fieldNodes);
    if (cachedValue === undefined) {
        return createLoader(options);
    }
    return cachedValue;
}

function batchDelegateToSchema(options) {
    const key = options.key;
    if (key == null) {
        return null;
    }
    else if (Array.isArray(key) && !key.length) {
        return [];
    }
    const loader = getLoader(options);
    return Array.isArray(key) ? loader.loadMany(key) : loader.load(key);
}

function createBatchDelegateFn(optionsOrArgsFromKeys, lazyOptionsFn, dataLoaderOptions, valuesFromResults) {
    return typeof optionsOrArgsFromKeys === 'function'
        ? createBatchDelegateFnImpl({
            argsFromKeys: optionsOrArgsFromKeys,
            lazyOptionsFn,
            dataLoaderOptions,
            valuesFromResults,
        })
        : createBatchDelegateFnImpl(optionsOrArgsFromKeys);
}
function createBatchDelegateFnImpl(options) {
    return batchDelegateOptions => {
        const loader = getLoader({
            ...options,
            ...batchDelegateOptions,
        });
        return loader.load(batchDelegateOptions.key);
    };
}

export { batchDelegateToSchema, createBatchDelegateFn };
//# sourceMappingURL=index.esm.js.map
