import { DocumentNode, GraphQLNamedType, GraphQLSchema, GraphQLDirective, SchemaDefinitionNode, SchemaExtensionNode } from 'graphql';
import { SubschemaConfig } from '@graphql-tools/delegate';
import { MergeTypeCandidate, MergeTypeFilter, OnTypeConflict, StitchingInfo, TypeMergingOptions } from './types';
import { TypeMap } from '@graphql-tools/utils';
export declare function buildTypeCandidates({ schemaLikeObjects, transformedSchemas, extensions, directiveMap, schemaDefs, operationTypeNames, mergeDirectives, }: {
    schemaLikeObjects: Array<GraphQLSchema | SubschemaConfig | DocumentNode | GraphQLNamedType>;
    transformedSchemas: Map<GraphQLSchema | SubschemaConfig, GraphQLSchema>;
    extensions: Array<DocumentNode>;
    directiveMap: Record<string, GraphQLDirective>;
    schemaDefs: {
        schemaDef: SchemaDefinitionNode;
        schemaExtensions: Array<SchemaExtensionNode>;
    };
    operationTypeNames: Record<string, any>;
    mergeDirectives: boolean;
}): Record<string, Array<MergeTypeCandidate>>;
export declare function buildTypeMap({ typeCandidates, stitchingInfo, operationTypeNames, onTypeConflict, mergeTypes, typeMergingOptions, }: {
    typeCandidates: Record<string, Array<MergeTypeCandidate>>;
    stitchingInfo: StitchingInfo;
    operationTypeNames: Record<string, any>;
    onTypeConflict: OnTypeConflict;
    mergeTypes: boolean | Array<string> | MergeTypeFilter;
    typeMergingOptions: TypeMergingOptions;
}): TypeMap;
