import { GraphQLNamedType, GraphQLSchema, SelectionSetNode, DocumentNode, InlineFragmentNode, FieldNode, GraphQLFieldConfig, GraphQLObjectType, GraphQLInterfaceType, GraphQLInputFieldConfig, GraphQLInputObjectType } from 'graphql';
import { ITypeDefinitions, TypeMap } from '@graphql-tools/utils';
import { SubschemaConfig } from '@graphql-tools/delegate';
import { IExecutableSchemaDefinition } from '@graphql-tools/schema';
export interface MergeTypeCandidate {
    type: GraphQLNamedType;
    subschema?: GraphQLSchema | SubschemaConfig;
    transformedSchema?: GraphQLSchema;
}
export interface MergeFieldConfigCandidate {
    fieldConfig: GraphQLFieldConfig<any, any>;
    fieldName: string;
    type: GraphQLObjectType | GraphQLInterfaceType;
    subschema?: GraphQLSchema | SubschemaConfig;
    transformedSchema?: GraphQLSchema;
}
export interface MergeInputFieldConfigCandidate {
    inputFieldConfig: GraphQLInputFieldConfig;
    fieldName: string;
    type: GraphQLInputObjectType;
    subschema?: GraphQLSchema | SubschemaConfig;
    transformedSchema?: GraphQLSchema;
}
export declare type MergeTypeFilter = (mergeTypeCandidates: Array<MergeTypeCandidate>, typeName: string) => boolean;
export interface MergedTypeInfo {
    typeName: string;
    targetSubschemas: Map<GraphQLSchema | SubschemaConfig, Array<SubschemaConfig>>;
    uniqueFields: Record<string, SubschemaConfig>;
    nonUniqueFields: Record<string, Array<SubschemaConfig>>;
    typeMaps: Map<GraphQLSchema | SubschemaConfig, TypeMap>;
    selectionSets: Map<SubschemaConfig, SelectionSetNode>;
    fieldSelectionSets: Map<SubschemaConfig, Record<string, SelectionSetNode>>;
}
export interface StitchingInfo {
    transformedSchemas: Map<GraphQLSchema | SubschemaConfig, GraphQLSchema>;
    fragmentsByField: Record<string, Record<string, InlineFragmentNode>>;
    selectionSetsByField: Record<string, Record<string, SelectionSetNode>>;
    dynamicSelectionSetsByField: Record<string, Record<string, Array<(node: FieldNode) => SelectionSetNode>>>;
    mergedTypes: Record<string, MergedTypeInfo>;
}
export declare type SchemaLikeObject = SubschemaConfig | GraphQLSchema | string | DocumentNode | Array<GraphQLNamedType>;
export interface IStitchSchemasOptions<TContext = any> extends Omit<IExecutableSchemaDefinition<TContext>, 'typeDefs'> {
    subschemas?: Array<GraphQLSchema | SubschemaConfig | Array<SubschemaConfig>>;
    typeDefs?: ITypeDefinitions;
    types?: Array<GraphQLNamedType>;
    schemas?: Array<SchemaLikeObject>;
    onTypeConflict?: OnTypeConflict;
    mergeDirectives?: boolean;
    mergeTypes?: boolean | Array<string> | MergeTypeFilter;
    typeMergingOptions?: TypeMergingOptions;
}
export interface TypeMergingOptions {
    typeDescriptionsMerger?: (candidates: Array<MergeTypeCandidate>) => string;
    fieldConfigMerger?: (candidates: Array<MergeFieldConfigCandidate>) => GraphQLFieldConfig<any, any>;
    inputFieldConfigMerger?: (candidates: Array<MergeInputFieldConfigCandidate>) => GraphQLInputFieldConfig;
}
export declare type OnTypeConflict = (left: GraphQLNamedType, right: GraphQLNamedType, info?: {
    left: {
        schema?: GraphQLSchema | SubschemaConfig;
    };
    right: {
        schema?: GraphQLSchema | SubschemaConfig;
    };
}) => GraphQLNamedType;
declare module '@graphql-tools/utils' {
    interface IFieldResolverOptions<TSource = any, TContext = any, TArgs = any> {
        fragment?: string;
        selectionSet?: string | ((node: FieldNode) => SelectionSetNode);
    }
}
