import { ApolloLink } from 'apollo-link';
import { GraphQLFieldResolver, GraphQLSchema, ExecutionResult, GraphQLResolveInfo, DocumentNode, BuildSchemaOptions } from 'graphql';
export declare type ResolverFn = (rootValue?: any, args?: any, context?: any, info?: GraphQLResolveInfo) => AsyncIterator<any>;
export declare type Fetcher = (operation: FetcherOperation) => Promise<ExecutionResult>;
export declare type FetcherOperation = {
    query: DocumentNode;
    operationName?: string;
    variables?: {
        [key: string]: any;
    };
    context?: {
        [key: string]: any;
    };
};
/**
 * This type has been copied inline from its source on `@types/graphql`:
 *
 * https://git.io/Jv8NX
 *
 * Previously, it was imported from `graphql/utilities/schemaPrinter`, however
 * that module has been removed in `graphql@15`.  Furthermore, the sole property
 * on this type is due to be deprecated in `graphql@16`.
 */
interface PrintSchemaOptions {
    /**
     * Descriptions are defined as preceding string literals, however an older
     * experimental version of the SDL supported preceding comments as
     * descriptions. Set to true to enable this deprecated behavior.
     * This option is provided to ease adoption and will be removed in v16.
     *
     * Default: false
     */
    commentDescriptions?: boolean;
}
export default function makeRemoteExecutableSchema({ schema, link, fetcher, createResolver: customCreateResolver, buildSchemaOptions, printSchemaOptions }: {
    schema: GraphQLSchema | string;
    link?: ApolloLink;
    fetcher?: Fetcher;
    createResolver?: (fetcher: Fetcher) => GraphQLFieldResolver<any, any>;
    buildSchemaOptions?: BuildSchemaOptions;
    printSchemaOptions?: PrintSchemaOptions;
}): GraphQLSchema;
export declare function createResolver(fetcher: Fetcher): GraphQLFieldResolver<any, any>;
export {};
