package serialconsole

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/serialconsole/mgmt/2018-05-01/serialconsole"

// DeploymentValidateResult details on Failure
type DeploymentValidateResult struct {
	// ErrorMessage - Error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// GetDisabledResult returns whether or not Serial Console is disabled for this given subscription
type GetDisabledResult struct {
	autorest.Response `json:"-"`
	// Disabled - Disabled result
	Disabled *bool `json:"disabled,omitempty"`
}

// GetResult returns whether or not Serial Console is disabled.
type GetResult struct {
	// Value - Whether or not Serial Console is disabled.
	Value *bool `json:"value,omitempty"`
}

// Operations serial Console operations
type Operations struct {
	autorest.Response `json:"-"`
	// Value - Serial Console operations
	Value *string `json:"value,omitempty"`
}

// SetDisabledResult sets disable status and returns whether or not Serial Console is now disabled for this
// given subscription
type SetDisabledResult struct {
	autorest.Response `json:"-"`
	// Disabled - Disabled result
	Disabled *bool `json:"disabled,omitempty"`
}
