package devicesapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/iothub/mgmt/2016-02-03/devices"
	"github.com/Azure/go-autorest/autorest"
)

// IotHubResourceClientAPI contains the set of methods on the IotHubResourceClient type.
type IotHubResourceClientAPI interface {
	CheckNameAvailability(ctx context.Context, operationInputs devices.OperationInputs) (result devices.IotHubNameAvailabilityInfo, err error)
	CreateEventHubConsumerGroup(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (result devices.EventHubConsumerGroupInfo, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, resourceName string, iotHubDescription devices.IotHubDescription) (result devices.IotHubResourceCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, resourceName string) (result devices.IotHubResourceDeleteFuture, err error)
	DeleteEventHubConsumerGroup(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (result autorest.Response, err error)
	ExportDevices(ctx context.Context, resourceGroupName string, resourceName string, exportDevicesParameters devices.ExportDevicesRequest) (result devices.JobResponse, err error)
	Get(ctx context.Context, resourceGroupName string, resourceName string) (result devices.IotHubDescription, err error)
	GetEventHubConsumerGroup(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (result devices.EventHubConsumerGroupInfo, err error)
	GetJob(ctx context.Context, resourceGroupName string, resourceName string, jobID string) (result devices.JobResponse, err error)
	GetKeysForKeyName(ctx context.Context, resourceGroupName string, resourceName string, keyName string) (result devices.SharedAccessSignatureAuthorizationRule, err error)
	GetQuotaMetrics(ctx context.Context, resourceGroupName string, resourceName string) (result devices.IotHubQuotaMetricInfoListResultPage, err error)
	GetStats(ctx context.Context, resourceGroupName string, resourceName string) (result devices.RegistryStatistics, err error)
	GetValidSkus(ctx context.Context, resourceGroupName string, resourceName string) (result devices.IotHubSkuDescriptionListResultPage, err error)
	ImportDevices(ctx context.Context, resourceGroupName string, resourceName string, importDevicesParameters devices.ImportDevicesRequest) (result devices.JobResponse, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result devices.IotHubDescriptionListResultPage, err error)
	ListBySubscription(ctx context.Context) (result devices.IotHubDescriptionListResultPage, err error)
	ListEventHubConsumerGroups(ctx context.Context, resourceGroupName string, resourceName string, eventHubEndpointName string) (result devices.EventHubConsumerGroupsListResultPage, err error)
	ListJobs(ctx context.Context, resourceGroupName string, resourceName string) (result devices.JobResponseListResultPage, err error)
	ListKeys(ctx context.Context, resourceGroupName string, resourceName string) (result devices.SharedAccessSignatureAuthorizationRuleListResultPage, err error)
}

var _ IotHubResourceClientAPI = (*devices.IotHubResourceClient)(nil)
