---
layout: "api"
page_title: "HTTP API: Libraries"
sidebar_current: "docs-http-libraries"
description: |-
  List of official and community contributed libraries for interacting with the Vault HTTP API.
---

# Libraries

The programming libraries listed on this page can be used to consume the API more conveniently.
Some are officially maintained while others are provided by the community.

## Official

These libraries are officially maintained by HashiCorp.

### Go

* [Vault Go Client](https://github.com/hashicorp/vault/tree/master/api)

```shell
$ go get github.com/hashicorp/vault/api
```

### Ruby

* [Vault Ruby Client](https://github.com/hashicorp/vault-ruby)

```shell
$ gem install vault
```

## Community

These libraries are provided by the community.

### Ansible

* [ansible-vault](https://github.com/jhaals/ansible-vault) lookup plugin without third-party dependencies.
* [Ansible Modules Hashivault](https://pypi.python.org/pypi/ansible-modules-hashivault)

```shell
$ pip install ansible-modules-hashivault
```

### C&#35;

* [VaultSharp](https://github.com/rajanadar/VaultSharp) (.NET Standard = 1.4 (.NET Core >= 1.0.0) and also .NET 4.5.x, .NET 4.6.x)

```shell
$ Install-Package VaultSharp
```

* [Vault.NET](https://github.com/Chatham/Vault.NET)

```shell
$ Install-Package Vault
```

### Clojure

* [vault-clj](https://github.com/amperity/vault-clj)

### Elixir

* [vaultex](https://hex.pm/packages/vaultex)

### Go

* [vc](https://github.com/adfinis-sygroup/vault-client)

```shell
$ go get github.com/adfinis-sygroup/vault-client
```

### Haskell

* [vault-tool](https://hackage.haskell.org/package/vault-tool)

```shell
$ cabal install vault-tool
```

### Java

* [Spring Vault](https://github.com/spring-projects/spring-vault)
* [vault-java-driver](https://github.com/BetterCloud/vault-java-driver)

### Kotlin

* [vault-kotlin](https://github.com/kunickiaj/vault-kotlin)

### Node.js

* [node-vault](https://github.com/kr1sp1n/node-vault)

```shell
$ npm install node-vault
```

* [vaulted](https://github.com/chiefy/vaulted)

```shell
$ npm install vaulted
```

### PHP

* [vault-php-sdk](https://github.com/jippi/vault-php-sdk)

```shell
$ composer require jippi/vault-php-sdk
```

* [vault-php-sdk](https://github.com/violuke/vault-php-sdk) extended from jipppi

```shell
$ composer require violuke/vault-php-sdk
```

* [vault-php](https://github.com/CSharpRU/vault-php)

```shell
$ composer require csharpru/vault-php
```

### PowerShell

* [Zyborg.Vault](https://github.com/zyborg/Zyborg.Vault)

```PowerShell
Install-Module Zyborg.Vault
```

### Python

* [HVAC](https://github.com/ianunruh/hvac)

```shell
$ pip install hvac
```

### Rust

* [HashicorpVault](https://crates.io/crates/hashicorp_vault)

### Scala
 * [scala-vault](https://github.com/janstenpickle/scala-vault)
