package serialconsole

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ListClient is the azure Virtual Machine Serial Console allows you to access serial console of a Virtual Machine
type ListClient struct {
	BaseClient
}

// NewListClient creates an instance of the ListClient client.
func NewListClient(subscriptionID string) ListClient {
	return NewListClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewListClientWithBaseURI creates an instance of the ListClient client.
func NewListClientWithBaseURI(baseURI string, subscriptionID string) ListClient {
	return ListClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Operations gets a list of Serial Console API operations.
func (client ListClient) Operations(ctx context.Context) (result Operations, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListClient.Operations")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.OperationsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "serialconsole.ListClient", "Operations", nil, "Failure preparing request")
		return
	}

	resp, err := client.OperationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "serialconsole.ListClient", "Operations", resp, "Failure sending request")
		return
	}

	result, err = client.OperationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "serialconsole.ListClient", "Operations", resp, "Failure responding to request")
	}

	return
}

// OperationsPreparer prepares the Operations request.
func (client ListClient) OperationsPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.SerialConsole/operations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// OperationsSender sends the Operations request. The method will close the
// http.Response Body if it receives an error.
func (client ListClient) OperationsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// OperationsResponder handles the response to the Operations request. The method always
// closes the http.Response Body.
func (client ListClient) OperationsResponder(resp *http.Response) (result Operations, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
