// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/billing_setup_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for
// [BillingSetupService.GetBillingSetup][google.ads.googleads.v0.services.BillingSetupService.GetBillingSetup].
type GetBillingSetupRequest struct {
	// The resource name of the billing setup to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBillingSetupRequest) Reset()         { *m = GetBillingSetupRequest{} }
func (m *GetBillingSetupRequest) String() string { return proto.CompactTextString(m) }
func (*GetBillingSetupRequest) ProtoMessage()    {}
func (*GetBillingSetupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_billing_setup_service_d261261c49205cc7, []int{0}
}
func (m *GetBillingSetupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBillingSetupRequest.Unmarshal(m, b)
}
func (m *GetBillingSetupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBillingSetupRequest.Marshal(b, m, deterministic)
}
func (dst *GetBillingSetupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBillingSetupRequest.Merge(dst, src)
}
func (m *GetBillingSetupRequest) XXX_Size() int {
	return xxx_messageInfo_GetBillingSetupRequest.Size(m)
}
func (m *GetBillingSetupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBillingSetupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBillingSetupRequest proto.InternalMessageInfo

func (m *GetBillingSetupRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for billing setup mutate operations.
type MutateBillingSetupRequest struct {
	// Id of the customer to apply the billing setup mutate operation to.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The operation to perform.
	Operation            *BillingSetupOperation `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *MutateBillingSetupRequest) Reset()         { *m = MutateBillingSetupRequest{} }
func (m *MutateBillingSetupRequest) String() string { return proto.CompactTextString(m) }
func (*MutateBillingSetupRequest) ProtoMessage()    {}
func (*MutateBillingSetupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_billing_setup_service_d261261c49205cc7, []int{1}
}
func (m *MutateBillingSetupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateBillingSetupRequest.Unmarshal(m, b)
}
func (m *MutateBillingSetupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateBillingSetupRequest.Marshal(b, m, deterministic)
}
func (dst *MutateBillingSetupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateBillingSetupRequest.Merge(dst, src)
}
func (m *MutateBillingSetupRequest) XXX_Size() int {
	return xxx_messageInfo_MutateBillingSetupRequest.Size(m)
}
func (m *MutateBillingSetupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateBillingSetupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateBillingSetupRequest proto.InternalMessageInfo

func (m *MutateBillingSetupRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateBillingSetupRequest) GetOperation() *BillingSetupOperation {
	if m != nil {
		return m.Operation
	}
	return nil
}

// A single operation on a billing setup, which describes the cancellation of an
// existing billing setup.
type BillingSetupOperation struct {
	// Only one of these operations can be set. "Update" operations are not
	// supported.
	//
	// Types that are valid to be assigned to Operation:
	//	*BillingSetupOperation_Create
	//	*BillingSetupOperation_Remove
	Operation            isBillingSetupOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *BillingSetupOperation) Reset()         { *m = BillingSetupOperation{} }
func (m *BillingSetupOperation) String() string { return proto.CompactTextString(m) }
func (*BillingSetupOperation) ProtoMessage()    {}
func (*BillingSetupOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_billing_setup_service_d261261c49205cc7, []int{2}
}
func (m *BillingSetupOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BillingSetupOperation.Unmarshal(m, b)
}
func (m *BillingSetupOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BillingSetupOperation.Marshal(b, m, deterministic)
}
func (dst *BillingSetupOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BillingSetupOperation.Merge(dst, src)
}
func (m *BillingSetupOperation) XXX_Size() int {
	return xxx_messageInfo_BillingSetupOperation.Size(m)
}
func (m *BillingSetupOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_BillingSetupOperation.DiscardUnknown(m)
}

var xxx_messageInfo_BillingSetupOperation proto.InternalMessageInfo

type isBillingSetupOperation_Operation interface {
	isBillingSetupOperation_Operation()
}

type BillingSetupOperation_Create struct {
	Create *resources.BillingSetup `protobuf:"bytes,2,opt,name=create,proto3,oneof"`
}

type BillingSetupOperation_Remove struct {
	Remove string `protobuf:"bytes,1,opt,name=remove,proto3,oneof"`
}

func (*BillingSetupOperation_Create) isBillingSetupOperation_Operation() {}

func (*BillingSetupOperation_Remove) isBillingSetupOperation_Operation() {}

func (m *BillingSetupOperation) GetOperation() isBillingSetupOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *BillingSetupOperation) GetCreate() *resources.BillingSetup {
	if x, ok := m.GetOperation().(*BillingSetupOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *BillingSetupOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*BillingSetupOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BillingSetupOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BillingSetupOperation_OneofMarshaler, _BillingSetupOperation_OneofUnmarshaler, _BillingSetupOperation_OneofSizer, []interface{}{
		(*BillingSetupOperation_Create)(nil),
		(*BillingSetupOperation_Remove)(nil),
	}
}

func _BillingSetupOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BillingSetupOperation)
	// operation
	switch x := m.Operation.(type) {
	case *BillingSetupOperation_Create:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case *BillingSetupOperation_Remove:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Remove)
	case nil:
	default:
		return fmt.Errorf("BillingSetupOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _BillingSetupOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BillingSetupOperation)
	switch tag {
	case 2: // operation.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.BillingSetup)
		err := b.DecodeMessage(msg)
		m.Operation = &BillingSetupOperation_Create{msg}
		return true, err
	case 1: // operation.remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Operation = &BillingSetupOperation_Remove{x}
		return true, err
	default:
		return false, nil
	}
}

func _BillingSetupOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BillingSetupOperation)
	// operation
	switch x := m.Operation.(type) {
	case *BillingSetupOperation_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BillingSetupOperation_Remove:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Remove)))
		n += len(x.Remove)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for a billing setup operation.
type MutateBillingSetupResponse struct {
	// A result that identifies the resource affected by the mutate request.
	Result               *MutateBillingSetupResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *MutateBillingSetupResponse) Reset()         { *m = MutateBillingSetupResponse{} }
func (m *MutateBillingSetupResponse) String() string { return proto.CompactTextString(m) }
func (*MutateBillingSetupResponse) ProtoMessage()    {}
func (*MutateBillingSetupResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_billing_setup_service_d261261c49205cc7, []int{3}
}
func (m *MutateBillingSetupResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateBillingSetupResponse.Unmarshal(m, b)
}
func (m *MutateBillingSetupResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateBillingSetupResponse.Marshal(b, m, deterministic)
}
func (dst *MutateBillingSetupResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateBillingSetupResponse.Merge(dst, src)
}
func (m *MutateBillingSetupResponse) XXX_Size() int {
	return xxx_messageInfo_MutateBillingSetupResponse.Size(m)
}
func (m *MutateBillingSetupResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateBillingSetupResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateBillingSetupResponse proto.InternalMessageInfo

func (m *MutateBillingSetupResponse) GetResult() *MutateBillingSetupResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// Result for a single billing setup mutate.
type MutateBillingSetupResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateBillingSetupResult) Reset()         { *m = MutateBillingSetupResult{} }
func (m *MutateBillingSetupResult) String() string { return proto.CompactTextString(m) }
func (*MutateBillingSetupResult) ProtoMessage()    {}
func (*MutateBillingSetupResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_billing_setup_service_d261261c49205cc7, []int{4}
}
func (m *MutateBillingSetupResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateBillingSetupResult.Unmarshal(m, b)
}
func (m *MutateBillingSetupResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateBillingSetupResult.Marshal(b, m, deterministic)
}
func (dst *MutateBillingSetupResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateBillingSetupResult.Merge(dst, src)
}
func (m *MutateBillingSetupResult) XXX_Size() int {
	return xxx_messageInfo_MutateBillingSetupResult.Size(m)
}
func (m *MutateBillingSetupResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateBillingSetupResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateBillingSetupResult proto.InternalMessageInfo

func (m *MutateBillingSetupResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetBillingSetupRequest)(nil), "google.ads.googleads.v0.services.GetBillingSetupRequest")
	proto.RegisterType((*MutateBillingSetupRequest)(nil), "google.ads.googleads.v0.services.MutateBillingSetupRequest")
	proto.RegisterType((*BillingSetupOperation)(nil), "google.ads.googleads.v0.services.BillingSetupOperation")
	proto.RegisterType((*MutateBillingSetupResponse)(nil), "google.ads.googleads.v0.services.MutateBillingSetupResponse")
	proto.RegisterType((*MutateBillingSetupResult)(nil), "google.ads.googleads.v0.services.MutateBillingSetupResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BillingSetupServiceClient is the client API for BillingSetupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BillingSetupServiceClient interface {
	// Returns a billing setup.
	GetBillingSetup(ctx context.Context, in *GetBillingSetupRequest, opts ...grpc.CallOption) (*resources.BillingSetup, error)
	// Creates a billing setup, or cancels an existing billing setup.
	MutateBillingSetup(ctx context.Context, in *MutateBillingSetupRequest, opts ...grpc.CallOption) (*MutateBillingSetupResponse, error)
}

type billingSetupServiceClient struct {
	cc *grpc.ClientConn
}

func NewBillingSetupServiceClient(cc *grpc.ClientConn) BillingSetupServiceClient {
	return &billingSetupServiceClient{cc}
}

func (c *billingSetupServiceClient) GetBillingSetup(ctx context.Context, in *GetBillingSetupRequest, opts ...grpc.CallOption) (*resources.BillingSetup, error) {
	out := new(resources.BillingSetup)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.BillingSetupService/GetBillingSetup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *billingSetupServiceClient) MutateBillingSetup(ctx context.Context, in *MutateBillingSetupRequest, opts ...grpc.CallOption) (*MutateBillingSetupResponse, error) {
	out := new(MutateBillingSetupResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.BillingSetupService/MutateBillingSetup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BillingSetupServiceServer is the server API for BillingSetupService service.
type BillingSetupServiceServer interface {
	// Returns a billing setup.
	GetBillingSetup(context.Context, *GetBillingSetupRequest) (*resources.BillingSetup, error)
	// Creates a billing setup, or cancels an existing billing setup.
	MutateBillingSetup(context.Context, *MutateBillingSetupRequest) (*MutateBillingSetupResponse, error)
}

func RegisterBillingSetupServiceServer(s *grpc.Server, srv BillingSetupServiceServer) {
	s.RegisterService(&_BillingSetupService_serviceDesc, srv)
}

func _BillingSetupService_GetBillingSetup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBillingSetupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingSetupServiceServer).GetBillingSetup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.BillingSetupService/GetBillingSetup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingSetupServiceServer).GetBillingSetup(ctx, req.(*GetBillingSetupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BillingSetupService_MutateBillingSetup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateBillingSetupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BillingSetupServiceServer).MutateBillingSetup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.BillingSetupService/MutateBillingSetup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BillingSetupServiceServer).MutateBillingSetup(ctx, req.(*MutateBillingSetupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BillingSetupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.BillingSetupService",
	HandlerType: (*BillingSetupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetBillingSetup",
			Handler:    _BillingSetupService_GetBillingSetup_Handler,
		},
		{
			MethodName: "MutateBillingSetup",
			Handler:    _BillingSetupService_MutateBillingSetup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/billing_setup_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/billing_setup_service.proto", fileDescriptor_billing_setup_service_d261261c49205cc7)
}

var fileDescriptor_billing_setup_service_d261261c49205cc7 = []byte{
	// 546 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0x31, 0x6f, 0xd3, 0x40,
	0x14, 0xe6, 0x52, 0x29, 0x52, 0x2f, 0x20, 0xa4, 0x43, 0xa0, 0x10, 0x21, 0x11, 0x99, 0x0e, 0x55,
	0x86, 0x3b, 0x13, 0x84, 0x82, 0xae, 0x8d, 0x90, 0xb3, 0xa4, 0x1d, 0x80, 0xca, 0x15, 0x19, 0x50,
	0xa4, 0xc8, 0x8d, 0x4f, 0x96, 0x25, 0xdb, 0x67, 0xfc, 0xce, 0x59, 0xaa, 0x2e, 0x6c, 0xcc, 0xdd,
	0x19, 0x18, 0xd9, 0xf9, 0x13, 0x0c, 0x2c, 0xfc, 0x05, 0x26, 0xfe, 0x04, 0xc8, 0x3e, 0x5f, 0x9a,
	0x50, 0x47, 0x81, 0x6e, 0xcf, 0xe7, 0xf7, 0x7d, 0xdf, 0x7b, 0xdf, 0x7b, 0x77, 0xf8, 0x30, 0x90,
	0x32, 0x88, 0x04, 0xf3, 0x7c, 0x60, 0x3a, 0x2c, 0xa2, 0x85, 0xcd, 0x40, 0x64, 0x8b, 0x70, 0x2e,
	0x80, 0x9d, 0x85, 0x51, 0x14, 0x26, 0xc1, 0x0c, 0x84, 0xca, 0xd3, 0x59, 0x75, 0x4c, 0xd3, 0x4c,
	0x2a, 0x49, 0xba, 0x1a, 0x42, 0x3d, 0x1f, 0xe8, 0x12, 0x4d, 0x17, 0x36, 0x35, 0xe8, 0xce, 0xf3,
	0x4d, 0xfc, 0x99, 0x00, 0x99, 0x67, 0xd7, 0x04, 0x34, 0x71, 0xe7, 0x91, 0x81, 0xa5, 0x21, 0xf3,
	0x92, 0x44, 0x2a, 0x4f, 0x85, 0x32, 0x01, 0xfd, 0xd7, 0x1a, 0xe2, 0x07, 0x63, 0xa1, 0x46, 0x1a,
	0x77, 0x5a, 0xc0, 0x5c, 0xf1, 0x3e, 0x17, 0xa0, 0xc8, 0x13, 0x7c, 0xc7, 0x10, 0xcf, 0x12, 0x2f,
	0x16, 0x6d, 0xd4, 0x45, 0xfb, 0xbb, 0xee, 0x6d, 0x73, 0xf8, 0xda, 0x8b, 0x85, 0x75, 0x89, 0xf0,
	0xc3, 0x57, 0xb9, 0xf2, 0x94, 0xa8, 0xa3, 0x78, 0x8c, 0x5b, 0xf3, 0x1c, 0x94, 0x8c, 0x45, 0x36,
	0x0b, 0xfd, 0x8a, 0x00, 0x9b, 0xa3, 0x63, 0x9f, 0xbc, 0xc5, 0xbb, 0x32, 0x15, 0x59, 0x59, 0x51,
	0xbb, 0xd1, 0x45, 0xfb, 0xad, 0xfe, 0x80, 0x6e, 0x33, 0x82, 0xae, 0x4a, 0xbd, 0x31, 0x70, 0xf7,
	0x8a, 0xc9, 0xfa, 0x88, 0xf0, 0xfd, 0xda, 0x24, 0x72, 0x8c, 0x9b, 0xf3, 0x4c, 0x78, 0x4a, 0x54,
	0x6a, 0x6c, 0xa3, 0xda, 0xd2, 0xd4, 0x35, 0xb9, 0xa3, 0x5b, 0x6e, 0x45, 0x40, 0xda, 0xb8, 0x99,
	0x89, 0x58, 0x2e, 0x2a, 0x63, 0x8a, 0x3f, 0xfa, 0x7b, 0xd4, 0x5a, 0xe9, 0xca, 0x4a, 0x71, 0xa7,
	0xce, 0x20, 0x48, 0x65, 0x02, 0x82, 0xb8, 0x05, 0x09, 0xe4, 0x91, 0x2a, 0x49, 0x5a, 0x7d, 0xbe,
	0xbd, 0xfb, 0x5a, 0xb6, 0x3c, 0x52, 0x6e, 0xc5, 0x64, 0xbd, 0xc4, 0xed, 0x4d, 0x39, 0xff, 0x34,
	0xd4, 0xfe, 0xa7, 0x1d, 0x7c, 0x6f, 0x15, 0x7b, 0xaa, 0xa5, 0xc9, 0x57, 0x84, 0xef, 0xfe, 0xb5,
	0x2c, 0xe4, 0xc5, 0xf6, 0x82, 0xeb, 0xf7, 0xab, 0xf3, 0xbf, 0xd6, 0x5b, 0x83, 0x0f, 0x3f, 0x7e,
	0x5e, 0x36, 0x9e, 0x12, 0x56, 0xec, 0xfc, 0xf9, 0x5a, 0x1b, 0x43, 0xb3, 0x53, 0xc0, 0x7a, 0xe6,
	0x12, 0x94, 0x20, 0x60, 0xbd, 0x0b, 0xf2, 0x1d, 0x61, 0x72, 0xdd, 0x11, 0x72, 0x70, 0x33, 0xaf,
	0x75, 0xf5, 0x87, 0x37, 0x1c, 0x54, 0x39, 0x76, 0x6b, 0x58, 0xb6, 0x32, 0xb0, 0xfa, 0x45, 0x2b,
	0x57, 0xb5, 0x9f, 0xaf, 0xdc, 0x96, 0x61, 0xef, 0x62, 0xbd, 0x13, 0x1e, 0x97, 0x7c, 0x1c, 0xf5,
	0x46, 0xbf, 0x11, 0xde, 0x9b, 0xcb, 0x78, 0x6b, 0x09, 0xa3, 0x76, 0xcd, 0x18, 0x4f, 0x8a, 0x7b,
	0x7f, 0x82, 0xde, 0x1d, 0x55, 0xe8, 0x40, 0x46, 0x5e, 0x12, 0x50, 0x99, 0x05, 0x2c, 0x10, 0x49,
	0xf9, 0x2a, 0x98, 0xe7, 0x25, 0x0d, 0x61, 0xf3, 0x6b, 0x76, 0x60, 0x82, 0xcf, 0x8d, 0x9d, 0xb1,
	0xe3, 0x7c, 0x69, 0x74, 0xc7, 0x9a, 0xd0, 0xf1, 0x81, 0xea, 0xb0, 0x88, 0x26, 0x36, 0xad, 0x84,
	0xe1, 0x9b, 0x49, 0x99, 0x3a, 0x3e, 0x4c, 0x97, 0x29, 0xd3, 0x89, 0x3d, 0x35, 0x29, 0xbf, 0x1a,
	0x7b, 0xfa, 0x9c, 0x73, 0xc7, 0x07, 0xce, 0x97, 0x49, 0x9c, 0x4f, 0x6c, 0xce, 0x4d, 0xda, 0x59,
	0xb3, 0xac, 0xf3, 0xd9, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x92, 0x30, 0x0d, 0xa0, 0x74, 0x05,
	0x00, 0x00,
}
