"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartLegendTooltipContent = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_core_1 = require("victory-core");
const victory_legend_1 = require("victory-legend");
const ChartLabel_1 = require("../ChartLabel");
const ChartLegend_1 = require("../ChartLegend");
const ChartLegendTooltipLabel_1 = require("./ChartLegendTooltipLabel");
const ChartTheme_1 = require("../ChartTheme");
const ChartUtils_1 = require("../ChartUtils");
const ChartLegendTooltipContent = (_a) => {
    var { activePoints, center, datum, dx = 0, dy = 0, flyoutHeight, flyoutWidth, height, labelComponent = React.createElement(ChartLegendTooltipLabel_1.ChartLegendTooltipLabel, null), legendComponent = React.createElement(ChartLegend_1.ChartLegend, null), legendData, text, themeColor, themeVariant, title, titleComponent = React.createElement(ChartLabel_1.ChartLabel, null), width, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant) } = _a, rest = tslib_1.__rest(_a, ["activePoints", "center", "datum", "dx", "dy", "flyoutHeight", "flyoutWidth", "height", "labelComponent", "legendComponent", "legendData", "text", "themeColor", "themeVariant", "title", "titleComponent", "width", "theme"]);
    const pointerLength = theme && theme.tooltip ? victory_core_1.Helpers.evaluateProp(theme.tooltip.pointerLength) : 10;
    const legendProps = ChartUtils_1.getLegendTooltipDataProps(legendComponent.props);
    const visibleLegendData = ChartUtils_1.getLegendTooltipVisibleData({
        activePoints,
        colorScale: legendProps.colorScale,
        legendData,
        text,
        theme
    });
    // Component offsets
    const legendOffsetX = 0;
    const legendOffsetY = title ? 5 : -10;
    const titleOffsetX = 10;
    const titleOffsetY = 0;
    // Returns x position of flyout
    const getX = () => {
        if (!(center || flyoutWidth || width)) {
            const x = rest.x;
            return x ? x : undefined;
        }
        const _flyoutWidth = victory_core_1.Helpers.evaluateProp(flyoutWidth);
        if (width > center.x + _flyoutWidth + pointerLength) {
            return center.x + ChartTheme_1.ChartLegendTooltipStyles.flyout.padding / 2;
        }
        else if (center.x < _flyoutWidth + pointerLength) {
            return ChartTheme_1.ChartLegendTooltipStyles.flyout.padding / 2 - pointerLength;
        }
        else {
            return center.x - _flyoutWidth;
        }
    };
    // Returns y position
    const getY = () => {
        if (!(center || flyoutHeight || height)) {
            const y = rest.y;
            return y ? y : undefined;
        }
        const _flyoutHeight = victory_core_1.Helpers.evaluateProp(flyoutHeight);
        if (center.y < _flyoutHeight / 2) {
            return ChartTheme_1.ChartLegendTooltipStyles.flyout.padding / 2;
        }
        else if (center.y > height - _flyoutHeight / 2) {
            return height - _flyoutHeight + ChartTheme_1.ChartLegendTooltipStyles.flyout.padding / 2;
        }
        else {
            return center.y - _flyoutHeight / 2 + ChartTheme_1.ChartLegendTooltipStyles.flyout.padding / 2;
        }
    };
    // Min & max dimensions do not include flyout padding
    const maxLegendDimensions = ChartUtils_1.getLegendTooltipSize({
        legendData: visibleLegendData,
        legendProps,
        text: ChartUtils_1.getLegendTooltipVisibleText({ activePoints, legendData, text }),
        theme
    });
    const minLegendDimensions = ChartUtils_1.getLegendTooltipSize({
        legendData: [{ name: '' }],
        legendProps,
        theme
    });
    // Returns the label component
    const getLabelComponent = () => React.cloneElement(labelComponent, Object.assign({ dx: maxLegendDimensions.width - minLegendDimensions.width, legendData: visibleLegendData }, labelComponent.props));
    // Returns the title component
    const getTitleComponent = () => {
        const _title = title instanceof Function ? title(datum) : title;
        return React.cloneElement(titleComponent, Object.assign({ style: {
                fill: ChartTheme_1.ChartLegendTooltipStyles.label.fill,
                fontWeight: ChartTheme_1.ChartLegendTooltipStyles.label.fontWeight
            }, text: _title, textAnchor: 'start', x: getX() + titleOffsetX + victory_core_1.Helpers.evaluateProp(dx), y: getY() + titleOffsetY + victory_core_1.Helpers.evaluateProp(dy) }, titleComponent.props));
    };
    // Returns the legebd component
    const getLegendComponent = () => React.cloneElement(legendComponent, Object.assign({ data: ChartUtils_1.getLegendTooltipVisibleData({
            activePoints,
            colorScale: legendProps.colorScale,
            legendData,
            text,
            textAsLegendData: true,
            theme
        }), labelComponent: getLabelComponent(), standalone: false, theme, x: getX() + legendOffsetX + victory_core_1.Helpers.evaluateProp(dx), y: getY() + legendOffsetY + victory_core_1.Helpers.evaluateProp(dy) }, legendProps));
    return (React.createElement(React.Fragment, null,
        getTitleComponent(),
        getLegendComponent()));
};
exports.ChartLegendTooltipContent = ChartLegendTooltipContent;
exports.ChartLegendTooltipContent.displayName = 'ChartLegendTooltipContent';
// Note: VictoryLegend.role must be hoisted, but getBaseProps causes error with ChartVoronoiContainer
hoist_non_react_statics_1.default(exports.ChartLegendTooltipContent, victory_legend_1.VictoryLegend, { getBaseProps: true });
//# sourceMappingURL=ChartLegendTooltipContent.js.map