import React from 'react';
import { DropdownPosition, LabelProps, DropdownProps, TooltipPosition } from '@patternfly/react-core';
declare type Props = Omit<DropdownProps, 'toggle' | 'onSelect'>;
export declare type AcmDropdownProps = Props & {
    dropdownItems: AcmDropdownItems[];
    text: string;
    isDisabled?: boolean;
    onSelect: (id: string) => void;
    id: string;
    toggle?: React.ReactNode;
    tooltip?: string | React.ReactNode;
    isKebab?: boolean;
    onHover?: () => void;
    isPlain?: boolean;
    isPrimary?: boolean;
    onToggle?: (isOpen?: boolean) => void;
    tooltipPosition?: TooltipPosition;
    label?: string | React.ReactNode;
    labelColor?: LabelProps['color'];
    dropdownPosition?: DropdownPosition;
};
export declare type AcmDropdownItems = {
    id: string;
    component?: string | React.ReactNode;
    isDisabled?: boolean;
    tooltip?: string | React.ReactNode;
    text: string | React.ReactNode;
    href?: string;
    icon?: React.ReactNode;
    tooltipPosition?: TooltipPosition;
};
export declare function AcmDropdown(props: AcmDropdownProps): JSX.Element;
export {};
