"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _victoryCore = require("victory-core");

var _slice = _interopRequireDefault(require("./slice"));

var _helperMethods = require("./helper-methods");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (typeof call === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var fallbackProps = {
  endAngle: 360,
  height: 400,
  innerRadius: 0,
  cornerRadius: 0,
  padAngle: 0,
  padding: 30,
  width: 400,
  startAngle: 0,
  colorScale: ["#ffffff", "#f0f0f0", "#d9d9d9", "#bdbdbd", "#969696", "#737373", "#525252", "#252525", "#000000"],
  labelPosition: "centroid"
};

var VictoryPie =
/*#__PURE__*/
function (_React$Component) {
  _inherits(VictoryPie, _React$Component);

  function VictoryPie() {
    _classCallCheck(this, VictoryPie);

    return _possibleConstructorReturn(this, (VictoryPie.__proto__ || Object.getPrototypeOf(VictoryPie)).apply(this, arguments));
  }

  _createClass(VictoryPie, [{
    key: "shouldAnimate",
    // Overridden in victory-native
    value: function shouldAnimate() {
      return Boolean(this.props.animate);
    }
  }, {
    key: "render",
    value: function render() {
      var animationWhitelist = VictoryPie.animationWhitelist,
          role = VictoryPie.role;

      var props = _victoryCore.Helpers.modifyProps(this.props, fallbackProps, role);

      if (this.shouldAnimate()) {
        return this.animateComponent(props, animationWhitelist);
      }

      var children = this.renderData(props);
      return props.standalone ? this.renderContainer(props.containerComponent, children) : children;
    }
  }]);

  return VictoryPie;
}(_react.default.Component);

Object.defineProperty(VictoryPie, "animationWhitelist", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: ["data", "endAngle", "height", "innerRadius", "cornerRadius", "padAngle", "padding", "colorScale", "startAngle", "style", "width"]
});
Object.defineProperty(VictoryPie, "displayName", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: "VictoryPie"
});
Object.defineProperty(VictoryPie, "role", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: "pie"
});
Object.defineProperty(VictoryPie, "defaultTransitions", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    onExit: {
      duration: 500,
      before: function () {
        return {
          _y: 0,
          label: " "
        };
      }
    },
    onEnter: {
      duration: 500,
      before: function () {
        return {
          _y: 0,
          label: " "
        };
      },
      after: function (datum) {
        return {
          y_: datum._y,
          label: datum.label
        };
      }
    }
  }
});
Object.defineProperty(VictoryPie, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    animate: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.object]),
    colorScale: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string), _propTypes.default.oneOf(["grayscale", "qualitative", "heatmap", "warm", "cool", "red", "green", "blue"])]),
    containerComponent: _propTypes.default.element,
    cornerRadius: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    data: _propTypes.default.array,
    dataComponent: _propTypes.default.element,
    disableInlineStyes: _propTypes.default.bool,
    endAngle: _propTypes.default.number,
    eventKey: _propTypes.default.oneOfType([_propTypes.default.func, _victoryCore.PropTypes.allOfType([_victoryCore.PropTypes.integer, _victoryCore.PropTypes.nonNegative]), _propTypes.default.string]),
    events: _propTypes.default.arrayOf(_propTypes.default.shape({
      target: _propTypes.default.oneOf(["data", "labels", "parent"]),
      eventKey: _propTypes.default.oneOfType([_propTypes.default.func, _victoryCore.PropTypes.allOfType([_victoryCore.PropTypes.integer, _victoryCore.PropTypes.nonNegative]), _propTypes.default.string]),
      eventHandlers: _propTypes.default.object
    })),
    externalEventMutations: _propTypes.default.arrayOf(_propTypes.default.shape({
      callback: _propTypes.default.function,
      childName: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.array]),
      eventKey: _propTypes.default.oneOfType([_propTypes.default.array, _victoryCore.PropTypes.allOfType([_victoryCore.PropTypes.integer, _victoryCore.PropTypes.nonNegative]), _propTypes.default.string]),
      mutation: _propTypes.default.function,
      target: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.array])
    })),
    groupComponent: _propTypes.default.element,
    height: _victoryCore.PropTypes.nonNegative,
    innerRadius: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    labelComponent: _propTypes.default.element,
    labelPlacement: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.oneOf(["parallel", "perpendicular", "vertical"])]),
    labelPosition: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.oneOf(["startAngle", "centroid", "endAngle"])]),
    labelRadius: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    labels: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.array]),
    name: _propTypes.default.string,
    origin: _propTypes.default.shape({
      x: _victoryCore.PropTypes.nonNegative,
      y: _victoryCore.PropTypes.nonNegative
    }),
    padAngle: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    padding: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.shape({
      top: _propTypes.default.number,
      bottom: _propTypes.default.number,
      left: _propTypes.default.number,
      right: _propTypes.default.number
    })]),
    radius: _propTypes.default.oneOfType([_victoryCore.PropTypes.nonNegative, _propTypes.default.func]),
    sharedEvents: _propTypes.default.shape({
      events: _propTypes.default.array,
      getEventState: _propTypes.default.func
    }),
    sortKey: _propTypes.default.oneOfType([_propTypes.default.func, _victoryCore.PropTypes.allOfType([_victoryCore.PropTypes.integer, _victoryCore.PropTypes.nonNegative]), _propTypes.default.string, _propTypes.default.arrayOf(_propTypes.default.string)]),
    sortOrder: _propTypes.default.oneOf(["ascending", "descending"]),
    standalone: _propTypes.default.bool,
    startAngle: _propTypes.default.number,
    style: _propTypes.default.shape({
      parent: _propTypes.default.object,
      data: _propTypes.default.object,
      labels: _propTypes.default.object
    }),
    theme: _propTypes.default.object,
    width: _victoryCore.PropTypes.nonNegative,
    x: _propTypes.default.oneOfType([_propTypes.default.func, _victoryCore.PropTypes.allOfType([_victoryCore.PropTypes.integer, _victoryCore.PropTypes.nonNegative]), _propTypes.default.string, _propTypes.default.arrayOf(_propTypes.default.string)]),
    y: _propTypes.default.oneOfType([_propTypes.default.func, _victoryCore.PropTypes.allOfType([_victoryCore.PropTypes.integer, _victoryCore.PropTypes.nonNegative]), _propTypes.default.string, _propTypes.default.arrayOf(_propTypes.default.string)])
  }
});
Object.defineProperty(VictoryPie, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    data: [{
      x: "A",
      y: 1
    }, {
      x: "B",
      y: 2
    }, {
      x: "C",
      y: 3
    }, {
      x: "D",
      y: 1
    }, {
      x: "E",
      y: 2
    }],
    standalone: true,
    dataComponent: _react.default.createElement(_slice.default, null),
    labelComponent: _react.default.createElement(_victoryCore.VictoryLabel, null),
    containerComponent: _react.default.createElement(_victoryCore.VictoryContainer, null),
    groupComponent: _react.default.createElement("g", null),
    sortOrder: "ascending",
    theme: _victoryCore.VictoryTheme.grayscale
  }
});
Object.defineProperty(VictoryPie, "getBaseProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: function (props) {
    return (0, _helperMethods.getBaseProps)(props, fallbackProps);
  }
});
Object.defineProperty(VictoryPie, "getData", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: _victoryCore.Data.getData
});
Object.defineProperty(VictoryPie, "expectedComponents", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: ["dataComponent", "labelComponent", "groupComponent", "containerComponent"]
});

var _default = (0, _victoryCore.addEvents)(VictoryPie);

exports.default = _default;