"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

var Checkbox = function Checkbox(_ref) {
  var className = _ref.className,
      id = _ref.id,
      labelText = _ref.labelText,
      _onChange = _ref.onChange,
      indeterminate = _ref.indeterminate,
      hideLabel = _ref.hideLabel,
      wrapperClassName = _ref.wrapperClassName,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? '' : _ref$title,
      other = _objectWithoutProperties(_ref, ["className", "id", "labelText", "onChange", "indeterminate", "hideLabel", "wrapperClassName", "title"]);

  var input;
  var labelClasses = (0, _classnames.default)("".concat(prefix, "--checkbox-label"), className);
  var innerLabelClasses = (0, _classnames.default)(_defineProperty({}, "".concat(prefix, "--visually-hidden"), hideLabel));
  var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--form-item"), "".concat(prefix, "--checkbox-wrapper"), wrapperClassName);
  return _react.default.createElement("div", {
    className: wrapperClasses
  }, _react.default.createElement("input", _extends({}, other, {
    type: "checkbox",
    onChange: function onChange(evt) {
      _onChange(input.checked, id, evt);
    },
    className: "".concat(prefix, "--checkbox"),
    id: id,
    ref: function ref(el) {
      input = el;

      if (input) {
        input.indeterminate = indeterminate;
      }
    }
  })), _react.default.createElement("label", {
    htmlFor: id,
    className: labelClasses,
    title: title || null
  }, _react.default.createElement("span", {
    className: innerLabelClasses
  }, labelText)));
};

Checkbox.propTypes = {
  /**
   * Specify whether the underlying input should be checked
   */
  checked: _propTypes.default.bool,

  /**
   * Specify whether the underlying input should be checked by default
   */
  defaultChecked: _propTypes.default.bool,

  /**
   * Specify whether the Checkbox is in an indeterminate state
   */
  indeterminate: _propTypes.default.bool,

  /**
   * Specify an optional className to be applied to the <label> node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the Checkbox should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide an `id` to uniquely identify the Checkbox input
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Provide a label to provide a description of the Checkbox input that you are
   * exposing to the user
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Receives three arguments: true/false, the checkbox's id, and the dom event.
   * `(value, id, event) => console.log({value, id, event})`
   */
  onChange: _propTypes.default.func,

  /**
   * Specify a title for the <label> node for the Checkbox
   */
  title: _propTypes.default.string,

  /**
   * The CSS class name to be placed on the wrapping element
   */
  wrapperClassName: _propTypes.default.string
};
Checkbox.defaultProps = {
  onChange: function onChange() {},
  indeterminate: false
};
var _default = Checkbox;
exports.default = _default;