<!--
---
linkTitle: "Trigger Templates"
weight: 3
---
-->
# TriggerTemplates

A `TriggerTemplate` is a resource that can template resources.
`TriggerTemplate`s have [parameters](#parameters) that can be substituted
**anywhere** within the resource template.

<!-- FILE: examples/triggertemplates/triggertemplate.yaml -->
```YAML
apiVersion: triggers.tekton.dev/v1alpha1
kind: TriggerTemplate
metadata:
  name: pipeline-template
spec:
  params:
  - name: gitrevision
    description: The git revision
    default: master
  - name: gitrepositoryurl
    description: The git repository url
  - name: message
    description: The message to print
    default: This is the default message
  - name: contenttype
    description: The Content-Type of the event
  resourcetemplates:
  - apiVersion: tekton.dev/v1beta1
    kind: PipelineRun
    metadata:
      generateName: simple-pipeline-run-
    spec:
      pipelineRef:
        name: simple-pipeline
      params:
      - name: message
        value: $(params.message)
      - name: contenttype
        value: $(params.contenttype)
      resources:
      - name: git-source
        resourceSpec:
          type: git
          params:
          - name: revision
            value: $(params.gitrevision)
          - name: url
            value: $(params.gitrepositoryurl)
```


Similar to
[Pipelines](https://github.com/tektoncd/pipeline/blob/master/docs/pipelines.md),`TriggerTemplate`s
do not do any actual work, but instead act as the blueprint for what resources
should be created.

If the namespace is omitted, it will be resolved to the `EventListener`'s
namespace.

The `$(uid)` variable is implicitly available throughout a `TriggerTemplate`'s
resource templates. A random string value is assigned to `$(uid)` like the
postfix generated by the Kubernetes `generateName` metadata field. One instance
where there is useful is when resources in a `TriggerTemplate` have internal
references.

The following are additional labels added to all `TriggerTemplate` resource
templates:

- To help with housekeeping/garbage collection: `tekton.dev/eventlistener`:
  `<EventListenerName>`
- To track resources created by the same event: `tekton.dev/triggers-eventid`:
  `<EventID>`

To enable support for arbitrary resource types, the resource templates are
internally resolved as byte blobs. As a result, validation on these resources is
only done at event processing time (rather than during `TriggerTemplate`
creation). :rotating_light: As of now, only Tekton resources can be defined
within a `TriggerTemplate` :rotating_light:

## Parameters

`TriggerTemplate`s can declare parameters that are supplied by a
`TriggerBinding` and/or `EventListener`. `params` must have a `name`, and can
have an optional `description` and `default` value.

`params` can be referenced in the `TriggerTemplate` using the following variable
substitution syntax, where `<name>` is the name of the parameter:

```YAML
$(params.<name>)
```

`params` can be referenced in the `resourceTemplates` section of a
`TriggerTemplate`. The purpose of `params` is to make `TriggerTemplates`
reusable.

## Best Practices

As of Tekton Pipelines version
[v0.8.0](https://github.com/tektoncd/pipeline/releases/tag/v0.8.0), users can
embed resource specs. It is a best practice to embed each resource specs in the
PipelineRun or TaskRun that uses the resource spec. Embedding the resource spec
avoids a race condition between creating and using resources.
