/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/tektoncd/operator/pkg/apis/operator/v1alpha1"
	scheme "github.com/tektoncd/operator/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// TektonTriggersGetter has a method to return a TektonTriggerInterface.
// A group's client should implement this interface.
type TektonTriggersGetter interface {
	TektonTriggers() TektonTriggerInterface
}

// TektonTriggerInterface has methods to work with TektonTrigger resources.
type TektonTriggerInterface interface {
	Create(ctx context.Context, tektonTrigger *v1alpha1.TektonTrigger, opts v1.CreateOptions) (*v1alpha1.TektonTrigger, error)
	Update(ctx context.Context, tektonTrigger *v1alpha1.TektonTrigger, opts v1.UpdateOptions) (*v1alpha1.TektonTrigger, error)
	UpdateStatus(ctx context.Context, tektonTrigger *v1alpha1.TektonTrigger, opts v1.UpdateOptions) (*v1alpha1.TektonTrigger, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.TektonTrigger, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.TektonTriggerList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TektonTrigger, err error)
	TektonTriggerExpansion
}

// tektonTriggers implements TektonTriggerInterface
type tektonTriggers struct {
	client rest.Interface
}

// newTektonTriggers returns a TektonTriggers
func newTektonTriggers(c *OperatorV1alpha1Client) *tektonTriggers {
	return &tektonTriggers{
		client: c.RESTClient(),
	}
}

// Get takes name of the tektonTrigger, and returns the corresponding tektonTrigger object, and an error if there is any.
func (c *tektonTriggers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.TektonTrigger, err error) {
	result = &v1alpha1.TektonTrigger{}
	err = c.client.Get().
		Resource("tektontriggers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TektonTriggers that match those selectors.
func (c *tektonTriggers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.TektonTriggerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.TektonTriggerList{}
	err = c.client.Get().
		Resource("tektontriggers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tektonTriggers.
func (c *tektonTriggers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("tektontriggers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tektonTrigger and creates it.  Returns the server's representation of the tektonTrigger, and an error, if there is any.
func (c *tektonTriggers) Create(ctx context.Context, tektonTrigger *v1alpha1.TektonTrigger, opts v1.CreateOptions) (result *v1alpha1.TektonTrigger, err error) {
	result = &v1alpha1.TektonTrigger{}
	err = c.client.Post().
		Resource("tektontriggers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tektonTrigger).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tektonTrigger and updates it. Returns the server's representation of the tektonTrigger, and an error, if there is any.
func (c *tektonTriggers) Update(ctx context.Context, tektonTrigger *v1alpha1.TektonTrigger, opts v1.UpdateOptions) (result *v1alpha1.TektonTrigger, err error) {
	result = &v1alpha1.TektonTrigger{}
	err = c.client.Put().
		Resource("tektontriggers").
		Name(tektonTrigger.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tektonTrigger).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *tektonTriggers) UpdateStatus(ctx context.Context, tektonTrigger *v1alpha1.TektonTrigger, opts v1.UpdateOptions) (result *v1alpha1.TektonTrigger, err error) {
	result = &v1alpha1.TektonTrigger{}
	err = c.client.Put().
		Resource("tektontriggers").
		Name(tektonTrigger.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tektonTrigger).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tektonTrigger and deletes it. Returns an error if one occurs.
func (c *tektonTriggers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("tektontriggers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tektonTriggers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("tektontriggers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tektonTrigger.
func (c *tektonTriggers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TektonTrigger, err error) {
	result = &v1alpha1.TektonTrigger{}
	err = c.client.Patch(pt).
		Resource("tektontriggers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
