// Code generated by goa v3.4.0, DO NOT EDIT.
//
// resource HTTP server encoders and decoders
//
// Command:
// $ goa gen github.com/tektoncd/hub/api/design

package server

import (
	"context"
	"net/http"
	"strconv"

	resourceviews "github.com/tektoncd/hub/api/gen/resource/views"
	goahttp "goa.design/goa/v3/http"
	goa "goa.design/goa/v3/pkg"
)

// EncodeVersionsByIDResponse returns an encoder for responses returned by the
// resource VersionsByID endpoint.
func EncodeVersionsByIDResponse(encoder func(context.Context, http.ResponseWriter) goahttp.Encoder) func(context.Context, http.ResponseWriter, interface{}) error {
	return func(ctx context.Context, w http.ResponseWriter, v interface{}) error {
		res := v.(*resourceviews.ResourceVersions)
		enc := encoder(ctx, w)
		body := NewVersionsByIDResponseBody(res.Projected)
		w.WriteHeader(http.StatusOK)
		return enc.Encode(body)
	}
}

// DecodeVersionsByIDRequest returns a decoder for requests sent to the
// resource VersionsByID endpoint.
func DecodeVersionsByIDRequest(mux goahttp.Muxer, decoder func(*http.Request) goahttp.Decoder) func(*http.Request) (interface{}, error) {
	return func(r *http.Request) (interface{}, error) {
		var (
			id  uint
			err error

			params = mux.Vars(r)
		)
		{
			idRaw := params["id"]
			v, err2 := strconv.ParseUint(idRaw, 10, strconv.IntSize)
			if err2 != nil {
				err = goa.MergeErrors(err, goa.InvalidFieldTypeError("id", idRaw, "unsigned integer"))
			}
			id = uint(v)
		}
		if err != nil {
			return nil, err
		}
		payload := NewVersionsByIDPayload(id)

		return payload, nil
	}
}

// EncodeVersionsByIDError returns an encoder for errors returned by the
// VersionsByID resource endpoint.
func EncodeVersionsByIDError(encoder func(context.Context, http.ResponseWriter) goahttp.Encoder, formatter func(err error) goahttp.Statuser) func(context.Context, http.ResponseWriter, error) error {
	encodeError := goahttp.ErrorEncoder(encoder, formatter)
	return func(ctx context.Context, w http.ResponseWriter, v error) error {
		en, ok := v.(ErrorNamer)
		if !ok {
			return encodeError(ctx, w, v)
		}
		switch en.ErrorName() {
		case "internal-error":
			res := v.(*goa.ServiceError)
			enc := encoder(ctx, w)
			var body interface{}
			if formatter != nil {
				body = formatter(res)
			} else {
				body = NewVersionsByIDInternalErrorResponseBody(res)
			}
			w.Header().Set("goa-error", "internal-error")
			w.WriteHeader(http.StatusInternalServerError)
			return enc.Encode(body)
		case "not-found":
			res := v.(*goa.ServiceError)
			enc := encoder(ctx, w)
			var body interface{}
			if formatter != nil {
				body = formatter(res)
			} else {
				body = NewVersionsByIDNotFoundResponseBody(res)
			}
			w.Header().Set("goa-error", "not-found")
			w.WriteHeader(http.StatusNotFound)
			return enc.Encode(body)
		default:
			return encodeError(ctx, w, v)
		}
	}
}

// marshalResourceviewsResourceDataViewToResourceDataResponseBodyWithoutVersion
// builds a value of type *ResourceDataResponseBodyWithoutVersion from a value
// of type *resourceviews.ResourceDataView.
func marshalResourceviewsResourceDataViewToResourceDataResponseBodyWithoutVersion(v *resourceviews.ResourceDataView) *ResourceDataResponseBodyWithoutVersion {
	res := &ResourceDataResponseBodyWithoutVersion{
		ID:         *v.ID,
		Name:       *v.Name,
		Kind:       *v.Kind,
		HubURLPath: *v.HubURLPath,
		Rating:     *v.Rating,
	}
	if v.Catalog != nil {
		res.Catalog = marshalResourceviewsCatalogViewToCatalogResponseBodyMin(v.Catalog)
	}
	if v.Categories != nil {
		res.Categories = make([]*CategoryResponseBody, len(v.Categories))
		for i, val := range v.Categories {
			res.Categories[i] = marshalResourceviewsCategoryViewToCategoryResponseBody(val)
		}
	}
	if v.LatestVersion != nil {
		res.LatestVersion = marshalResourceviewsResourceVersionDataViewToResourceVersionDataResponseBodyWithoutResource(v.LatestVersion)
	}
	if v.Tags != nil {
		res.Tags = make([]*TagResponseBody, len(v.Tags))
		for i, val := range v.Tags {
			res.Tags[i] = marshalResourceviewsTagViewToTagResponseBody(val)
		}
	}
	if v.Platforms != nil {
		res.Platforms = make([]*PlatformResponseBody, len(v.Platforms))
		for i, val := range v.Platforms {
			res.Platforms[i] = marshalResourceviewsPlatformViewToPlatformResponseBody(val)
		}
	}

	return res
}

// marshalResourceviewsCatalogViewToCatalogResponseBodyMin builds a value of
// type *CatalogResponseBodyMin from a value of type *resourceviews.CatalogView.
func marshalResourceviewsCatalogViewToCatalogResponseBodyMin(v *resourceviews.CatalogView) *CatalogResponseBodyMin {
	res := &CatalogResponseBodyMin{
		ID:   *v.ID,
		Name: *v.Name,
		Type: *v.Type,
	}

	return res
}

// marshalResourceviewsCategoryViewToCategoryResponseBody builds a value of
// type *CategoryResponseBody from a value of type *resourceviews.CategoryView.
func marshalResourceviewsCategoryViewToCategoryResponseBody(v *resourceviews.CategoryView) *CategoryResponseBody {
	res := &CategoryResponseBody{
		ID:   *v.ID,
		Name: *v.Name,
	}

	return res
}

// marshalResourceviewsResourceVersionDataViewToResourceVersionDataResponseBodyWithoutResource
// builds a value of type *ResourceVersionDataResponseBodyWithoutResource from
// a value of type *resourceviews.ResourceVersionDataView.
func marshalResourceviewsResourceVersionDataViewToResourceVersionDataResponseBodyWithoutResource(v *resourceviews.ResourceVersionDataView) *ResourceVersionDataResponseBodyWithoutResource {
	res := &ResourceVersionDataResponseBodyWithoutResource{
		ID:                  *v.ID,
		Version:             *v.Version,
		DisplayName:         *v.DisplayName,
		Deprecated:          v.Deprecated,
		Description:         *v.Description,
		MinPipelinesVersion: *v.MinPipelinesVersion,
		RawURL:              *v.RawURL,
		WebURL:              *v.WebURL,
		UpdatedAt:           *v.UpdatedAt,
		HubURLPath:          *v.HubURLPath,
	}
	if v.Platforms != nil {
		res.Platforms = make([]*PlatformResponseBody, len(v.Platforms))
		for i, val := range v.Platforms {
			res.Platforms[i] = marshalResourceviewsPlatformViewToPlatformResponseBody(val)
		}
	}

	return res
}

// marshalResourceviewsPlatformViewToPlatformResponseBody builds a value of
// type *PlatformResponseBody from a value of type *resourceviews.PlatformView.
func marshalResourceviewsPlatformViewToPlatformResponseBody(v *resourceviews.PlatformView) *PlatformResponseBody {
	res := &PlatformResponseBody{
		ID:   *v.ID,
		Name: *v.Name,
	}

	return res
}

// marshalResourceviewsTagViewToTagResponseBody builds a value of type
// *TagResponseBody from a value of type *resourceviews.TagView.
func marshalResourceviewsTagViewToTagResponseBody(v *resourceviews.TagView) *TagResponseBody {
	res := &TagResponseBody{
		ID:   *v.ID,
		Name: *v.Name,
	}

	return res
}

// marshalResourceviewsVersionsViewToVersionsResponseBody builds a value of
// type *VersionsResponseBody from a value of type *resourceviews.VersionsView.
func marshalResourceviewsVersionsViewToVersionsResponseBody(v *resourceviews.VersionsView) *VersionsResponseBody {
	res := &VersionsResponseBody{}
	if v.Latest != nil {
		res.Latest = marshalResourceviewsResourceVersionDataViewToResourceVersionDataResponseBodyMin(v.Latest)
	}
	if v.Versions != nil {
		res.Versions = make([]*ResourceVersionDataResponseBodyMin, len(v.Versions))
		for i, val := range v.Versions {
			res.Versions[i] = marshalResourceviewsResourceVersionDataViewToResourceVersionDataResponseBodyMin(val)
		}
	}

	return res
}

// marshalResourceviewsResourceVersionDataViewToResourceVersionDataResponseBodyMin
// builds a value of type *ResourceVersionDataResponseBodyMin from a value of
// type *resourceviews.ResourceVersionDataView.
func marshalResourceviewsResourceVersionDataViewToResourceVersionDataResponseBodyMin(v *resourceviews.ResourceVersionDataView) *ResourceVersionDataResponseBodyMin {
	res := &ResourceVersionDataResponseBodyMin{
		ID:         *v.ID,
		Version:    *v.Version,
		RawURL:     *v.RawURL,
		WebURL:     *v.WebURL,
		HubURLPath: *v.HubURLPath,
	}
	if v.Platforms != nil {
		res.Platforms = make([]*PlatformResponseBody, len(v.Platforms))
		for i, val := range v.Platforms {
			res.Platforms[i] = marshalResourceviewsPlatformViewToPlatformResponseBody(val)
		}
	}

	return res
}
