// Code generated by goa v3.4.0, DO NOT EDIT.
//
// hub HTTP client CLI support package
//
// Command:
// $ goa gen github.com/tektoncd/hub/api/design

package cli

import (
	"flag"
	"fmt"
	"net/http"
	"os"

	adminc "github.com/tektoncd/hub/api/gen/http/admin/client"
	catalogc "github.com/tektoncd/hub/api/gen/http/catalog/client"
	categoryc "github.com/tektoncd/hub/api/gen/http/category/client"
	ratingc "github.com/tektoncd/hub/api/gen/http/rating/client"
	resourcec "github.com/tektoncd/hub/api/gen/http/resource/client"
	statusc "github.com/tektoncd/hub/api/gen/http/status/client"
	goahttp "goa.design/goa/v3/http"
	goa "goa.design/goa/v3/pkg"
)

// UsageCommands returns the set of commands and sub-commands using the format
//
//    command (subcommand1|subcommand2|...)
//
func UsageCommands() string {
	return `admin (update-agent|refresh-config)
catalog (refresh|refresh-all|catalog-error)
category list
rating (get|update)
resource (list|versions-by-id)
status status
`
}

// UsageExamples produces an example of a valid invocation of the CLI tool.
func UsageExamples() string {
	return os.Args[0] + ` admin update-agent --body '{
      "name": "abc",
      "scopes": [
         "catalog-refresh",
         "agent:create"
      ]
   }' --token "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJleHAiOjE1Nzc4ODAzMDAsImlhdCI6MTU3Nzg4MDAwMCwiaWQiOjExLCJpc3MiOiJUZWt0b24gSHViIiwic2NvcGVzIjpbInJhdGluZzpyZWFkIiwicmF0aW5nOndyaXRlIiwiYWdlbnQ6Y3JlYXRlIl0sInR5cGUiOiJhY2Nlc3MtdG9rZW4ifQ.6pDmziSKkoSqI1f0rc4-AqVdcfY0Q8wA-tSLzdTCLgM"` + "\n" +
		os.Args[0] + ` catalog refresh --catalog-name "tekton" --token "Qui occaecati officia inventore adipisci molestiae quaerat."` + "\n" +
		os.Args[0] + ` category list` + "\n" +
		os.Args[0] + ` rating get --id 8747404606346667859 --token "Deserunt vel."` + "\n" +
		os.Args[0] + ` resource list` + "\n" +
		""
}

// ParseEndpoint returns the endpoint and payload as specified on the command
// line.
func ParseEndpoint(
	scheme, host string,
	doer goahttp.Doer,
	enc func(*http.Request) goahttp.Encoder,
	dec func(*http.Response) goahttp.Decoder,
	restore bool,
) (goa.Endpoint, interface{}, error) {
	var (
		adminFlags = flag.NewFlagSet("admin", flag.ContinueOnError)

		adminUpdateAgentFlags     = flag.NewFlagSet("update-agent", flag.ExitOnError)
		adminUpdateAgentBodyFlag  = adminUpdateAgentFlags.String("body", "REQUIRED", "")
		adminUpdateAgentTokenFlag = adminUpdateAgentFlags.String("token", "REQUIRED", "")

		adminRefreshConfigFlags     = flag.NewFlagSet("refresh-config", flag.ExitOnError)
		adminRefreshConfigTokenFlag = adminRefreshConfigFlags.String("token", "REQUIRED", "")

		catalogFlags = flag.NewFlagSet("catalog", flag.ContinueOnError)

		catalogRefreshFlags           = flag.NewFlagSet("refresh", flag.ExitOnError)
		catalogRefreshCatalogNameFlag = catalogRefreshFlags.String("catalog-name", "REQUIRED", "Name of catalog")
		catalogRefreshTokenFlag       = catalogRefreshFlags.String("token", "REQUIRED", "")

		catalogRefreshAllFlags     = flag.NewFlagSet("refresh-all", flag.ExitOnError)
		catalogRefreshAllTokenFlag = catalogRefreshAllFlags.String("token", "REQUIRED", "")

		catalogCatalogErrorFlags           = flag.NewFlagSet("catalog-error", flag.ExitOnError)
		catalogCatalogErrorCatalogNameFlag = catalogCatalogErrorFlags.String("catalog-name", "REQUIRED", "Name of catalog")
		catalogCatalogErrorTokenFlag       = catalogCatalogErrorFlags.String("token", "REQUIRED", "")

		categoryFlags = flag.NewFlagSet("category", flag.ContinueOnError)

		categoryListFlags = flag.NewFlagSet("list", flag.ExitOnError)

		ratingFlags = flag.NewFlagSet("rating", flag.ContinueOnError)

		ratingGetFlags     = flag.NewFlagSet("get", flag.ExitOnError)
		ratingGetIDFlag    = ratingGetFlags.String("id", "REQUIRED", "ID of a resource")
		ratingGetTokenFlag = ratingGetFlags.String("token", "REQUIRED", "")

		ratingUpdateFlags     = flag.NewFlagSet("update", flag.ExitOnError)
		ratingUpdateBodyFlag  = ratingUpdateFlags.String("body", "REQUIRED", "")
		ratingUpdateIDFlag    = ratingUpdateFlags.String("id", "REQUIRED", "ID of a resource")
		ratingUpdateTokenFlag = ratingUpdateFlags.String("token", "REQUIRED", "")

		resourceFlags = flag.NewFlagSet("resource", flag.ContinueOnError)

		resourceListFlags = flag.NewFlagSet("list", flag.ExitOnError)

		resourceVersionsByIDFlags  = flag.NewFlagSet("versions-by-id", flag.ExitOnError)
		resourceVersionsByIDIDFlag = resourceVersionsByIDFlags.String("id", "REQUIRED", "ID of a resource")

		statusFlags = flag.NewFlagSet("status", flag.ContinueOnError)

		statusStatusFlags = flag.NewFlagSet("status", flag.ExitOnError)
	)
	adminFlags.Usage = adminUsage
	adminUpdateAgentFlags.Usage = adminUpdateAgentUsage
	adminRefreshConfigFlags.Usage = adminRefreshConfigUsage

	catalogFlags.Usage = catalogUsage
	catalogRefreshFlags.Usage = catalogRefreshUsage
	catalogRefreshAllFlags.Usage = catalogRefreshAllUsage
	catalogCatalogErrorFlags.Usage = catalogCatalogErrorUsage

	categoryFlags.Usage = categoryUsage
	categoryListFlags.Usage = categoryListUsage

	ratingFlags.Usage = ratingUsage
	ratingGetFlags.Usage = ratingGetUsage
	ratingUpdateFlags.Usage = ratingUpdateUsage

	resourceFlags.Usage = resourceUsage
	resourceListFlags.Usage = resourceListUsage
	resourceVersionsByIDFlags.Usage = resourceVersionsByIDUsage

	statusFlags.Usage = statusUsage
	statusStatusFlags.Usage = statusStatusUsage

	if err := flag.CommandLine.Parse(os.Args[1:]); err != nil {
		return nil, nil, err
	}

	if flag.NArg() < 2 { // two non flag args are required: SERVICE and ENDPOINT (aka COMMAND)
		return nil, nil, fmt.Errorf("not enough arguments")
	}

	var (
		svcn string
		svcf *flag.FlagSet
	)
	{
		svcn = flag.Arg(0)
		switch svcn {
		case "admin":
			svcf = adminFlags
		case "catalog":
			svcf = catalogFlags
		case "category":
			svcf = categoryFlags
		case "rating":
			svcf = ratingFlags
		case "resource":
			svcf = resourceFlags
		case "status":
			svcf = statusFlags
		default:
			return nil, nil, fmt.Errorf("unknown service %q", svcn)
		}
	}
	if err := svcf.Parse(flag.Args()[1:]); err != nil {
		return nil, nil, err
	}

	var (
		epn string
		epf *flag.FlagSet
	)
	{
		epn = svcf.Arg(0)
		switch svcn {
		case "admin":
			switch epn {
			case "update-agent":
				epf = adminUpdateAgentFlags

			case "refresh-config":
				epf = adminRefreshConfigFlags

			}

		case "catalog":
			switch epn {
			case "refresh":
				epf = catalogRefreshFlags

			case "refresh-all":
				epf = catalogRefreshAllFlags

			case "catalog-error":
				epf = catalogCatalogErrorFlags

			}

		case "category":
			switch epn {
			case "list":
				epf = categoryListFlags

			}

		case "rating":
			switch epn {
			case "get":
				epf = ratingGetFlags

			case "update":
				epf = ratingUpdateFlags

			}

		case "resource":
			switch epn {
			case "list":
				epf = resourceListFlags

			case "versions-by-id":
				epf = resourceVersionsByIDFlags

			}

		case "status":
			switch epn {
			case "status":
				epf = statusStatusFlags

			}

		}
	}
	if epf == nil {
		return nil, nil, fmt.Errorf("unknown %q endpoint %q", svcn, epn)
	}

	// Parse endpoint flags if any
	if svcf.NArg() > 1 {
		if err := epf.Parse(svcf.Args()[1:]); err != nil {
			return nil, nil, err
		}
	}

	var (
		data     interface{}
		endpoint goa.Endpoint
		err      error
	)
	{
		switch svcn {
		case "admin":
			c := adminc.NewClient(scheme, host, doer, enc, dec, restore)
			switch epn {
			case "update-agent":
				endpoint = c.UpdateAgent()
				data, err = adminc.BuildUpdateAgentPayload(*adminUpdateAgentBodyFlag, *adminUpdateAgentTokenFlag)
			case "refresh-config":
				endpoint = c.RefreshConfig()
				data, err = adminc.BuildRefreshConfigPayload(*adminRefreshConfigTokenFlag)
			}
		case "catalog":
			c := catalogc.NewClient(scheme, host, doer, enc, dec, restore)
			switch epn {
			case "refresh":
				endpoint = c.Refresh()
				data, err = catalogc.BuildRefreshPayload(*catalogRefreshCatalogNameFlag, *catalogRefreshTokenFlag)
			case "refresh-all":
				endpoint = c.RefreshAll()
				data, err = catalogc.BuildRefreshAllPayload(*catalogRefreshAllTokenFlag)
			case "catalog-error":
				endpoint = c.CatalogError()
				data, err = catalogc.BuildCatalogErrorPayload(*catalogCatalogErrorCatalogNameFlag, *catalogCatalogErrorTokenFlag)
			}
		case "category":
			c := categoryc.NewClient(scheme, host, doer, enc, dec, restore)
			switch epn {
			case "list":
				endpoint = c.List()
				data = nil
			}
		case "rating":
			c := ratingc.NewClient(scheme, host, doer, enc, dec, restore)
			switch epn {
			case "get":
				endpoint = c.Get()
				data, err = ratingc.BuildGetPayload(*ratingGetIDFlag, *ratingGetTokenFlag)
			case "update":
				endpoint = c.Update()
				data, err = ratingc.BuildUpdatePayload(*ratingUpdateBodyFlag, *ratingUpdateIDFlag, *ratingUpdateTokenFlag)
			}
		case "resource":
			c := resourcec.NewClient(scheme, host, doer, enc, dec, restore)
			switch epn {
			case "list":
				endpoint = c.List()
				data = nil
			case "versions-by-id":
				endpoint = c.VersionsByID()
				data, err = resourcec.BuildVersionsByIDPayload(*resourceVersionsByIDIDFlag)
			}
		case "status":
			c := statusc.NewClient(scheme, host, doer, enc, dec, restore)
			switch epn {
			case "status":
				endpoint = c.Status()
				data = nil
			}
		}
	}
	if err != nil {
		return nil, nil, err
	}

	return endpoint, data, nil
}

// adminUsage displays the usage of the admin command and its subcommands.
func adminUsage() {
	fmt.Fprintf(os.Stderr, `Admin service
Usage:
    %s [globalflags] admin COMMAND [flags]

COMMAND:
    update-agent: Create or Update an agent user with required scopes
    refresh-config: Refresh the changes in config file

Additional help:
    %s admin COMMAND --help
`, os.Args[0], os.Args[0])
}
func adminUpdateAgentUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] admin update-agent -body JSON -token STRING

Create or Update an agent user with required scopes
    -body JSON: 
    -token STRING: 

Example:
    `+os.Args[0]+` admin update-agent --body '{
      "name": "abc",
      "scopes": [
         "catalog-refresh",
         "agent:create"
      ]
   }' --token "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJleHAiOjE1Nzc4ODAzMDAsImlhdCI6MTU3Nzg4MDAwMCwiaWQiOjExLCJpc3MiOiJUZWt0b24gSHViIiwic2NvcGVzIjpbInJhdGluZzpyZWFkIiwicmF0aW5nOndyaXRlIiwiYWdlbnQ6Y3JlYXRlIl0sInR5cGUiOiJhY2Nlc3MtdG9rZW4ifQ.6pDmziSKkoSqI1f0rc4-AqVdcfY0Q8wA-tSLzdTCLgM"
`, os.Args[0])
}

func adminRefreshConfigUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] admin refresh-config -token STRING

Refresh the changes in config file
    -token STRING: 

Example:
    `+os.Args[0]+` admin refresh-config --token "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJleHAiOjE1Nzc4ODAzMDAsImlhdCI6MTU3Nzg4MDAwMCwiaWQiOjExLCJpc3MiOiJUZWt0b24gSHViIiwic2NvcGVzIjpbInJhdGluZzpyZWFkIiwicmF0aW5nOndyaXRlIiwiYWdlbnQ6Y3JlYXRlIl0sInR5cGUiOiJhY2Nlc3MtdG9rZW4ifQ.6pDmziSKkoSqI1f0rc4-AqVdcfY0Q8wA-tSLzdTCLgM"
`, os.Args[0])
}

// catalogUsage displays the usage of the catalog command and its subcommands.
func catalogUsage() {
	fmt.Fprintf(os.Stderr, `The Catalog Service exposes endpoints to interact with catalogs
Usage:
    %s [globalflags] catalog COMMAND [flags]

COMMAND:
    refresh: Refresh a Catalog by it's name
    refresh-all: Refresh all catalogs
    catalog-error: List all errors occurred refreshing a catalog

Additional help:
    %s catalog COMMAND --help
`, os.Args[0], os.Args[0])
}
func catalogRefreshUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] catalog refresh -catalog-name STRING -token STRING

Refresh a Catalog by it's name
    -catalog-name STRING: Name of catalog
    -token STRING: 

Example:
    `+os.Args[0]+` catalog refresh --catalog-name "tekton" --token "Qui occaecati officia inventore adipisci molestiae quaerat."
`, os.Args[0])
}

func catalogRefreshAllUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] catalog refresh-all -token STRING

Refresh all catalogs
    -token STRING: 

Example:
    `+os.Args[0]+` catalog refresh-all --token "Qui qui temporibus consequuntur."
`, os.Args[0])
}

func catalogCatalogErrorUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] catalog catalog-error -catalog-name STRING -token STRING

List all errors occurred refreshing a catalog
    -catalog-name STRING: Name of catalog
    -token STRING: 

Example:
    `+os.Args[0]+` catalog catalog-error --catalog-name "tekton" --token "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJleHAiOjE1Nzc4ODM2MDAsImlhdCI6MTU3Nzg4MDAwMCwiaWQiOjExLCJpc3MiOiJUZWt0b24gSHViIiwic2NvcGVzIjpbInJlZnJlc2g6dG9rZW4iXSwidHlwZSI6InJlZnJlc2gtdG9rZW4ifQ.4RdUk5ttHdDiymurlZ_f7Uy5Pas3Lq9w04BjKQKRiCE"
`, os.Args[0])
}

// categoryUsage displays the usage of the category command and its subcommands.
func categoryUsage() {
	fmt.Fprintf(os.Stderr, `The category service provides details about category
Usage:
    %s [globalflags] category COMMAND [flags]

COMMAND:
    list: List all categories along with their tags sorted by name

Additional help:
    %s category COMMAND --help
`, os.Args[0], os.Args[0])
}
func categoryListUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] category list

List all categories along with their tags sorted by name

Example:
    `+os.Args[0]+` category list
`, os.Args[0])
}

// ratingUsage displays the usage of the rating command and its subcommands.
func ratingUsage() {
	fmt.Fprintf(os.Stderr, `The rating service exposes endpoints to read and write user's rating for resources
Usage:
    %s [globalflags] rating COMMAND [flags]

COMMAND:
    get: Find user's rating for a resource
    update: Update user's rating for a resource

Additional help:
    %s rating COMMAND --help
`, os.Args[0], os.Args[0])
}
func ratingGetUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] rating get -id UINT -token STRING

Find user's rating for a resource
    -id UINT: ID of a resource
    -token STRING: 

Example:
    `+os.Args[0]+` rating get --id 8747404606346667859 --token "Deserunt vel."
`, os.Args[0])
}

func ratingUpdateUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] rating update -body JSON -id UINT -token STRING

Update user's rating for a resource
    -body JSON: 
    -id UINT: ID of a resource
    -token STRING: 

Example:
    `+os.Args[0]+` rating update --body '{
      "rating": 0
   }' --id 12809560377624145324 --token "Qui hic."
`, os.Args[0])
}

// resourceUsage displays the usage of the resource command and its subcommands.
func resourceUsage() {
	fmt.Fprintf(os.Stderr, `The resource service provides details about all kind of resources
Usage:
    %s [globalflags] resource COMMAND [flags]

COMMAND:
    list: List all resources sorted by rating and name
    versions-by-id: Find all versions of a resource by its id

Additional help:
    %s resource COMMAND --help
`, os.Args[0], os.Args[0])
}
func resourceListUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] resource list

List all resources sorted by rating and name

Example:
    `+os.Args[0]+` resource list
`, os.Args[0])
}

func resourceVersionsByIDUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] resource versions-by-id -id UINT

Find all versions of a resource by its id
    -id UINT: ID of a resource

Example:
    `+os.Args[0]+` resource versions-by-id --id 1
`, os.Args[0])
}

// statusUsage displays the usage of the status command and its subcommands.
func statusUsage() {
	fmt.Fprintf(os.Stderr, `Describes the status of each service
Usage:
    %s [globalflags] status COMMAND [flags]

COMMAND:
    status: Return status of the services

Additional help:
    %s status COMMAND --help
`, os.Args[0], os.Args[0])
}
func statusStatusUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] status status

Return status of the services

Example:
    `+os.Args[0]+` status status
`, os.Args[0])
}
