package com.redhat.openshift;

import org.mindrot.jbcrypt.BCrypt;
//import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

/**
 * This has been migrated from acegi to jbcrypt because of Acegi removal from
 * Jenkins. Jenkins team also talks about using BCryptPasswordEncoder instead,
 * so in case this happens one can uncomment the spring-security lines here to
 * change the implementation. However, this requires commons-logging to be in
 * the classpath, which is not the case for Jenkins.
 * 
 * @author Akram
 *
 */
public class PasswordEncoder {
	public static void main(String[] args) {
		String password = args[0];
//		int strength = 10;
//		BCryptPasswordEncoder encoder = new BCryptPasswordEncoder(strength, new SecureRandom());
//		String encodedPassword = encoder.encode(password);
//		System.out.println(encodedPassword);
		String encodedPassword = BCrypt.hashpw(password, BCrypt.gensalt());
		System.out.println(encodedPassword);
	}
}
