/*
Copyright the Velero contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/vmware-tanzu/velero/pkg/apis/velero/v1"
	scheme "github.com/vmware-tanzu/velero/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// DownloadRequestsGetter has a method to return a DownloadRequestInterface.
// A group's client should implement this interface.
type DownloadRequestsGetter interface {
	DownloadRequests(namespace string) DownloadRequestInterface
}

// DownloadRequestInterface has methods to work with DownloadRequest resources.
type DownloadRequestInterface interface {
	Create(ctx context.Context, downloadRequest *v1.DownloadRequest, opts metav1.CreateOptions) (*v1.DownloadRequest, error)
	Update(ctx context.Context, downloadRequest *v1.DownloadRequest, opts metav1.UpdateOptions) (*v1.DownloadRequest, error)
	UpdateStatus(ctx context.Context, downloadRequest *v1.DownloadRequest, opts metav1.UpdateOptions) (*v1.DownloadRequest, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.DownloadRequest, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.DownloadRequestList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.DownloadRequest, err error)
	DownloadRequestExpansion
}

// downloadRequests implements DownloadRequestInterface
type downloadRequests struct {
	client rest.Interface
	ns     string
}

// newDownloadRequests returns a DownloadRequests
func newDownloadRequests(c *VeleroV1Client, namespace string) *downloadRequests {
	return &downloadRequests{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the downloadRequest, and returns the corresponding downloadRequest object, and an error if there is any.
func (c *downloadRequests) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.DownloadRequest, err error) {
	result = &v1.DownloadRequest{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("downloadrequests").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of DownloadRequests that match those selectors.
func (c *downloadRequests) List(ctx context.Context, opts metav1.ListOptions) (result *v1.DownloadRequestList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.DownloadRequestList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("downloadrequests").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested downloadRequests.
func (c *downloadRequests) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("downloadrequests").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a downloadRequest and creates it.  Returns the server's representation of the downloadRequest, and an error, if there is any.
func (c *downloadRequests) Create(ctx context.Context, downloadRequest *v1.DownloadRequest, opts metav1.CreateOptions) (result *v1.DownloadRequest, err error) {
	result = &v1.DownloadRequest{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("downloadrequests").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(downloadRequest).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a downloadRequest and updates it. Returns the server's representation of the downloadRequest, and an error, if there is any.
func (c *downloadRequests) Update(ctx context.Context, downloadRequest *v1.DownloadRequest, opts metav1.UpdateOptions) (result *v1.DownloadRequest, err error) {
	result = &v1.DownloadRequest{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("downloadrequests").
		Name(downloadRequest.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(downloadRequest).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *downloadRequests) UpdateStatus(ctx context.Context, downloadRequest *v1.DownloadRequest, opts metav1.UpdateOptions) (result *v1.DownloadRequest, err error) {
	result = &v1.DownloadRequest{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("downloadrequests").
		Name(downloadRequest.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(downloadRequest).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the downloadRequest and deletes it. Returns an error if one occurs.
func (c *downloadRequests) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("downloadrequests").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *downloadRequests) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("downloadrequests").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched downloadRequest.
func (c *downloadRequests) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.DownloadRequest, err error) {
	result = &v1.DownloadRequest{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("downloadrequests").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
