// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3control

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restxml"
)

const opCreateAccessPoint = "CreateAccessPoint"

// CreateAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessPoint for more information on using the CreateAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAccessPointRequest method.
//    req, resp := client.CreateAccessPointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessPoint
func (c *S3Control) CreateAccessPointRequest(input *CreateAccessPointInput) (req *request.Request, output *CreateAccessPointOutput) {
	op := &request.Operation{
		Name:       opCreateAccessPoint,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accesspoint/{name}",
	}

	if input == nil {
		input = &CreateAccessPointInput{}
	}

	output = &CreateAccessPointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateAccessPoint API operation for AWS S3 Control.
//
// Creates an access point and associates it with the specified bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateAccessPoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateAccessPoint
func (c *S3Control) CreateAccessPoint(input *CreateAccessPointInput) (*CreateAccessPointOutput, error) {
	req, out := c.CreateAccessPointRequest(input)
	return out, req.Send()
}

// CreateAccessPointWithContext is the same as CreateAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateAccessPointWithContext(ctx aws.Context, input *CreateAccessPointInput, opts ...request.Option) (*CreateAccessPointOutput, error) {
	req, out := c.CreateAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJob for more information on using the CreateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateJobRequest method.
//    req, resp := client.CreateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateJob
func (c *S3Control) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/jobs",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateJob API operation for AWS S3 Control.
//
// You can use Amazon S3 Batch Operations to perform large-scale Batch Operations
// on Amazon S3 objects. Amazon S3 Batch Operations can execute a single operation
// or action on lists of Amazon S3 objects that you specify. For more information,
// see Amazon S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * DescribeJob
//
//    * ListJobs
//
//    * UpdateJobPriority
//
//    * UpdateJobStatus
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation CreateJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeIdempotencyException "IdempotencyException"
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/CreateJob
func (c *S3Control) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	return out, req.Send()
}

// CreateJobWithContext is the same as CreateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) CreateJobWithContext(ctx aws.Context, input *CreateJobInput, opts ...request.Option) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessPoint = "DeleteAccessPoint"

// DeleteAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessPoint for more information on using the DeleteAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccessPointRequest method.
//    req, resp := client.DeleteAccessPointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPoint
func (c *S3Control) DeleteAccessPointRequest(input *DeleteAccessPointInput) (req *request.Request, output *DeleteAccessPointOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessPoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accesspoint/{name}",
	}

	if input == nil {
		input = &DeleteAccessPointInput{}
	}

	output = &DeleteAccessPointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAccessPoint API operation for AWS S3 Control.
//
// Deletes the specified access point.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteAccessPoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPoint
func (c *S3Control) DeleteAccessPoint(input *DeleteAccessPointInput) (*DeleteAccessPointOutput, error) {
	req, out := c.DeleteAccessPointRequest(input)
	return out, req.Send()
}

// DeleteAccessPointWithContext is the same as DeleteAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteAccessPointWithContext(ctx aws.Context, input *DeleteAccessPointInput, opts ...request.Option) (*DeleteAccessPointOutput, error) {
	req, out := c.DeleteAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessPointPolicy = "DeleteAccessPointPolicy"

// DeleteAccessPointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessPointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessPointPolicy for more information on using the DeleteAccessPointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccessPointPolicyRequest method.
//    req, resp := client.DeleteAccessPointPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointPolicy
func (c *S3Control) DeleteAccessPointPolicyRequest(input *DeleteAccessPointPolicyInput) (req *request.Request, output *DeleteAccessPointPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessPointPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/accesspoint/{name}/policy",
	}

	if input == nil {
		input = &DeleteAccessPointPolicyInput{}
	}

	output = &DeleteAccessPointPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteAccessPointPolicy API operation for AWS S3 Control.
//
// Deletes the access point policy for the specified access point.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteAccessPointPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteAccessPointPolicy
func (c *S3Control) DeleteAccessPointPolicy(input *DeleteAccessPointPolicyInput) (*DeleteAccessPointPolicyOutput, error) {
	req, out := c.DeleteAccessPointPolicyRequest(input)
	return out, req.Send()
}

// DeleteAccessPointPolicyWithContext is the same as DeleteAccessPointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessPointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteAccessPointPolicyWithContext(ctx aws.Context, input *DeleteAccessPointPolicyInput, opts ...request.Option) (*DeleteAccessPointPolicyOutput, error) {
	req, out := c.DeleteAccessPointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJobTagging = "DeleteJobTagging"

// DeleteJobTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJobTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJobTagging for more information on using the DeleteJobTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJobTaggingRequest method.
//    req, resp := client.DeleteJobTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteJobTagging
func (c *S3Control) DeleteJobTaggingRequest(input *DeleteJobTaggingInput) (req *request.Request, output *DeleteJobTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteJobTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/jobs/{id}/tagging",
	}

	if input == nil {
		input = &DeleteJobTaggingInput{}
	}

	output = &DeleteJobTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteJobTagging API operation for AWS S3 Control.
//
// Removes the entire tag set from the specified Amazon S3 Batch Operations
// job. To use this operation, you must have permission to perform the s3:DeleteJobTagging
// action. For more information, see Using Job Tags (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob
//
//    * GetJobTagging
//
//    * PutJobTagging
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeleteJobTagging for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeleteJobTagging
func (c *S3Control) DeleteJobTagging(input *DeleteJobTaggingInput) (*DeleteJobTaggingOutput, error) {
	req, out := c.DeleteJobTaggingRequest(input)
	return out, req.Send()
}

// DeleteJobTaggingWithContext is the same as DeleteJobTagging with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJobTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeleteJobTaggingWithContext(ctx aws.Context, input *DeleteJobTaggingInput, opts ...request.Option) (*DeleteJobTaggingOutput, error) {
	req, out := c.DeleteJobTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePublicAccessBlock = "DeletePublicAccessBlock"

// DeletePublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the DeletePublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePublicAccessBlock for more information on using the DeletePublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePublicAccessBlockRequest method.
//    req, resp := client.DeletePublicAccessBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeletePublicAccessBlock
func (c *S3Control) DeletePublicAccessBlockRequest(input *DeletePublicAccessBlockInput) (req *request.Request, output *DeletePublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opDeletePublicAccessBlock,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v20180820/configuration/publicAccessBlock",
	}

	if input == nil {
		input = &DeletePublicAccessBlockInput{}
	}

	output = &DeletePublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeletePublicAccessBlock API operation for AWS S3 Control.
//
// Removes the PublicAccessBlock configuration for an Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DeletePublicAccessBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DeletePublicAccessBlock
func (c *S3Control) DeletePublicAccessBlock(input *DeletePublicAccessBlockInput) (*DeletePublicAccessBlockOutput, error) {
	req, out := c.DeletePublicAccessBlockRequest(input)
	return out, req.Send()
}

// DeletePublicAccessBlockWithContext is the same as DeletePublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DeletePublicAccessBlockWithContext(ctx aws.Context, input *DeletePublicAccessBlockInput, opts ...request.Option) (*DeletePublicAccessBlockOutput, error) {
	req, out := c.DeletePublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJob = "DescribeJob"

// DescribeJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJob for more information on using the DescribeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobRequest method.
//    req, resp := client.DescribeJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeJob
func (c *S3Control) DescribeJobRequest(input *DescribeJobInput) (req *request.Request, output *DescribeJobOutput) {
	op := &request.Operation{
		Name:       opDescribeJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/jobs/{id}",
	}

	if input == nil {
		input = &DescribeJobInput{}
	}

	output = &DescribeJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeJob API operation for AWS S3 Control.
//
// Retrieves the configuration parameters and status for a Batch Operations
// job. For more information, see Amazon S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob
//
//    * ListJobs
//
//    * UpdateJobPriority
//
//    * UpdateJobStatus
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation DescribeJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeJob
func (c *S3Control) DescribeJob(input *DescribeJobInput) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	return out, req.Send()
}

// DescribeJobWithContext is the same as DescribeJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) DescribeJobWithContext(ctx aws.Context, input *DescribeJobInput, opts ...request.Option) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPoint = "GetAccessPoint"

// GetAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPoint for more information on using the GetAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccessPointRequest method.
//    req, resp := client.GetAccessPointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPoint
func (c *S3Control) GetAccessPointRequest(input *GetAccessPointInput) (req *request.Request, output *GetAccessPointOutput) {
	op := &request.Operation{
		Name:       opGetAccessPoint,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint/{name}",
	}

	if input == nil {
		input = &GetAccessPointInput{}
	}

	output = &GetAccessPointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPoint API operation for AWS S3 Control.
//
// Returns configuration information about the specified access point.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPoint
func (c *S3Control) GetAccessPoint(input *GetAccessPointInput) (*GetAccessPointOutput, error) {
	req, out := c.GetAccessPointRequest(input)
	return out, req.Send()
}

// GetAccessPointWithContext is the same as GetAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointWithContext(ctx aws.Context, input *GetAccessPointInput, opts ...request.Option) (*GetAccessPointOutput, error) {
	req, out := c.GetAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPointPolicy = "GetAccessPointPolicy"

// GetAccessPointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPointPolicy for more information on using the GetAccessPointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccessPointPolicyRequest method.
//    req, resp := client.GetAccessPointPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicy
func (c *S3Control) GetAccessPointPolicyRequest(input *GetAccessPointPolicyInput) (req *request.Request, output *GetAccessPointPolicyOutput) {
	op := &request.Operation{
		Name:       opGetAccessPointPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint/{name}/policy",
	}

	if input == nil {
		input = &GetAccessPointPolicyInput{}
	}

	output = &GetAccessPointPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPointPolicy API operation for AWS S3 Control.
//
// Returns the access point policy associated with the specified access point.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPointPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicy
func (c *S3Control) GetAccessPointPolicy(input *GetAccessPointPolicyInput) (*GetAccessPointPolicyOutput, error) {
	req, out := c.GetAccessPointPolicyRequest(input)
	return out, req.Send()
}

// GetAccessPointPolicyWithContext is the same as GetAccessPointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointPolicyWithContext(ctx aws.Context, input *GetAccessPointPolicyInput, opts ...request.Option) (*GetAccessPointPolicyOutput, error) {
	req, out := c.GetAccessPointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPointPolicyStatus = "GetAccessPointPolicyStatus"

// GetAccessPointPolicyStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPointPolicyStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPointPolicyStatus for more information on using the GetAccessPointPolicyStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccessPointPolicyStatusRequest method.
//    req, resp := client.GetAccessPointPolicyStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyStatus
func (c *S3Control) GetAccessPointPolicyStatusRequest(input *GetAccessPointPolicyStatusInput) (req *request.Request, output *GetAccessPointPolicyStatusOutput) {
	op := &request.Operation{
		Name:       opGetAccessPointPolicyStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint/{name}/policyStatus",
	}

	if input == nil {
		input = &GetAccessPointPolicyStatusInput{}
	}

	output = &GetAccessPointPolicyStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetAccessPointPolicyStatus API operation for AWS S3 Control.
//
// Indicates whether the specified access point currently has a policy that
// allows public access. For more information about public access through access
// points, see Managing Data Access with Amazon S3 Access Points (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetAccessPointPolicyStatus for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyStatus
func (c *S3Control) GetAccessPointPolicyStatus(input *GetAccessPointPolicyStatusInput) (*GetAccessPointPolicyStatusOutput, error) {
	req, out := c.GetAccessPointPolicyStatusRequest(input)
	return out, req.Send()
}

// GetAccessPointPolicyStatusWithContext is the same as GetAccessPointPolicyStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPointPolicyStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetAccessPointPolicyStatusWithContext(ctx aws.Context, input *GetAccessPointPolicyStatusInput, opts ...request.Option) (*GetAccessPointPolicyStatusOutput, error) {
	req, out := c.GetAccessPointPolicyStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobTagging = "GetJobTagging"

// GetJobTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetJobTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobTagging for more information on using the GetJobTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobTaggingRequest method.
//    req, resp := client.GetJobTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetJobTagging
func (c *S3Control) GetJobTaggingRequest(input *GetJobTaggingInput) (req *request.Request, output *GetJobTaggingOutput) {
	op := &request.Operation{
		Name:       opGetJobTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/jobs/{id}/tagging",
	}

	if input == nil {
		input = &GetJobTaggingInput{}
	}

	output = &GetJobTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetJobTagging API operation for AWS S3 Control.
//
// Returns the tags on an Amazon S3 Batch Operations job. To use this operation,
// you must have permission to perform the s3:GetJobTagging action. For more
// information, see Using Job Tags (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob
//
//    * PutJobTagging
//
//    * DeleteJobTagging
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetJobTagging for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetJobTagging
func (c *S3Control) GetJobTagging(input *GetJobTaggingInput) (*GetJobTaggingOutput, error) {
	req, out := c.GetJobTaggingRequest(input)
	return out, req.Send()
}

// GetJobTaggingWithContext is the same as GetJobTagging with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetJobTaggingWithContext(ctx aws.Context, input *GetJobTaggingInput, opts ...request.Option) (*GetJobTaggingOutput, error) {
	req, out := c.GetJobTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicAccessBlock = "GetPublicAccessBlock"

// GetPublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the GetPublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPublicAccessBlock for more information on using the GetPublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPublicAccessBlockRequest method.
//    req, resp := client.GetPublicAccessBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetPublicAccessBlock
func (c *S3Control) GetPublicAccessBlockRequest(input *GetPublicAccessBlockInput) (req *request.Request, output *GetPublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opGetPublicAccessBlock,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/configuration/publicAccessBlock",
	}

	if input == nil {
		input = &GetPublicAccessBlockInput{}
	}

	output = &GetPublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetPublicAccessBlock API operation for AWS S3 Control.
//
// Retrieves the PublicAccessBlock configuration for an Amazon Web Services
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation GetPublicAccessBlock for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchPublicAccessBlockConfiguration "NoSuchPublicAccessBlockConfiguration"
//   Amazon S3 throws this exception if you make a GetPublicAccessBlock request
//   against an account that doesn't have a PublicAccessBlockConfiguration set.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetPublicAccessBlock
func (c *S3Control) GetPublicAccessBlock(input *GetPublicAccessBlockInput) (*GetPublicAccessBlockOutput, error) {
	req, out := c.GetPublicAccessBlockRequest(input)
	return out, req.Send()
}

// GetPublicAccessBlockWithContext is the same as GetPublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) GetPublicAccessBlockWithContext(ctx aws.Context, input *GetPublicAccessBlockInput, opts ...request.Option) (*GetPublicAccessBlockOutput, error) {
	req, out := c.GetPublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccessPoints = "ListAccessPoints"

// ListAccessPointsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessPoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessPoints for more information on using the ListAccessPoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccessPointsRequest method.
//    req, resp := client.ListAccessPointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessPoints
func (c *S3Control) ListAccessPointsRequest(input *ListAccessPointsInput) (req *request.Request, output *ListAccessPointsOutput) {
	op := &request.Operation{
		Name:       opListAccessPoints,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessPointsInput{}
	}

	output = &ListAccessPointsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAccessPoints API operation for AWS S3 Control.
//
// Returns a list of the access points currently associated with the specified
// bucket. You can retrieve up to 1000 access points per call. If the specified
// bucket has more than 1,000 access points (or the number specified in maxResults,
// whichever is less), the response will include a continuation token that you
// can use to list the additional access points.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListAccessPoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListAccessPoints
func (c *S3Control) ListAccessPoints(input *ListAccessPointsInput) (*ListAccessPointsOutput, error) {
	req, out := c.ListAccessPointsRequest(input)
	return out, req.Send()
}

// ListAccessPointsWithContext is the same as ListAccessPoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessPointsWithContext(ctx aws.Context, input *ListAccessPointsInput, opts ...request.Option) (*ListAccessPointsOutput, error) {
	req, out := c.ListAccessPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessPointsPages iterates over the pages of a ListAccessPoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessPoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccessPoints operation.
//    pageNum := 0
//    err := client.ListAccessPointsPages(params,
//        func(page *s3control.ListAccessPointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3Control) ListAccessPointsPages(input *ListAccessPointsInput, fn func(*ListAccessPointsOutput, bool) bool) error {
	return c.ListAccessPointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessPointsPagesWithContext same as ListAccessPointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListAccessPointsPagesWithContext(ctx aws.Context, input *ListAccessPointsInput, fn func(*ListAccessPointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessPointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessPointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessPointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListJobs
func (c *S3Control) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListJobs API operation for AWS S3 Control.
//
// Lists current Amazon S3 Batch Operations jobs and jobs that have ended within
// the last 30 days for the AWS account making the request. For more information,
// see Amazon S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob
//
//    * DescribeJob
//
//    * UpdateJobPriority
//
//    * UpdateJobStatus
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation ListJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/ListJobs
func (c *S3Control) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListJobs operation.
//    pageNum := 0
//    err := client.ListJobsPages(params,
//        func(page *s3control.ListJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3Control) ListJobsPages(input *ListJobsInput, fn func(*ListJobsOutput, bool) bool) error {
	return c.ListJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobsPagesWithContext same as ListJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) ListJobsPagesWithContext(ctx aws.Context, input *ListJobsInput, fn func(*ListJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutAccessPointPolicy = "PutAccessPointPolicy"

// PutAccessPointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutAccessPointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccessPointPolicy for more information on using the PutAccessPointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAccessPointPolicyRequest method.
//    req, resp := client.PutAccessPointPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointPolicy
func (c *S3Control) PutAccessPointPolicyRequest(input *PutAccessPointPolicyInput) (req *request.Request, output *PutAccessPointPolicyOutput) {
	op := &request.Operation{
		Name:       opPutAccessPointPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/accesspoint/{name}/policy",
	}

	if input == nil {
		input = &PutAccessPointPolicyInput{}
	}

	output = &PutAccessPointPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutAccessPointPolicy API operation for AWS S3 Control.
//
// Associates an access policy with the specified access point. Each access
// point can have only one policy, so a request made to this API replaces any
// existing policy associated with the specified access point.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutAccessPointPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutAccessPointPolicy
func (c *S3Control) PutAccessPointPolicy(input *PutAccessPointPolicyInput) (*PutAccessPointPolicyOutput, error) {
	req, out := c.PutAccessPointPolicyRequest(input)
	return out, req.Send()
}

// PutAccessPointPolicyWithContext is the same as PutAccessPointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccessPointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutAccessPointPolicyWithContext(ctx aws.Context, input *PutAccessPointPolicyInput, opts ...request.Option) (*PutAccessPointPolicyOutput, error) {
	req, out := c.PutAccessPointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutJobTagging = "PutJobTagging"

// PutJobTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutJobTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutJobTagging for more information on using the PutJobTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutJobTaggingRequest method.
//    req, resp := client.PutJobTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutJobTagging
func (c *S3Control) PutJobTaggingRequest(input *PutJobTaggingInput) (req *request.Request, output *PutJobTaggingOutput) {
	op := &request.Operation{
		Name:       opPutJobTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/jobs/{id}/tagging",
	}

	if input == nil {
		input = &PutJobTaggingInput{}
	}

	output = &PutJobTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutJobTagging API operation for AWS S3 Control.
//
// Set the supplied tag-set on an Amazon S3 Batch Operations job.
//
// A tag is a key-value pair. You can associate Amazon S3 Batch Operations tags
// with any job by sending a PUT request against the tagging subresource that
// is associated with the job. To modify the existing tag set, you can either
// replace the existing tag set entirely, or make changes within the existing
// tag set by retrieving the existing tag set using GetJobTagging, modify that
// tag set, and use this API action to replace the tag set with the one you
// have modified.. For more information, see Using Job Tags (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-managing-jobs.html#batch-ops-job-tags)
// in the Amazon Simple Storage Service Developer Guide.
//
//    * If you send this request with an empty tag set, Amazon S3 deletes the
//    existing tag set on the Batch Operations job. If you use this method,
//    you will be charged for a Tier 1 Request (PUT). For more information,
//    see Amazon S3 pricing (http://aws.amazon.com/s3/pricing/).
//
//    * For deleting existing tags for your batch operations job, DeleteJobTagging
//    request is preferred because it achieves the same result without incurring
//    charges.
//
//    * A few things to consider about using tags: Amazon S3 limits the maximum
//    number of tags to 50 tags per job. You can associate up to 50 tags with
//    a job as long as they have unique tag keys. A tag key can be up to 128
//    Unicode characters in length, and tag values can be up to 256 Unicode
//    characters in length. The key and values are case sensitive. For tagging-related
//    restrictions related to characters and encodings, see User-Defined Tag
//    Restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html).
//
// To use this operation, you must have permission to perform the s3:PutJobTagging
// action.
//
// Related actions include:
//
//    * CreateJob
//
//    * GetJobTagging
//
//    * DeleteJobTagging
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutJobTagging for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutJobTagging
func (c *S3Control) PutJobTagging(input *PutJobTaggingInput) (*PutJobTaggingOutput, error) {
	req, out := c.PutJobTaggingRequest(input)
	return out, req.Send()
}

// PutJobTaggingWithContext is the same as PutJobTagging with the addition of
// the ability to pass a context and additional request options.
//
// See PutJobTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutJobTaggingWithContext(ctx aws.Context, input *PutJobTaggingInput, opts ...request.Option) (*PutJobTaggingOutput, error) {
	req, out := c.PutJobTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPublicAccessBlock = "PutPublicAccessBlock"

// PutPublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the PutPublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPublicAccessBlock for more information on using the PutPublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutPublicAccessBlockRequest method.
//    req, resp := client.PutPublicAccessBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutPublicAccessBlock
func (c *S3Control) PutPublicAccessBlockRequest(input *PutPublicAccessBlockInput) (req *request.Request, output *PutPublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opPutPublicAccessBlock,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20180820/configuration/publicAccessBlock",
	}

	if input == nil {
		input = &PutPublicAccessBlockInput{}
	}

	output = &PutPublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutPublicAccessBlock API operation for AWS S3 Control.
//
// Creates or modifies the PublicAccessBlock configuration for an Amazon Web
// Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation PutPublicAccessBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/PutPublicAccessBlock
func (c *S3Control) PutPublicAccessBlock(input *PutPublicAccessBlockInput) (*PutPublicAccessBlockOutput, error) {
	req, out := c.PutPublicAccessBlockRequest(input)
	return out, req.Send()
}

// PutPublicAccessBlockWithContext is the same as PutPublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See PutPublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) PutPublicAccessBlockWithContext(ctx aws.Context, input *PutPublicAccessBlockInput, opts ...request.Option) (*PutPublicAccessBlockOutput, error) {
	req, out := c.PutPublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJobPriority = "UpdateJobPriority"

// UpdateJobPriorityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJobPriority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJobPriority for more information on using the UpdateJobPriority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateJobPriorityRequest method.
//    req, resp := client.UpdateJobPriorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobPriority
func (c *S3Control) UpdateJobPriorityRequest(input *UpdateJobPriorityInput) (req *request.Request, output *UpdateJobPriorityOutput) {
	op := &request.Operation{
		Name:       opUpdateJobPriority,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/jobs/{id}/priority",
	}

	if input == nil {
		input = &UpdateJobPriorityInput{}
	}

	output = &UpdateJobPriorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateJobPriority API operation for AWS S3 Control.
//
// Updates an existing Amazon S3 Batch Operations job's priority. For more information,
// see Amazon S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob
//
//    * ListJobs
//
//    * DescribeJob
//
//    * UpdateJobStatus
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation UpdateJobPriority for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobPriority
func (c *S3Control) UpdateJobPriority(input *UpdateJobPriorityInput) (*UpdateJobPriorityOutput, error) {
	req, out := c.UpdateJobPriorityRequest(input)
	return out, req.Send()
}

// UpdateJobPriorityWithContext is the same as UpdateJobPriority with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJobPriority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) UpdateJobPriorityWithContext(ctx aws.Context, input *UpdateJobPriorityInput, opts ...request.Option) (*UpdateJobPriorityOutput, error) {
	req, out := c.UpdateJobPriorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJobStatus = "UpdateJobStatus"

// UpdateJobStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJobStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJobStatus for more information on using the UpdateJobStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateJobStatusRequest method.
//    req, resp := client.UpdateJobStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobStatus
func (c *S3Control) UpdateJobStatusRequest(input *UpdateJobStatusInput) (req *request.Request, output *UpdateJobStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateJobStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/v20180820/jobs/{id}/status",
	}

	if input == nil {
		input = &UpdateJobStatusInput{}
	}

	output = &UpdateJobStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("{AccountId}.", input.hostLabels))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateJobStatus API operation for AWS S3 Control.
//
// Updates the status for the specified job. Use this operation to confirm that
// you want to run a job or to cancel an existing job. For more information,
// see Amazon S3 Batch Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Related actions include:
//
//    * CreateJob
//
//    * ListJobs
//
//    * DescribeJob
//
//    * UpdateJobStatus
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS S3 Control's
// API operation UpdateJobStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeJobStatusException "JobStatusException"
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/UpdateJobStatus
func (c *S3Control) UpdateJobStatus(input *UpdateJobStatusInput) (*UpdateJobStatusOutput, error) {
	req, out := c.UpdateJobStatusRequest(input)
	return out, req.Send()
}

// UpdateJobStatusWithContext is the same as UpdateJobStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJobStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3Control) UpdateJobStatusWithContext(ctx aws.Context, input *UpdateJobStatusInput, opts ...request.Option) (*UpdateJobStatusOutput, error) {
	req, out := c.UpdateJobStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An access point used to access a bucket.
type AccessPoint struct {
	_ struct{} `type:"structure"`

	// The name of the bucket associated with this access point.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The name of this access point.
	//
	// Name is a required field
	Name *string `min:"3" type:"string" required:"true"`

	// Indicates whether this access point allows access from the public internet.
	// If VpcConfiguration is specified for this access point, then NetworkOrigin
	// is VPC, and the access point doesn't allow access from the public internet.
	// Otherwise, NetworkOrigin is Internet, and the access point allows access
	// from the public internet, subject to the access point and bucket access policies.
	//
	// NetworkOrigin is a required field
	NetworkOrigin *string `type:"string" required:"true" enum:"NetworkOrigin"`

	// The virtual private cloud (VPC) configuration for this access point, if one
	// exists.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s AccessPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessPoint) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *AccessPoint) SetBucket(v string) *AccessPoint {
	s.Bucket = &v
	return s
}

// SetName sets the Name field's value.
func (s *AccessPoint) SetName(v string) *AccessPoint {
	s.Name = &v
	return s
}

// SetNetworkOrigin sets the NetworkOrigin field's value.
func (s *AccessPoint) SetNetworkOrigin(v string) *AccessPoint {
	s.NetworkOrigin = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *AccessPoint) SetVpcConfiguration(v *VpcConfiguration) *AccessPoint {
	s.VpcConfiguration = v
	return s
}

type CreateAccessPointInput struct {
	_ struct{} `locationName:"CreateAccessPointRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The AWS account ID for the owner of the bucket for which you want to create
	// an access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the bucket that you want to associate this access point with.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The name you want to assign to this access point.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// The PublicAccessBlock configuration that you want to apply to this Amazon
	// S3 bucket. You can enable the configuration options in any combination. For
	// more information about when Amazon S3 considers a bucket or object public,
	// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon Simple Storage Service Developer Guide.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`

	// If you include this field, Amazon S3 restricts access to this access point
	// to requests from the specified virtual private cloud (VPC).
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessPointInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateAccessPointInput) SetAccountId(v string) *CreateAccessPointInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateAccessPointInput) SetBucket(v string) *CreateAccessPointInput {
	s.Bucket = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAccessPointInput) SetName(v string) *CreateAccessPointInput {
	s.Name = &v
	return s
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *CreateAccessPointInput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *CreateAccessPointInput {
	s.PublicAccessBlockConfiguration = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *CreateAccessPointInput) SetVpcConfiguration(v *VpcConfiguration) *CreateAccessPointInput {
	s.VpcConfiguration = v
	return s
}

func (s *CreateAccessPointInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type CreateAccessPointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccessPointOutput) GoString() string {
	return s.String()
}

type CreateJobInput struct {
	_ struct{} `locationName:"CreateJobRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// An idempotency token to ensure that you don't accidentally submit the same
	// request twice. You can use any string up to the maximum length.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Indicates whether confirmation is required before Amazon S3 runs the job.
	// Confirmation is only required for jobs created through the Amazon S3 console.
	ConfirmationRequired *bool `type:"boolean"`

	// A description for this job. You can use any string within the permitted length.
	// Descriptions don't need to be unique and can be used for multiple jobs.
	Description *string `min:"1" type:"string"`

	// Configuration parameters for the manifest.
	//
	// Manifest is a required field
	Manifest *JobManifest `type:"structure" required:"true"`

	// The operation that you want this job to perform on each object listed in
	// the manifest. For more information about the available operations, see Available
	// Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Operation is a required field
	Operation *JobOperation `type:"structure" required:"true"`

	// The numerical priority for this job. Higher numbers indicate higher priority.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`

	// Configuration parameters for the optional job-completion report.
	//
	// Report is a required field
	Report *JobReport `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) for the AWS Identity and Access Management
	// (IAM) role that Batch Operations will use to execute this job's operation
	// on each object in the manifest.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// A set of tags to associate with the Amazon S3 Batch Operations job. This
	// is an optional parameter.
	Tags []*S3Tag `type:"list"`
}

// String returns the string representation
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Manifest == nil {
		invalidParams.Add(request.NewErrParamRequired("Manifest"))
	}
	if s.Operation == nil {
		invalidParams.Add(request.NewErrParamRequired("Operation"))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Report == nil {
		invalidParams.Add(request.NewErrParamRequired("Report"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Manifest != nil {
		if err := s.Manifest.Validate(); err != nil {
			invalidParams.AddNested("Manifest", err.(request.ErrInvalidParams))
		}
	}
	if s.Operation != nil {
		if err := s.Operation.Validate(); err != nil {
			invalidParams.AddNested("Operation", err.(request.ErrInvalidParams))
		}
	}
	if s.Report != nil {
		if err := s.Report.Validate(); err != nil {
			invalidParams.AddNested("Report", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateJobInput) SetAccountId(v string) *CreateJobInput {
	s.AccountId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateJobInput) SetClientRequestToken(v string) *CreateJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetConfirmationRequired sets the ConfirmationRequired field's value.
func (s *CreateJobInput) SetConfirmationRequired(v bool) *CreateJobInput {
	s.ConfirmationRequired = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateJobInput) SetDescription(v string) *CreateJobInput {
	s.Description = &v
	return s
}

// SetManifest sets the Manifest field's value.
func (s *CreateJobInput) SetManifest(v *JobManifest) *CreateJobInput {
	s.Manifest = v
	return s
}

// SetOperation sets the Operation field's value.
func (s *CreateJobInput) SetOperation(v *JobOperation) *CreateJobInput {
	s.Operation = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *CreateJobInput) SetPriority(v int64) *CreateJobInput {
	s.Priority = &v
	return s
}

// SetReport sets the Report field's value.
func (s *CreateJobInput) SetReport(v *JobReport) *CreateJobInput {
	s.Report = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateJobInput) SetRoleArn(v string) *CreateJobInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateJobInput) SetTags(v []*S3Tag) *CreateJobInput {
	s.Tags = v
	return s
}

func (s *CreateJobInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// The ID for this job. Amazon S3 generates this ID automatically and returns
	// it after a successful Create Job request.
	JobId *string `min:"5" type:"string"`
}

// String returns the string representation
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *CreateJobOutput) SetJobId(v string) *CreateJobOutput {
	s.JobId = &v
	return s
}

type DeleteAccessPointInput struct {
	_ struct{} `locationName:"DeleteAccessPointRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point you want to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessPointInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccessPointInput) SetAccountId(v string) *DeleteAccessPointInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAccessPointInput) SetName(v string) *DeleteAccessPointInput {
	s.Name = &v
	return s
}

func (s *DeleteAccessPointInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteAccessPointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessPointOutput) GoString() string {
	return s.String()
}

type DeleteAccessPointPolicyInput struct {
	_ struct{} `locationName:"DeleteAccessPointPolicyRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose policy you want to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAccessPointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessPointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessPointPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccessPointPolicyInput) SetAccountId(v string) *DeleteAccessPointPolicyInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAccessPointPolicyInput) SetName(v string) *DeleteAccessPointPolicyInput {
	s.Name = &v
	return s
}

func (s *DeleteAccessPointPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteAccessPointPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccessPointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessPointPolicyOutput) GoString() string {
	return s.String()
}

type DeleteJobTaggingInput struct {
	_ struct{} `locationName:"DeleteJobTaggingRequest" type:"structure"`

	// The AWS account ID associated with the Amazon S3 Batch Operations job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the Amazon S3 Batch Operations job whose tags you want to delete.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJobTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteJobTaggingInput) SetAccountId(v string) *DeleteJobTaggingInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeleteJobTaggingInput) SetJobId(v string) *DeleteJobTaggingInput {
	s.JobId = &v
	return s
}

func (s *DeleteJobTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeleteJobTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteJobTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobTaggingOutput) GoString() string {
	return s.String()
}

type DeletePublicAccessBlockInput struct {
	_ struct{} `locationName:"DeletePublicAccessBlockRequest" type:"structure"`

	// The account ID for the Amazon Web Services account whose PublicAccessBlock
	// configuration you want to remove.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePublicAccessBlockInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeletePublicAccessBlockInput) SetAccountId(v string) *DeletePublicAccessBlockInput {
	s.AccountId = &v
	return s
}

func (s *DeletePublicAccessBlockInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DeletePublicAccessBlockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePublicAccessBlockOutput) GoString() string {
	return s.String()
}

type DescribeJobInput struct {
	_ struct{} `locationName:"DescribeJobRequest" type:"structure"`

	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the job whose information you want to retrieve.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeJobInput) SetAccountId(v string) *DescribeJobInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DescribeJobInput) SetJobId(v string) *DescribeJobInput {
	s.JobId = &v
	return s
}

func (s *DescribeJobInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type DescribeJobOutput struct {
	_ struct{} `type:"structure"`

	// Contains the configuration parameters and status for the job specified in
	// the Describe Job request.
	Job *JobDescriptor `type:"structure"`
}

// String returns the string representation
func (s DescribeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *DescribeJobOutput) SetJob(v *JobDescriptor) *DescribeJobOutput {
	s.Job = v
	return s
}

type GetAccessPointInput struct {
	_ struct{} `locationName:"GetAccessPointRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose configuration information you want to
	// retrieve.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointInput) SetAccountId(v string) *GetAccessPointInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointInput) SetName(v string) *GetAccessPointInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessPointOutput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket associated with the specified access point.
	Bucket *string `min:"3" type:"string"`

	// The date and time when the specified access point was created.
	CreationDate *time.Time `type:"timestamp"`

	// The name of the specified access point.
	Name *string `min:"3" type:"string"`

	// Indicates whether this access point allows access from the public internet.
	// If VpcConfiguration is specified for this access point, then NetworkOrigin
	// is VPC, and the access point doesn't allow access from the public internet.
	// Otherwise, NetworkOrigin is Internet, and the access point allows access
	// from the public internet, subject to the access point and bucket access policies.
	NetworkOrigin *string `type:"string" enum:"NetworkOrigin"`

	// The PublicAccessBlock configuration that you want to apply to this Amazon
	// S3 bucket. You can enable the configuration options in any combination. For
	// more information about when Amazon S3 considers a bucket or object public,
	// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon Simple Storage Service Developer Guide.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`

	// Contains the virtual private cloud (VPC) configuration for the specified
	// access point.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessPointOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *GetAccessPointOutput) SetBucket(v string) *GetAccessPointOutput {
	s.Bucket = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetAccessPointOutput) SetCreationDate(v time.Time) *GetAccessPointOutput {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointOutput) SetName(v string) *GetAccessPointOutput {
	s.Name = &v
	return s
}

// SetNetworkOrigin sets the NetworkOrigin field's value.
func (s *GetAccessPointOutput) SetNetworkOrigin(v string) *GetAccessPointOutput {
	s.NetworkOrigin = &v
	return s
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *GetAccessPointOutput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *GetAccessPointOutput {
	s.PublicAccessBlockConfiguration = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *GetAccessPointOutput) SetVpcConfiguration(v *VpcConfiguration) *GetAccessPointOutput {
	s.VpcConfiguration = v
	return s
}

type GetAccessPointPolicyInput struct {
	_ struct{} `locationName:"GetAccessPointPolicyRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose policy you want to retrieve.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccessPointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessPointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointPolicyInput) SetAccountId(v string) *GetAccessPointPolicyInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointPolicyInput) SetName(v string) *GetAccessPointPolicyInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessPointPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The access point policy associated with the specified access point.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s GetAccessPointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessPointPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetAccessPointPolicyOutput) SetPolicy(v string) *GetAccessPointPolicyOutput {
	s.Policy = &v
	return s
}

type GetAccessPointPolicyStatusInput struct {
	_ struct{} `locationName:"GetAccessPointPolicyStatusRequest" type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose policy status you want to retrieve.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccessPointPolicyStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessPointPolicyStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointPolicyStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPointPolicyStatusInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccessPointPolicyStatusInput) SetAccountId(v string) *GetAccessPointPolicyStatusInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAccessPointPolicyStatusInput) SetName(v string) *GetAccessPointPolicyStatusInput {
	s.Name = &v
	return s
}

func (s *GetAccessPointPolicyStatusInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetAccessPointPolicyStatusOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the current policy status of the specified access point.
	PolicyStatus *PolicyStatus `type:"structure"`
}

// String returns the string representation
func (s GetAccessPointPolicyStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessPointPolicyStatusOutput) GoString() string {
	return s.String()
}

// SetPolicyStatus sets the PolicyStatus field's value.
func (s *GetAccessPointPolicyStatusOutput) SetPolicyStatus(v *PolicyStatus) *GetAccessPointPolicyStatusOutput {
	s.PolicyStatus = v
	return s
}

type GetJobTaggingInput struct {
	_ struct{} `locationName:"GetJobTaggingRequest" type:"structure"`

	// The AWS account ID associated with the Amazon S3 Batch Operations job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the Amazon S3 Batch Operations job whose tags you want to retrieve.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetJobTaggingInput) SetAccountId(v string) *GetJobTaggingInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetJobTaggingInput) SetJobId(v string) *GetJobTaggingInput {
	s.JobId = &v
	return s
}

func (s *GetJobTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetJobTaggingOutput struct {
	_ struct{} `type:"structure"`

	// The set of tags associated with the Amazon S3 Batch Operations job.
	Tags []*S3Tag `type:"list"`
}

// String returns the string representation
func (s GetJobTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobTaggingOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *GetJobTaggingOutput) SetTags(v []*S3Tag) *GetJobTaggingOutput {
	s.Tags = v
	return s
}

type GetPublicAccessBlockInput struct {
	_ struct{} `locationName:"GetPublicAccessBlockRequest" type:"structure"`

	// The account ID for the Amazon Web Services account whose PublicAccessBlock
	// configuration you want to retrieve.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicAccessBlockInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetPublicAccessBlockInput) SetAccountId(v string) *GetPublicAccessBlockInput {
	s.AccountId = &v
	return s
}

func (s *GetPublicAccessBlockInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type GetPublicAccessBlockOutput struct {
	_ struct{} `type:"structure" payload:"PublicAccessBlockConfiguration"`

	// The PublicAccessBlock configuration currently in effect for this Amazon Web
	// Services account.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetPublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicAccessBlockOutput) GoString() string {
	return s.String()
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *GetPublicAccessBlockOutput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *GetPublicAccessBlockOutput {
	s.PublicAccessBlockConfiguration = v
	return s
}

// A container element for the job configuration and status information returned
// by a Describe Job request.
type JobDescriptor struct {
	_ struct{} `type:"structure"`

	// Indicates whether confirmation is required before Amazon S3 begins running
	// the specified job. Confirmation is required only for jobs created through
	// the Amazon S3 console.
	ConfirmationRequired *bool `type:"boolean"`

	// A timestamp indicating when this job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description for this job, if one was provided in this job's Create Job
	// request.
	Description *string `min:"1" type:"string"`

	// If the specified job failed, this field contains information describing the
	// failure.
	FailureReasons []*JobFailure `type:"list"`

	// The Amazon Resource Name (ARN) for this job.
	JobArn *string `min:"1" type:"string"`

	// The ID for the specified job.
	JobId *string `min:"5" type:"string"`

	// The configuration information for the specified job's manifest object.
	Manifest *JobManifest `type:"structure"`

	// The operation that the specified job is configured to execute on the objects
	// listed in the manifest.
	Operation *JobOperation `type:"structure"`

	// The priority of the specified job.
	Priority *int64 `type:"integer"`

	// Describes the total number of tasks that the specified job has executed,
	// the number of tasks that succeeded, and the number of tasks that failed.
	ProgressSummary *JobProgressSummary `type:"structure"`

	// Contains the configuration information for the job-completion report if you
	// requested one in the Create Job request.
	Report *JobReport `type:"structure"`

	// The Amazon Resource Name (ARN) for the AWS Identity and Access Management
	// (IAM) role assigned to execute the tasks for this job.
	RoleArn *string `min:"1" type:"string"`

	// The current status of the specified job.
	Status *string `type:"string" enum:"JobStatus"`

	StatusUpdateReason *string `min:"1" type:"string"`

	// The reason why the specified job was suspended. A job is only suspended if
	// you create it through the Amazon S3 console. When you create the job, it
	// enters the Suspended state to await confirmation before running. After you
	// confirm the job, it automatically exits the Suspended state.
	SuspendedCause *string `min:"1" type:"string"`

	// The timestamp when this job was suspended, if it has been suspended.
	SuspendedDate *time.Time `type:"timestamp"`

	// A timestamp indicating when this job terminated. A job's termination date
	// is the date and time when it succeeded, failed, or was canceled.
	TerminationDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s JobDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobDescriptor) GoString() string {
	return s.String()
}

// SetConfirmationRequired sets the ConfirmationRequired field's value.
func (s *JobDescriptor) SetConfirmationRequired(v bool) *JobDescriptor {
	s.ConfirmationRequired = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *JobDescriptor) SetCreationTime(v time.Time) *JobDescriptor {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *JobDescriptor) SetDescription(v string) *JobDescriptor {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *JobDescriptor) SetFailureReasons(v []*JobFailure) *JobDescriptor {
	s.FailureReasons = v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *JobDescriptor) SetJobArn(v string) *JobDescriptor {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobDescriptor) SetJobId(v string) *JobDescriptor {
	s.JobId = &v
	return s
}

// SetManifest sets the Manifest field's value.
func (s *JobDescriptor) SetManifest(v *JobManifest) *JobDescriptor {
	s.Manifest = v
	return s
}

// SetOperation sets the Operation field's value.
func (s *JobDescriptor) SetOperation(v *JobOperation) *JobDescriptor {
	s.Operation = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *JobDescriptor) SetPriority(v int64) *JobDescriptor {
	s.Priority = &v
	return s
}

// SetProgressSummary sets the ProgressSummary field's value.
func (s *JobDescriptor) SetProgressSummary(v *JobProgressSummary) *JobDescriptor {
	s.ProgressSummary = v
	return s
}

// SetReport sets the Report field's value.
func (s *JobDescriptor) SetReport(v *JobReport) *JobDescriptor {
	s.Report = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *JobDescriptor) SetRoleArn(v string) *JobDescriptor {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobDescriptor) SetStatus(v string) *JobDescriptor {
	s.Status = &v
	return s
}

// SetStatusUpdateReason sets the StatusUpdateReason field's value.
func (s *JobDescriptor) SetStatusUpdateReason(v string) *JobDescriptor {
	s.StatusUpdateReason = &v
	return s
}

// SetSuspendedCause sets the SuspendedCause field's value.
func (s *JobDescriptor) SetSuspendedCause(v string) *JobDescriptor {
	s.SuspendedCause = &v
	return s
}

// SetSuspendedDate sets the SuspendedDate field's value.
func (s *JobDescriptor) SetSuspendedDate(v time.Time) *JobDescriptor {
	s.SuspendedDate = &v
	return s
}

// SetTerminationDate sets the TerminationDate field's value.
func (s *JobDescriptor) SetTerminationDate(v time.Time) *JobDescriptor {
	s.TerminationDate = &v
	return s
}

// If this job failed, this element indicates why the job failed.
type JobFailure struct {
	_ struct{} `type:"structure"`

	// The failure code, if any, for the specified job.
	FailureCode *string `min:"1" type:"string"`

	// The failure reason, if any, for the specified job.
	FailureReason *string `min:"1" type:"string"`
}

// String returns the string representation
func (s JobFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFailure) GoString() string {
	return s.String()
}

// SetFailureCode sets the FailureCode field's value.
func (s *JobFailure) SetFailureCode(v string) *JobFailure {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *JobFailure) SetFailureReason(v string) *JobFailure {
	s.FailureReason = &v
	return s
}

// Contains the configuration and status information for a single job retrieved
// as part of a job list.
type JobListDescriptor struct {
	_ struct{} `type:"structure"`

	// A timestamp indicating when the specified job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The user-specified description that was included in the specified job's Create
	// Job request.
	Description *string `min:"1" type:"string"`

	// The ID for the specified job.
	JobId *string `min:"5" type:"string"`

	// The operation that the specified job is configured to run on each object
	// listed in the manifest.
	Operation *string `type:"string" enum:"OperationName"`

	// The current priority for the specified job.
	Priority *int64 `type:"integer"`

	// Describes the total number of tasks that the specified job has executed,
	// the number of tasks that succeeded, and the number of tasks that failed.
	ProgressSummary *JobProgressSummary `type:"structure"`

	// The specified job's current status.
	Status *string `type:"string" enum:"JobStatus"`

	// A timestamp indicating when the specified job terminated. A job's termination
	// date is the date and time when it succeeded, failed, or was canceled.
	TerminationDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s JobListDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobListDescriptor) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *JobListDescriptor) SetCreationTime(v time.Time) *JobListDescriptor {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *JobListDescriptor) SetDescription(v string) *JobListDescriptor {
	s.Description = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobListDescriptor) SetJobId(v string) *JobListDescriptor {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *JobListDescriptor) SetOperation(v string) *JobListDescriptor {
	s.Operation = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *JobListDescriptor) SetPriority(v int64) *JobListDescriptor {
	s.Priority = &v
	return s
}

// SetProgressSummary sets the ProgressSummary field's value.
func (s *JobListDescriptor) SetProgressSummary(v *JobProgressSummary) *JobListDescriptor {
	s.ProgressSummary = v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobListDescriptor) SetStatus(v string) *JobListDescriptor {
	s.Status = &v
	return s
}

// SetTerminationDate sets the TerminationDate field's value.
func (s *JobListDescriptor) SetTerminationDate(v time.Time) *JobListDescriptor {
	s.TerminationDate = &v
	return s
}

// Contains the configuration information for a job's manifest.
type JobManifest struct {
	_ struct{} `type:"structure"`

	// Contains the information required to locate the specified job's manifest.
	//
	// Location is a required field
	Location *JobManifestLocation `type:"structure" required:"true"`

	// Describes the format of the specified job's manifest. If the manifest is
	// in CSV format, also describes the columns contained within the manifest.
	//
	// Spec is a required field
	Spec *JobManifestSpec `type:"structure" required:"true"`
}

// String returns the string representation
func (s JobManifest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobManifest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobManifest"}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(request.ErrInvalidParams))
		}
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocation sets the Location field's value.
func (s *JobManifest) SetLocation(v *JobManifestLocation) *JobManifest {
	s.Location = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *JobManifest) SetSpec(v *JobManifestSpec) *JobManifest {
	s.Spec = v
	return s
}

// Contains the information required to locate a manifest object.
type JobManifestLocation struct {
	_ struct{} `type:"structure"`

	// The ETag for the specified manifest object.
	//
	// ETag is a required field
	ETag *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for a manifest object.
	//
	// ObjectArn is a required field
	ObjectArn *string `min:"1" type:"string" required:"true"`

	// The optional version ID to identify a specific version of the manifest object.
	ObjectVersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s JobManifestLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobManifestLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifestLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobManifestLocation"}
	if s.ETag == nil {
		invalidParams.Add(request.NewErrParamRequired("ETag"))
	}
	if s.ETag != nil && len(*s.ETag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ETag", 1))
	}
	if s.ObjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectArn"))
	}
	if s.ObjectArn != nil && len(*s.ObjectArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectArn", 1))
	}
	if s.ObjectVersionId != nil && len(*s.ObjectVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetETag sets the ETag field's value.
func (s *JobManifestLocation) SetETag(v string) *JobManifestLocation {
	s.ETag = &v
	return s
}

// SetObjectArn sets the ObjectArn field's value.
func (s *JobManifestLocation) SetObjectArn(v string) *JobManifestLocation {
	s.ObjectArn = &v
	return s
}

// SetObjectVersionId sets the ObjectVersionId field's value.
func (s *JobManifestLocation) SetObjectVersionId(v string) *JobManifestLocation {
	s.ObjectVersionId = &v
	return s
}

// Describes the format of a manifest. If the manifest is in CSV format, also
// describes the columns contained within the manifest.
type JobManifestSpec struct {
	_ struct{} `type:"structure"`

	// If the specified manifest object is in the S3BatchOperations_CSV_20180820
	// format, this element describes which columns contain the required data.
	Fields []*string `type:"list"`

	// Indicates which of the available formats the specified manifest uses.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"JobManifestFormat"`
}

// String returns the string representation
func (s JobManifestSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobManifestSpec) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobManifestSpec) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobManifestSpec"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFields sets the Fields field's value.
func (s *JobManifestSpec) SetFields(v []*string) *JobManifestSpec {
	s.Fields = v
	return s
}

// SetFormat sets the Format field's value.
func (s *JobManifestSpec) SetFormat(v string) *JobManifestSpec {
	s.Format = &v
	return s
}

// The operation that you want this job to perform on each object listed in
// the manifest. For more information about the available operations, see Available
// Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html)
// in the Amazon Simple Storage Service Developer Guide.
type JobOperation struct {
	_ struct{} `type:"structure"`

	// Directs the specified job to invoke an AWS Lambda function on each object
	// in the manifest.
	LambdaInvoke *LambdaInvokeOperation `type:"structure"`

	// Directs the specified job to execute an Initiate Glacier Restore call on
	// each object in the manifest.
	S3InitiateRestoreObject *S3InitiateRestoreObjectOperation `type:"structure"`

	// Directs the specified job to execute a PUT Object acl call on each object
	// in the manifest.
	S3PutObjectAcl *S3SetObjectAclOperation `type:"structure"`

	// Directs the specified job to execute a PUT Copy object call on each object
	// in the manifest.
	S3PutObjectCopy *S3CopyObjectOperation `type:"structure"`

	// Contains the configuration parameters for a Set Object Legal Hold operation.
	// Amazon S3 Batch Operations passes each value through to the underlying PUT
	// Object Legal Hold API. For more information about the parameters for this
	// operation, see PUT Object Legal Hold (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.htmll#object-lock-legal-holds).
	S3PutObjectLegalHold *S3SetObjectLegalHoldOperation `type:"structure"`

	// Contains the configuration parameters for a Set Object Retention operation.
	// Amazon S3 Batch Operations passes each value through to the underlying PUT
	// Object Retention API. For more information about the parameters for this
	// operation, see PUT Object Retention (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes).
	S3PutObjectRetention *S3SetObjectRetentionOperation `type:"structure"`

	// Directs the specified job to execute a PUT Object tagging call on each object
	// in the manifest.
	S3PutObjectTagging *S3SetObjectTaggingOperation `type:"structure"`
}

// String returns the string representation
func (s JobOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobOperation"}
	if s.LambdaInvoke != nil {
		if err := s.LambdaInvoke.Validate(); err != nil {
			invalidParams.AddNested("LambdaInvoke", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectAcl != nil {
		if err := s.S3PutObjectAcl.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectAcl", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectCopy != nil {
		if err := s.S3PutObjectCopy.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectCopy", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectLegalHold != nil {
		if err := s.S3PutObjectLegalHold.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectLegalHold", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectRetention != nil {
		if err := s.S3PutObjectRetention.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectRetention", err.(request.ErrInvalidParams))
		}
	}
	if s.S3PutObjectTagging != nil {
		if err := s.S3PutObjectTagging.Validate(); err != nil {
			invalidParams.AddNested("S3PutObjectTagging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaInvoke sets the LambdaInvoke field's value.
func (s *JobOperation) SetLambdaInvoke(v *LambdaInvokeOperation) *JobOperation {
	s.LambdaInvoke = v
	return s
}

// SetS3InitiateRestoreObject sets the S3InitiateRestoreObject field's value.
func (s *JobOperation) SetS3InitiateRestoreObject(v *S3InitiateRestoreObjectOperation) *JobOperation {
	s.S3InitiateRestoreObject = v
	return s
}

// SetS3PutObjectAcl sets the S3PutObjectAcl field's value.
func (s *JobOperation) SetS3PutObjectAcl(v *S3SetObjectAclOperation) *JobOperation {
	s.S3PutObjectAcl = v
	return s
}

// SetS3PutObjectCopy sets the S3PutObjectCopy field's value.
func (s *JobOperation) SetS3PutObjectCopy(v *S3CopyObjectOperation) *JobOperation {
	s.S3PutObjectCopy = v
	return s
}

// SetS3PutObjectLegalHold sets the S3PutObjectLegalHold field's value.
func (s *JobOperation) SetS3PutObjectLegalHold(v *S3SetObjectLegalHoldOperation) *JobOperation {
	s.S3PutObjectLegalHold = v
	return s
}

// SetS3PutObjectRetention sets the S3PutObjectRetention field's value.
func (s *JobOperation) SetS3PutObjectRetention(v *S3SetObjectRetentionOperation) *JobOperation {
	s.S3PutObjectRetention = v
	return s
}

// SetS3PutObjectTagging sets the S3PutObjectTagging field's value.
func (s *JobOperation) SetS3PutObjectTagging(v *S3SetObjectTaggingOperation) *JobOperation {
	s.S3PutObjectTagging = v
	return s
}

// Describes the total number of tasks that the specified job has executed,
// the number of tasks that succeeded, and the number of tasks that failed.
type JobProgressSummary struct {
	_ struct{} `type:"structure"`

	NumberOfTasksFailed *int64 `type:"long"`

	NumberOfTasksSucceeded *int64 `type:"long"`

	TotalNumberOfTasks *int64 `type:"long"`
}

// String returns the string representation
func (s JobProgressSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobProgressSummary) GoString() string {
	return s.String()
}

// SetNumberOfTasksFailed sets the NumberOfTasksFailed field's value.
func (s *JobProgressSummary) SetNumberOfTasksFailed(v int64) *JobProgressSummary {
	s.NumberOfTasksFailed = &v
	return s
}

// SetNumberOfTasksSucceeded sets the NumberOfTasksSucceeded field's value.
func (s *JobProgressSummary) SetNumberOfTasksSucceeded(v int64) *JobProgressSummary {
	s.NumberOfTasksSucceeded = &v
	return s
}

// SetTotalNumberOfTasks sets the TotalNumberOfTasks field's value.
func (s *JobProgressSummary) SetTotalNumberOfTasks(v int64) *JobProgressSummary {
	s.TotalNumberOfTasks = &v
	return s
}

// Contains the configuration parameters for a job-completion report.
type JobReport struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the bucket where specified job-completion
	// report will be stored.
	Bucket *string `min:"1" type:"string"`

	// Indicates whether the specified job will generate a job-completion report.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The format of the specified job-completion report.
	Format *string `type:"string" enum:"JobReportFormat"`

	// An optional prefix to describe where in the specified bucket the job-completion
	// report will be stored. Amazon S3 will store the job-completion report at
	// <prefix>/job-<job-id>/report.json.
	Prefix *string `min:"1" type:"string"`

	// Indicates whether the job-completion report will include details of all tasks
	// or only failed tasks.
	ReportScope *string `type:"string" enum:"JobReportScope"`
}

// String returns the string representation
func (s JobReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobReport) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobReport) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobReport"}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Prefix != nil && len(*s.Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *JobReport) SetBucket(v string) *JobReport {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *JobReport) SetEnabled(v bool) *JobReport {
	s.Enabled = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *JobReport) SetFormat(v string) *JobReport {
	s.Format = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *JobReport) SetPrefix(v string) *JobReport {
	s.Prefix = &v
	return s
}

// SetReportScope sets the ReportScope field's value.
func (s *JobReport) SetReportScope(v string) *JobReport {
	s.ReportScope = &v
	return s
}

// Contains the configuration parameters for a Lambda Invoke operation.
type LambdaInvokeOperation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the AWS Lambda function that the specified
	// job will invoke for each object in the manifest.
	FunctionArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LambdaInvokeOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaInvokeOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaInvokeOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaInvokeOperation"}
	if s.FunctionArn != nil && len(*s.FunctionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *LambdaInvokeOperation) SetFunctionArn(v string) *LambdaInvokeOperation {
	s.FunctionArn = &v
	return s
}

type ListAccessPointsInput struct {
	_ struct{} `locationName:"ListAccessPointsRequest" type:"structure"`

	// The AWS account ID for owner of the bucket whose access points you want to
	// list.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the bucket whose associated access points you want to list.
	Bucket *string `location:"querystring" locationName:"bucket" min:"3" type:"string"`

	// The maximum number of access points that you want to include in the list.
	// If the specified bucket has more than this number of access points, then
	// the response will include a continuation token in the NextToken field that
	// you can use to retrieve the next page of access points.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A continuation token. If a previous call to ListAccessPoints returned a continuation
	// token in the NextToken field, then providing that value here causes Amazon
	// S3 to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccessPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessPointsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListAccessPointsInput) SetAccountId(v string) *ListAccessPointsInput {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *ListAccessPointsInput) SetBucket(v string) *ListAccessPointsInput {
	s.Bucket = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessPointsInput) SetMaxResults(v int64) *ListAccessPointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPointsInput) SetNextToken(v string) *ListAccessPointsInput {
	s.NextToken = &v
	return s
}

func (s *ListAccessPointsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type ListAccessPointsOutput struct {
	_ struct{} `type:"structure"`

	// Contains identification and configuration information for one or more access
	// points associated with the specified bucket.
	AccessPointList []*AccessPoint `locationNameList:"AccessPoint" type:"list"`

	// If the specified bucket has more access points than can be returned in one
	// call to this API, then this field contains a continuation token that you
	// can provide in subsequent calls to this API to retrieve additional access
	// points.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccessPointsOutput) GoString() string {
	return s.String()
}

// SetAccessPointList sets the AccessPointList field's value.
func (s *ListAccessPointsOutput) SetAccessPointList(v []*AccessPoint) *ListAccessPointsOutput {
	s.AccessPointList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPointsOutput) SetNextToken(v string) *ListAccessPointsOutput {
	s.NextToken = &v
	return s
}

type ListJobsInput struct {
	_ struct{} `locationName:"ListJobsRequest" type:"structure"`

	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The List Jobs request returns jobs that match the statuses listed in this
	// element.
	JobStatuses []*string `location:"querystring" locationName:"jobStatuses" type:"list"`

	// The maximum number of jobs that Amazon S3 will include in the List Jobs response.
	// If there are more jobs than this number, the response will include a pagination
	// token in the NextToken field to enable you to retrieve the next page of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A pagination token to request the next page of results. Use the token that
	// Amazon S3 returned in the NextToken element of the ListJobsResult from the
	// previous List Jobs request.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListJobsInput) SetAccountId(v string) *ListJobsInput {
	s.AccountId = &v
	return s
}

// SetJobStatuses sets the JobStatuses field's value.
func (s *ListJobsInput) SetJobStatuses(v []*string) *ListJobsInput {
	s.JobStatuses = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobsInput) SetMaxResults(v int64) *ListJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

func (s *ListJobsInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// The list of current jobs and jobs that have ended within the last 30 days.
	Jobs []*JobListDescriptor `type:"list"`

	// If the List Jobs request produced more than the maximum number of results,
	// you can pass this value into a subsequent List Jobs request in order to retrieve
	// the next page of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListJobsOutput) SetJobs(v []*JobListDescriptor) *ListJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

// Indicates whether this access point policy is public. For more information
// about how Amazon S3 evaluates policies to determine whether they are public,
// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
// in the Amazon Simple Storage Service Developer Guide.
type PolicyStatus struct {
	_ struct{} `type:"structure"`

	IsPublic *bool `locationName:"IsPublic" type:"boolean"`
}

// String returns the string representation
func (s PolicyStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyStatus) GoString() string {
	return s.String()
}

// SetIsPublic sets the IsPublic field's value.
func (s *PolicyStatus) SetIsPublic(v bool) *PolicyStatus {
	s.IsPublic = &v
	return s
}

// The PublicAccessBlock configuration that you want to apply to this Amazon
// S3 bucket. You can enable the configuration options in any combination. For
// more information about when Amazon S3 considers a bucket or object public,
// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
// in the Amazon Simple Storage Service Developer Guide.
type PublicAccessBlockConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 should block public access control lists (ACLs)
	// for buckets in this account. Setting this element to TRUE causes the following
	// behavior:
	//
	//    * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is
	//    public.
	//
	//    * PUT Object calls fail if the request includes a public ACL.
	//
	//    * PUT Bucket calls fail if the request includes a public ACL.
	//
	// Enabling this setting doesn't affect existing policies or ACLs.
	BlockPublicAcls *bool `locationName:"BlockPublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should block public bucket policies for buckets
	// in this account. Setting this element to TRUE causes Amazon S3 to reject
	// calls to PUT Bucket policy if the specified bucket policy allows public access.
	//
	// Enabling this setting doesn't affect existing bucket policies.
	BlockPublicPolicy *bool `locationName:"BlockPublicPolicy" type:"boolean"`

	// Specifies whether Amazon S3 should ignore public ACLs for buckets in this
	// account. Setting this element to TRUE causes Amazon S3 to ignore all public
	// ACLs on buckets in this account and any objects that they contain.
	//
	// Enabling this setting doesn't affect the persistence of any existing ACLs
	// and doesn't prevent new public ACLs from being set.
	IgnorePublicAcls *bool `locationName:"IgnorePublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should restrict public bucket policies for buckets
	// in this account. Setting this element to TRUE restricts access to buckets
	// with public policies to only AWS services and authorized users within this
	// account.
	//
	// Enabling this setting doesn't affect previously stored bucket policies, except
	// that public and cross-account access within any public bucket policy, including
	// non-public delegation to specific accounts, is blocked.
	RestrictPublicBuckets *bool `locationName:"RestrictPublicBuckets" type:"boolean"`
}

// String returns the string representation
func (s PublicAccessBlockConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicAccessBlockConfiguration) GoString() string {
	return s.String()
}

// SetBlockPublicAcls sets the BlockPublicAcls field's value.
func (s *PublicAccessBlockConfiguration) SetBlockPublicAcls(v bool) *PublicAccessBlockConfiguration {
	s.BlockPublicAcls = &v
	return s
}

// SetBlockPublicPolicy sets the BlockPublicPolicy field's value.
func (s *PublicAccessBlockConfiguration) SetBlockPublicPolicy(v bool) *PublicAccessBlockConfiguration {
	s.BlockPublicPolicy = &v
	return s
}

// SetIgnorePublicAcls sets the IgnorePublicAcls field's value.
func (s *PublicAccessBlockConfiguration) SetIgnorePublicAcls(v bool) *PublicAccessBlockConfiguration {
	s.IgnorePublicAcls = &v
	return s
}

// SetRestrictPublicBuckets sets the RestrictPublicBuckets field's value.
func (s *PublicAccessBlockConfiguration) SetRestrictPublicBuckets(v bool) *PublicAccessBlockConfiguration {
	s.RestrictPublicBuckets = &v
	return s
}

type PutAccessPointPolicyInput struct {
	_ struct{} `locationName:"PutAccessPointPolicyRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The AWS account ID for owner of the bucket associated with the specified
	// access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point that you want to associate with the specified
	// policy.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`

	// The policy that you want to apply to the specified access point. For more
	// information about access point policies, see Managing Data Access with Amazon
	// S3 Access Points (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutAccessPointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccessPointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccessPointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAccessPointPolicyInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutAccessPointPolicyInput) SetAccountId(v string) *PutAccessPointPolicyInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutAccessPointPolicyInput) SetName(v string) *PutAccessPointPolicyInput {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutAccessPointPolicyInput) SetPolicy(v string) *PutAccessPointPolicyInput {
	s.Policy = &v
	return s
}

func (s *PutAccessPointPolicyInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type PutAccessPointPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAccessPointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccessPointPolicyOutput) GoString() string {
	return s.String()
}

type PutJobTaggingInput struct {
	_ struct{} `locationName:"PutJobTaggingRequest" type:"structure" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`

	// The AWS account ID associated with the Amazon S3 Batch Operations job.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the Amazon S3 Batch Operations job whose tags you want to replace.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`

	// The set of tags to associate with the Amazon S3 Batch Operations job.
	//
	// Tags is a required field
	Tags []*S3Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s PutJobTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutJobTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutJobTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutJobTaggingInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutJobTaggingInput) SetAccountId(v string) *PutJobTaggingInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PutJobTaggingInput) SetJobId(v string) *PutJobTaggingInput {
	s.JobId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutJobTaggingInput) SetTags(v []*S3Tag) *PutJobTaggingInput {
	s.Tags = v
	return s
}

func (s *PutJobTaggingInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type PutJobTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutJobTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutJobTaggingOutput) GoString() string {
	return s.String()
}

type PutPublicAccessBlockInput struct {
	_ struct{} `locationName:"PutPublicAccessBlockRequest" type:"structure" payload:"PublicAccessBlockConfiguration"`

	// The account ID for the Amazon Web Services account whose PublicAccessBlock
	// configuration you want to set.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The PublicAccessBlock configuration that you want to apply to the specified
	// Amazon Web Services account.
	//
	// PublicAccessBlockConfiguration is a required field
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `locationName:"PublicAccessBlockConfiguration" type:"structure" required:"true" xmlURI:"http://awss3control.amazonaws.com/doc/2018-08-20/"`
}

// String returns the string representation
func (s PutPublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPublicAccessBlockInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.PublicAccessBlockConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicAccessBlockConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutPublicAccessBlockInput) SetAccountId(v string) *PutPublicAccessBlockInput {
	s.AccountId = &v
	return s
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *PutPublicAccessBlockInput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *PutPublicAccessBlockInput {
	s.PublicAccessBlockConfiguration = v
	return s
}

func (s *PutPublicAccessBlockInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type PutPublicAccessBlockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutPublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPublicAccessBlockOutput) GoString() string {
	return s.String()
}

type S3AccessControlList struct {
	_ struct{} `type:"structure"`

	Grants []*S3Grant `type:"list"`

	// Owner is a required field
	Owner *S3ObjectOwner `type:"structure" required:"true"`
}

// String returns the string representation
func (s S3AccessControlList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3AccessControlList) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3AccessControlList) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3AccessControlList"}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}
	if s.Grants != nil {
		for i, v := range s.Grants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Grants", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Owner != nil {
		if err := s.Owner.Validate(); err != nil {
			invalidParams.AddNested("Owner", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrants sets the Grants field's value.
func (s *S3AccessControlList) SetGrants(v []*S3Grant) *S3AccessControlList {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *S3AccessControlList) SetOwner(v *S3ObjectOwner) *S3AccessControlList {
	s.Owner = v
	return s
}

type S3AccessControlPolicy struct {
	_ struct{} `type:"structure"`

	AccessControlList *S3AccessControlList `type:"structure"`

	CannedAccessControlList *string `type:"string" enum:"S3CannedAccessControlList"`
}

// String returns the string representation
func (s S3AccessControlPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3AccessControlPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3AccessControlPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3AccessControlPolicy"}
	if s.AccessControlList != nil {
		if err := s.AccessControlList.Validate(); err != nil {
			invalidParams.AddNested("AccessControlList", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlList sets the AccessControlList field's value.
func (s *S3AccessControlPolicy) SetAccessControlList(v *S3AccessControlList) *S3AccessControlPolicy {
	s.AccessControlList = v
	return s
}

// SetCannedAccessControlList sets the CannedAccessControlList field's value.
func (s *S3AccessControlPolicy) SetCannedAccessControlList(v string) *S3AccessControlPolicy {
	s.CannedAccessControlList = &v
	return s
}

// Contains the configuration parameters for a PUT Copy object operation. Amazon
// S3 Batch Operations passes each value through to the underlying PUT Copy
// object API. For more information about the parameters for this operation,
// see PUT Object - Copy (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectCOPY.html).
type S3CopyObjectOperation struct {
	_ struct{} `type:"structure"`

	AccessControlGrants []*S3Grant `type:"list"`

	CannedAccessControlList *string `type:"string" enum:"S3CannedAccessControlList"`

	MetadataDirective *string `type:"string" enum:"S3MetadataDirective"`

	ModifiedSinceConstraint *time.Time `type:"timestamp"`

	NewObjectMetadata *S3ObjectMetadata `type:"structure"`

	NewObjectTagging []*S3Tag `type:"list"`

	// The Legal Hold status to be applied to all objects in the Batch Operations
	// job.
	ObjectLockLegalHoldStatus *string `type:"string" enum:"S3ObjectLockLegalHoldStatus"`

	// The Retention mode to be applied to all objects in the Batch Operations job.
	ObjectLockMode *string `type:"string" enum:"S3ObjectLockMode"`

	// The date when the applied Object Retention configuration will expire on all
	// objects in the Batch Operations job.
	ObjectLockRetainUntilDate *time.Time `type:"timestamp"`

	RedirectLocation *string `min:"1" type:"string"`

	RequesterPays *bool `type:"boolean"`

	SSEAwsKmsKeyId *string `min:"1" type:"string"`

	StorageClass *string `type:"string" enum:"S3StorageClass"`

	TargetKeyPrefix *string `min:"1" type:"string"`

	TargetResource *string `min:"1" type:"string"`

	UnModifiedSinceConstraint *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s S3CopyObjectOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3CopyObjectOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3CopyObjectOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3CopyObjectOperation"}
	if s.RedirectLocation != nil && len(*s.RedirectLocation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RedirectLocation", 1))
	}
	if s.SSEAwsKmsKeyId != nil && len(*s.SSEAwsKmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SSEAwsKmsKeyId", 1))
	}
	if s.TargetKeyPrefix != nil && len(*s.TargetKeyPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetKeyPrefix", 1))
	}
	if s.TargetResource != nil && len(*s.TargetResource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetResource", 1))
	}
	if s.AccessControlGrants != nil {
		for i, v := range s.AccessControlGrants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlGrants", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.NewObjectMetadata != nil {
		if err := s.NewObjectMetadata.Validate(); err != nil {
			invalidParams.AddNested("NewObjectMetadata", err.(request.ErrInvalidParams))
		}
	}
	if s.NewObjectTagging != nil {
		for i, v := range s.NewObjectTagging {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NewObjectTagging", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlGrants sets the AccessControlGrants field's value.
func (s *S3CopyObjectOperation) SetAccessControlGrants(v []*S3Grant) *S3CopyObjectOperation {
	s.AccessControlGrants = v
	return s
}

// SetCannedAccessControlList sets the CannedAccessControlList field's value.
func (s *S3CopyObjectOperation) SetCannedAccessControlList(v string) *S3CopyObjectOperation {
	s.CannedAccessControlList = &v
	return s
}

// SetMetadataDirective sets the MetadataDirective field's value.
func (s *S3CopyObjectOperation) SetMetadataDirective(v string) *S3CopyObjectOperation {
	s.MetadataDirective = &v
	return s
}

// SetModifiedSinceConstraint sets the ModifiedSinceConstraint field's value.
func (s *S3CopyObjectOperation) SetModifiedSinceConstraint(v time.Time) *S3CopyObjectOperation {
	s.ModifiedSinceConstraint = &v
	return s
}

// SetNewObjectMetadata sets the NewObjectMetadata field's value.
func (s *S3CopyObjectOperation) SetNewObjectMetadata(v *S3ObjectMetadata) *S3CopyObjectOperation {
	s.NewObjectMetadata = v
	return s
}

// SetNewObjectTagging sets the NewObjectTagging field's value.
func (s *S3CopyObjectOperation) SetNewObjectTagging(v []*S3Tag) *S3CopyObjectOperation {
	s.NewObjectTagging = v
	return s
}

// SetObjectLockLegalHoldStatus sets the ObjectLockLegalHoldStatus field's value.
func (s *S3CopyObjectOperation) SetObjectLockLegalHoldStatus(v string) *S3CopyObjectOperation {
	s.ObjectLockLegalHoldStatus = &v
	return s
}

// SetObjectLockMode sets the ObjectLockMode field's value.
func (s *S3CopyObjectOperation) SetObjectLockMode(v string) *S3CopyObjectOperation {
	s.ObjectLockMode = &v
	return s
}

// SetObjectLockRetainUntilDate sets the ObjectLockRetainUntilDate field's value.
func (s *S3CopyObjectOperation) SetObjectLockRetainUntilDate(v time.Time) *S3CopyObjectOperation {
	s.ObjectLockRetainUntilDate = &v
	return s
}

// SetRedirectLocation sets the RedirectLocation field's value.
func (s *S3CopyObjectOperation) SetRedirectLocation(v string) *S3CopyObjectOperation {
	s.RedirectLocation = &v
	return s
}

// SetRequesterPays sets the RequesterPays field's value.
func (s *S3CopyObjectOperation) SetRequesterPays(v bool) *S3CopyObjectOperation {
	s.RequesterPays = &v
	return s
}

// SetSSEAwsKmsKeyId sets the SSEAwsKmsKeyId field's value.
func (s *S3CopyObjectOperation) SetSSEAwsKmsKeyId(v string) *S3CopyObjectOperation {
	s.SSEAwsKmsKeyId = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *S3CopyObjectOperation) SetStorageClass(v string) *S3CopyObjectOperation {
	s.StorageClass = &v
	return s
}

// SetTargetKeyPrefix sets the TargetKeyPrefix field's value.
func (s *S3CopyObjectOperation) SetTargetKeyPrefix(v string) *S3CopyObjectOperation {
	s.TargetKeyPrefix = &v
	return s
}

// SetTargetResource sets the TargetResource field's value.
func (s *S3CopyObjectOperation) SetTargetResource(v string) *S3CopyObjectOperation {
	s.TargetResource = &v
	return s
}

// SetUnModifiedSinceConstraint sets the UnModifiedSinceConstraint field's value.
func (s *S3CopyObjectOperation) SetUnModifiedSinceConstraint(v time.Time) *S3CopyObjectOperation {
	s.UnModifiedSinceConstraint = &v
	return s
}

type S3Grant struct {
	_ struct{} `type:"structure"`

	Grantee *S3Grantee `type:"structure"`

	Permission *string `type:"string" enum:"S3Permission"`
}

// String returns the string representation
func (s S3Grant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Grant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Grant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Grant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantee sets the Grantee field's value.
func (s *S3Grant) SetGrantee(v *S3Grantee) *S3Grant {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *S3Grant) SetPermission(v string) *S3Grant {
	s.Permission = &v
	return s
}

type S3Grantee struct {
	_ struct{} `type:"structure"`

	DisplayName *string `min:"1" type:"string"`

	Identifier *string `min:"1" type:"string"`

	TypeIdentifier *string `type:"string" enum:"S3GranteeTypeIdentifier"`
}

// String returns the string representation
func (s S3Grantee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Grantee) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Grantee) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Grantee"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *S3Grantee) SetDisplayName(v string) *S3Grantee {
	s.DisplayName = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *S3Grantee) SetIdentifier(v string) *S3Grantee {
	s.Identifier = &v
	return s
}

// SetTypeIdentifier sets the TypeIdentifier field's value.
func (s *S3Grantee) SetTypeIdentifier(v string) *S3Grantee {
	s.TypeIdentifier = &v
	return s
}

// Contains the configuration parameters for an Initiate Glacier Restore job.
// Amazon S3 Batch Operations passes each value through to the underlying POST
// Object restore API. For more information about the parameters for this operation,
// see Restoring Archives (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html#RESTObjectPOSTrestore-restore-request).
type S3InitiateRestoreObjectOperation struct {
	_ struct{} `type:"structure"`

	ExpirationInDays *int64 `type:"integer"`

	GlacierJobTier *string `type:"string" enum:"S3GlacierJobTier"`
}

// String returns the string representation
func (s S3InitiateRestoreObjectOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3InitiateRestoreObjectOperation) GoString() string {
	return s.String()
}

// SetExpirationInDays sets the ExpirationInDays field's value.
func (s *S3InitiateRestoreObjectOperation) SetExpirationInDays(v int64) *S3InitiateRestoreObjectOperation {
	s.ExpirationInDays = &v
	return s
}

// SetGlacierJobTier sets the GlacierJobTier field's value.
func (s *S3InitiateRestoreObjectOperation) SetGlacierJobTier(v string) *S3InitiateRestoreObjectOperation {
	s.GlacierJobTier = &v
	return s
}

type S3ObjectLockLegalHold struct {
	_ struct{} `type:"structure"`

	// The Legal Hold status to be applied to all objects in the Batch Operations
	// job.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"S3ObjectLockLegalHoldStatus"`
}

// String returns the string representation
func (s S3ObjectLockLegalHold) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ObjectLockLegalHold) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ObjectLockLegalHold) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ObjectLockLegalHold"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *S3ObjectLockLegalHold) SetStatus(v string) *S3ObjectLockLegalHold {
	s.Status = &v
	return s
}

type S3ObjectMetadata struct {
	_ struct{} `type:"structure"`

	CacheControl *string `min:"1" type:"string"`

	ContentDisposition *string `min:"1" type:"string"`

	ContentEncoding *string `min:"1" type:"string"`

	ContentLanguage *string `min:"1" type:"string"`

	ContentLength *int64 `type:"long"`

	ContentMD5 *string `min:"1" type:"string"`

	ContentType *string `min:"1" type:"string"`

	HttpExpiresDate *time.Time `type:"timestamp"`

	RequesterCharged *bool `type:"boolean"`

	SSEAlgorithm *string `type:"string" enum:"S3SSEAlgorithm"`

	UserMetadata map[string]*string `type:"map"`
}

// String returns the string representation
func (s S3ObjectMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ObjectMetadata) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ObjectMetadata) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ObjectMetadata"}
	if s.CacheControl != nil && len(*s.CacheControl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CacheControl", 1))
	}
	if s.ContentDisposition != nil && len(*s.ContentDisposition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentDisposition", 1))
	}
	if s.ContentEncoding != nil && len(*s.ContentEncoding) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentEncoding", 1))
	}
	if s.ContentLanguage != nil && len(*s.ContentLanguage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentLanguage", 1))
	}
	if s.ContentMD5 != nil && len(*s.ContentMD5) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentMD5", 1))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheControl sets the CacheControl field's value.
func (s *S3ObjectMetadata) SetCacheControl(v string) *S3ObjectMetadata {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *S3ObjectMetadata) SetContentDisposition(v string) *S3ObjectMetadata {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *S3ObjectMetadata) SetContentEncoding(v string) *S3ObjectMetadata {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *S3ObjectMetadata) SetContentLanguage(v string) *S3ObjectMetadata {
	s.ContentLanguage = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *S3ObjectMetadata) SetContentLength(v int64) *S3ObjectMetadata {
	s.ContentLength = &v
	return s
}

// SetContentMD5 sets the ContentMD5 field's value.
func (s *S3ObjectMetadata) SetContentMD5(v string) *S3ObjectMetadata {
	s.ContentMD5 = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *S3ObjectMetadata) SetContentType(v string) *S3ObjectMetadata {
	s.ContentType = &v
	return s
}

// SetHttpExpiresDate sets the HttpExpiresDate field's value.
func (s *S3ObjectMetadata) SetHttpExpiresDate(v time.Time) *S3ObjectMetadata {
	s.HttpExpiresDate = &v
	return s
}

// SetRequesterCharged sets the RequesterCharged field's value.
func (s *S3ObjectMetadata) SetRequesterCharged(v bool) *S3ObjectMetadata {
	s.RequesterCharged = &v
	return s
}

// SetSSEAlgorithm sets the SSEAlgorithm field's value.
func (s *S3ObjectMetadata) SetSSEAlgorithm(v string) *S3ObjectMetadata {
	s.SSEAlgorithm = &v
	return s
}

// SetUserMetadata sets the UserMetadata field's value.
func (s *S3ObjectMetadata) SetUserMetadata(v map[string]*string) *S3ObjectMetadata {
	s.UserMetadata = v
	return s
}

type S3ObjectOwner struct {
	_ struct{} `type:"structure"`

	DisplayName *string `min:"1" type:"string"`

	ID *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3ObjectOwner) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ObjectOwner) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ObjectOwner) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ObjectOwner"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.ID != nil && len(*s.ID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *S3ObjectOwner) SetDisplayName(v string) *S3ObjectOwner {
	s.DisplayName = &v
	return s
}

// SetID sets the ID field's value.
func (s *S3ObjectOwner) SetID(v string) *S3ObjectOwner {
	s.ID = &v
	return s
}

type S3Retention struct {
	_ struct{} `type:"structure"`

	// The Retention mode to be applied to all objects in the Batch Operations job.
	Mode *string `type:"string" enum:"S3ObjectLockRetentionMode"`

	// The date when the applied Object Retention will expire on all objects in
	// the Batch Operations job.
	RetainUntilDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s S3Retention) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Retention) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *S3Retention) SetMode(v string) *S3Retention {
	s.Mode = &v
	return s
}

// SetRetainUntilDate sets the RetainUntilDate field's value.
func (s *S3Retention) SetRetainUntilDate(v time.Time) *S3Retention {
	s.RetainUntilDate = &v
	return s
}

// Contains the configuration parameters for a Set Object ACL operation. Amazon
// S3 Batch Operations passes each value through to the underlying PUT Object
// acl API. For more information about the parameters for this operation, see
// PUT Object acl (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTacl.html).
type S3SetObjectAclOperation struct {
	_ struct{} `type:"structure"`

	AccessControlPolicy *S3AccessControlPolicy `type:"structure"`
}

// String returns the string representation
func (s S3SetObjectAclOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3SetObjectAclOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SetObjectAclOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3SetObjectAclOperation"}
	if s.AccessControlPolicy != nil {
		if err := s.AccessControlPolicy.Validate(); err != nil {
			invalidParams.AddNested("AccessControlPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlPolicy sets the AccessControlPolicy field's value.
func (s *S3SetObjectAclOperation) SetAccessControlPolicy(v *S3AccessControlPolicy) *S3SetObjectAclOperation {
	s.AccessControlPolicy = v
	return s
}

// Contains the configuration parameters for a Set Object Legal Hold operation.
// Amazon S3 Batch Operations passes each value through to the underlying PUT
// Object Legal Hold API. For more information about the parameters for this
// operation, see PUT Object Legal Hold (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.htmll#object-lock-legal-holds).
type S3SetObjectLegalHoldOperation struct {
	_ struct{} `type:"structure"`

	// The Legal Hold contains the status to be applied to all objects in the Batch
	// Operations job.
	//
	// LegalHold is a required field
	LegalHold *S3ObjectLockLegalHold `type:"structure" required:"true"`
}

// String returns the string representation
func (s S3SetObjectLegalHoldOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3SetObjectLegalHoldOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SetObjectLegalHoldOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3SetObjectLegalHoldOperation"}
	if s.LegalHold == nil {
		invalidParams.Add(request.NewErrParamRequired("LegalHold"))
	}
	if s.LegalHold != nil {
		if err := s.LegalHold.Validate(); err != nil {
			invalidParams.AddNested("LegalHold", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLegalHold sets the LegalHold field's value.
func (s *S3SetObjectLegalHoldOperation) SetLegalHold(v *S3ObjectLockLegalHold) *S3SetObjectLegalHoldOperation {
	s.LegalHold = v
	return s
}

// Contains the configuration parameters for a Set Object Retention operation.
// Amazon S3 Batch Operations passes each value through to the underlying PUT
// Object Retention API. For more information about the parameters for this
// operation, see PUT Object Retention (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html#object-lock-retention-modes).
type S3SetObjectRetentionOperation struct {
	_ struct{} `type:"structure"`

	// Indicates if the operation should be applied to objects in the Batch Operations
	// job even if they have Governance-type Object Lock in place.
	BypassGovernanceRetention *bool `type:"boolean"`

	// Amazon S3 object lock Retention contains the retention mode to be applied
	// to all objects in the Batch Operations job.
	//
	// Retention is a required field
	Retention *S3Retention `type:"structure" required:"true"`
}

// String returns the string representation
func (s S3SetObjectRetentionOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3SetObjectRetentionOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SetObjectRetentionOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3SetObjectRetentionOperation"}
	if s.Retention == nil {
		invalidParams.Add(request.NewErrParamRequired("Retention"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBypassGovernanceRetention sets the BypassGovernanceRetention field's value.
func (s *S3SetObjectRetentionOperation) SetBypassGovernanceRetention(v bool) *S3SetObjectRetentionOperation {
	s.BypassGovernanceRetention = &v
	return s
}

// SetRetention sets the Retention field's value.
func (s *S3SetObjectRetentionOperation) SetRetention(v *S3Retention) *S3SetObjectRetentionOperation {
	s.Retention = v
	return s
}

// Contains the configuration parameters for a Set Object Tagging operation.
// Amazon S3 Batch Operations passes each value through to the underlying PUT
// Object tagging API. For more information about the parameters for this operation,
// see PUT Object tagging (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTtagging.html).
type S3SetObjectTaggingOperation struct {
	_ struct{} `type:"structure"`

	TagSet []*S3Tag `type:"list"`
}

// String returns the string representation
func (s S3SetObjectTaggingOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3SetObjectTaggingOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SetObjectTaggingOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3SetObjectTaggingOperation"}
	if s.TagSet != nil {
		for i, v := range s.TagSet {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagSet", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTagSet sets the TagSet field's value.
func (s *S3SetObjectTaggingOperation) SetTagSet(v []*S3Tag) *S3SetObjectTaggingOperation {
	s.TagSet = v
	return s
}

type S3Tag struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *S3Tag) SetKey(v string) *S3Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *S3Tag) SetValue(v string) *S3Tag {
	s.Value = &v
	return s
}

type UpdateJobPriorityInput struct {
	_ struct{} `locationName:"UpdateJobPriorityRequest" type:"structure"`

	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the job whose priority you want to update.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`

	// The priority you want to assign to this job.
	//
	// Priority is a required field
	Priority *int64 `location:"querystring" locationName:"priority" type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateJobPriorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobPriorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJobPriorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateJobPriorityInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateJobPriorityInput) SetAccountId(v string) *UpdateJobPriorityInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *UpdateJobPriorityInput) SetJobId(v string) *UpdateJobPriorityInput {
	s.JobId = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *UpdateJobPriorityInput) SetPriority(v int64) *UpdateJobPriorityInput {
	s.Priority = &v
	return s
}

func (s *UpdateJobPriorityInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type UpdateJobPriorityOutput struct {
	_ struct{} `type:"structure"`

	// The ID for the job whose priority Amazon S3 updated.
	//
	// JobId is a required field
	JobId *string `min:"5" type:"string" required:"true"`

	// The new priority assigned to the specified job.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateJobPriorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobPriorityOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *UpdateJobPriorityOutput) SetJobId(v string) *UpdateJobPriorityOutput {
	s.JobId = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *UpdateJobPriorityOutput) SetPriority(v int64) *UpdateJobPriorityOutput {
	s.Priority = &v
	return s
}

type UpdateJobStatusInput struct {
	_ struct{} `locationName:"UpdateJobStatusRequest" type:"structure"`

	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID of the job whose status you want to update.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`

	// The status that you want to move the specified job to.
	//
	// RequestedJobStatus is a required field
	RequestedJobStatus *string `location:"querystring" locationName:"requestedJobStatus" type:"string" required:"true" enum:"RequestedJobStatus"`

	// A description of the reason why you want to change the specified job's status.
	// This field can be any string up to the maximum length.
	StatusUpdateReason *string `location:"querystring" locationName:"statusUpdateReason" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateJobStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJobStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateJobStatusInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 5))
	}
	if s.RequestedJobStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestedJobStatus"))
	}
	if s.StatusUpdateReason != nil && len(*s.StatusUpdateReason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusUpdateReason", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateJobStatusInput) SetAccountId(v string) *UpdateJobStatusInput {
	s.AccountId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *UpdateJobStatusInput) SetJobId(v string) *UpdateJobStatusInput {
	s.JobId = &v
	return s
}

// SetRequestedJobStatus sets the RequestedJobStatus field's value.
func (s *UpdateJobStatusInput) SetRequestedJobStatus(v string) *UpdateJobStatusInput {
	s.RequestedJobStatus = &v
	return s
}

// SetStatusUpdateReason sets the StatusUpdateReason field's value.
func (s *UpdateJobStatusInput) SetStatusUpdateReason(v string) *UpdateJobStatusInput {
	s.StatusUpdateReason = &v
	return s
}

func (s *UpdateJobStatusInput) hostLabels() map[string]string {
	return map[string]string{
		"AccountId": aws.StringValue(s.AccountId),
	}
}

type UpdateJobStatusOutput struct {
	_ struct{} `type:"structure"`

	// The ID for the job whose status was updated.
	JobId *string `min:"5" type:"string"`

	// The current status for the specified job.
	Status *string `type:"string" enum:"JobStatus"`

	// The reason that the specified job's status was updated.
	StatusUpdateReason *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateJobStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobStatusOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *UpdateJobStatusOutput) SetJobId(v string) *UpdateJobStatusOutput {
	s.JobId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateJobStatusOutput) SetStatus(v string) *UpdateJobStatusOutput {
	s.Status = &v
	return s
}

// SetStatusUpdateReason sets the StatusUpdateReason field's value.
func (s *UpdateJobStatusOutput) SetStatusUpdateReason(v string) *UpdateJobStatusOutput {
	s.StatusUpdateReason = &v
	return s
}

// The virtual private cloud (VPC) configuration for an access point.
type VpcConfiguration struct {
	_ struct{} `type:"structure"`

	// If this field is specified, this access point will only allow connections
	// from the specified VPC ID.
	//
	// VpcId is a required field
	VpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfiguration"}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfiguration) SetVpcId(v string) *VpcConfiguration {
	s.VpcId = &v
	return s
}

const (
	// JobManifestFieldNameIgnore is a JobManifestFieldName enum value
	JobManifestFieldNameIgnore = "Ignore"

	// JobManifestFieldNameBucket is a JobManifestFieldName enum value
	JobManifestFieldNameBucket = "Bucket"

	// JobManifestFieldNameKey is a JobManifestFieldName enum value
	JobManifestFieldNameKey = "Key"

	// JobManifestFieldNameVersionId is a JobManifestFieldName enum value
	JobManifestFieldNameVersionId = "VersionId"
)

// JobManifestFieldName_Values returns all elements of the JobManifestFieldName enum
func JobManifestFieldName_Values() []string {
	return []string{
		JobManifestFieldNameIgnore,
		JobManifestFieldNameBucket,
		JobManifestFieldNameKey,
		JobManifestFieldNameVersionId,
	}
}

const (
	// JobManifestFormatS3batchOperationsCsv20180820 is a JobManifestFormat enum value
	JobManifestFormatS3batchOperationsCsv20180820 = "S3BatchOperations_CSV_20180820"

	// JobManifestFormatS3inventoryReportCsv20161130 is a JobManifestFormat enum value
	JobManifestFormatS3inventoryReportCsv20161130 = "S3InventoryReport_CSV_20161130"
)

// JobManifestFormat_Values returns all elements of the JobManifestFormat enum
func JobManifestFormat_Values() []string {
	return []string{
		JobManifestFormatS3batchOperationsCsv20180820,
		JobManifestFormatS3inventoryReportCsv20161130,
	}
}

const (
	// JobReportFormatReportCsv20180820 is a JobReportFormat enum value
	JobReportFormatReportCsv20180820 = "Report_CSV_20180820"
)

// JobReportFormat_Values returns all elements of the JobReportFormat enum
func JobReportFormat_Values() []string {
	return []string{
		JobReportFormatReportCsv20180820,
	}
}

const (
	// JobReportScopeAllTasks is a JobReportScope enum value
	JobReportScopeAllTasks = "AllTasks"

	// JobReportScopeFailedTasksOnly is a JobReportScope enum value
	JobReportScopeFailedTasksOnly = "FailedTasksOnly"
)

// JobReportScope_Values returns all elements of the JobReportScope enum
func JobReportScope_Values() []string {
	return []string{
		JobReportScopeAllTasks,
		JobReportScopeFailedTasksOnly,
	}
}

const (
	// JobStatusActive is a JobStatus enum value
	JobStatusActive = "Active"

	// JobStatusCancelled is a JobStatus enum value
	JobStatusCancelled = "Cancelled"

	// JobStatusCancelling is a JobStatus enum value
	JobStatusCancelling = "Cancelling"

	// JobStatusComplete is a JobStatus enum value
	JobStatusComplete = "Complete"

	// JobStatusCompleting is a JobStatus enum value
	JobStatusCompleting = "Completing"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "Failed"

	// JobStatusFailing is a JobStatus enum value
	JobStatusFailing = "Failing"

	// JobStatusNew is a JobStatus enum value
	JobStatusNew = "New"

	// JobStatusPaused is a JobStatus enum value
	JobStatusPaused = "Paused"

	// JobStatusPausing is a JobStatus enum value
	JobStatusPausing = "Pausing"

	// JobStatusPreparing is a JobStatus enum value
	JobStatusPreparing = "Preparing"

	// JobStatusReady is a JobStatus enum value
	JobStatusReady = "Ready"

	// JobStatusSuspended is a JobStatus enum value
	JobStatusSuspended = "Suspended"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusActive,
		JobStatusCancelled,
		JobStatusCancelling,
		JobStatusComplete,
		JobStatusCompleting,
		JobStatusFailed,
		JobStatusFailing,
		JobStatusNew,
		JobStatusPaused,
		JobStatusPausing,
		JobStatusPreparing,
		JobStatusReady,
		JobStatusSuspended,
	}
}

const (
	// NetworkOriginInternet is a NetworkOrigin enum value
	NetworkOriginInternet = "Internet"

	// NetworkOriginVpc is a NetworkOrigin enum value
	NetworkOriginVpc = "VPC"
)

// NetworkOrigin_Values returns all elements of the NetworkOrigin enum
func NetworkOrigin_Values() []string {
	return []string{
		NetworkOriginInternet,
		NetworkOriginVpc,
	}
}

const (
	// OperationNameLambdaInvoke is a OperationName enum value
	OperationNameLambdaInvoke = "LambdaInvoke"

	// OperationNameS3putObjectCopy is a OperationName enum value
	OperationNameS3putObjectCopy = "S3PutObjectCopy"

	// OperationNameS3putObjectAcl is a OperationName enum value
	OperationNameS3putObjectAcl = "S3PutObjectAcl"

	// OperationNameS3putObjectTagging is a OperationName enum value
	OperationNameS3putObjectTagging = "S3PutObjectTagging"

	// OperationNameS3initiateRestoreObject is a OperationName enum value
	OperationNameS3initiateRestoreObject = "S3InitiateRestoreObject"

	// OperationNameS3putObjectLegalHold is a OperationName enum value
	OperationNameS3putObjectLegalHold = "S3PutObjectLegalHold"

	// OperationNameS3putObjectRetention is a OperationName enum value
	OperationNameS3putObjectRetention = "S3PutObjectRetention"
)

// OperationName_Values returns all elements of the OperationName enum
func OperationName_Values() []string {
	return []string{
		OperationNameLambdaInvoke,
		OperationNameS3putObjectCopy,
		OperationNameS3putObjectAcl,
		OperationNameS3putObjectTagging,
		OperationNameS3initiateRestoreObject,
		OperationNameS3putObjectLegalHold,
		OperationNameS3putObjectRetention,
	}
}

const (
	// RequestedJobStatusCancelled is a RequestedJobStatus enum value
	RequestedJobStatusCancelled = "Cancelled"

	// RequestedJobStatusReady is a RequestedJobStatus enum value
	RequestedJobStatusReady = "Ready"
)

// RequestedJobStatus_Values returns all elements of the RequestedJobStatus enum
func RequestedJobStatus_Values() []string {
	return []string{
		RequestedJobStatusCancelled,
		RequestedJobStatusReady,
	}
}

const (
	// S3CannedAccessControlListPrivate is a S3CannedAccessControlList enum value
	S3CannedAccessControlListPrivate = "private"

	// S3CannedAccessControlListPublicRead is a S3CannedAccessControlList enum value
	S3CannedAccessControlListPublicRead = "public-read"

	// S3CannedAccessControlListPublicReadWrite is a S3CannedAccessControlList enum value
	S3CannedAccessControlListPublicReadWrite = "public-read-write"

	// S3CannedAccessControlListAwsExecRead is a S3CannedAccessControlList enum value
	S3CannedAccessControlListAwsExecRead = "aws-exec-read"

	// S3CannedAccessControlListAuthenticatedRead is a S3CannedAccessControlList enum value
	S3CannedAccessControlListAuthenticatedRead = "authenticated-read"

	// S3CannedAccessControlListBucketOwnerRead is a S3CannedAccessControlList enum value
	S3CannedAccessControlListBucketOwnerRead = "bucket-owner-read"

	// S3CannedAccessControlListBucketOwnerFullControl is a S3CannedAccessControlList enum value
	S3CannedAccessControlListBucketOwnerFullControl = "bucket-owner-full-control"
)

// S3CannedAccessControlList_Values returns all elements of the S3CannedAccessControlList enum
func S3CannedAccessControlList_Values() []string {
	return []string{
		S3CannedAccessControlListPrivate,
		S3CannedAccessControlListPublicRead,
		S3CannedAccessControlListPublicReadWrite,
		S3CannedAccessControlListAwsExecRead,
		S3CannedAccessControlListAuthenticatedRead,
		S3CannedAccessControlListBucketOwnerRead,
		S3CannedAccessControlListBucketOwnerFullControl,
	}
}

const (
	// S3GlacierJobTierBulk is a S3GlacierJobTier enum value
	S3GlacierJobTierBulk = "BULK"

	// S3GlacierJobTierStandard is a S3GlacierJobTier enum value
	S3GlacierJobTierStandard = "STANDARD"
)

// S3GlacierJobTier_Values returns all elements of the S3GlacierJobTier enum
func S3GlacierJobTier_Values() []string {
	return []string{
		S3GlacierJobTierBulk,
		S3GlacierJobTierStandard,
	}
}

const (
	// S3GranteeTypeIdentifierId is a S3GranteeTypeIdentifier enum value
	S3GranteeTypeIdentifierId = "id"

	// S3GranteeTypeIdentifierEmailAddress is a S3GranteeTypeIdentifier enum value
	S3GranteeTypeIdentifierEmailAddress = "emailAddress"

	// S3GranteeTypeIdentifierUri is a S3GranteeTypeIdentifier enum value
	S3GranteeTypeIdentifierUri = "uri"
)

// S3GranteeTypeIdentifier_Values returns all elements of the S3GranteeTypeIdentifier enum
func S3GranteeTypeIdentifier_Values() []string {
	return []string{
		S3GranteeTypeIdentifierId,
		S3GranteeTypeIdentifierEmailAddress,
		S3GranteeTypeIdentifierUri,
	}
}

const (
	// S3MetadataDirectiveCopy is a S3MetadataDirective enum value
	S3MetadataDirectiveCopy = "COPY"

	// S3MetadataDirectiveReplace is a S3MetadataDirective enum value
	S3MetadataDirectiveReplace = "REPLACE"
)

// S3MetadataDirective_Values returns all elements of the S3MetadataDirective enum
func S3MetadataDirective_Values() []string {
	return []string{
		S3MetadataDirectiveCopy,
		S3MetadataDirectiveReplace,
	}
}

const (
	// S3ObjectLockLegalHoldStatusOff is a S3ObjectLockLegalHoldStatus enum value
	S3ObjectLockLegalHoldStatusOff = "OFF"

	// S3ObjectLockLegalHoldStatusOn is a S3ObjectLockLegalHoldStatus enum value
	S3ObjectLockLegalHoldStatusOn = "ON"
)

// S3ObjectLockLegalHoldStatus_Values returns all elements of the S3ObjectLockLegalHoldStatus enum
func S3ObjectLockLegalHoldStatus_Values() []string {
	return []string{
		S3ObjectLockLegalHoldStatusOff,
		S3ObjectLockLegalHoldStatusOn,
	}
}

const (
	// S3ObjectLockModeCompliance is a S3ObjectLockMode enum value
	S3ObjectLockModeCompliance = "COMPLIANCE"

	// S3ObjectLockModeGovernance is a S3ObjectLockMode enum value
	S3ObjectLockModeGovernance = "GOVERNANCE"
)

// S3ObjectLockMode_Values returns all elements of the S3ObjectLockMode enum
func S3ObjectLockMode_Values() []string {
	return []string{
		S3ObjectLockModeCompliance,
		S3ObjectLockModeGovernance,
	}
}

const (
	// S3ObjectLockRetentionModeCompliance is a S3ObjectLockRetentionMode enum value
	S3ObjectLockRetentionModeCompliance = "COMPLIANCE"

	// S3ObjectLockRetentionModeGovernance is a S3ObjectLockRetentionMode enum value
	S3ObjectLockRetentionModeGovernance = "GOVERNANCE"
)

// S3ObjectLockRetentionMode_Values returns all elements of the S3ObjectLockRetentionMode enum
func S3ObjectLockRetentionMode_Values() []string {
	return []string{
		S3ObjectLockRetentionModeCompliance,
		S3ObjectLockRetentionModeGovernance,
	}
}

const (
	// S3PermissionFullControl is a S3Permission enum value
	S3PermissionFullControl = "FULL_CONTROL"

	// S3PermissionRead is a S3Permission enum value
	S3PermissionRead = "READ"

	// S3PermissionWrite is a S3Permission enum value
	S3PermissionWrite = "WRITE"

	// S3PermissionReadAcp is a S3Permission enum value
	S3PermissionReadAcp = "READ_ACP"

	// S3PermissionWriteAcp is a S3Permission enum value
	S3PermissionWriteAcp = "WRITE_ACP"
)

// S3Permission_Values returns all elements of the S3Permission enum
func S3Permission_Values() []string {
	return []string{
		S3PermissionFullControl,
		S3PermissionRead,
		S3PermissionWrite,
		S3PermissionReadAcp,
		S3PermissionWriteAcp,
	}
}

const (
	// S3SSEAlgorithmAes256 is a S3SSEAlgorithm enum value
	S3SSEAlgorithmAes256 = "AES256"

	// S3SSEAlgorithmKms is a S3SSEAlgorithm enum value
	S3SSEAlgorithmKms = "KMS"
)

// S3SSEAlgorithm_Values returns all elements of the S3SSEAlgorithm enum
func S3SSEAlgorithm_Values() []string {
	return []string{
		S3SSEAlgorithmAes256,
		S3SSEAlgorithmKms,
	}
}

const (
	// S3StorageClassStandard is a S3StorageClass enum value
	S3StorageClassStandard = "STANDARD"

	// S3StorageClassStandardIa is a S3StorageClass enum value
	S3StorageClassStandardIa = "STANDARD_IA"

	// S3StorageClassOnezoneIa is a S3StorageClass enum value
	S3StorageClassOnezoneIa = "ONEZONE_IA"

	// S3StorageClassGlacier is a S3StorageClass enum value
	S3StorageClassGlacier = "GLACIER"

	// S3StorageClassIntelligentTiering is a S3StorageClass enum value
	S3StorageClassIntelligentTiering = "INTELLIGENT_TIERING"

	// S3StorageClassDeepArchive is a S3StorageClass enum value
	S3StorageClassDeepArchive = "DEEP_ARCHIVE"
)

// S3StorageClass_Values returns all elements of the S3StorageClass enum
func S3StorageClass_Values() []string {
	return []string{
		S3StorageClassStandard,
		S3StorageClassStandardIa,
		S3StorageClassOnezoneIa,
		S3StorageClassGlacier,
		S3StorageClassIntelligentTiering,
		S3StorageClassDeepArchive,
	}
}
