---
name: Bug report
about: For behaviors which violate documentation or cause incorrect results
title: ''
labels: ''
assignees: ''
---

<!--
This template is for bug reports. The lack of a feature is not a bug; to request a feature, please switch templates.

Are you asking for help with using Caddy? Please ask on our forum: https://caddy.community

Please do not skip relevant questions; this will slow down the debugging process and your issue may be closed.
-->

## 1. Which version of Caddy are you using (`caddy -version`)?
<!-- If there is no version information, please paste commit SHA instead. -->




## 2. What are you trying to do?
<!-- Please clearly describe what you are trying to do thoroughly enough so that a reader with no background information can repeat it. -->




## 3. What is your Caddyfile?
```text
paste entire Caddyfile here - DO NOT REDACT ANYTHING (except credentials)
```
<!-- Changing or hiding parts of your Caddyfile only slows things down and may result in your report being closed.
For more information, see https://caddy.community/t/how-to-get-help-with-caddy-more-effectively/5222 -->
<!-- If you are unable to post this publicly, we offer private support: https://caddyserver.com/products/support -->




## 4. How did you run Caddy (give the full command and describe the execution environment)?
<!-- IMPORTANT: Please eliminate Docker, systemd, reverse proxies, upstream dependencies, caches, firewalls, and other unnecessary, external factors from your setup first. This will help prove that this is a bug in Caddy and not a misconfiguration of your environment. We may close issues that are too complex to replicate. Thank you! -->




## 5. Please paste any relevant HTTP request(s) here.
<!-- Paste curl command, or full HTTP request including headers and body. You may skip this if the bug does not require HTTP requests. -->




## 6. What did you expect to see?
<!-- Describe your expected results as precisely as possible. -->




## 7. What did you see instead (give full error messages and/or log)?
<!-- Please run Caddy with the -log flag, and use the log and errors directives as needed. DO NOT REDACT INFORMATION except for credentials. See https://caddy.community/t/how-to-get-help-with-caddy-more-effectively/5222 -->




## 8. Why is this a bug, and how do you think this should be fixed?
<!-- Help us understand why it is a bug; it is not always obvious. You can help us get this resolved faster by thinking about the problem and describing possible solutions! -->




## 9. What are you doing to work around the problem in the meantime?
<!-- This can help others who encounter the same problem, until we implement a fix. -->




## 10. Please link to any related issues, pull requests, and/or discussion.
<!-- This can add crucial context to your report. -->




## Bonus: What do you use Caddy for? Why did you choose Caddy?
<!-- We'd like to know! -->
