/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: k8s.io/kubernetes/vendor/k8s.io/apiserver/pkg/apis/apiserverinternal/v1alpha1/generated.proto

package v1alpha1

import (
	fmt "fmt"

	io "io"

	proto "github.com/gogo/protobuf/proto"

	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

func (m *ServerStorageVersion) Reset()      { *m = ServerStorageVersion{} }
func (*ServerStorageVersion) ProtoMessage() {}
func (*ServerStorageVersion) Descriptor() ([]byte, []int) {
	return fileDescriptor_e78b74fcffb22985, []int{0}
}
func (m *ServerStorageVersion) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServerStorageVersion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *ServerStorageVersion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerStorageVersion.Merge(m, src)
}
func (m *ServerStorageVersion) XXX_Size() int {
	return m.Size()
}
func (m *ServerStorageVersion) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerStorageVersion.DiscardUnknown(m)
}

var xxx_messageInfo_ServerStorageVersion proto.InternalMessageInfo

func (m *StorageVersion) Reset()      { *m = StorageVersion{} }
func (*StorageVersion) ProtoMessage() {}
func (*StorageVersion) Descriptor() ([]byte, []int) {
	return fileDescriptor_e78b74fcffb22985, []int{1}
}
func (m *StorageVersion) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageVersion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *StorageVersion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageVersion.Merge(m, src)
}
func (m *StorageVersion) XXX_Size() int {
	return m.Size()
}
func (m *StorageVersion) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageVersion.DiscardUnknown(m)
}

var xxx_messageInfo_StorageVersion proto.InternalMessageInfo

func (m *StorageVersionCondition) Reset()      { *m = StorageVersionCondition{} }
func (*StorageVersionCondition) ProtoMessage() {}
func (*StorageVersionCondition) Descriptor() ([]byte, []int) {
	return fileDescriptor_e78b74fcffb22985, []int{2}
}
func (m *StorageVersionCondition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageVersionCondition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *StorageVersionCondition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageVersionCondition.Merge(m, src)
}
func (m *StorageVersionCondition) XXX_Size() int {
	return m.Size()
}
func (m *StorageVersionCondition) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageVersionCondition.DiscardUnknown(m)
}

var xxx_messageInfo_StorageVersionCondition proto.InternalMessageInfo

func (m *StorageVersionList) Reset()      { *m = StorageVersionList{} }
func (*StorageVersionList) ProtoMessage() {}
func (*StorageVersionList) Descriptor() ([]byte, []int) {
	return fileDescriptor_e78b74fcffb22985, []int{3}
}
func (m *StorageVersionList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageVersionList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *StorageVersionList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageVersionList.Merge(m, src)
}
func (m *StorageVersionList) XXX_Size() int {
	return m.Size()
}
func (m *StorageVersionList) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageVersionList.DiscardUnknown(m)
}

var xxx_messageInfo_StorageVersionList proto.InternalMessageInfo

func (m *StorageVersionSpec) Reset()      { *m = StorageVersionSpec{} }
func (*StorageVersionSpec) ProtoMessage() {}
func (*StorageVersionSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_e78b74fcffb22985, []int{4}
}
func (m *StorageVersionSpec) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageVersionSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *StorageVersionSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageVersionSpec.Merge(m, src)
}
func (m *StorageVersionSpec) XXX_Size() int {
	return m.Size()
}
func (m *StorageVersionSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageVersionSpec.DiscardUnknown(m)
}

var xxx_messageInfo_StorageVersionSpec proto.InternalMessageInfo

func (m *StorageVersionStatus) Reset()      { *m = StorageVersionStatus{} }
func (*StorageVersionStatus) ProtoMessage() {}
func (*StorageVersionStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_e78b74fcffb22985, []int{5}
}
func (m *StorageVersionStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageVersionStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *StorageVersionStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageVersionStatus.Merge(m, src)
}
func (m *StorageVersionStatus) XXX_Size() int {
	return m.Size()
}
func (m *StorageVersionStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageVersionStatus.DiscardUnknown(m)
}

var xxx_messageInfo_StorageVersionStatus proto.InternalMessageInfo

func init() {
	proto.RegisterType((*ServerStorageVersion)(nil), "k8s.io.apiserver.pkg.apis.apiserverinternal.v1alpha1.ServerStorageVersion")
	proto.RegisterType((*StorageVersion)(nil), "k8s.io.apiserver.pkg.apis.apiserverinternal.v1alpha1.StorageVersion")
	proto.RegisterType((*StorageVersionCondition)(nil), "k8s.io.apiserver.pkg.apis.apiserverinternal.v1alpha1.StorageVersionCondition")
	proto.RegisterType((*StorageVersionList)(nil), "k8s.io.apiserver.pkg.apis.apiserverinternal.v1alpha1.StorageVersionList")
	proto.RegisterType((*StorageVersionSpec)(nil), "k8s.io.apiserver.pkg.apis.apiserverinternal.v1alpha1.StorageVersionSpec")
	proto.RegisterType((*StorageVersionStatus)(nil), "k8s.io.apiserver.pkg.apis.apiserverinternal.v1alpha1.StorageVersionStatus")
}

func init() {
	proto.RegisterFile("k8s.io/kubernetes/vendor/k8s.io/apiserver/pkg/apis/apiserverinternal/v1alpha1/generated.proto", fileDescriptor_e78b74fcffb22985)
}

var fileDescriptor_e78b74fcffb22985 = []byte{
	// 767 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x54, 0x5d, 0x4f, 0x13, 0x4d,
	0x14, 0xee, 0xd2, 0x52, 0x60, 0xfa, 0xbe, 0xf4, 0x65, 0x5e, 0x08, 0xb5, 0x26, 0x5b, 0xec, 0x85,
	0x41, 0x8d, 0xbb, 0xd2, 0xa0, 0xd1, 0x2b, 0xc3, 0x02, 0x51, 0x08, 0x04, 0x33, 0x10, 0x2f, 0x8c,
	0x26, 0x4e, 0x77, 0xc7, 0xed, 0xd2, 0xee, 0xce, 0x66, 0x67, 0xda, 0x84, 0x3b, 0xfd, 0x01, 0x26,
	0xfe, 0x10, 0x7f, 0x08, 0x97, 0xc4, 0xc4, 0x84, 0x1b, 0x1b, 0x59, 0xff, 0x05, 0xde, 0x98, 0x9d,
	0xfd, 0x62, 0xdb, 0x25, 0x12, 0xc2, 0xdd, 0x9e, 0x8f, 0xe7, 0x3c, 0xe7, 0x9c, 0x7d, 0xce, 0x80,
	0x77, 0xdd, 0xa7, 0x4c, 0xb1, 0xa8, 0xda, 0xed, 0xb7, 0x89, 0xe7, 0x10, 0x4e, 0x98, 0x3a, 0x20,
	0x8e, 0x41, 0x3d, 0x35, 0x0a, 0x60, 0xd7, 0x62, 0xc4, 0x1b, 0x10, 0x4f, 0x75, 0xbb, 0xa6, 0xb0,
	0x52, 0x97, 0xe5, 0x70, 0xe2, 0x39, 0xb8, 0xa7, 0x0e, 0x56, 0x70, 0xcf, 0xed, 0xe0, 0x15, 0xd5,
	0x24, 0x0e, 0xf1, 0x30, 0x27, 0x86, 0xe2, 0x7a, 0x94, 0x53, 0xb8, 0x1a, 0x56, 0x51, 0x12, 0x88,
	0xe2, 0x76, 0x4d, 0x61, 0x29, 0x63, 0x55, 0x94, 0xb8, 0x4a, 0xfd, 0xa1, 0x69, 0xf1, 0x4e, 0xbf,
	0xad, 0xe8, 0xd4, 0x56, 0x4d, 0x6a, 0x52, 0x55, 0x14, 0x6b, 0xf7, 0x3f, 0x08, 0x4b, 0x18, 0xe2,
	0x2b, 0x24, 0xa9, 0xaf, 0xa6, 0xad, 0xda, 0x58, 0xef, 0x58, 0x0e, 0xf1, 0x8e, 0xd2, 0x6e, 0x6d,
	0xc2, 0xb1, 0x3a, 0x18, 0x6b, 0xad, 0xae, 0x5e, 0x86, 0xf2, 0xfa, 0x0e, 0xb7, 0x6c, 0x32, 0x06,
	0x78, 0xf2, 0x37, 0x00, 0xd3, 0x3b, 0xc4, 0xc6, 0xa3, 0xb8, 0xe6, 0x77, 0x09, 0xcc, 0xef, 0x8b,
	0x49, 0xf7, 0x39, 0xf5, 0xb0, 0x49, 0x5e, 0x13, 0x8f, 0x59, 0xd4, 0x81, 0x8f, 0x41, 0x05, 0xbb,
	0x56, 0x18, 0xda, 0xda, 0xa8, 0x49, 0x4b, 0xd2, 0xf2, 0x8c, 0xf6, 0xff, 0xf1, 0xb0, 0x51, 0xf0,
	0x87, 0x8d, 0xca, 0xda, 0xab, 0xad, 0x38, 0x84, 0x2e, 0xe6, 0xc1, 0x35, 0x50, 0x25, 0x8e, 0x4e,
	0x0d, 0xcb, 0x31, 0xa3, 0x4a, 0xb5, 0x09, 0x01, 0x5d, 0x8c, 0xa0, 0xd5, 0xcd, 0x6c, 0x18, 0x8d,
	0xe6, 0xc3, 0x75, 0x30, 0x67, 0x10, 0x9d, 0x1a, 0xb8, 0xdd, 0x8b, 0xbb, 0x61, 0xb5, 0xe2, 0x52,
	0x71, 0x79, 0x46, 0x5b, 0xf0, 0x87, 0x8d, 0xb9, 0x8d, 0xd1, 0x20, 0x1a, 0xcf, 0x6f, 0x7e, 0x9b,
	0x00, 0xb3, 0x23, 0x13, 0xbd, 0x07, 0xd3, 0xc1, 0xba, 0x0d, 0xcc, 0xb1, 0x18, 0xa7, 0xd2, 0x7a,
	0xa4, 0xa4, 0x0a, 0x48, 0xb6, 0x96, 0x8a, 0x20, 0xc8, 0x56, 0x06, 0x2b, 0xca, 0x5e, 0xfb, 0x90,
	0xe8, 0x7c, 0x97, 0x70, 0xac, 0xc1, 0x68, 0x0a, 0x90, 0xfa, 0x50, 0x52, 0x15, 0x1e, 0x82, 0x12,
	0x73, 0x89, 0x2e, 0x26, 0xae, 0xb4, 0x5e, 0x2a, 0xd7, 0xd1, 0x97, 0x92, 0xed, 0x7a, 0xdf, 0x25,
	0xba, 0xf6, 0x4f, 0xc4, 0x5a, 0x0a, 0x2c, 0x24, 0x38, 0xa0, 0x07, 0xca, 0x8c, 0x63, 0xde, 0x0f,
	0x56, 0x13, 0xb0, 0x6d, 0xdf, 0x08, 0x9b, 0xa8, 0xa8, 0xcd, 0x46, 0x7c, 0xe5, 0xd0, 0x46, 0x11,
	0x53, 0xf3, 0x6b, 0x11, 0x2c, 0x66, 0x01, 0xeb, 0xd4, 0x31, 0x2c, 0x1e, 0x6c, 0xf7, 0x39, 0x28,
	0xf1, 0x23, 0x97, 0x44, 0x42, 0x79, 0x10, 0x77, 0x7c, 0x70, 0xe4, 0x92, 0xf3, 0x61, 0xe3, 0xf6,
	0x25, 0xb0, 0x20, 0x8c, 0x04, 0x10, 0x3e, 0x4b, 0x06, 0x0a, 0x05, 0x73, 0x27, 0xdb, 0xc4, 0xf9,
	0xb0, 0x51, 0x4d, 0x60, 0xd9, 0xbe, 0xe0, 0x36, 0x80, 0xb4, 0x2d, 0x26, 0x34, 0x5e, 0x84, 0xfa,
	0x0e, 0x74, 0x17, 0xec, 0xa5, 0xa8, 0xd5, 0xa3, 0x32, 0x70, 0x6f, 0x2c, 0x03, 0xe5, 0xa0, 0xe0,
	0x00, 0xc0, 0x1e, 0x66, 0xfc, 0xc0, 0xc3, 0x0e, 0x0b, 0x5b, 0xb4, 0x6c, 0x52, 0x2b, 0x89, 0x1d,
	0xdf, 0xbf, 0x9a, 0x5e, 0x02, 0x44, 0xca, 0xbb, 0x33, 0x56, 0x0d, 0xe5, 0x30, 0xc0, 0xbb, 0xa0,
	0xec, 0x11, 0xcc, 0xa8, 0x53, 0x9b, 0x14, 0xe3, 0x27, 0xff, 0x00, 0x09, 0x2f, 0x8a, 0xa2, 0xf0,
	0x1e, 0x98, 0xb2, 0x09, 0x63, 0xd8, 0x24, 0xb5, 0xb2, 0x48, 0xac, 0x46, 0x89, 0x53, 0xbb, 0xa1,
	0x1b, 0xc5, 0xf1, 0xe6, 0x0f, 0x09, 0xc0, 0xec, 0xde, 0x77, 0x2c, 0xc6, 0xe1, 0xdb, 0xb1, 0x3b,
	0x50, 0xae, 0x36, 0x57, 0x80, 0x16, 0x57, 0xf0, 0x5f, 0x44, 0x39, 0x1d, 0x7b, 0x2e, 0xdc, 0x80,
	0x05, 0x26, 0x2d, 0x4e, 0xec, 0xe0, 0x2f, 0x16, 0x97, 0x2b, 0xad, 0x8d, 0x9b, 0x90, 0xa5, 0xf6,
	0x6f, 0x44, 0x38, 0xb9, 0x15, 0x94, 0x46, 0x21, 0x43, 0x73, 0x7e, 0x74, 0xbc, 0xe0, 0x3c, 0x9a,
	0xbf, 0x27, 0xc0, 0x7c, 0x9e, 0xaa, 0xe1, 0x67, 0x09, 0x54, 0x59, 0x26, 0xc0, 0x6a, 0x92, 0x68,
	0xf2, 0xba, 0xb7, 0x93, 0xf3, 0x6e, 0xa6, 0xef, 0x5c, 0xd6, 0xcf, 0xd0, 0x28, 0x37, 0xdc, 0x03,
	0x0b, 0x3a, 0xb5, 0x6d, 0xea, 0x6c, 0xe6, 0x3e, 0x98, 0xb7, 0xfc, 0x61, 0x63, 0x61, 0x3d, 0x2f,
	0x01, 0xe5, 0xe3, 0xe0, 0x27, 0x09, 0x00, 0x3d, 0x3e, 0x91, 0xf0, 0xc9, 0xac, 0xb4, 0x76, 0x6f,
	0xe2, 0x07, 0x24, 0x87, 0x97, 0x3e, 0x80, 0x89, 0x8b, 0xa1, 0x0b, 0xa4, 0x9a, 0x72, 0x7c, 0x26,
	0x17, 0x4e, 0xce, 0xe4, 0xc2, 0xe9, 0x99, 0x5c, 0xf8, 0xe8, 0xcb, 0xd2, 0xb1, 0x2f, 0x4b, 0x27,
	0xbe, 0x2c, 0x9d, 0xfa, 0xb2, 0xf4, 0xd3, 0x97, 0xa5, 0x2f, 0xbf, 0xe4, 0xc2, 0x9b, 0xe9, 0x98,
	0xe7, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x07, 0x1e, 0x5f, 0x1d, 0xe3, 0x07, 0x00, 0x00,
}

func (m *ServerStorageVersion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServerStorageVersion) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServerStorageVersion) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DecodableVersions) > 0 {
		for iNdEx := len(m.DecodableVersions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DecodableVersions[iNdEx])
			copy(dAtA[i:], m.DecodableVersions[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.DecodableVersions[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	i -= len(m.EncodingVersion)
	copy(dAtA[i:], m.EncodingVersion)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.EncodingVersion)))
	i--
	dAtA[i] = 0x12
	i -= len(m.APIServerID)
	copy(dAtA[i:], m.APIServerID)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.APIServerID)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *StorageVersion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageVersion) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StorageVersion) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	{
		size, err := m.Spec.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *StorageVersionCondition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageVersionCondition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StorageVersionCondition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Message)
	copy(dAtA[i:], m.Message)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Message)))
	i--
	dAtA[i] = 0x32
	i -= len(m.Reason)
	copy(dAtA[i:], m.Reason)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Reason)))
	i--
	dAtA[i] = 0x2a
	{
		size, err := m.LastTransitionTime.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	i = encodeVarintGenerated(dAtA, i, uint64(m.ObservedGeneration))
	i--
	dAtA[i] = 0x18
	i -= len(m.Status)
	copy(dAtA[i:], m.Status)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Status)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Type)
	copy(dAtA[i:], m.Type)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Type)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *StorageVersionList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageVersionList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StorageVersionList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.ListMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *StorageVersionSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageVersionSpec) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StorageVersionSpec) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *StorageVersionStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageVersionStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StorageVersionStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Conditions) > 0 {
		for iNdEx := len(m.Conditions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Conditions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.CommonEncodingVersion != nil {
		i -= len(*m.CommonEncodingVersion)
		copy(dAtA[i:], *m.CommonEncodingVersion)
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.CommonEncodingVersion)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.StorageVersions) > 0 {
		for iNdEx := len(m.StorageVersions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.StorageVersions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	offset -= sovGenerated(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ServerStorageVersion) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.APIServerID)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.EncodingVersion)
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.DecodableVersions) > 0 {
		for _, s := range m.DecodableVersions {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *StorageVersion) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ObjectMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = m.Spec.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = m.Status.Size()
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *StorageVersionCondition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Status)
	n += 1 + l + sovGenerated(uint64(l))
	n += 1 + sovGenerated(uint64(m.ObservedGeneration))
	l = m.LastTransitionTime.Size()
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Reason)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.Message)
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func (m *StorageVersionList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ListMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *StorageVersionSpec) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *StorageVersionStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.StorageVersions) > 0 {
		for _, e := range m.StorageVersions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.CommonEncodingVersion != nil {
		l = len(*m.CommonEncodingVersion)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Conditions) > 0 {
		for _, e := range m.Conditions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func sovGenerated(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ServerStorageVersion) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServerStorageVersion{`,
		`APIServerID:` + fmt.Sprintf("%v", this.APIServerID) + `,`,
		`EncodingVersion:` + fmt.Sprintf("%v", this.EncodingVersion) + `,`,
		`DecodableVersions:` + fmt.Sprintf("%v", this.DecodableVersions) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StorageVersion) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StorageVersion{`,
		`ObjectMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ObjectMeta), "ObjectMeta", "v1.ObjectMeta", 1), `&`, ``, 1) + `,`,
		`Spec:` + strings.Replace(strings.Replace(this.Spec.String(), "StorageVersionSpec", "StorageVersionSpec", 1), `&`, ``, 1) + `,`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "StorageVersionStatus", "StorageVersionStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StorageVersionCondition) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StorageVersionCondition{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`ObservedGeneration:` + fmt.Sprintf("%v", this.ObservedGeneration) + `,`,
		`LastTransitionTime:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.LastTransitionTime), "Time", "v1.Time", 1), `&`, ``, 1) + `,`,
		`Reason:` + fmt.Sprintf("%v", this.Reason) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StorageVersionList) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForItems := "[]StorageVersion{"
	for _, f := range this.Items {
		repeatedStringForItems += strings.Replace(strings.Replace(f.String(), "StorageVersion", "StorageVersion", 1), `&`, ``, 1) + ","
	}
	repeatedStringForItems += "}"
	s := strings.Join([]string{`&StorageVersionList{`,
		`ListMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ListMeta), "ListMeta", "v1.ListMeta", 1), `&`, ``, 1) + `,`,
		`Items:` + repeatedStringForItems + `,`,
		`}`,
	}, "")
	return s
}
func (this *StorageVersionSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StorageVersionSpec{`,
		`}`,
	}, "")
	return s
}
func (this *StorageVersionStatus) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForStorageVersions := "[]ServerStorageVersion{"
	for _, f := range this.StorageVersions {
		repeatedStringForStorageVersions += strings.Replace(strings.Replace(f.String(), "ServerStorageVersion", "ServerStorageVersion", 1), `&`, ``, 1) + ","
	}
	repeatedStringForStorageVersions += "}"
	repeatedStringForConditions := "[]StorageVersionCondition{"
	for _, f := range this.Conditions {
		repeatedStringForConditions += strings.Replace(strings.Replace(f.String(), "StorageVersionCondition", "StorageVersionCondition", 1), `&`, ``, 1) + ","
	}
	repeatedStringForConditions += "}"
	s := strings.Join([]string{`&StorageVersionStatus{`,
		`StorageVersions:` + repeatedStringForStorageVersions + `,`,
		`CommonEncodingVersion:` + valueToStringGenerated(this.CommonEncodingVersion) + `,`,
		`Conditions:` + repeatedStringForConditions + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringGenerated(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *ServerStorageVersion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerStorageVersion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerStorageVersion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field APIServerID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.APIServerID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodingVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncodingVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DecodableVersions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DecodableVersions = append(m.DecodableVersions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StorageVersion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StorageVersion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StorageVersion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spec", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Spec.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StorageVersionCondition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StorageVersionCondition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StorageVersionCondition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = StorageVersionConditionType(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = ConditionStatus(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObservedGeneration", wireType)
			}
			m.ObservedGeneration = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ObservedGeneration |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastTransitionTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LastTransitionTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Reason = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StorageVersionList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StorageVersionList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StorageVersionList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ListMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, StorageVersion{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StorageVersionSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StorageVersionSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StorageVersionSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StorageVersionStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StorageVersionStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StorageVersionStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageVersions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StorageVersions = append(m.StorageVersions, ServerStorageVersion{})
			if err := m.StorageVersions[len(m.StorageVersions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonEncodingVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.CommonEncodingVersion = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conditions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Conditions = append(m.Conditions, StorageVersionCondition{})
			if err := m.Conditions[len(m.Conditions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGenerated(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupGenerated
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthGenerated
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthGenerated        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGenerated          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupGenerated = fmt.Errorf("proto: unexpected end of group")
)
