// +build !ignore_autogenerated_kubeadm_types

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package upstreamv1beta3

import (
	unsafe "unsafe"

	corev1 "k8s.io/api/core/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	v1beta1 "sigs.k8s.io/cluster-api/bootstrap/kubeadm/api/v1beta1"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*APIEndpoint)(nil), (*v1beta1.APIEndpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_APIEndpoint_To_v1beta1_APIEndpoint(a.(*APIEndpoint), b.(*v1beta1.APIEndpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.APIEndpoint)(nil), (*APIEndpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_APIEndpoint_To_upstreamv1beta3_APIEndpoint(a.(*v1beta1.APIEndpoint), b.(*APIEndpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*APIServer)(nil), (*v1beta1.APIServer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_APIServer_To_v1beta1_APIServer(a.(*APIServer), b.(*v1beta1.APIServer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.APIServer)(nil), (*APIServer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_APIServer_To_upstreamv1beta3_APIServer(a.(*v1beta1.APIServer), b.(*APIServer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BootstrapToken)(nil), (*v1beta1.BootstrapToken)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_BootstrapToken_To_v1beta1_BootstrapToken(a.(*BootstrapToken), b.(*v1beta1.BootstrapToken), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.BootstrapToken)(nil), (*BootstrapToken)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_BootstrapToken_To_upstreamv1beta3_BootstrapToken(a.(*v1beta1.BootstrapToken), b.(*BootstrapToken), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BootstrapTokenDiscovery)(nil), (*v1beta1.BootstrapTokenDiscovery)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_BootstrapTokenDiscovery_To_v1beta1_BootstrapTokenDiscovery(a.(*BootstrapTokenDiscovery), b.(*v1beta1.BootstrapTokenDiscovery), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.BootstrapTokenDiscovery)(nil), (*BootstrapTokenDiscovery)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_BootstrapTokenDiscovery_To_upstreamv1beta3_BootstrapTokenDiscovery(a.(*v1beta1.BootstrapTokenDiscovery), b.(*BootstrapTokenDiscovery), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BootstrapTokenString)(nil), (*v1beta1.BootstrapTokenString)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_BootstrapTokenString_To_v1beta1_BootstrapTokenString(a.(*BootstrapTokenString), b.(*v1beta1.BootstrapTokenString), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.BootstrapTokenString)(nil), (*BootstrapTokenString)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_BootstrapTokenString_To_upstreamv1beta3_BootstrapTokenString(a.(*v1beta1.BootstrapTokenString), b.(*BootstrapTokenString), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterConfiguration)(nil), (*v1beta1.ClusterConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_ClusterConfiguration_To_v1beta1_ClusterConfiguration(a.(*ClusterConfiguration), b.(*v1beta1.ClusterConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ClusterConfiguration)(nil), (*ClusterConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterConfiguration_To_upstreamv1beta3_ClusterConfiguration(a.(*v1beta1.ClusterConfiguration), b.(*ClusterConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControlPlaneComponent)(nil), (*v1beta1.ControlPlaneComponent)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(a.(*ControlPlaneComponent), b.(*v1beta1.ControlPlaneComponent), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ControlPlaneComponent)(nil), (*ControlPlaneComponent)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ControlPlaneComponent_To_upstreamv1beta3_ControlPlaneComponent(a.(*v1beta1.ControlPlaneComponent), b.(*ControlPlaneComponent), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*DNS)(nil), (*v1beta1.DNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_DNS_To_v1beta1_DNS(a.(*DNS), b.(*v1beta1.DNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DNS)(nil), (*DNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DNS_To_upstreamv1beta3_DNS(a.(*v1beta1.DNS), b.(*DNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Discovery)(nil), (*v1beta1.Discovery)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_Discovery_To_v1beta1_Discovery(a.(*Discovery), b.(*v1beta1.Discovery), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Discovery)(nil), (*Discovery)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Discovery_To_upstreamv1beta3_Discovery(a.(*v1beta1.Discovery), b.(*Discovery), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Etcd)(nil), (*v1beta1.Etcd)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_Etcd_To_v1beta1_Etcd(a.(*Etcd), b.(*v1beta1.Etcd), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Etcd)(nil), (*Etcd)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Etcd_To_upstreamv1beta3_Etcd(a.(*v1beta1.Etcd), b.(*Etcd), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ExternalEtcd)(nil), (*v1beta1.ExternalEtcd)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_ExternalEtcd_To_v1beta1_ExternalEtcd(a.(*ExternalEtcd), b.(*v1beta1.ExternalEtcd), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ExternalEtcd)(nil), (*ExternalEtcd)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ExternalEtcd_To_upstreamv1beta3_ExternalEtcd(a.(*v1beta1.ExternalEtcd), b.(*ExternalEtcd), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*FileDiscovery)(nil), (*v1beta1.FileDiscovery)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_FileDiscovery_To_v1beta1_FileDiscovery(a.(*FileDiscovery), b.(*v1beta1.FileDiscovery), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.FileDiscovery)(nil), (*FileDiscovery)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_FileDiscovery_To_upstreamv1beta3_FileDiscovery(a.(*v1beta1.FileDiscovery), b.(*FileDiscovery), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*HostPathMount)(nil), (*v1beta1.HostPathMount)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_HostPathMount_To_v1beta1_HostPathMount(a.(*HostPathMount), b.(*v1beta1.HostPathMount), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.HostPathMount)(nil), (*HostPathMount)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_HostPathMount_To_upstreamv1beta3_HostPathMount(a.(*v1beta1.HostPathMount), b.(*HostPathMount), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ImageMeta)(nil), (*v1beta1.ImageMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_ImageMeta_To_v1beta1_ImageMeta(a.(*ImageMeta), b.(*v1beta1.ImageMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ImageMeta)(nil), (*ImageMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ImageMeta_To_upstreamv1beta3_ImageMeta(a.(*v1beta1.ImageMeta), b.(*ImageMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.InitConfiguration)(nil), (*InitConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_InitConfiguration_To_upstreamv1beta3_InitConfiguration(a.(*v1beta1.InitConfiguration), b.(*InitConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.JoinConfiguration)(nil), (*JoinConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_JoinConfiguration_To_upstreamv1beta3_JoinConfiguration(a.(*v1beta1.JoinConfiguration), b.(*JoinConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.JoinControlPlane)(nil), (*JoinControlPlane)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_JoinControlPlane_To_upstreamv1beta3_JoinControlPlane(a.(*v1beta1.JoinControlPlane), b.(*JoinControlPlane), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LocalEtcd)(nil), (*v1beta1.LocalEtcd)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_LocalEtcd_To_v1beta1_LocalEtcd(a.(*LocalEtcd), b.(*v1beta1.LocalEtcd), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.LocalEtcd)(nil), (*LocalEtcd)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_LocalEtcd_To_upstreamv1beta3_LocalEtcd(a.(*v1beta1.LocalEtcd), b.(*LocalEtcd), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Networking)(nil), (*v1beta1.Networking)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_Networking_To_v1beta1_Networking(a.(*Networking), b.(*v1beta1.Networking), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Networking)(nil), (*Networking)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Networking_To_upstreamv1beta3_Networking(a.(*v1beta1.Networking), b.(*Networking), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.NodeRegistrationOptions)(nil), (*NodeRegistrationOptions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_NodeRegistrationOptions_To_upstreamv1beta3_NodeRegistrationOptions(a.(*v1beta1.NodeRegistrationOptions), b.(*NodeRegistrationOptions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*InitConfiguration)(nil), (*v1beta1.InitConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_InitConfiguration_To_v1beta1_InitConfiguration(a.(*InitConfiguration), b.(*v1beta1.InitConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*JoinConfiguration)(nil), (*v1beta1.JoinConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_JoinConfiguration_To_v1beta1_JoinConfiguration(a.(*JoinConfiguration), b.(*v1beta1.JoinConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*JoinControlPlane)(nil), (*v1beta1.JoinControlPlane)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_JoinControlPlane_To_v1beta1_JoinControlPlane(a.(*JoinControlPlane), b.(*v1beta1.JoinControlPlane), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*NodeRegistrationOptions)(nil), (*v1beta1.NodeRegistrationOptions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_upstreamv1beta3_NodeRegistrationOptions_To_v1beta1_NodeRegistrationOptions(a.(*NodeRegistrationOptions), b.(*v1beta1.NodeRegistrationOptions), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_upstreamv1beta3_APIEndpoint_To_v1beta1_APIEndpoint(in *APIEndpoint, out *v1beta1.APIEndpoint, s conversion.Scope) error {
	out.AdvertiseAddress = in.AdvertiseAddress
	out.BindPort = in.BindPort
	return nil
}

// Convert_upstreamv1beta3_APIEndpoint_To_v1beta1_APIEndpoint is an autogenerated conversion function.
func Convert_upstreamv1beta3_APIEndpoint_To_v1beta1_APIEndpoint(in *APIEndpoint, out *v1beta1.APIEndpoint, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_APIEndpoint_To_v1beta1_APIEndpoint(in, out, s)
}

func autoConvert_v1beta1_APIEndpoint_To_upstreamv1beta3_APIEndpoint(in *v1beta1.APIEndpoint, out *APIEndpoint, s conversion.Scope) error {
	out.AdvertiseAddress = in.AdvertiseAddress
	out.BindPort = in.BindPort
	return nil
}

// Convert_v1beta1_APIEndpoint_To_upstreamv1beta3_APIEndpoint is an autogenerated conversion function.
func Convert_v1beta1_APIEndpoint_To_upstreamv1beta3_APIEndpoint(in *v1beta1.APIEndpoint, out *APIEndpoint, s conversion.Scope) error {
	return autoConvert_v1beta1_APIEndpoint_To_upstreamv1beta3_APIEndpoint(in, out, s)
}

func autoConvert_upstreamv1beta3_APIServer_To_v1beta1_APIServer(in *APIServer, out *v1beta1.APIServer, s conversion.Scope) error {
	if err := Convert_upstreamv1beta3_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(&in.ControlPlaneComponent, &out.ControlPlaneComponent, s); err != nil {
		return err
	}
	out.CertSANs = *(*[]string)(unsafe.Pointer(&in.CertSANs))
	out.TimeoutForControlPlane = (*v1.Duration)(unsafe.Pointer(in.TimeoutForControlPlane))
	return nil
}

// Convert_upstreamv1beta3_APIServer_To_v1beta1_APIServer is an autogenerated conversion function.
func Convert_upstreamv1beta3_APIServer_To_v1beta1_APIServer(in *APIServer, out *v1beta1.APIServer, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_APIServer_To_v1beta1_APIServer(in, out, s)
}

func autoConvert_v1beta1_APIServer_To_upstreamv1beta3_APIServer(in *v1beta1.APIServer, out *APIServer, s conversion.Scope) error {
	if err := Convert_v1beta1_ControlPlaneComponent_To_upstreamv1beta3_ControlPlaneComponent(&in.ControlPlaneComponent, &out.ControlPlaneComponent, s); err != nil {
		return err
	}
	out.CertSANs = *(*[]string)(unsafe.Pointer(&in.CertSANs))
	out.TimeoutForControlPlane = (*v1.Duration)(unsafe.Pointer(in.TimeoutForControlPlane))
	return nil
}

// Convert_v1beta1_APIServer_To_upstreamv1beta3_APIServer is an autogenerated conversion function.
func Convert_v1beta1_APIServer_To_upstreamv1beta3_APIServer(in *v1beta1.APIServer, out *APIServer, s conversion.Scope) error {
	return autoConvert_v1beta1_APIServer_To_upstreamv1beta3_APIServer(in, out, s)
}

func autoConvert_upstreamv1beta3_BootstrapToken_To_v1beta1_BootstrapToken(in *BootstrapToken, out *v1beta1.BootstrapToken, s conversion.Scope) error {
	out.Token = (*v1beta1.BootstrapTokenString)(unsafe.Pointer(in.Token))
	out.Description = in.Description
	out.TTL = (*v1.Duration)(unsafe.Pointer(in.TTL))
	out.Expires = (*v1.Time)(unsafe.Pointer(in.Expires))
	out.Usages = *(*[]string)(unsafe.Pointer(&in.Usages))
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	return nil
}

// Convert_upstreamv1beta3_BootstrapToken_To_v1beta1_BootstrapToken is an autogenerated conversion function.
func Convert_upstreamv1beta3_BootstrapToken_To_v1beta1_BootstrapToken(in *BootstrapToken, out *v1beta1.BootstrapToken, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_BootstrapToken_To_v1beta1_BootstrapToken(in, out, s)
}

func autoConvert_v1beta1_BootstrapToken_To_upstreamv1beta3_BootstrapToken(in *v1beta1.BootstrapToken, out *BootstrapToken, s conversion.Scope) error {
	out.Token = (*BootstrapTokenString)(unsafe.Pointer(in.Token))
	out.Description = in.Description
	out.TTL = (*v1.Duration)(unsafe.Pointer(in.TTL))
	out.Expires = (*v1.Time)(unsafe.Pointer(in.Expires))
	out.Usages = *(*[]string)(unsafe.Pointer(&in.Usages))
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	return nil
}

// Convert_v1beta1_BootstrapToken_To_upstreamv1beta3_BootstrapToken is an autogenerated conversion function.
func Convert_v1beta1_BootstrapToken_To_upstreamv1beta3_BootstrapToken(in *v1beta1.BootstrapToken, out *BootstrapToken, s conversion.Scope) error {
	return autoConvert_v1beta1_BootstrapToken_To_upstreamv1beta3_BootstrapToken(in, out, s)
}

func autoConvert_upstreamv1beta3_BootstrapTokenDiscovery_To_v1beta1_BootstrapTokenDiscovery(in *BootstrapTokenDiscovery, out *v1beta1.BootstrapTokenDiscovery, s conversion.Scope) error {
	out.Token = in.Token
	out.APIServerEndpoint = in.APIServerEndpoint
	out.CACertHashes = *(*[]string)(unsafe.Pointer(&in.CACertHashes))
	out.UnsafeSkipCAVerification = in.UnsafeSkipCAVerification
	return nil
}

// Convert_upstreamv1beta3_BootstrapTokenDiscovery_To_v1beta1_BootstrapTokenDiscovery is an autogenerated conversion function.
func Convert_upstreamv1beta3_BootstrapTokenDiscovery_To_v1beta1_BootstrapTokenDiscovery(in *BootstrapTokenDiscovery, out *v1beta1.BootstrapTokenDiscovery, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_BootstrapTokenDiscovery_To_v1beta1_BootstrapTokenDiscovery(in, out, s)
}

func autoConvert_v1beta1_BootstrapTokenDiscovery_To_upstreamv1beta3_BootstrapTokenDiscovery(in *v1beta1.BootstrapTokenDiscovery, out *BootstrapTokenDiscovery, s conversion.Scope) error {
	out.Token = in.Token
	out.APIServerEndpoint = in.APIServerEndpoint
	out.CACertHashes = *(*[]string)(unsafe.Pointer(&in.CACertHashes))
	out.UnsafeSkipCAVerification = in.UnsafeSkipCAVerification
	return nil
}

// Convert_v1beta1_BootstrapTokenDiscovery_To_upstreamv1beta3_BootstrapTokenDiscovery is an autogenerated conversion function.
func Convert_v1beta1_BootstrapTokenDiscovery_To_upstreamv1beta3_BootstrapTokenDiscovery(in *v1beta1.BootstrapTokenDiscovery, out *BootstrapTokenDiscovery, s conversion.Scope) error {
	return autoConvert_v1beta1_BootstrapTokenDiscovery_To_upstreamv1beta3_BootstrapTokenDiscovery(in, out, s)
}

func autoConvert_upstreamv1beta3_BootstrapTokenString_To_v1beta1_BootstrapTokenString(in *BootstrapTokenString, out *v1beta1.BootstrapTokenString, s conversion.Scope) error {
	out.ID = in.ID
	out.Secret = in.Secret
	return nil
}

// Convert_upstreamv1beta3_BootstrapTokenString_To_v1beta1_BootstrapTokenString is an autogenerated conversion function.
func Convert_upstreamv1beta3_BootstrapTokenString_To_v1beta1_BootstrapTokenString(in *BootstrapTokenString, out *v1beta1.BootstrapTokenString, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_BootstrapTokenString_To_v1beta1_BootstrapTokenString(in, out, s)
}

func autoConvert_v1beta1_BootstrapTokenString_To_upstreamv1beta3_BootstrapTokenString(in *v1beta1.BootstrapTokenString, out *BootstrapTokenString, s conversion.Scope) error {
	out.ID = in.ID
	out.Secret = in.Secret
	return nil
}

// Convert_v1beta1_BootstrapTokenString_To_upstreamv1beta3_BootstrapTokenString is an autogenerated conversion function.
func Convert_v1beta1_BootstrapTokenString_To_upstreamv1beta3_BootstrapTokenString(in *v1beta1.BootstrapTokenString, out *BootstrapTokenString, s conversion.Scope) error {
	return autoConvert_v1beta1_BootstrapTokenString_To_upstreamv1beta3_BootstrapTokenString(in, out, s)
}

func autoConvert_upstreamv1beta3_ClusterConfiguration_To_v1beta1_ClusterConfiguration(in *ClusterConfiguration, out *v1beta1.ClusterConfiguration, s conversion.Scope) error {
	if err := Convert_upstreamv1beta3_Etcd_To_v1beta1_Etcd(&in.Etcd, &out.Etcd, s); err != nil {
		return err
	}
	if err := Convert_upstreamv1beta3_Networking_To_v1beta1_Networking(&in.Networking, &out.Networking, s); err != nil {
		return err
	}
	out.KubernetesVersion = in.KubernetesVersion
	out.ControlPlaneEndpoint = in.ControlPlaneEndpoint
	if err := Convert_upstreamv1beta3_APIServer_To_v1beta1_APIServer(&in.APIServer, &out.APIServer, s); err != nil {
		return err
	}
	if err := Convert_upstreamv1beta3_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(&in.ControllerManager, &out.ControllerManager, s); err != nil {
		return err
	}
	if err := Convert_upstreamv1beta3_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(&in.Scheduler, &out.Scheduler, s); err != nil {
		return err
	}
	if err := Convert_upstreamv1beta3_DNS_To_v1beta1_DNS(&in.DNS, &out.DNS, s); err != nil {
		return err
	}
	out.CertificatesDir = in.CertificatesDir
	out.ImageRepository = in.ImageRepository
	out.FeatureGates = *(*map[string]bool)(unsafe.Pointer(&in.FeatureGates))
	out.ClusterName = in.ClusterName
	return nil
}

// Convert_upstreamv1beta3_ClusterConfiguration_To_v1beta1_ClusterConfiguration is an autogenerated conversion function.
func Convert_upstreamv1beta3_ClusterConfiguration_To_v1beta1_ClusterConfiguration(in *ClusterConfiguration, out *v1beta1.ClusterConfiguration, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_ClusterConfiguration_To_v1beta1_ClusterConfiguration(in, out, s)
}

func autoConvert_v1beta1_ClusterConfiguration_To_upstreamv1beta3_ClusterConfiguration(in *v1beta1.ClusterConfiguration, out *ClusterConfiguration, s conversion.Scope) error {
	if err := Convert_v1beta1_Etcd_To_upstreamv1beta3_Etcd(&in.Etcd, &out.Etcd, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_Networking_To_upstreamv1beta3_Networking(&in.Networking, &out.Networking, s); err != nil {
		return err
	}
	out.KubernetesVersion = in.KubernetesVersion
	out.ControlPlaneEndpoint = in.ControlPlaneEndpoint
	if err := Convert_v1beta1_APIServer_To_upstreamv1beta3_APIServer(&in.APIServer, &out.APIServer, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_ControlPlaneComponent_To_upstreamv1beta3_ControlPlaneComponent(&in.ControllerManager, &out.ControllerManager, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_ControlPlaneComponent_To_upstreamv1beta3_ControlPlaneComponent(&in.Scheduler, &out.Scheduler, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_DNS_To_upstreamv1beta3_DNS(&in.DNS, &out.DNS, s); err != nil {
		return err
	}
	out.CertificatesDir = in.CertificatesDir
	out.ImageRepository = in.ImageRepository
	out.FeatureGates = *(*map[string]bool)(unsafe.Pointer(&in.FeatureGates))
	out.ClusterName = in.ClusterName
	return nil
}

// Convert_v1beta1_ClusterConfiguration_To_upstreamv1beta3_ClusterConfiguration is an autogenerated conversion function.
func Convert_v1beta1_ClusterConfiguration_To_upstreamv1beta3_ClusterConfiguration(in *v1beta1.ClusterConfiguration, out *ClusterConfiguration, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterConfiguration_To_upstreamv1beta3_ClusterConfiguration(in, out, s)
}

func autoConvert_upstreamv1beta3_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(in *ControlPlaneComponent, out *v1beta1.ControlPlaneComponent, s conversion.Scope) error {
	out.ExtraArgs = *(*map[string]string)(unsafe.Pointer(&in.ExtraArgs))
	out.ExtraVolumes = *(*[]v1beta1.HostPathMount)(unsafe.Pointer(&in.ExtraVolumes))
	return nil
}

// Convert_upstreamv1beta3_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent is an autogenerated conversion function.
func Convert_upstreamv1beta3_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(in *ControlPlaneComponent, out *v1beta1.ControlPlaneComponent, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(in, out, s)
}

func autoConvert_v1beta1_ControlPlaneComponent_To_upstreamv1beta3_ControlPlaneComponent(in *v1beta1.ControlPlaneComponent, out *ControlPlaneComponent, s conversion.Scope) error {
	out.ExtraArgs = *(*map[string]string)(unsafe.Pointer(&in.ExtraArgs))
	out.ExtraVolumes = *(*[]HostPathMount)(unsafe.Pointer(&in.ExtraVolumes))
	return nil
}

// Convert_v1beta1_ControlPlaneComponent_To_upstreamv1beta3_ControlPlaneComponent is an autogenerated conversion function.
func Convert_v1beta1_ControlPlaneComponent_To_upstreamv1beta3_ControlPlaneComponent(in *v1beta1.ControlPlaneComponent, out *ControlPlaneComponent, s conversion.Scope) error {
	return autoConvert_v1beta1_ControlPlaneComponent_To_upstreamv1beta3_ControlPlaneComponent(in, out, s)
}

func autoConvert_upstreamv1beta3_DNS_To_v1beta1_DNS(in *DNS, out *v1beta1.DNS, s conversion.Scope) error {
	if err := Convert_upstreamv1beta3_ImageMeta_To_v1beta1_ImageMeta(&in.ImageMeta, &out.ImageMeta, s); err != nil {
		return err
	}
	return nil
}

// Convert_upstreamv1beta3_DNS_To_v1beta1_DNS is an autogenerated conversion function.
func Convert_upstreamv1beta3_DNS_To_v1beta1_DNS(in *DNS, out *v1beta1.DNS, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_DNS_To_v1beta1_DNS(in, out, s)
}

func autoConvert_v1beta1_DNS_To_upstreamv1beta3_DNS(in *v1beta1.DNS, out *DNS, s conversion.Scope) error {
	if err := Convert_v1beta1_ImageMeta_To_upstreamv1beta3_ImageMeta(&in.ImageMeta, &out.ImageMeta, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_DNS_To_upstreamv1beta3_DNS is an autogenerated conversion function.
func Convert_v1beta1_DNS_To_upstreamv1beta3_DNS(in *v1beta1.DNS, out *DNS, s conversion.Scope) error {
	return autoConvert_v1beta1_DNS_To_upstreamv1beta3_DNS(in, out, s)
}

func autoConvert_upstreamv1beta3_Discovery_To_v1beta1_Discovery(in *Discovery, out *v1beta1.Discovery, s conversion.Scope) error {
	out.BootstrapToken = (*v1beta1.BootstrapTokenDiscovery)(unsafe.Pointer(in.BootstrapToken))
	out.File = (*v1beta1.FileDiscovery)(unsafe.Pointer(in.File))
	out.TLSBootstrapToken = in.TLSBootstrapToken
	out.Timeout = (*v1.Duration)(unsafe.Pointer(in.Timeout))
	return nil
}

// Convert_upstreamv1beta3_Discovery_To_v1beta1_Discovery is an autogenerated conversion function.
func Convert_upstreamv1beta3_Discovery_To_v1beta1_Discovery(in *Discovery, out *v1beta1.Discovery, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_Discovery_To_v1beta1_Discovery(in, out, s)
}

func autoConvert_v1beta1_Discovery_To_upstreamv1beta3_Discovery(in *v1beta1.Discovery, out *Discovery, s conversion.Scope) error {
	out.BootstrapToken = (*BootstrapTokenDiscovery)(unsafe.Pointer(in.BootstrapToken))
	out.File = (*FileDiscovery)(unsafe.Pointer(in.File))
	out.TLSBootstrapToken = in.TLSBootstrapToken
	out.Timeout = (*v1.Duration)(unsafe.Pointer(in.Timeout))
	return nil
}

// Convert_v1beta1_Discovery_To_upstreamv1beta3_Discovery is an autogenerated conversion function.
func Convert_v1beta1_Discovery_To_upstreamv1beta3_Discovery(in *v1beta1.Discovery, out *Discovery, s conversion.Scope) error {
	return autoConvert_v1beta1_Discovery_To_upstreamv1beta3_Discovery(in, out, s)
}

func autoConvert_upstreamv1beta3_Etcd_To_v1beta1_Etcd(in *Etcd, out *v1beta1.Etcd, s conversion.Scope) error {
	out.Local = (*v1beta1.LocalEtcd)(unsafe.Pointer(in.Local))
	out.External = (*v1beta1.ExternalEtcd)(unsafe.Pointer(in.External))
	return nil
}

// Convert_upstreamv1beta3_Etcd_To_v1beta1_Etcd is an autogenerated conversion function.
func Convert_upstreamv1beta3_Etcd_To_v1beta1_Etcd(in *Etcd, out *v1beta1.Etcd, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_Etcd_To_v1beta1_Etcd(in, out, s)
}

func autoConvert_v1beta1_Etcd_To_upstreamv1beta3_Etcd(in *v1beta1.Etcd, out *Etcd, s conversion.Scope) error {
	out.Local = (*LocalEtcd)(unsafe.Pointer(in.Local))
	out.External = (*ExternalEtcd)(unsafe.Pointer(in.External))
	return nil
}

// Convert_v1beta1_Etcd_To_upstreamv1beta3_Etcd is an autogenerated conversion function.
func Convert_v1beta1_Etcd_To_upstreamv1beta3_Etcd(in *v1beta1.Etcd, out *Etcd, s conversion.Scope) error {
	return autoConvert_v1beta1_Etcd_To_upstreamv1beta3_Etcd(in, out, s)
}

func autoConvert_upstreamv1beta3_ExternalEtcd_To_v1beta1_ExternalEtcd(in *ExternalEtcd, out *v1beta1.ExternalEtcd, s conversion.Scope) error {
	out.Endpoints = *(*[]string)(unsafe.Pointer(&in.Endpoints))
	out.CAFile = in.CAFile
	out.CertFile = in.CertFile
	out.KeyFile = in.KeyFile
	return nil
}

// Convert_upstreamv1beta3_ExternalEtcd_To_v1beta1_ExternalEtcd is an autogenerated conversion function.
func Convert_upstreamv1beta3_ExternalEtcd_To_v1beta1_ExternalEtcd(in *ExternalEtcd, out *v1beta1.ExternalEtcd, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_ExternalEtcd_To_v1beta1_ExternalEtcd(in, out, s)
}

func autoConvert_v1beta1_ExternalEtcd_To_upstreamv1beta3_ExternalEtcd(in *v1beta1.ExternalEtcd, out *ExternalEtcd, s conversion.Scope) error {
	out.Endpoints = *(*[]string)(unsafe.Pointer(&in.Endpoints))
	out.CAFile = in.CAFile
	out.CertFile = in.CertFile
	out.KeyFile = in.KeyFile
	return nil
}

// Convert_v1beta1_ExternalEtcd_To_upstreamv1beta3_ExternalEtcd is an autogenerated conversion function.
func Convert_v1beta1_ExternalEtcd_To_upstreamv1beta3_ExternalEtcd(in *v1beta1.ExternalEtcd, out *ExternalEtcd, s conversion.Scope) error {
	return autoConvert_v1beta1_ExternalEtcd_To_upstreamv1beta3_ExternalEtcd(in, out, s)
}

func autoConvert_upstreamv1beta3_FileDiscovery_To_v1beta1_FileDiscovery(in *FileDiscovery, out *v1beta1.FileDiscovery, s conversion.Scope) error {
	out.KubeConfigPath = in.KubeConfigPath
	return nil
}

// Convert_upstreamv1beta3_FileDiscovery_To_v1beta1_FileDiscovery is an autogenerated conversion function.
func Convert_upstreamv1beta3_FileDiscovery_To_v1beta1_FileDiscovery(in *FileDiscovery, out *v1beta1.FileDiscovery, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_FileDiscovery_To_v1beta1_FileDiscovery(in, out, s)
}

func autoConvert_v1beta1_FileDiscovery_To_upstreamv1beta3_FileDiscovery(in *v1beta1.FileDiscovery, out *FileDiscovery, s conversion.Scope) error {
	out.KubeConfigPath = in.KubeConfigPath
	return nil
}

// Convert_v1beta1_FileDiscovery_To_upstreamv1beta3_FileDiscovery is an autogenerated conversion function.
func Convert_v1beta1_FileDiscovery_To_upstreamv1beta3_FileDiscovery(in *v1beta1.FileDiscovery, out *FileDiscovery, s conversion.Scope) error {
	return autoConvert_v1beta1_FileDiscovery_To_upstreamv1beta3_FileDiscovery(in, out, s)
}

func autoConvert_upstreamv1beta3_HostPathMount_To_v1beta1_HostPathMount(in *HostPathMount, out *v1beta1.HostPathMount, s conversion.Scope) error {
	out.Name = in.Name
	out.HostPath = in.HostPath
	out.MountPath = in.MountPath
	out.ReadOnly = in.ReadOnly
	out.PathType = corev1.HostPathType(in.PathType)
	return nil
}

// Convert_upstreamv1beta3_HostPathMount_To_v1beta1_HostPathMount is an autogenerated conversion function.
func Convert_upstreamv1beta3_HostPathMount_To_v1beta1_HostPathMount(in *HostPathMount, out *v1beta1.HostPathMount, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_HostPathMount_To_v1beta1_HostPathMount(in, out, s)
}

func autoConvert_v1beta1_HostPathMount_To_upstreamv1beta3_HostPathMount(in *v1beta1.HostPathMount, out *HostPathMount, s conversion.Scope) error {
	out.Name = in.Name
	out.HostPath = in.HostPath
	out.MountPath = in.MountPath
	out.ReadOnly = in.ReadOnly
	out.PathType = corev1.HostPathType(in.PathType)
	return nil
}

// Convert_v1beta1_HostPathMount_To_upstreamv1beta3_HostPathMount is an autogenerated conversion function.
func Convert_v1beta1_HostPathMount_To_upstreamv1beta3_HostPathMount(in *v1beta1.HostPathMount, out *HostPathMount, s conversion.Scope) error {
	return autoConvert_v1beta1_HostPathMount_To_upstreamv1beta3_HostPathMount(in, out, s)
}

func autoConvert_upstreamv1beta3_ImageMeta_To_v1beta1_ImageMeta(in *ImageMeta, out *v1beta1.ImageMeta, s conversion.Scope) error {
	out.ImageRepository = in.ImageRepository
	out.ImageTag = in.ImageTag
	return nil
}

// Convert_upstreamv1beta3_ImageMeta_To_v1beta1_ImageMeta is an autogenerated conversion function.
func Convert_upstreamv1beta3_ImageMeta_To_v1beta1_ImageMeta(in *ImageMeta, out *v1beta1.ImageMeta, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_ImageMeta_To_v1beta1_ImageMeta(in, out, s)
}

func autoConvert_v1beta1_ImageMeta_To_upstreamv1beta3_ImageMeta(in *v1beta1.ImageMeta, out *ImageMeta, s conversion.Scope) error {
	out.ImageRepository = in.ImageRepository
	out.ImageTag = in.ImageTag
	return nil
}

// Convert_v1beta1_ImageMeta_To_upstreamv1beta3_ImageMeta is an autogenerated conversion function.
func Convert_v1beta1_ImageMeta_To_upstreamv1beta3_ImageMeta(in *v1beta1.ImageMeta, out *ImageMeta, s conversion.Scope) error {
	return autoConvert_v1beta1_ImageMeta_To_upstreamv1beta3_ImageMeta(in, out, s)
}

func autoConvert_upstreamv1beta3_InitConfiguration_To_v1beta1_InitConfiguration(in *InitConfiguration, out *v1beta1.InitConfiguration, s conversion.Scope) error {
	out.BootstrapTokens = *(*[]v1beta1.BootstrapToken)(unsafe.Pointer(&in.BootstrapTokens))
	if err := Convert_upstreamv1beta3_NodeRegistrationOptions_To_v1beta1_NodeRegistrationOptions(&in.NodeRegistration, &out.NodeRegistration, s); err != nil {
		return err
	}
	if err := Convert_upstreamv1beta3_APIEndpoint_To_v1beta1_APIEndpoint(&in.LocalAPIEndpoint, &out.LocalAPIEndpoint, s); err != nil {
		return err
	}
	// WARNING: in.CertificateKey requires manual conversion: does not exist in peer-type
	// WARNING: in.SkipPhases requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1beta1_InitConfiguration_To_upstreamv1beta3_InitConfiguration(in *v1beta1.InitConfiguration, out *InitConfiguration, s conversion.Scope) error {
	out.BootstrapTokens = *(*[]BootstrapToken)(unsafe.Pointer(&in.BootstrapTokens))
	if err := Convert_v1beta1_NodeRegistrationOptions_To_upstreamv1beta3_NodeRegistrationOptions(&in.NodeRegistration, &out.NodeRegistration, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_APIEndpoint_To_upstreamv1beta3_APIEndpoint(&in.LocalAPIEndpoint, &out.LocalAPIEndpoint, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_InitConfiguration_To_upstreamv1beta3_InitConfiguration is an autogenerated conversion function.
func Convert_v1beta1_InitConfiguration_To_upstreamv1beta3_InitConfiguration(in *v1beta1.InitConfiguration, out *InitConfiguration, s conversion.Scope) error {
	return autoConvert_v1beta1_InitConfiguration_To_upstreamv1beta3_InitConfiguration(in, out, s)
}

func autoConvert_upstreamv1beta3_JoinConfiguration_To_v1beta1_JoinConfiguration(in *JoinConfiguration, out *v1beta1.JoinConfiguration, s conversion.Scope) error {
	if err := Convert_upstreamv1beta3_NodeRegistrationOptions_To_v1beta1_NodeRegistrationOptions(&in.NodeRegistration, &out.NodeRegistration, s); err != nil {
		return err
	}
	out.CACertPath = in.CACertPath
	if err := Convert_upstreamv1beta3_Discovery_To_v1beta1_Discovery(&in.Discovery, &out.Discovery, s); err != nil {
		return err
	}
	if in.ControlPlane != nil {
		in, out := &in.ControlPlane, &out.ControlPlane
		*out = new(v1beta1.JoinControlPlane)
		if err := Convert_upstreamv1beta3_JoinControlPlane_To_v1beta1_JoinControlPlane(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ControlPlane = nil
	}
	// WARNING: in.SkipPhases requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1beta1_JoinConfiguration_To_upstreamv1beta3_JoinConfiguration(in *v1beta1.JoinConfiguration, out *JoinConfiguration, s conversion.Scope) error {
	if err := Convert_v1beta1_NodeRegistrationOptions_To_upstreamv1beta3_NodeRegistrationOptions(&in.NodeRegistration, &out.NodeRegistration, s); err != nil {
		return err
	}
	out.CACertPath = in.CACertPath
	if err := Convert_v1beta1_Discovery_To_upstreamv1beta3_Discovery(&in.Discovery, &out.Discovery, s); err != nil {
		return err
	}
	if in.ControlPlane != nil {
		in, out := &in.ControlPlane, &out.ControlPlane
		*out = new(JoinControlPlane)
		if err := Convert_v1beta1_JoinControlPlane_To_upstreamv1beta3_JoinControlPlane(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ControlPlane = nil
	}
	return nil
}

// Convert_v1beta1_JoinConfiguration_To_upstreamv1beta3_JoinConfiguration is an autogenerated conversion function.
func Convert_v1beta1_JoinConfiguration_To_upstreamv1beta3_JoinConfiguration(in *v1beta1.JoinConfiguration, out *JoinConfiguration, s conversion.Scope) error {
	return autoConvert_v1beta1_JoinConfiguration_To_upstreamv1beta3_JoinConfiguration(in, out, s)
}

func autoConvert_upstreamv1beta3_JoinControlPlane_To_v1beta1_JoinControlPlane(in *JoinControlPlane, out *v1beta1.JoinControlPlane, s conversion.Scope) error {
	if err := Convert_upstreamv1beta3_APIEndpoint_To_v1beta1_APIEndpoint(&in.LocalAPIEndpoint, &out.LocalAPIEndpoint, s); err != nil {
		return err
	}
	// WARNING: in.CertificateKey requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1beta1_JoinControlPlane_To_upstreamv1beta3_JoinControlPlane(in *v1beta1.JoinControlPlane, out *JoinControlPlane, s conversion.Scope) error {
	if err := Convert_v1beta1_APIEndpoint_To_upstreamv1beta3_APIEndpoint(&in.LocalAPIEndpoint, &out.LocalAPIEndpoint, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_JoinControlPlane_To_upstreamv1beta3_JoinControlPlane is an autogenerated conversion function.
func Convert_v1beta1_JoinControlPlane_To_upstreamv1beta3_JoinControlPlane(in *v1beta1.JoinControlPlane, out *JoinControlPlane, s conversion.Scope) error {
	return autoConvert_v1beta1_JoinControlPlane_To_upstreamv1beta3_JoinControlPlane(in, out, s)
}

func autoConvert_upstreamv1beta3_LocalEtcd_To_v1beta1_LocalEtcd(in *LocalEtcd, out *v1beta1.LocalEtcd, s conversion.Scope) error {
	if err := Convert_upstreamv1beta3_ImageMeta_To_v1beta1_ImageMeta(&in.ImageMeta, &out.ImageMeta, s); err != nil {
		return err
	}
	out.DataDir = in.DataDir
	out.ExtraArgs = *(*map[string]string)(unsafe.Pointer(&in.ExtraArgs))
	out.ServerCertSANs = *(*[]string)(unsafe.Pointer(&in.ServerCertSANs))
	out.PeerCertSANs = *(*[]string)(unsafe.Pointer(&in.PeerCertSANs))
	return nil
}

// Convert_upstreamv1beta3_LocalEtcd_To_v1beta1_LocalEtcd is an autogenerated conversion function.
func Convert_upstreamv1beta3_LocalEtcd_To_v1beta1_LocalEtcd(in *LocalEtcd, out *v1beta1.LocalEtcd, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_LocalEtcd_To_v1beta1_LocalEtcd(in, out, s)
}

func autoConvert_v1beta1_LocalEtcd_To_upstreamv1beta3_LocalEtcd(in *v1beta1.LocalEtcd, out *LocalEtcd, s conversion.Scope) error {
	if err := Convert_v1beta1_ImageMeta_To_upstreamv1beta3_ImageMeta(&in.ImageMeta, &out.ImageMeta, s); err != nil {
		return err
	}
	out.DataDir = in.DataDir
	out.ExtraArgs = *(*map[string]string)(unsafe.Pointer(&in.ExtraArgs))
	out.ServerCertSANs = *(*[]string)(unsafe.Pointer(&in.ServerCertSANs))
	out.PeerCertSANs = *(*[]string)(unsafe.Pointer(&in.PeerCertSANs))
	return nil
}

// Convert_v1beta1_LocalEtcd_To_upstreamv1beta3_LocalEtcd is an autogenerated conversion function.
func Convert_v1beta1_LocalEtcd_To_upstreamv1beta3_LocalEtcd(in *v1beta1.LocalEtcd, out *LocalEtcd, s conversion.Scope) error {
	return autoConvert_v1beta1_LocalEtcd_To_upstreamv1beta3_LocalEtcd(in, out, s)
}

func autoConvert_upstreamv1beta3_Networking_To_v1beta1_Networking(in *Networking, out *v1beta1.Networking, s conversion.Scope) error {
	out.ServiceSubnet = in.ServiceSubnet
	out.PodSubnet = in.PodSubnet
	out.DNSDomain = in.DNSDomain
	return nil
}

// Convert_upstreamv1beta3_Networking_To_v1beta1_Networking is an autogenerated conversion function.
func Convert_upstreamv1beta3_Networking_To_v1beta1_Networking(in *Networking, out *v1beta1.Networking, s conversion.Scope) error {
	return autoConvert_upstreamv1beta3_Networking_To_v1beta1_Networking(in, out, s)
}

func autoConvert_v1beta1_Networking_To_upstreamv1beta3_Networking(in *v1beta1.Networking, out *Networking, s conversion.Scope) error {
	out.ServiceSubnet = in.ServiceSubnet
	out.PodSubnet = in.PodSubnet
	out.DNSDomain = in.DNSDomain
	return nil
}

// Convert_v1beta1_Networking_To_upstreamv1beta3_Networking is an autogenerated conversion function.
func Convert_v1beta1_Networking_To_upstreamv1beta3_Networking(in *v1beta1.Networking, out *Networking, s conversion.Scope) error {
	return autoConvert_v1beta1_Networking_To_upstreamv1beta3_Networking(in, out, s)
}

func autoConvert_upstreamv1beta3_NodeRegistrationOptions_To_v1beta1_NodeRegistrationOptions(in *NodeRegistrationOptions, out *v1beta1.NodeRegistrationOptions, s conversion.Scope) error {
	out.Name = in.Name
	out.CRISocket = in.CRISocket
	out.Taints = *(*[]corev1.Taint)(unsafe.Pointer(&in.Taints))
	out.KubeletExtraArgs = *(*map[string]string)(unsafe.Pointer(&in.KubeletExtraArgs))
	out.IgnorePreflightErrors = *(*[]string)(unsafe.Pointer(&in.IgnorePreflightErrors))
	return nil
}

func autoConvert_v1beta1_NodeRegistrationOptions_To_upstreamv1beta3_NodeRegistrationOptions(in *v1beta1.NodeRegistrationOptions, out *NodeRegistrationOptions, s conversion.Scope) error {
	out.Name = in.Name
	out.CRISocket = in.CRISocket
	out.Taints = *(*[]corev1.Taint)(unsafe.Pointer(&in.Taints))
	out.KubeletExtraArgs = *(*map[string]string)(unsafe.Pointer(&in.KubeletExtraArgs))
	out.IgnorePreflightErrors = *(*[]string)(unsafe.Pointer(&in.IgnorePreflightErrors))
	return nil
}

// Convert_v1beta1_NodeRegistrationOptions_To_upstreamv1beta3_NodeRegistrationOptions is an autogenerated conversion function.
func Convert_v1beta1_NodeRegistrationOptions_To_upstreamv1beta3_NodeRegistrationOptions(in *v1beta1.NodeRegistrationOptions, out *NodeRegistrationOptions, s conversion.Scope) error {
	return autoConvert_v1beta1_NodeRegistrationOptions_To_upstreamv1beta3_NodeRegistrationOptions(in, out, s)
}
