// +build !ignore_autogenerated_core

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha4

import (
	unsafe "unsafe"

	v1 "k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
	v1beta1 "sigs.k8s.io/cluster-api/api/v1beta1"
	errors "sigs.k8s.io/cluster-api/errors"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*APIEndpoint)(nil), (*v1beta1.APIEndpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint(a.(*APIEndpoint), b.(*v1beta1.APIEndpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.APIEndpoint)(nil), (*APIEndpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint(a.(*v1beta1.APIEndpoint), b.(*APIEndpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Bootstrap)(nil), (*v1beta1.Bootstrap)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_Bootstrap_To_v1beta1_Bootstrap(a.(*Bootstrap), b.(*v1beta1.Bootstrap), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Bootstrap)(nil), (*Bootstrap)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Bootstrap_To_v1alpha4_Bootstrap(a.(*v1beta1.Bootstrap), b.(*Bootstrap), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Cluster)(nil), (*v1beta1.Cluster)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_Cluster_To_v1beta1_Cluster(a.(*Cluster), b.(*v1beta1.Cluster), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Cluster)(nil), (*Cluster)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Cluster_To_v1alpha4_Cluster(a.(*v1beta1.Cluster), b.(*Cluster), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterClass)(nil), (*v1beta1.ClusterClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ClusterClass_To_v1beta1_ClusterClass(a.(*ClusterClass), b.(*v1beta1.ClusterClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ClusterClass)(nil), (*ClusterClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterClass_To_v1alpha4_ClusterClass(a.(*v1beta1.ClusterClass), b.(*ClusterClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterClassList)(nil), (*v1beta1.ClusterClassList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ClusterClassList_To_v1beta1_ClusterClassList(a.(*ClusterClassList), b.(*v1beta1.ClusterClassList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ClusterClassList)(nil), (*ClusterClassList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterClassList_To_v1alpha4_ClusterClassList(a.(*v1beta1.ClusterClassList), b.(*ClusterClassList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterClassSpec)(nil), (*v1beta1.ClusterClassSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ClusterClassSpec_To_v1beta1_ClusterClassSpec(a.(*ClusterClassSpec), b.(*v1beta1.ClusterClassSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ClusterClassSpec)(nil), (*ClusterClassSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterClassSpec_To_v1alpha4_ClusterClassSpec(a.(*v1beta1.ClusterClassSpec), b.(*ClusterClassSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterList)(nil), (*v1beta1.ClusterList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ClusterList_To_v1beta1_ClusterList(a.(*ClusterList), b.(*v1beta1.ClusterList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ClusterList)(nil), (*ClusterList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterList_To_v1alpha4_ClusterList(a.(*v1beta1.ClusterList), b.(*ClusterList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterNetwork)(nil), (*v1beta1.ClusterNetwork)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ClusterNetwork_To_v1beta1_ClusterNetwork(a.(*ClusterNetwork), b.(*v1beta1.ClusterNetwork), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ClusterNetwork)(nil), (*ClusterNetwork)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterNetwork_To_v1alpha4_ClusterNetwork(a.(*v1beta1.ClusterNetwork), b.(*ClusterNetwork), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterSpec)(nil), (*v1beta1.ClusterSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ClusterSpec_To_v1beta1_ClusterSpec(a.(*ClusterSpec), b.(*v1beta1.ClusterSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ClusterSpec)(nil), (*ClusterSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterSpec_To_v1alpha4_ClusterSpec(a.(*v1beta1.ClusterSpec), b.(*ClusterSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterStatus)(nil), (*v1beta1.ClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ClusterStatus_To_v1beta1_ClusterStatus(a.(*ClusterStatus), b.(*v1beta1.ClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ClusterStatus)(nil), (*ClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterStatus_To_v1alpha4_ClusterStatus(a.(*v1beta1.ClusterStatus), b.(*ClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Condition)(nil), (*v1beta1.Condition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_Condition_To_v1beta1_Condition(a.(*Condition), b.(*v1beta1.Condition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Condition)(nil), (*Condition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Condition_To_v1alpha4_Condition(a.(*v1beta1.Condition), b.(*Condition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControlPlaneClass)(nil), (*v1beta1.ControlPlaneClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ControlPlaneClass_To_v1beta1_ControlPlaneClass(a.(*ControlPlaneClass), b.(*v1beta1.ControlPlaneClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ControlPlaneClass)(nil), (*ControlPlaneClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ControlPlaneClass_To_v1alpha4_ControlPlaneClass(a.(*v1beta1.ControlPlaneClass), b.(*ControlPlaneClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControlPlaneTopology)(nil), (*v1beta1.ControlPlaneTopology)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ControlPlaneTopology_To_v1beta1_ControlPlaneTopology(a.(*ControlPlaneTopology), b.(*v1beta1.ControlPlaneTopology), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ControlPlaneTopology)(nil), (*ControlPlaneTopology)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ControlPlaneTopology_To_v1alpha4_ControlPlaneTopology(a.(*v1beta1.ControlPlaneTopology), b.(*ControlPlaneTopology), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*FailureDomainSpec)(nil), (*v1beta1.FailureDomainSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_FailureDomainSpec_To_v1beta1_FailureDomainSpec(a.(*FailureDomainSpec), b.(*v1beta1.FailureDomainSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.FailureDomainSpec)(nil), (*FailureDomainSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_FailureDomainSpec_To_v1alpha4_FailureDomainSpec(a.(*v1beta1.FailureDomainSpec), b.(*FailureDomainSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LocalObjectTemplate)(nil), (*v1beta1.LocalObjectTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_LocalObjectTemplate_To_v1beta1_LocalObjectTemplate(a.(*LocalObjectTemplate), b.(*v1beta1.LocalObjectTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.LocalObjectTemplate)(nil), (*LocalObjectTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_LocalObjectTemplate_To_v1alpha4_LocalObjectTemplate(a.(*v1beta1.LocalObjectTemplate), b.(*LocalObjectTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Machine)(nil), (*v1beta1.Machine)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_Machine_To_v1beta1_Machine(a.(*Machine), b.(*v1beta1.Machine), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Machine)(nil), (*Machine)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Machine_To_v1alpha4_Machine(a.(*v1beta1.Machine), b.(*Machine), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineAddress)(nil), (*v1beta1.MachineAddress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineAddress_To_v1beta1_MachineAddress(a.(*MachineAddress), b.(*v1beta1.MachineAddress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineAddress)(nil), (*MachineAddress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineAddress_To_v1alpha4_MachineAddress(a.(*v1beta1.MachineAddress), b.(*MachineAddress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeployment)(nil), (*v1beta1.MachineDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineDeployment_To_v1beta1_MachineDeployment(a.(*MachineDeployment), b.(*v1beta1.MachineDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineDeployment)(nil), (*MachineDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeployment_To_v1alpha4_MachineDeployment(a.(*v1beta1.MachineDeployment), b.(*MachineDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeploymentClass)(nil), (*v1beta1.MachineDeploymentClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineDeploymentClass_To_v1beta1_MachineDeploymentClass(a.(*MachineDeploymentClass), b.(*v1beta1.MachineDeploymentClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineDeploymentClass)(nil), (*MachineDeploymentClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeploymentClass_To_v1alpha4_MachineDeploymentClass(a.(*v1beta1.MachineDeploymentClass), b.(*MachineDeploymentClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeploymentClassTemplate)(nil), (*v1beta1.MachineDeploymentClassTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineDeploymentClassTemplate_To_v1beta1_MachineDeploymentClassTemplate(a.(*MachineDeploymentClassTemplate), b.(*v1beta1.MachineDeploymentClassTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineDeploymentClassTemplate)(nil), (*MachineDeploymentClassTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeploymentClassTemplate_To_v1alpha4_MachineDeploymentClassTemplate(a.(*v1beta1.MachineDeploymentClassTemplate), b.(*MachineDeploymentClassTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeploymentList)(nil), (*v1beta1.MachineDeploymentList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineDeploymentList_To_v1beta1_MachineDeploymentList(a.(*MachineDeploymentList), b.(*v1beta1.MachineDeploymentList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineDeploymentList)(nil), (*MachineDeploymentList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeploymentList_To_v1alpha4_MachineDeploymentList(a.(*v1beta1.MachineDeploymentList), b.(*MachineDeploymentList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeploymentSpec)(nil), (*v1beta1.MachineDeploymentSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineDeploymentSpec_To_v1beta1_MachineDeploymentSpec(a.(*MachineDeploymentSpec), b.(*v1beta1.MachineDeploymentSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineDeploymentSpec)(nil), (*MachineDeploymentSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeploymentSpec_To_v1alpha4_MachineDeploymentSpec(a.(*v1beta1.MachineDeploymentSpec), b.(*MachineDeploymentSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeploymentStatus)(nil), (*v1beta1.MachineDeploymentStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineDeploymentStatus_To_v1beta1_MachineDeploymentStatus(a.(*MachineDeploymentStatus), b.(*v1beta1.MachineDeploymentStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineDeploymentStatus)(nil), (*MachineDeploymentStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeploymentStatus_To_v1alpha4_MachineDeploymentStatus(a.(*v1beta1.MachineDeploymentStatus), b.(*MachineDeploymentStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeploymentStrategy)(nil), (*v1beta1.MachineDeploymentStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineDeploymentStrategy_To_v1beta1_MachineDeploymentStrategy(a.(*MachineDeploymentStrategy), b.(*v1beta1.MachineDeploymentStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineDeploymentStrategy)(nil), (*MachineDeploymentStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeploymentStrategy_To_v1alpha4_MachineDeploymentStrategy(a.(*v1beta1.MachineDeploymentStrategy), b.(*MachineDeploymentStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineDeploymentTopology)(nil), (*v1beta1.MachineDeploymentTopology)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineDeploymentTopology_To_v1beta1_MachineDeploymentTopology(a.(*MachineDeploymentTopology), b.(*v1beta1.MachineDeploymentTopology), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineDeploymentTopology)(nil), (*MachineDeploymentTopology)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineDeploymentTopology_To_v1alpha4_MachineDeploymentTopology(a.(*v1beta1.MachineDeploymentTopology), b.(*MachineDeploymentTopology), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineHealthCheck)(nil), (*v1beta1.MachineHealthCheck)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineHealthCheck_To_v1beta1_MachineHealthCheck(a.(*MachineHealthCheck), b.(*v1beta1.MachineHealthCheck), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineHealthCheck)(nil), (*MachineHealthCheck)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineHealthCheck_To_v1alpha4_MachineHealthCheck(a.(*v1beta1.MachineHealthCheck), b.(*MachineHealthCheck), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineHealthCheckList)(nil), (*v1beta1.MachineHealthCheckList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineHealthCheckList_To_v1beta1_MachineHealthCheckList(a.(*MachineHealthCheckList), b.(*v1beta1.MachineHealthCheckList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineHealthCheckList)(nil), (*MachineHealthCheckList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineHealthCheckList_To_v1alpha4_MachineHealthCheckList(a.(*v1beta1.MachineHealthCheckList), b.(*MachineHealthCheckList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineHealthCheckSpec)(nil), (*v1beta1.MachineHealthCheckSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineHealthCheckSpec_To_v1beta1_MachineHealthCheckSpec(a.(*MachineHealthCheckSpec), b.(*v1beta1.MachineHealthCheckSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineHealthCheckSpec)(nil), (*MachineHealthCheckSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineHealthCheckSpec_To_v1alpha4_MachineHealthCheckSpec(a.(*v1beta1.MachineHealthCheckSpec), b.(*MachineHealthCheckSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineHealthCheckStatus)(nil), (*v1beta1.MachineHealthCheckStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineHealthCheckStatus_To_v1beta1_MachineHealthCheckStatus(a.(*MachineHealthCheckStatus), b.(*v1beta1.MachineHealthCheckStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineHealthCheckStatus)(nil), (*MachineHealthCheckStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineHealthCheckStatus_To_v1alpha4_MachineHealthCheckStatus(a.(*v1beta1.MachineHealthCheckStatus), b.(*MachineHealthCheckStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineList)(nil), (*v1beta1.MachineList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineList_To_v1beta1_MachineList(a.(*MachineList), b.(*v1beta1.MachineList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineList)(nil), (*MachineList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineList_To_v1alpha4_MachineList(a.(*v1beta1.MachineList), b.(*MachineList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineRollingUpdateDeployment)(nil), (*v1beta1.MachineRollingUpdateDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineRollingUpdateDeployment_To_v1beta1_MachineRollingUpdateDeployment(a.(*MachineRollingUpdateDeployment), b.(*v1beta1.MachineRollingUpdateDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineRollingUpdateDeployment)(nil), (*MachineRollingUpdateDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineRollingUpdateDeployment_To_v1alpha4_MachineRollingUpdateDeployment(a.(*v1beta1.MachineRollingUpdateDeployment), b.(*MachineRollingUpdateDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineSet)(nil), (*v1beta1.MachineSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineSet_To_v1beta1_MachineSet(a.(*MachineSet), b.(*v1beta1.MachineSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineSet)(nil), (*MachineSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineSet_To_v1alpha4_MachineSet(a.(*v1beta1.MachineSet), b.(*MachineSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineSetList)(nil), (*v1beta1.MachineSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineSetList_To_v1beta1_MachineSetList(a.(*MachineSetList), b.(*v1beta1.MachineSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineSetList)(nil), (*MachineSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineSetList_To_v1alpha4_MachineSetList(a.(*v1beta1.MachineSetList), b.(*MachineSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineSetSpec)(nil), (*v1beta1.MachineSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineSetSpec_To_v1beta1_MachineSetSpec(a.(*MachineSetSpec), b.(*v1beta1.MachineSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineSetSpec)(nil), (*MachineSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineSetSpec_To_v1alpha4_MachineSetSpec(a.(*v1beta1.MachineSetSpec), b.(*MachineSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineSetStatus)(nil), (*v1beta1.MachineSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineSetStatus_To_v1beta1_MachineSetStatus(a.(*MachineSetStatus), b.(*v1beta1.MachineSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineSetStatus)(nil), (*MachineSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineSetStatus_To_v1alpha4_MachineSetStatus(a.(*v1beta1.MachineSetStatus), b.(*MachineSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineSpec)(nil), (*v1beta1.MachineSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineSpec_To_v1beta1_MachineSpec(a.(*MachineSpec), b.(*v1beta1.MachineSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineSpec)(nil), (*MachineSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineSpec_To_v1alpha4_MachineSpec(a.(*v1beta1.MachineSpec), b.(*MachineSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineStatus)(nil), (*MachineStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineStatus_To_v1alpha4_MachineStatus(a.(*v1beta1.MachineStatus), b.(*MachineStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MachineTemplateSpec)(nil), (*v1beta1.MachineTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec(a.(*MachineTemplateSpec), b.(*v1beta1.MachineTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.MachineTemplateSpec)(nil), (*MachineTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_MachineTemplateSpec_To_v1alpha4_MachineTemplateSpec(a.(*v1beta1.MachineTemplateSpec), b.(*MachineTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*NetworkRanges)(nil), (*v1beta1.NetworkRanges)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_NetworkRanges_To_v1beta1_NetworkRanges(a.(*NetworkRanges), b.(*v1beta1.NetworkRanges), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.NetworkRanges)(nil), (*NetworkRanges)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_NetworkRanges_To_v1alpha4_NetworkRanges(a.(*v1beta1.NetworkRanges), b.(*NetworkRanges), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ObjectMeta)(nil), (*v1beta1.ObjectMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ObjectMeta_To_v1beta1_ObjectMeta(a.(*ObjectMeta), b.(*v1beta1.ObjectMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ObjectMeta)(nil), (*ObjectMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ObjectMeta_To_v1alpha4_ObjectMeta(a.(*v1beta1.ObjectMeta), b.(*ObjectMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Topology)(nil), (*v1beta1.Topology)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_Topology_To_v1beta1_Topology(a.(*Topology), b.(*v1beta1.Topology), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Topology)(nil), (*Topology)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Topology_To_v1alpha4_Topology(a.(*v1beta1.Topology), b.(*Topology), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*UnhealthyCondition)(nil), (*v1beta1.UnhealthyCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_UnhealthyCondition_To_v1beta1_UnhealthyCondition(a.(*UnhealthyCondition), b.(*v1beta1.UnhealthyCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.UnhealthyCondition)(nil), (*UnhealthyCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_UnhealthyCondition_To_v1alpha4_UnhealthyCondition(a.(*v1beta1.UnhealthyCondition), b.(*UnhealthyCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkersClass)(nil), (*v1beta1.WorkersClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_WorkersClass_To_v1beta1_WorkersClass(a.(*WorkersClass), b.(*v1beta1.WorkersClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.WorkersClass)(nil), (*WorkersClass)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_WorkersClass_To_v1alpha4_WorkersClass(a.(*v1beta1.WorkersClass), b.(*WorkersClass), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*WorkersTopology)(nil), (*v1beta1.WorkersTopology)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_WorkersTopology_To_v1beta1_WorkersTopology(a.(*WorkersTopology), b.(*v1beta1.WorkersTopology), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.WorkersTopology)(nil), (*WorkersTopology)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_WorkersTopology_To_v1alpha4_WorkersTopology(a.(*v1beta1.WorkersTopology), b.(*WorkersTopology), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*MachineStatus)(nil), (*v1beta1.MachineStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_MachineStatus_To_v1beta1_MachineStatus(a.(*MachineStatus), b.(*v1beta1.MachineStatus), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint(in *APIEndpoint, out *v1beta1.APIEndpoint, s conversion.Scope) error {
	out.Host = in.Host
	out.Port = in.Port
	return nil
}

// Convert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint is an autogenerated conversion function.
func Convert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint(in *APIEndpoint, out *v1beta1.APIEndpoint, s conversion.Scope) error {
	return autoConvert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint(in, out, s)
}

func autoConvert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint(in *v1beta1.APIEndpoint, out *APIEndpoint, s conversion.Scope) error {
	out.Host = in.Host
	out.Port = in.Port
	return nil
}

// Convert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint is an autogenerated conversion function.
func Convert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint(in *v1beta1.APIEndpoint, out *APIEndpoint, s conversion.Scope) error {
	return autoConvert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint(in, out, s)
}

func autoConvert_v1alpha4_Bootstrap_To_v1beta1_Bootstrap(in *Bootstrap, out *v1beta1.Bootstrap, s conversion.Scope) error {
	out.ConfigRef = (*v1.ObjectReference)(unsafe.Pointer(in.ConfigRef))
	out.DataSecretName = (*string)(unsafe.Pointer(in.DataSecretName))
	return nil
}

// Convert_v1alpha4_Bootstrap_To_v1beta1_Bootstrap is an autogenerated conversion function.
func Convert_v1alpha4_Bootstrap_To_v1beta1_Bootstrap(in *Bootstrap, out *v1beta1.Bootstrap, s conversion.Scope) error {
	return autoConvert_v1alpha4_Bootstrap_To_v1beta1_Bootstrap(in, out, s)
}

func autoConvert_v1beta1_Bootstrap_To_v1alpha4_Bootstrap(in *v1beta1.Bootstrap, out *Bootstrap, s conversion.Scope) error {
	out.ConfigRef = (*v1.ObjectReference)(unsafe.Pointer(in.ConfigRef))
	out.DataSecretName = (*string)(unsafe.Pointer(in.DataSecretName))
	return nil
}

// Convert_v1beta1_Bootstrap_To_v1alpha4_Bootstrap is an autogenerated conversion function.
func Convert_v1beta1_Bootstrap_To_v1alpha4_Bootstrap(in *v1beta1.Bootstrap, out *Bootstrap, s conversion.Scope) error {
	return autoConvert_v1beta1_Bootstrap_To_v1alpha4_Bootstrap(in, out, s)
}

func autoConvert_v1alpha4_Cluster_To_v1beta1_Cluster(in *Cluster, out *v1beta1.Cluster, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha4_ClusterSpec_To_v1beta1_ClusterSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_ClusterStatus_To_v1beta1_ClusterStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_Cluster_To_v1beta1_Cluster is an autogenerated conversion function.
func Convert_v1alpha4_Cluster_To_v1beta1_Cluster(in *Cluster, out *v1beta1.Cluster, s conversion.Scope) error {
	return autoConvert_v1alpha4_Cluster_To_v1beta1_Cluster(in, out, s)
}

func autoConvert_v1beta1_Cluster_To_v1alpha4_Cluster(in *v1beta1.Cluster, out *Cluster, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_ClusterSpec_To_v1alpha4_ClusterSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_ClusterStatus_To_v1alpha4_ClusterStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_Cluster_To_v1alpha4_Cluster is an autogenerated conversion function.
func Convert_v1beta1_Cluster_To_v1alpha4_Cluster(in *v1beta1.Cluster, out *Cluster, s conversion.Scope) error {
	return autoConvert_v1beta1_Cluster_To_v1alpha4_Cluster(in, out, s)
}

func autoConvert_v1alpha4_ClusterClass_To_v1beta1_ClusterClass(in *ClusterClass, out *v1beta1.ClusterClass, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha4_ClusterClassSpec_To_v1beta1_ClusterClassSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_ClusterClass_To_v1beta1_ClusterClass is an autogenerated conversion function.
func Convert_v1alpha4_ClusterClass_To_v1beta1_ClusterClass(in *ClusterClass, out *v1beta1.ClusterClass, s conversion.Scope) error {
	return autoConvert_v1alpha4_ClusterClass_To_v1beta1_ClusterClass(in, out, s)
}

func autoConvert_v1beta1_ClusterClass_To_v1alpha4_ClusterClass(in *v1beta1.ClusterClass, out *ClusterClass, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_ClusterClassSpec_To_v1alpha4_ClusterClassSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_ClusterClass_To_v1alpha4_ClusterClass is an autogenerated conversion function.
func Convert_v1beta1_ClusterClass_To_v1alpha4_ClusterClass(in *v1beta1.ClusterClass, out *ClusterClass, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterClass_To_v1alpha4_ClusterClass(in, out, s)
}

func autoConvert_v1alpha4_ClusterClassList_To_v1beta1_ClusterClassList(in *ClusterClassList, out *v1beta1.ClusterClassList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1beta1.ClusterClass)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha4_ClusterClassList_To_v1beta1_ClusterClassList is an autogenerated conversion function.
func Convert_v1alpha4_ClusterClassList_To_v1beta1_ClusterClassList(in *ClusterClassList, out *v1beta1.ClusterClassList, s conversion.Scope) error {
	return autoConvert_v1alpha4_ClusterClassList_To_v1beta1_ClusterClassList(in, out, s)
}

func autoConvert_v1beta1_ClusterClassList_To_v1alpha4_ClusterClassList(in *v1beta1.ClusterClassList, out *ClusterClassList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]ClusterClass)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_ClusterClassList_To_v1alpha4_ClusterClassList is an autogenerated conversion function.
func Convert_v1beta1_ClusterClassList_To_v1alpha4_ClusterClassList(in *v1beta1.ClusterClassList, out *ClusterClassList, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterClassList_To_v1alpha4_ClusterClassList(in, out, s)
}

func autoConvert_v1alpha4_ClusterClassSpec_To_v1beta1_ClusterClassSpec(in *ClusterClassSpec, out *v1beta1.ClusterClassSpec, s conversion.Scope) error {
	if err := Convert_v1alpha4_LocalObjectTemplate_To_v1beta1_LocalObjectTemplate(&in.Infrastructure, &out.Infrastructure, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_ControlPlaneClass_To_v1beta1_ControlPlaneClass(&in.ControlPlane, &out.ControlPlane, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_WorkersClass_To_v1beta1_WorkersClass(&in.Workers, &out.Workers, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_ClusterClassSpec_To_v1beta1_ClusterClassSpec is an autogenerated conversion function.
func Convert_v1alpha4_ClusterClassSpec_To_v1beta1_ClusterClassSpec(in *ClusterClassSpec, out *v1beta1.ClusterClassSpec, s conversion.Scope) error {
	return autoConvert_v1alpha4_ClusterClassSpec_To_v1beta1_ClusterClassSpec(in, out, s)
}

func autoConvert_v1beta1_ClusterClassSpec_To_v1alpha4_ClusterClassSpec(in *v1beta1.ClusterClassSpec, out *ClusterClassSpec, s conversion.Scope) error {
	if err := Convert_v1beta1_LocalObjectTemplate_To_v1alpha4_LocalObjectTemplate(&in.Infrastructure, &out.Infrastructure, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_ControlPlaneClass_To_v1alpha4_ControlPlaneClass(&in.ControlPlane, &out.ControlPlane, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_WorkersClass_To_v1alpha4_WorkersClass(&in.Workers, &out.Workers, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_ClusterClassSpec_To_v1alpha4_ClusterClassSpec is an autogenerated conversion function.
func Convert_v1beta1_ClusterClassSpec_To_v1alpha4_ClusterClassSpec(in *v1beta1.ClusterClassSpec, out *ClusterClassSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterClassSpec_To_v1alpha4_ClusterClassSpec(in, out, s)
}

func autoConvert_v1alpha4_ClusterList_To_v1beta1_ClusterList(in *ClusterList, out *v1beta1.ClusterList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1beta1.Cluster)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha4_ClusterList_To_v1beta1_ClusterList is an autogenerated conversion function.
func Convert_v1alpha4_ClusterList_To_v1beta1_ClusterList(in *ClusterList, out *v1beta1.ClusterList, s conversion.Scope) error {
	return autoConvert_v1alpha4_ClusterList_To_v1beta1_ClusterList(in, out, s)
}

func autoConvert_v1beta1_ClusterList_To_v1alpha4_ClusterList(in *v1beta1.ClusterList, out *ClusterList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]Cluster)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_ClusterList_To_v1alpha4_ClusterList is an autogenerated conversion function.
func Convert_v1beta1_ClusterList_To_v1alpha4_ClusterList(in *v1beta1.ClusterList, out *ClusterList, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterList_To_v1alpha4_ClusterList(in, out, s)
}

func autoConvert_v1alpha4_ClusterNetwork_To_v1beta1_ClusterNetwork(in *ClusterNetwork, out *v1beta1.ClusterNetwork, s conversion.Scope) error {
	out.APIServerPort = (*int32)(unsafe.Pointer(in.APIServerPort))
	out.Services = (*v1beta1.NetworkRanges)(unsafe.Pointer(in.Services))
	out.Pods = (*v1beta1.NetworkRanges)(unsafe.Pointer(in.Pods))
	out.ServiceDomain = in.ServiceDomain
	return nil
}

// Convert_v1alpha4_ClusterNetwork_To_v1beta1_ClusterNetwork is an autogenerated conversion function.
func Convert_v1alpha4_ClusterNetwork_To_v1beta1_ClusterNetwork(in *ClusterNetwork, out *v1beta1.ClusterNetwork, s conversion.Scope) error {
	return autoConvert_v1alpha4_ClusterNetwork_To_v1beta1_ClusterNetwork(in, out, s)
}

func autoConvert_v1beta1_ClusterNetwork_To_v1alpha4_ClusterNetwork(in *v1beta1.ClusterNetwork, out *ClusterNetwork, s conversion.Scope) error {
	out.APIServerPort = (*int32)(unsafe.Pointer(in.APIServerPort))
	out.Services = (*NetworkRanges)(unsafe.Pointer(in.Services))
	out.Pods = (*NetworkRanges)(unsafe.Pointer(in.Pods))
	out.ServiceDomain = in.ServiceDomain
	return nil
}

// Convert_v1beta1_ClusterNetwork_To_v1alpha4_ClusterNetwork is an autogenerated conversion function.
func Convert_v1beta1_ClusterNetwork_To_v1alpha4_ClusterNetwork(in *v1beta1.ClusterNetwork, out *ClusterNetwork, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterNetwork_To_v1alpha4_ClusterNetwork(in, out, s)
}

func autoConvert_v1alpha4_ClusterSpec_To_v1beta1_ClusterSpec(in *ClusterSpec, out *v1beta1.ClusterSpec, s conversion.Scope) error {
	out.Paused = in.Paused
	out.ClusterNetwork = (*v1beta1.ClusterNetwork)(unsafe.Pointer(in.ClusterNetwork))
	if err := Convert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint(&in.ControlPlaneEndpoint, &out.ControlPlaneEndpoint, s); err != nil {
		return err
	}
	out.ControlPlaneRef = (*v1.ObjectReference)(unsafe.Pointer(in.ControlPlaneRef))
	out.InfrastructureRef = (*v1.ObjectReference)(unsafe.Pointer(in.InfrastructureRef))
	out.Topology = (*v1beta1.Topology)(unsafe.Pointer(in.Topology))
	return nil
}

// Convert_v1alpha4_ClusterSpec_To_v1beta1_ClusterSpec is an autogenerated conversion function.
func Convert_v1alpha4_ClusterSpec_To_v1beta1_ClusterSpec(in *ClusterSpec, out *v1beta1.ClusterSpec, s conversion.Scope) error {
	return autoConvert_v1alpha4_ClusterSpec_To_v1beta1_ClusterSpec(in, out, s)
}

func autoConvert_v1beta1_ClusterSpec_To_v1alpha4_ClusterSpec(in *v1beta1.ClusterSpec, out *ClusterSpec, s conversion.Scope) error {
	out.Paused = in.Paused
	out.ClusterNetwork = (*ClusterNetwork)(unsafe.Pointer(in.ClusterNetwork))
	if err := Convert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint(&in.ControlPlaneEndpoint, &out.ControlPlaneEndpoint, s); err != nil {
		return err
	}
	out.ControlPlaneRef = (*v1.ObjectReference)(unsafe.Pointer(in.ControlPlaneRef))
	out.InfrastructureRef = (*v1.ObjectReference)(unsafe.Pointer(in.InfrastructureRef))
	out.Topology = (*Topology)(unsafe.Pointer(in.Topology))
	return nil
}

// Convert_v1beta1_ClusterSpec_To_v1alpha4_ClusterSpec is an autogenerated conversion function.
func Convert_v1beta1_ClusterSpec_To_v1alpha4_ClusterSpec(in *v1beta1.ClusterSpec, out *ClusterSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterSpec_To_v1alpha4_ClusterSpec(in, out, s)
}

func autoConvert_v1alpha4_ClusterStatus_To_v1beta1_ClusterStatus(in *ClusterStatus, out *v1beta1.ClusterStatus, s conversion.Scope) error {
	out.FailureDomains = *(*v1beta1.FailureDomains)(unsafe.Pointer(&in.FailureDomains))
	out.FailureReason = (*errors.ClusterStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	out.Phase = in.Phase
	out.InfrastructureReady = in.InfrastructureReady
	out.ControlPlaneReady = in.ControlPlaneReady
	out.Conditions = *(*v1beta1.Conditions)(unsafe.Pointer(&in.Conditions))
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_v1alpha4_ClusterStatus_To_v1beta1_ClusterStatus is an autogenerated conversion function.
func Convert_v1alpha4_ClusterStatus_To_v1beta1_ClusterStatus(in *ClusterStatus, out *v1beta1.ClusterStatus, s conversion.Scope) error {
	return autoConvert_v1alpha4_ClusterStatus_To_v1beta1_ClusterStatus(in, out, s)
}

func autoConvert_v1beta1_ClusterStatus_To_v1alpha4_ClusterStatus(in *v1beta1.ClusterStatus, out *ClusterStatus, s conversion.Scope) error {
	out.FailureDomains = *(*FailureDomains)(unsafe.Pointer(&in.FailureDomains))
	out.FailureReason = (*errors.ClusterStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	out.Phase = in.Phase
	out.InfrastructureReady = in.InfrastructureReady
	out.ControlPlaneReady = in.ControlPlaneReady
	out.Conditions = *(*Conditions)(unsafe.Pointer(&in.Conditions))
	out.ObservedGeneration = in.ObservedGeneration
	return nil
}

// Convert_v1beta1_ClusterStatus_To_v1alpha4_ClusterStatus is an autogenerated conversion function.
func Convert_v1beta1_ClusterStatus_To_v1alpha4_ClusterStatus(in *v1beta1.ClusterStatus, out *ClusterStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterStatus_To_v1alpha4_ClusterStatus(in, out, s)
}

func autoConvert_v1alpha4_Condition_To_v1beta1_Condition(in *Condition, out *v1beta1.Condition, s conversion.Scope) error {
	out.Type = v1beta1.ConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.Severity = v1beta1.ConditionSeverity(in.Severity)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1alpha4_Condition_To_v1beta1_Condition is an autogenerated conversion function.
func Convert_v1alpha4_Condition_To_v1beta1_Condition(in *Condition, out *v1beta1.Condition, s conversion.Scope) error {
	return autoConvert_v1alpha4_Condition_To_v1beta1_Condition(in, out, s)
}

func autoConvert_v1beta1_Condition_To_v1alpha4_Condition(in *v1beta1.Condition, out *Condition, s conversion.Scope) error {
	out.Type = ConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.Severity = ConditionSeverity(in.Severity)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1beta1_Condition_To_v1alpha4_Condition is an autogenerated conversion function.
func Convert_v1beta1_Condition_To_v1alpha4_Condition(in *v1beta1.Condition, out *Condition, s conversion.Scope) error {
	return autoConvert_v1beta1_Condition_To_v1alpha4_Condition(in, out, s)
}

func autoConvert_v1alpha4_ControlPlaneClass_To_v1beta1_ControlPlaneClass(in *ControlPlaneClass, out *v1beta1.ControlPlaneClass, s conversion.Scope) error {
	if err := Convert_v1alpha4_ObjectMeta_To_v1beta1_ObjectMeta(&in.Metadata, &out.Metadata, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_LocalObjectTemplate_To_v1beta1_LocalObjectTemplate(&in.LocalObjectTemplate, &out.LocalObjectTemplate, s); err != nil {
		return err
	}
	out.MachineInfrastructure = (*v1beta1.LocalObjectTemplate)(unsafe.Pointer(in.MachineInfrastructure))
	return nil
}

// Convert_v1alpha4_ControlPlaneClass_To_v1beta1_ControlPlaneClass is an autogenerated conversion function.
func Convert_v1alpha4_ControlPlaneClass_To_v1beta1_ControlPlaneClass(in *ControlPlaneClass, out *v1beta1.ControlPlaneClass, s conversion.Scope) error {
	return autoConvert_v1alpha4_ControlPlaneClass_To_v1beta1_ControlPlaneClass(in, out, s)
}

func autoConvert_v1beta1_ControlPlaneClass_To_v1alpha4_ControlPlaneClass(in *v1beta1.ControlPlaneClass, out *ControlPlaneClass, s conversion.Scope) error {
	if err := Convert_v1beta1_ObjectMeta_To_v1alpha4_ObjectMeta(&in.Metadata, &out.Metadata, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_LocalObjectTemplate_To_v1alpha4_LocalObjectTemplate(&in.LocalObjectTemplate, &out.LocalObjectTemplate, s); err != nil {
		return err
	}
	out.MachineInfrastructure = (*LocalObjectTemplate)(unsafe.Pointer(in.MachineInfrastructure))
	return nil
}

// Convert_v1beta1_ControlPlaneClass_To_v1alpha4_ControlPlaneClass is an autogenerated conversion function.
func Convert_v1beta1_ControlPlaneClass_To_v1alpha4_ControlPlaneClass(in *v1beta1.ControlPlaneClass, out *ControlPlaneClass, s conversion.Scope) error {
	return autoConvert_v1beta1_ControlPlaneClass_To_v1alpha4_ControlPlaneClass(in, out, s)
}

func autoConvert_v1alpha4_ControlPlaneTopology_To_v1beta1_ControlPlaneTopology(in *ControlPlaneTopology, out *v1beta1.ControlPlaneTopology, s conversion.Scope) error {
	if err := Convert_v1alpha4_ObjectMeta_To_v1beta1_ObjectMeta(&in.Metadata, &out.Metadata, s); err != nil {
		return err
	}
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	return nil
}

// Convert_v1alpha4_ControlPlaneTopology_To_v1beta1_ControlPlaneTopology is an autogenerated conversion function.
func Convert_v1alpha4_ControlPlaneTopology_To_v1beta1_ControlPlaneTopology(in *ControlPlaneTopology, out *v1beta1.ControlPlaneTopology, s conversion.Scope) error {
	return autoConvert_v1alpha4_ControlPlaneTopology_To_v1beta1_ControlPlaneTopology(in, out, s)
}

func autoConvert_v1beta1_ControlPlaneTopology_To_v1alpha4_ControlPlaneTopology(in *v1beta1.ControlPlaneTopology, out *ControlPlaneTopology, s conversion.Scope) error {
	if err := Convert_v1beta1_ObjectMeta_To_v1alpha4_ObjectMeta(&in.Metadata, &out.Metadata, s); err != nil {
		return err
	}
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	return nil
}

// Convert_v1beta1_ControlPlaneTopology_To_v1alpha4_ControlPlaneTopology is an autogenerated conversion function.
func Convert_v1beta1_ControlPlaneTopology_To_v1alpha4_ControlPlaneTopology(in *v1beta1.ControlPlaneTopology, out *ControlPlaneTopology, s conversion.Scope) error {
	return autoConvert_v1beta1_ControlPlaneTopology_To_v1alpha4_ControlPlaneTopology(in, out, s)
}

func autoConvert_v1alpha4_FailureDomainSpec_To_v1beta1_FailureDomainSpec(in *FailureDomainSpec, out *v1beta1.FailureDomainSpec, s conversion.Scope) error {
	out.ControlPlane = in.ControlPlane
	out.Attributes = *(*map[string]string)(unsafe.Pointer(&in.Attributes))
	return nil
}

// Convert_v1alpha4_FailureDomainSpec_To_v1beta1_FailureDomainSpec is an autogenerated conversion function.
func Convert_v1alpha4_FailureDomainSpec_To_v1beta1_FailureDomainSpec(in *FailureDomainSpec, out *v1beta1.FailureDomainSpec, s conversion.Scope) error {
	return autoConvert_v1alpha4_FailureDomainSpec_To_v1beta1_FailureDomainSpec(in, out, s)
}

func autoConvert_v1beta1_FailureDomainSpec_To_v1alpha4_FailureDomainSpec(in *v1beta1.FailureDomainSpec, out *FailureDomainSpec, s conversion.Scope) error {
	out.ControlPlane = in.ControlPlane
	out.Attributes = *(*map[string]string)(unsafe.Pointer(&in.Attributes))
	return nil
}

// Convert_v1beta1_FailureDomainSpec_To_v1alpha4_FailureDomainSpec is an autogenerated conversion function.
func Convert_v1beta1_FailureDomainSpec_To_v1alpha4_FailureDomainSpec(in *v1beta1.FailureDomainSpec, out *FailureDomainSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_FailureDomainSpec_To_v1alpha4_FailureDomainSpec(in, out, s)
}

func autoConvert_v1alpha4_LocalObjectTemplate_To_v1beta1_LocalObjectTemplate(in *LocalObjectTemplate, out *v1beta1.LocalObjectTemplate, s conversion.Scope) error {
	out.Ref = (*v1.ObjectReference)(unsafe.Pointer(in.Ref))
	return nil
}

// Convert_v1alpha4_LocalObjectTemplate_To_v1beta1_LocalObjectTemplate is an autogenerated conversion function.
func Convert_v1alpha4_LocalObjectTemplate_To_v1beta1_LocalObjectTemplate(in *LocalObjectTemplate, out *v1beta1.LocalObjectTemplate, s conversion.Scope) error {
	return autoConvert_v1alpha4_LocalObjectTemplate_To_v1beta1_LocalObjectTemplate(in, out, s)
}

func autoConvert_v1beta1_LocalObjectTemplate_To_v1alpha4_LocalObjectTemplate(in *v1beta1.LocalObjectTemplate, out *LocalObjectTemplate, s conversion.Scope) error {
	out.Ref = (*v1.ObjectReference)(unsafe.Pointer(in.Ref))
	return nil
}

// Convert_v1beta1_LocalObjectTemplate_To_v1alpha4_LocalObjectTemplate is an autogenerated conversion function.
func Convert_v1beta1_LocalObjectTemplate_To_v1alpha4_LocalObjectTemplate(in *v1beta1.LocalObjectTemplate, out *LocalObjectTemplate, s conversion.Scope) error {
	return autoConvert_v1beta1_LocalObjectTemplate_To_v1alpha4_LocalObjectTemplate(in, out, s)
}

func autoConvert_v1alpha4_Machine_To_v1beta1_Machine(in *Machine, out *v1beta1.Machine, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha4_MachineSpec_To_v1beta1_MachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_MachineStatus_To_v1beta1_MachineStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_Machine_To_v1beta1_Machine is an autogenerated conversion function.
func Convert_v1alpha4_Machine_To_v1beta1_Machine(in *Machine, out *v1beta1.Machine, s conversion.Scope) error {
	return autoConvert_v1alpha4_Machine_To_v1beta1_Machine(in, out, s)
}

func autoConvert_v1beta1_Machine_To_v1alpha4_Machine(in *v1beta1.Machine, out *Machine, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_MachineSpec_To_v1alpha4_MachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_MachineStatus_To_v1alpha4_MachineStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_Machine_To_v1alpha4_Machine is an autogenerated conversion function.
func Convert_v1beta1_Machine_To_v1alpha4_Machine(in *v1beta1.Machine, out *Machine, s conversion.Scope) error {
	return autoConvert_v1beta1_Machine_To_v1alpha4_Machine(in, out, s)
}

func autoConvert_v1alpha4_MachineAddress_To_v1beta1_MachineAddress(in *MachineAddress, out *v1beta1.MachineAddress, s conversion.Scope) error {
	out.Type = v1beta1.MachineAddressType(in.Type)
	out.Address = in.Address
	return nil
}

// Convert_v1alpha4_MachineAddress_To_v1beta1_MachineAddress is an autogenerated conversion function.
func Convert_v1alpha4_MachineAddress_To_v1beta1_MachineAddress(in *MachineAddress, out *v1beta1.MachineAddress, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineAddress_To_v1beta1_MachineAddress(in, out, s)
}

func autoConvert_v1beta1_MachineAddress_To_v1alpha4_MachineAddress(in *v1beta1.MachineAddress, out *MachineAddress, s conversion.Scope) error {
	out.Type = MachineAddressType(in.Type)
	out.Address = in.Address
	return nil
}

// Convert_v1beta1_MachineAddress_To_v1alpha4_MachineAddress is an autogenerated conversion function.
func Convert_v1beta1_MachineAddress_To_v1alpha4_MachineAddress(in *v1beta1.MachineAddress, out *MachineAddress, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineAddress_To_v1alpha4_MachineAddress(in, out, s)
}

func autoConvert_v1alpha4_MachineDeployment_To_v1beta1_MachineDeployment(in *MachineDeployment, out *v1beta1.MachineDeployment, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha4_MachineDeploymentSpec_To_v1beta1_MachineDeploymentSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_MachineDeploymentStatus_To_v1beta1_MachineDeploymentStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_MachineDeployment_To_v1beta1_MachineDeployment is an autogenerated conversion function.
func Convert_v1alpha4_MachineDeployment_To_v1beta1_MachineDeployment(in *MachineDeployment, out *v1beta1.MachineDeployment, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineDeployment_To_v1beta1_MachineDeployment(in, out, s)
}

func autoConvert_v1beta1_MachineDeployment_To_v1alpha4_MachineDeployment(in *v1beta1.MachineDeployment, out *MachineDeployment, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_MachineDeploymentSpec_To_v1alpha4_MachineDeploymentSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_MachineDeploymentStatus_To_v1alpha4_MachineDeploymentStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_MachineDeployment_To_v1alpha4_MachineDeployment is an autogenerated conversion function.
func Convert_v1beta1_MachineDeployment_To_v1alpha4_MachineDeployment(in *v1beta1.MachineDeployment, out *MachineDeployment, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineDeployment_To_v1alpha4_MachineDeployment(in, out, s)
}

func autoConvert_v1alpha4_MachineDeploymentClass_To_v1beta1_MachineDeploymentClass(in *MachineDeploymentClass, out *v1beta1.MachineDeploymentClass, s conversion.Scope) error {
	out.Class = in.Class
	if err := Convert_v1alpha4_MachineDeploymentClassTemplate_To_v1beta1_MachineDeploymentClassTemplate(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_MachineDeploymentClass_To_v1beta1_MachineDeploymentClass is an autogenerated conversion function.
func Convert_v1alpha4_MachineDeploymentClass_To_v1beta1_MachineDeploymentClass(in *MachineDeploymentClass, out *v1beta1.MachineDeploymentClass, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineDeploymentClass_To_v1beta1_MachineDeploymentClass(in, out, s)
}

func autoConvert_v1beta1_MachineDeploymentClass_To_v1alpha4_MachineDeploymentClass(in *v1beta1.MachineDeploymentClass, out *MachineDeploymentClass, s conversion.Scope) error {
	out.Class = in.Class
	if err := Convert_v1beta1_MachineDeploymentClassTemplate_To_v1alpha4_MachineDeploymentClassTemplate(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_MachineDeploymentClass_To_v1alpha4_MachineDeploymentClass is an autogenerated conversion function.
func Convert_v1beta1_MachineDeploymentClass_To_v1alpha4_MachineDeploymentClass(in *v1beta1.MachineDeploymentClass, out *MachineDeploymentClass, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineDeploymentClass_To_v1alpha4_MachineDeploymentClass(in, out, s)
}

func autoConvert_v1alpha4_MachineDeploymentClassTemplate_To_v1beta1_MachineDeploymentClassTemplate(in *MachineDeploymentClassTemplate, out *v1beta1.MachineDeploymentClassTemplate, s conversion.Scope) error {
	if err := Convert_v1alpha4_ObjectMeta_To_v1beta1_ObjectMeta(&in.Metadata, &out.Metadata, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_LocalObjectTemplate_To_v1beta1_LocalObjectTemplate(&in.Bootstrap, &out.Bootstrap, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_LocalObjectTemplate_To_v1beta1_LocalObjectTemplate(&in.Infrastructure, &out.Infrastructure, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_MachineDeploymentClassTemplate_To_v1beta1_MachineDeploymentClassTemplate is an autogenerated conversion function.
func Convert_v1alpha4_MachineDeploymentClassTemplate_To_v1beta1_MachineDeploymentClassTemplate(in *MachineDeploymentClassTemplate, out *v1beta1.MachineDeploymentClassTemplate, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineDeploymentClassTemplate_To_v1beta1_MachineDeploymentClassTemplate(in, out, s)
}

func autoConvert_v1beta1_MachineDeploymentClassTemplate_To_v1alpha4_MachineDeploymentClassTemplate(in *v1beta1.MachineDeploymentClassTemplate, out *MachineDeploymentClassTemplate, s conversion.Scope) error {
	if err := Convert_v1beta1_ObjectMeta_To_v1alpha4_ObjectMeta(&in.Metadata, &out.Metadata, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_LocalObjectTemplate_To_v1alpha4_LocalObjectTemplate(&in.Bootstrap, &out.Bootstrap, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_LocalObjectTemplate_To_v1alpha4_LocalObjectTemplate(&in.Infrastructure, &out.Infrastructure, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_MachineDeploymentClassTemplate_To_v1alpha4_MachineDeploymentClassTemplate is an autogenerated conversion function.
func Convert_v1beta1_MachineDeploymentClassTemplate_To_v1alpha4_MachineDeploymentClassTemplate(in *v1beta1.MachineDeploymentClassTemplate, out *MachineDeploymentClassTemplate, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineDeploymentClassTemplate_To_v1alpha4_MachineDeploymentClassTemplate(in, out, s)
}

func autoConvert_v1alpha4_MachineDeploymentList_To_v1beta1_MachineDeploymentList(in *MachineDeploymentList, out *v1beta1.MachineDeploymentList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1beta1.MachineDeployment)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha4_MachineDeploymentList_To_v1beta1_MachineDeploymentList is an autogenerated conversion function.
func Convert_v1alpha4_MachineDeploymentList_To_v1beta1_MachineDeploymentList(in *MachineDeploymentList, out *v1beta1.MachineDeploymentList, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineDeploymentList_To_v1beta1_MachineDeploymentList(in, out, s)
}

func autoConvert_v1beta1_MachineDeploymentList_To_v1alpha4_MachineDeploymentList(in *v1beta1.MachineDeploymentList, out *MachineDeploymentList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]MachineDeployment)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_MachineDeploymentList_To_v1alpha4_MachineDeploymentList is an autogenerated conversion function.
func Convert_v1beta1_MachineDeploymentList_To_v1alpha4_MachineDeploymentList(in *v1beta1.MachineDeploymentList, out *MachineDeploymentList, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineDeploymentList_To_v1alpha4_MachineDeploymentList(in, out, s)
}

func autoConvert_v1alpha4_MachineDeploymentSpec_To_v1beta1_MachineDeploymentSpec(in *MachineDeploymentSpec, out *v1beta1.MachineDeploymentSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.Selector = in.Selector
	if err := Convert_v1alpha4_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	out.Strategy = (*v1beta1.MachineDeploymentStrategy)(unsafe.Pointer(in.Strategy))
	out.MinReadySeconds = (*int32)(unsafe.Pointer(in.MinReadySeconds))
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.Paused = in.Paused
	out.ProgressDeadlineSeconds = (*int32)(unsafe.Pointer(in.ProgressDeadlineSeconds))
	return nil
}

// Convert_v1alpha4_MachineDeploymentSpec_To_v1beta1_MachineDeploymentSpec is an autogenerated conversion function.
func Convert_v1alpha4_MachineDeploymentSpec_To_v1beta1_MachineDeploymentSpec(in *MachineDeploymentSpec, out *v1beta1.MachineDeploymentSpec, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineDeploymentSpec_To_v1beta1_MachineDeploymentSpec(in, out, s)
}

func autoConvert_v1beta1_MachineDeploymentSpec_To_v1alpha4_MachineDeploymentSpec(in *v1beta1.MachineDeploymentSpec, out *MachineDeploymentSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.Selector = in.Selector
	if err := Convert_v1beta1_MachineTemplateSpec_To_v1alpha4_MachineTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	out.Strategy = (*MachineDeploymentStrategy)(unsafe.Pointer(in.Strategy))
	out.MinReadySeconds = (*int32)(unsafe.Pointer(in.MinReadySeconds))
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.Paused = in.Paused
	out.ProgressDeadlineSeconds = (*int32)(unsafe.Pointer(in.ProgressDeadlineSeconds))
	return nil
}

// Convert_v1beta1_MachineDeploymentSpec_To_v1alpha4_MachineDeploymentSpec is an autogenerated conversion function.
func Convert_v1beta1_MachineDeploymentSpec_To_v1alpha4_MachineDeploymentSpec(in *v1beta1.MachineDeploymentSpec, out *MachineDeploymentSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineDeploymentSpec_To_v1alpha4_MachineDeploymentSpec(in, out, s)
}

func autoConvert_v1alpha4_MachineDeploymentStatus_To_v1beta1_MachineDeploymentStatus(in *MachineDeploymentStatus, out *v1beta1.MachineDeploymentStatus, s conversion.Scope) error {
	out.ObservedGeneration = in.ObservedGeneration
	out.Selector = in.Selector
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	out.Phase = in.Phase
	out.Conditions = *(*v1beta1.Conditions)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1alpha4_MachineDeploymentStatus_To_v1beta1_MachineDeploymentStatus is an autogenerated conversion function.
func Convert_v1alpha4_MachineDeploymentStatus_To_v1beta1_MachineDeploymentStatus(in *MachineDeploymentStatus, out *v1beta1.MachineDeploymentStatus, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineDeploymentStatus_To_v1beta1_MachineDeploymentStatus(in, out, s)
}

func autoConvert_v1beta1_MachineDeploymentStatus_To_v1alpha4_MachineDeploymentStatus(in *v1beta1.MachineDeploymentStatus, out *MachineDeploymentStatus, s conversion.Scope) error {
	out.ObservedGeneration = in.ObservedGeneration
	out.Selector = in.Selector
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	out.Phase = in.Phase
	out.Conditions = *(*Conditions)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1beta1_MachineDeploymentStatus_To_v1alpha4_MachineDeploymentStatus is an autogenerated conversion function.
func Convert_v1beta1_MachineDeploymentStatus_To_v1alpha4_MachineDeploymentStatus(in *v1beta1.MachineDeploymentStatus, out *MachineDeploymentStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineDeploymentStatus_To_v1alpha4_MachineDeploymentStatus(in, out, s)
}

func autoConvert_v1alpha4_MachineDeploymentStrategy_To_v1beta1_MachineDeploymentStrategy(in *MachineDeploymentStrategy, out *v1beta1.MachineDeploymentStrategy, s conversion.Scope) error {
	out.Type = v1beta1.MachineDeploymentStrategyType(in.Type)
	out.RollingUpdate = (*v1beta1.MachineRollingUpdateDeployment)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1alpha4_MachineDeploymentStrategy_To_v1beta1_MachineDeploymentStrategy is an autogenerated conversion function.
func Convert_v1alpha4_MachineDeploymentStrategy_To_v1beta1_MachineDeploymentStrategy(in *MachineDeploymentStrategy, out *v1beta1.MachineDeploymentStrategy, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineDeploymentStrategy_To_v1beta1_MachineDeploymentStrategy(in, out, s)
}

func autoConvert_v1beta1_MachineDeploymentStrategy_To_v1alpha4_MachineDeploymentStrategy(in *v1beta1.MachineDeploymentStrategy, out *MachineDeploymentStrategy, s conversion.Scope) error {
	out.Type = MachineDeploymentStrategyType(in.Type)
	out.RollingUpdate = (*MachineRollingUpdateDeployment)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1beta1_MachineDeploymentStrategy_To_v1alpha4_MachineDeploymentStrategy is an autogenerated conversion function.
func Convert_v1beta1_MachineDeploymentStrategy_To_v1alpha4_MachineDeploymentStrategy(in *v1beta1.MachineDeploymentStrategy, out *MachineDeploymentStrategy, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineDeploymentStrategy_To_v1alpha4_MachineDeploymentStrategy(in, out, s)
}

func autoConvert_v1alpha4_MachineDeploymentTopology_To_v1beta1_MachineDeploymentTopology(in *MachineDeploymentTopology, out *v1beta1.MachineDeploymentTopology, s conversion.Scope) error {
	if err := Convert_v1alpha4_ObjectMeta_To_v1beta1_ObjectMeta(&in.Metadata, &out.Metadata, s); err != nil {
		return err
	}
	out.Class = in.Class
	out.Name = in.Name
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	return nil
}

// Convert_v1alpha4_MachineDeploymentTopology_To_v1beta1_MachineDeploymentTopology is an autogenerated conversion function.
func Convert_v1alpha4_MachineDeploymentTopology_To_v1beta1_MachineDeploymentTopology(in *MachineDeploymentTopology, out *v1beta1.MachineDeploymentTopology, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineDeploymentTopology_To_v1beta1_MachineDeploymentTopology(in, out, s)
}

func autoConvert_v1beta1_MachineDeploymentTopology_To_v1alpha4_MachineDeploymentTopology(in *v1beta1.MachineDeploymentTopology, out *MachineDeploymentTopology, s conversion.Scope) error {
	if err := Convert_v1beta1_ObjectMeta_To_v1alpha4_ObjectMeta(&in.Metadata, &out.Metadata, s); err != nil {
		return err
	}
	out.Class = in.Class
	out.Name = in.Name
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	return nil
}

// Convert_v1beta1_MachineDeploymentTopology_To_v1alpha4_MachineDeploymentTopology is an autogenerated conversion function.
func Convert_v1beta1_MachineDeploymentTopology_To_v1alpha4_MachineDeploymentTopology(in *v1beta1.MachineDeploymentTopology, out *MachineDeploymentTopology, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineDeploymentTopology_To_v1alpha4_MachineDeploymentTopology(in, out, s)
}

func autoConvert_v1alpha4_MachineHealthCheck_To_v1beta1_MachineHealthCheck(in *MachineHealthCheck, out *v1beta1.MachineHealthCheck, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha4_MachineHealthCheckSpec_To_v1beta1_MachineHealthCheckSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_MachineHealthCheckStatus_To_v1beta1_MachineHealthCheckStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_MachineHealthCheck_To_v1beta1_MachineHealthCheck is an autogenerated conversion function.
func Convert_v1alpha4_MachineHealthCheck_To_v1beta1_MachineHealthCheck(in *MachineHealthCheck, out *v1beta1.MachineHealthCheck, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineHealthCheck_To_v1beta1_MachineHealthCheck(in, out, s)
}

func autoConvert_v1beta1_MachineHealthCheck_To_v1alpha4_MachineHealthCheck(in *v1beta1.MachineHealthCheck, out *MachineHealthCheck, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_MachineHealthCheckSpec_To_v1alpha4_MachineHealthCheckSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_MachineHealthCheckStatus_To_v1alpha4_MachineHealthCheckStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_MachineHealthCheck_To_v1alpha4_MachineHealthCheck is an autogenerated conversion function.
func Convert_v1beta1_MachineHealthCheck_To_v1alpha4_MachineHealthCheck(in *v1beta1.MachineHealthCheck, out *MachineHealthCheck, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineHealthCheck_To_v1alpha4_MachineHealthCheck(in, out, s)
}

func autoConvert_v1alpha4_MachineHealthCheckList_To_v1beta1_MachineHealthCheckList(in *MachineHealthCheckList, out *v1beta1.MachineHealthCheckList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1beta1.MachineHealthCheck)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha4_MachineHealthCheckList_To_v1beta1_MachineHealthCheckList is an autogenerated conversion function.
func Convert_v1alpha4_MachineHealthCheckList_To_v1beta1_MachineHealthCheckList(in *MachineHealthCheckList, out *v1beta1.MachineHealthCheckList, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineHealthCheckList_To_v1beta1_MachineHealthCheckList(in, out, s)
}

func autoConvert_v1beta1_MachineHealthCheckList_To_v1alpha4_MachineHealthCheckList(in *v1beta1.MachineHealthCheckList, out *MachineHealthCheckList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]MachineHealthCheck)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_MachineHealthCheckList_To_v1alpha4_MachineHealthCheckList is an autogenerated conversion function.
func Convert_v1beta1_MachineHealthCheckList_To_v1alpha4_MachineHealthCheckList(in *v1beta1.MachineHealthCheckList, out *MachineHealthCheckList, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineHealthCheckList_To_v1alpha4_MachineHealthCheckList(in, out, s)
}

func autoConvert_v1alpha4_MachineHealthCheckSpec_To_v1beta1_MachineHealthCheckSpec(in *MachineHealthCheckSpec, out *v1beta1.MachineHealthCheckSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.Selector = in.Selector
	out.UnhealthyConditions = *(*[]v1beta1.UnhealthyCondition)(unsafe.Pointer(&in.UnhealthyConditions))
	out.MaxUnhealthy = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnhealthy))
	out.UnhealthyRange = (*string)(unsafe.Pointer(in.UnhealthyRange))
	out.NodeStartupTimeout = (*metav1.Duration)(unsafe.Pointer(in.NodeStartupTimeout))
	out.RemediationTemplate = (*v1.ObjectReference)(unsafe.Pointer(in.RemediationTemplate))
	return nil
}

// Convert_v1alpha4_MachineHealthCheckSpec_To_v1beta1_MachineHealthCheckSpec is an autogenerated conversion function.
func Convert_v1alpha4_MachineHealthCheckSpec_To_v1beta1_MachineHealthCheckSpec(in *MachineHealthCheckSpec, out *v1beta1.MachineHealthCheckSpec, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineHealthCheckSpec_To_v1beta1_MachineHealthCheckSpec(in, out, s)
}

func autoConvert_v1beta1_MachineHealthCheckSpec_To_v1alpha4_MachineHealthCheckSpec(in *v1beta1.MachineHealthCheckSpec, out *MachineHealthCheckSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.Selector = in.Selector
	out.UnhealthyConditions = *(*[]UnhealthyCondition)(unsafe.Pointer(&in.UnhealthyConditions))
	out.MaxUnhealthy = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnhealthy))
	out.UnhealthyRange = (*string)(unsafe.Pointer(in.UnhealthyRange))
	out.NodeStartupTimeout = (*metav1.Duration)(unsafe.Pointer(in.NodeStartupTimeout))
	out.RemediationTemplate = (*v1.ObjectReference)(unsafe.Pointer(in.RemediationTemplate))
	return nil
}

// Convert_v1beta1_MachineHealthCheckSpec_To_v1alpha4_MachineHealthCheckSpec is an autogenerated conversion function.
func Convert_v1beta1_MachineHealthCheckSpec_To_v1alpha4_MachineHealthCheckSpec(in *v1beta1.MachineHealthCheckSpec, out *MachineHealthCheckSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineHealthCheckSpec_To_v1alpha4_MachineHealthCheckSpec(in, out, s)
}

func autoConvert_v1alpha4_MachineHealthCheckStatus_To_v1beta1_MachineHealthCheckStatus(in *MachineHealthCheckStatus, out *v1beta1.MachineHealthCheckStatus, s conversion.Scope) error {
	out.ExpectedMachines = in.ExpectedMachines
	out.CurrentHealthy = in.CurrentHealthy
	out.RemediationsAllowed = in.RemediationsAllowed
	out.ObservedGeneration = in.ObservedGeneration
	out.Targets = *(*[]string)(unsafe.Pointer(&in.Targets))
	out.Conditions = *(*v1beta1.Conditions)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1alpha4_MachineHealthCheckStatus_To_v1beta1_MachineHealthCheckStatus is an autogenerated conversion function.
func Convert_v1alpha4_MachineHealthCheckStatus_To_v1beta1_MachineHealthCheckStatus(in *MachineHealthCheckStatus, out *v1beta1.MachineHealthCheckStatus, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineHealthCheckStatus_To_v1beta1_MachineHealthCheckStatus(in, out, s)
}

func autoConvert_v1beta1_MachineHealthCheckStatus_To_v1alpha4_MachineHealthCheckStatus(in *v1beta1.MachineHealthCheckStatus, out *MachineHealthCheckStatus, s conversion.Scope) error {
	out.ExpectedMachines = in.ExpectedMachines
	out.CurrentHealthy = in.CurrentHealthy
	out.RemediationsAllowed = in.RemediationsAllowed
	out.ObservedGeneration = in.ObservedGeneration
	out.Targets = *(*[]string)(unsafe.Pointer(&in.Targets))
	out.Conditions = *(*Conditions)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1beta1_MachineHealthCheckStatus_To_v1alpha4_MachineHealthCheckStatus is an autogenerated conversion function.
func Convert_v1beta1_MachineHealthCheckStatus_To_v1alpha4_MachineHealthCheckStatus(in *v1beta1.MachineHealthCheckStatus, out *MachineHealthCheckStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineHealthCheckStatus_To_v1alpha4_MachineHealthCheckStatus(in, out, s)
}

func autoConvert_v1alpha4_MachineList_To_v1beta1_MachineList(in *MachineList, out *v1beta1.MachineList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.Machine, len(*in))
		for i := range *in {
			if err := Convert_v1alpha4_Machine_To_v1beta1_Machine(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha4_MachineList_To_v1beta1_MachineList is an autogenerated conversion function.
func Convert_v1alpha4_MachineList_To_v1beta1_MachineList(in *MachineList, out *v1beta1.MachineList, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineList_To_v1beta1_MachineList(in, out, s)
}

func autoConvert_v1beta1_MachineList_To_v1alpha4_MachineList(in *v1beta1.MachineList, out *MachineList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Machine, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_Machine_To_v1alpha4_Machine(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_MachineList_To_v1alpha4_MachineList is an autogenerated conversion function.
func Convert_v1beta1_MachineList_To_v1alpha4_MachineList(in *v1beta1.MachineList, out *MachineList, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineList_To_v1alpha4_MachineList(in, out, s)
}

func autoConvert_v1alpha4_MachineRollingUpdateDeployment_To_v1beta1_MachineRollingUpdateDeployment(in *MachineRollingUpdateDeployment, out *v1beta1.MachineRollingUpdateDeployment, s conversion.Scope) error {
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	out.MaxSurge = (*intstr.IntOrString)(unsafe.Pointer(in.MaxSurge))
	out.DeletePolicy = (*string)(unsafe.Pointer(in.DeletePolicy))
	return nil
}

// Convert_v1alpha4_MachineRollingUpdateDeployment_To_v1beta1_MachineRollingUpdateDeployment is an autogenerated conversion function.
func Convert_v1alpha4_MachineRollingUpdateDeployment_To_v1beta1_MachineRollingUpdateDeployment(in *MachineRollingUpdateDeployment, out *v1beta1.MachineRollingUpdateDeployment, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineRollingUpdateDeployment_To_v1beta1_MachineRollingUpdateDeployment(in, out, s)
}

func autoConvert_v1beta1_MachineRollingUpdateDeployment_To_v1alpha4_MachineRollingUpdateDeployment(in *v1beta1.MachineRollingUpdateDeployment, out *MachineRollingUpdateDeployment, s conversion.Scope) error {
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	out.MaxSurge = (*intstr.IntOrString)(unsafe.Pointer(in.MaxSurge))
	out.DeletePolicy = (*string)(unsafe.Pointer(in.DeletePolicy))
	return nil
}

// Convert_v1beta1_MachineRollingUpdateDeployment_To_v1alpha4_MachineRollingUpdateDeployment is an autogenerated conversion function.
func Convert_v1beta1_MachineRollingUpdateDeployment_To_v1alpha4_MachineRollingUpdateDeployment(in *v1beta1.MachineRollingUpdateDeployment, out *MachineRollingUpdateDeployment, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineRollingUpdateDeployment_To_v1alpha4_MachineRollingUpdateDeployment(in, out, s)
}

func autoConvert_v1alpha4_MachineSet_To_v1beta1_MachineSet(in *MachineSet, out *v1beta1.MachineSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha4_MachineSetSpec_To_v1beta1_MachineSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_MachineSetStatus_To_v1beta1_MachineSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_MachineSet_To_v1beta1_MachineSet is an autogenerated conversion function.
func Convert_v1alpha4_MachineSet_To_v1beta1_MachineSet(in *MachineSet, out *v1beta1.MachineSet, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineSet_To_v1beta1_MachineSet(in, out, s)
}

func autoConvert_v1beta1_MachineSet_To_v1alpha4_MachineSet(in *v1beta1.MachineSet, out *MachineSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_MachineSetSpec_To_v1alpha4_MachineSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_MachineSetStatus_To_v1alpha4_MachineSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_MachineSet_To_v1alpha4_MachineSet is an autogenerated conversion function.
func Convert_v1beta1_MachineSet_To_v1alpha4_MachineSet(in *v1beta1.MachineSet, out *MachineSet, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineSet_To_v1alpha4_MachineSet(in, out, s)
}

func autoConvert_v1alpha4_MachineSetList_To_v1beta1_MachineSetList(in *MachineSetList, out *v1beta1.MachineSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1beta1.MachineSet)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha4_MachineSetList_To_v1beta1_MachineSetList is an autogenerated conversion function.
func Convert_v1alpha4_MachineSetList_To_v1beta1_MachineSetList(in *MachineSetList, out *v1beta1.MachineSetList, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineSetList_To_v1beta1_MachineSetList(in, out, s)
}

func autoConvert_v1beta1_MachineSetList_To_v1alpha4_MachineSetList(in *v1beta1.MachineSetList, out *MachineSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]MachineSet)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_MachineSetList_To_v1alpha4_MachineSetList is an autogenerated conversion function.
func Convert_v1beta1_MachineSetList_To_v1alpha4_MachineSetList(in *v1beta1.MachineSetList, out *MachineSetList, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineSetList_To_v1alpha4_MachineSetList(in, out, s)
}

func autoConvert_v1alpha4_MachineSetSpec_To_v1beta1_MachineSetSpec(in *MachineSetSpec, out *v1beta1.MachineSetSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.MinReadySeconds = in.MinReadySeconds
	out.DeletePolicy = in.DeletePolicy
	out.Selector = in.Selector
	if err := Convert_v1alpha4_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_MachineSetSpec_To_v1beta1_MachineSetSpec is an autogenerated conversion function.
func Convert_v1alpha4_MachineSetSpec_To_v1beta1_MachineSetSpec(in *MachineSetSpec, out *v1beta1.MachineSetSpec, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineSetSpec_To_v1beta1_MachineSetSpec(in, out, s)
}

func autoConvert_v1beta1_MachineSetSpec_To_v1alpha4_MachineSetSpec(in *v1beta1.MachineSetSpec, out *MachineSetSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.MinReadySeconds = in.MinReadySeconds
	out.DeletePolicy = in.DeletePolicy
	out.Selector = in.Selector
	if err := Convert_v1beta1_MachineTemplateSpec_To_v1alpha4_MachineTemplateSpec(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_MachineSetSpec_To_v1alpha4_MachineSetSpec is an autogenerated conversion function.
func Convert_v1beta1_MachineSetSpec_To_v1alpha4_MachineSetSpec(in *v1beta1.MachineSetSpec, out *MachineSetSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineSetSpec_To_v1alpha4_MachineSetSpec(in, out, s)
}

func autoConvert_v1alpha4_MachineSetStatus_To_v1beta1_MachineSetStatus(in *MachineSetStatus, out *v1beta1.MachineSetStatus, s conversion.Scope) error {
	out.Selector = in.Selector
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.ObservedGeneration = in.ObservedGeneration
	out.FailureReason = (*errors.MachineSetStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	out.Conditions = *(*v1beta1.Conditions)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1alpha4_MachineSetStatus_To_v1beta1_MachineSetStatus is an autogenerated conversion function.
func Convert_v1alpha4_MachineSetStatus_To_v1beta1_MachineSetStatus(in *MachineSetStatus, out *v1beta1.MachineSetStatus, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineSetStatus_To_v1beta1_MachineSetStatus(in, out, s)
}

func autoConvert_v1beta1_MachineSetStatus_To_v1alpha4_MachineSetStatus(in *v1beta1.MachineSetStatus, out *MachineSetStatus, s conversion.Scope) error {
	out.Selector = in.Selector
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.ObservedGeneration = in.ObservedGeneration
	out.FailureReason = (*errors.MachineSetStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	out.Conditions = *(*Conditions)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1beta1_MachineSetStatus_To_v1alpha4_MachineSetStatus is an autogenerated conversion function.
func Convert_v1beta1_MachineSetStatus_To_v1alpha4_MachineSetStatus(in *v1beta1.MachineSetStatus, out *MachineSetStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineSetStatus_To_v1alpha4_MachineSetStatus(in, out, s)
}

func autoConvert_v1alpha4_MachineSpec_To_v1beta1_MachineSpec(in *MachineSpec, out *v1beta1.MachineSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	if err := Convert_v1alpha4_Bootstrap_To_v1beta1_Bootstrap(&in.Bootstrap, &out.Bootstrap, s); err != nil {
		return err
	}
	out.InfrastructureRef = in.InfrastructureRef
	out.Version = (*string)(unsafe.Pointer(in.Version))
	out.ProviderID = (*string)(unsafe.Pointer(in.ProviderID))
	out.FailureDomain = (*string)(unsafe.Pointer(in.FailureDomain))
	out.NodeDrainTimeout = (*metav1.Duration)(unsafe.Pointer(in.NodeDrainTimeout))
	return nil
}

// Convert_v1alpha4_MachineSpec_To_v1beta1_MachineSpec is an autogenerated conversion function.
func Convert_v1alpha4_MachineSpec_To_v1beta1_MachineSpec(in *MachineSpec, out *v1beta1.MachineSpec, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineSpec_To_v1beta1_MachineSpec(in, out, s)
}

func autoConvert_v1beta1_MachineSpec_To_v1alpha4_MachineSpec(in *v1beta1.MachineSpec, out *MachineSpec, s conversion.Scope) error {
	out.ClusterName = in.ClusterName
	if err := Convert_v1beta1_Bootstrap_To_v1alpha4_Bootstrap(&in.Bootstrap, &out.Bootstrap, s); err != nil {
		return err
	}
	out.InfrastructureRef = in.InfrastructureRef
	out.Version = (*string)(unsafe.Pointer(in.Version))
	out.ProviderID = (*string)(unsafe.Pointer(in.ProviderID))
	out.FailureDomain = (*string)(unsafe.Pointer(in.FailureDomain))
	out.NodeDrainTimeout = (*metav1.Duration)(unsafe.Pointer(in.NodeDrainTimeout))
	return nil
}

// Convert_v1beta1_MachineSpec_To_v1alpha4_MachineSpec is an autogenerated conversion function.
func Convert_v1beta1_MachineSpec_To_v1alpha4_MachineSpec(in *v1beta1.MachineSpec, out *MachineSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineSpec_To_v1alpha4_MachineSpec(in, out, s)
}

func autoConvert_v1alpha4_MachineStatus_To_v1beta1_MachineStatus(in *MachineStatus, out *v1beta1.MachineStatus, s conversion.Scope) error {
	out.NodeRef = (*v1.ObjectReference)(unsafe.Pointer(in.NodeRef))
	out.NodeInfo = (*v1.NodeSystemInfo)(unsafe.Pointer(in.NodeInfo))
	out.LastUpdated = (*metav1.Time)(unsafe.Pointer(in.LastUpdated))
	// WARNING: in.Version requires manual conversion: does not exist in peer-type
	out.FailureReason = (*errors.MachineStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	out.Addresses = *(*v1beta1.MachineAddresses)(unsafe.Pointer(&in.Addresses))
	out.Phase = in.Phase
	out.BootstrapReady = in.BootstrapReady
	out.InfrastructureReady = in.InfrastructureReady
	out.ObservedGeneration = in.ObservedGeneration
	out.Conditions = *(*v1beta1.Conditions)(unsafe.Pointer(&in.Conditions))
	return nil
}

func autoConvert_v1beta1_MachineStatus_To_v1alpha4_MachineStatus(in *v1beta1.MachineStatus, out *MachineStatus, s conversion.Scope) error {
	out.NodeRef = (*v1.ObjectReference)(unsafe.Pointer(in.NodeRef))
	out.NodeInfo = (*v1.NodeSystemInfo)(unsafe.Pointer(in.NodeInfo))
	out.LastUpdated = (*metav1.Time)(unsafe.Pointer(in.LastUpdated))
	out.FailureReason = (*errors.MachineStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	out.Addresses = *(*MachineAddresses)(unsafe.Pointer(&in.Addresses))
	out.Phase = in.Phase
	out.BootstrapReady = in.BootstrapReady
	out.InfrastructureReady = in.InfrastructureReady
	out.ObservedGeneration = in.ObservedGeneration
	out.Conditions = *(*Conditions)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1beta1_MachineStatus_To_v1alpha4_MachineStatus is an autogenerated conversion function.
func Convert_v1beta1_MachineStatus_To_v1alpha4_MachineStatus(in *v1beta1.MachineStatus, out *MachineStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineStatus_To_v1alpha4_MachineStatus(in, out, s)
}

func autoConvert_v1alpha4_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec(in *MachineTemplateSpec, out *v1beta1.MachineTemplateSpec, s conversion.Scope) error {
	if err := Convert_v1alpha4_ObjectMeta_To_v1beta1_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_MachineSpec_To_v1beta1_MachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec is an autogenerated conversion function.
func Convert_v1alpha4_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec(in *MachineTemplateSpec, out *v1beta1.MachineTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1alpha4_MachineTemplateSpec_To_v1beta1_MachineTemplateSpec(in, out, s)
}

func autoConvert_v1beta1_MachineTemplateSpec_To_v1alpha4_MachineTemplateSpec(in *v1beta1.MachineTemplateSpec, out *MachineTemplateSpec, s conversion.Scope) error {
	if err := Convert_v1beta1_ObjectMeta_To_v1alpha4_ObjectMeta(&in.ObjectMeta, &out.ObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_MachineSpec_To_v1alpha4_MachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_MachineTemplateSpec_To_v1alpha4_MachineTemplateSpec is an autogenerated conversion function.
func Convert_v1beta1_MachineTemplateSpec_To_v1alpha4_MachineTemplateSpec(in *v1beta1.MachineTemplateSpec, out *MachineTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_MachineTemplateSpec_To_v1alpha4_MachineTemplateSpec(in, out, s)
}

func autoConvert_v1alpha4_NetworkRanges_To_v1beta1_NetworkRanges(in *NetworkRanges, out *v1beta1.NetworkRanges, s conversion.Scope) error {
	out.CIDRBlocks = *(*[]string)(unsafe.Pointer(&in.CIDRBlocks))
	return nil
}

// Convert_v1alpha4_NetworkRanges_To_v1beta1_NetworkRanges is an autogenerated conversion function.
func Convert_v1alpha4_NetworkRanges_To_v1beta1_NetworkRanges(in *NetworkRanges, out *v1beta1.NetworkRanges, s conversion.Scope) error {
	return autoConvert_v1alpha4_NetworkRanges_To_v1beta1_NetworkRanges(in, out, s)
}

func autoConvert_v1beta1_NetworkRanges_To_v1alpha4_NetworkRanges(in *v1beta1.NetworkRanges, out *NetworkRanges, s conversion.Scope) error {
	out.CIDRBlocks = *(*[]string)(unsafe.Pointer(&in.CIDRBlocks))
	return nil
}

// Convert_v1beta1_NetworkRanges_To_v1alpha4_NetworkRanges is an autogenerated conversion function.
func Convert_v1beta1_NetworkRanges_To_v1alpha4_NetworkRanges(in *v1beta1.NetworkRanges, out *NetworkRanges, s conversion.Scope) error {
	return autoConvert_v1beta1_NetworkRanges_To_v1alpha4_NetworkRanges(in, out, s)
}

func autoConvert_v1alpha4_ObjectMeta_To_v1beta1_ObjectMeta(in *ObjectMeta, out *v1beta1.ObjectMeta, s conversion.Scope) error {
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	return nil
}

// Convert_v1alpha4_ObjectMeta_To_v1beta1_ObjectMeta is an autogenerated conversion function.
func Convert_v1alpha4_ObjectMeta_To_v1beta1_ObjectMeta(in *ObjectMeta, out *v1beta1.ObjectMeta, s conversion.Scope) error {
	return autoConvert_v1alpha4_ObjectMeta_To_v1beta1_ObjectMeta(in, out, s)
}

func autoConvert_v1beta1_ObjectMeta_To_v1alpha4_ObjectMeta(in *v1beta1.ObjectMeta, out *ObjectMeta, s conversion.Scope) error {
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	return nil
}

// Convert_v1beta1_ObjectMeta_To_v1alpha4_ObjectMeta is an autogenerated conversion function.
func Convert_v1beta1_ObjectMeta_To_v1alpha4_ObjectMeta(in *v1beta1.ObjectMeta, out *ObjectMeta, s conversion.Scope) error {
	return autoConvert_v1beta1_ObjectMeta_To_v1alpha4_ObjectMeta(in, out, s)
}

func autoConvert_v1alpha4_Topology_To_v1beta1_Topology(in *Topology, out *v1beta1.Topology, s conversion.Scope) error {
	out.Class = in.Class
	out.Version = in.Version
	out.RolloutAfter = (*metav1.Time)(unsafe.Pointer(in.RolloutAfter))
	if err := Convert_v1alpha4_ControlPlaneTopology_To_v1beta1_ControlPlaneTopology(&in.ControlPlane, &out.ControlPlane, s); err != nil {
		return err
	}
	out.Workers = (*v1beta1.WorkersTopology)(unsafe.Pointer(in.Workers))
	return nil
}

// Convert_v1alpha4_Topology_To_v1beta1_Topology is an autogenerated conversion function.
func Convert_v1alpha4_Topology_To_v1beta1_Topology(in *Topology, out *v1beta1.Topology, s conversion.Scope) error {
	return autoConvert_v1alpha4_Topology_To_v1beta1_Topology(in, out, s)
}

func autoConvert_v1beta1_Topology_To_v1alpha4_Topology(in *v1beta1.Topology, out *Topology, s conversion.Scope) error {
	out.Class = in.Class
	out.Version = in.Version
	out.RolloutAfter = (*metav1.Time)(unsafe.Pointer(in.RolloutAfter))
	if err := Convert_v1beta1_ControlPlaneTopology_To_v1alpha4_ControlPlaneTopology(&in.ControlPlane, &out.ControlPlane, s); err != nil {
		return err
	}
	out.Workers = (*WorkersTopology)(unsafe.Pointer(in.Workers))
	return nil
}

// Convert_v1beta1_Topology_To_v1alpha4_Topology is an autogenerated conversion function.
func Convert_v1beta1_Topology_To_v1alpha4_Topology(in *v1beta1.Topology, out *Topology, s conversion.Scope) error {
	return autoConvert_v1beta1_Topology_To_v1alpha4_Topology(in, out, s)
}

func autoConvert_v1alpha4_UnhealthyCondition_To_v1beta1_UnhealthyCondition(in *UnhealthyCondition, out *v1beta1.UnhealthyCondition, s conversion.Scope) error {
	out.Type = v1.NodeConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.Timeout = in.Timeout
	return nil
}

// Convert_v1alpha4_UnhealthyCondition_To_v1beta1_UnhealthyCondition is an autogenerated conversion function.
func Convert_v1alpha4_UnhealthyCondition_To_v1beta1_UnhealthyCondition(in *UnhealthyCondition, out *v1beta1.UnhealthyCondition, s conversion.Scope) error {
	return autoConvert_v1alpha4_UnhealthyCondition_To_v1beta1_UnhealthyCondition(in, out, s)
}

func autoConvert_v1beta1_UnhealthyCondition_To_v1alpha4_UnhealthyCondition(in *v1beta1.UnhealthyCondition, out *UnhealthyCondition, s conversion.Scope) error {
	out.Type = v1.NodeConditionType(in.Type)
	out.Status = v1.ConditionStatus(in.Status)
	out.Timeout = in.Timeout
	return nil
}

// Convert_v1beta1_UnhealthyCondition_To_v1alpha4_UnhealthyCondition is an autogenerated conversion function.
func Convert_v1beta1_UnhealthyCondition_To_v1alpha4_UnhealthyCondition(in *v1beta1.UnhealthyCondition, out *UnhealthyCondition, s conversion.Scope) error {
	return autoConvert_v1beta1_UnhealthyCondition_To_v1alpha4_UnhealthyCondition(in, out, s)
}

func autoConvert_v1alpha4_WorkersClass_To_v1beta1_WorkersClass(in *WorkersClass, out *v1beta1.WorkersClass, s conversion.Scope) error {
	out.MachineDeployments = *(*[]v1beta1.MachineDeploymentClass)(unsafe.Pointer(&in.MachineDeployments))
	return nil
}

// Convert_v1alpha4_WorkersClass_To_v1beta1_WorkersClass is an autogenerated conversion function.
func Convert_v1alpha4_WorkersClass_To_v1beta1_WorkersClass(in *WorkersClass, out *v1beta1.WorkersClass, s conversion.Scope) error {
	return autoConvert_v1alpha4_WorkersClass_To_v1beta1_WorkersClass(in, out, s)
}

func autoConvert_v1beta1_WorkersClass_To_v1alpha4_WorkersClass(in *v1beta1.WorkersClass, out *WorkersClass, s conversion.Scope) error {
	out.MachineDeployments = *(*[]MachineDeploymentClass)(unsafe.Pointer(&in.MachineDeployments))
	return nil
}

// Convert_v1beta1_WorkersClass_To_v1alpha4_WorkersClass is an autogenerated conversion function.
func Convert_v1beta1_WorkersClass_To_v1alpha4_WorkersClass(in *v1beta1.WorkersClass, out *WorkersClass, s conversion.Scope) error {
	return autoConvert_v1beta1_WorkersClass_To_v1alpha4_WorkersClass(in, out, s)
}

func autoConvert_v1alpha4_WorkersTopology_To_v1beta1_WorkersTopology(in *WorkersTopology, out *v1beta1.WorkersTopology, s conversion.Scope) error {
	out.MachineDeployments = *(*[]v1beta1.MachineDeploymentTopology)(unsafe.Pointer(&in.MachineDeployments))
	return nil
}

// Convert_v1alpha4_WorkersTopology_To_v1beta1_WorkersTopology is an autogenerated conversion function.
func Convert_v1alpha4_WorkersTopology_To_v1beta1_WorkersTopology(in *WorkersTopology, out *v1beta1.WorkersTopology, s conversion.Scope) error {
	return autoConvert_v1alpha4_WorkersTopology_To_v1beta1_WorkersTopology(in, out, s)
}

func autoConvert_v1beta1_WorkersTopology_To_v1alpha4_WorkersTopology(in *v1beta1.WorkersTopology, out *WorkersTopology, s conversion.Scope) error {
	out.MachineDeployments = *(*[]MachineDeploymentTopology)(unsafe.Pointer(&in.MachineDeployments))
	return nil
}

// Convert_v1beta1_WorkersTopology_To_v1alpha4_WorkersTopology is an autogenerated conversion function.
func Convert_v1beta1_WorkersTopology_To_v1alpha4_WorkersTopology(in *v1beta1.WorkersTopology, out *WorkersTopology, s conversion.Scope) error {
	return autoConvert_v1beta1_WorkersTopology_To_v1alpha4_WorkersTopology(in, out, s)
}
